﻿<%@ Import Namespace="SWTraining" %>

<%@ Page Language="c#" CodeBehind="StuPotentials.aspx.cs" AutoEventWireup="True"
    Inherits="SWTraining.Consultant.StuPotentials" Title="顾问工作台-学员咨询信息" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="PotentialID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="咨询号">
                    <ItemTemplate>
                        <asp:Label ID="labPotentialID" runat="server" Text='<%# Eval("PotentialID") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="姓名">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labPotentialName" ForeColor='<%# Convert.ToInt32(Eval("StatusID")) == 3 ? System.Drawing.Color.ForestGreen:System.Drawing.Color.Black%>'
                            Text='<%#Eval("PotentialName")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="来源">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labSourceType" Text='<%#Rs.Items.GetSourceType(Eval("SourceType"))%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="CourseName" ReadOnly="True" HeaderText="课程" />
                <asp:BoundField DataField="DateAndTime" ReadOnly="True" HeaderText="咨询日期" />
                <asp:TemplateField HeaderText="客户状态">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labStatusName" Text='<%# Eval("StatusName") %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="咨询顾问">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labTrueName" Text='<%#Eval("TrueName") %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="最后回访信息">
                    <ItemTemplate>
                        <%#Eval("LastPostName")%>|<%#Eval("LastPostTime")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="回访">
                    <ItemTemplate>
                        <font color="red">
                            <%#Eval("ReCount")%>
                        </font>次|<a href='Reply.aspx?PotentialID=<%#Eval("PotentialID")%>&GetURL=<% = swq.Web.PathAndQuery() %>'><asp:Literal
                            Text="回访" runat="server" /></a>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkEdit" runat="server" Text="编辑" NavigateUrl='<%# string.Format("PostPotential.aspx?PotentialID={0}&GetURL={1}",Eval("PotentialID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除" SortExpression="delete">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("UserID")%>'
                            OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
<input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
</label></div>
    </form>
</body>
</html>
