﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="FoundStu.aspx.cs" Inherits="SWTraining.Consultant.FoundStu"
    Title="顾问工作台-查找咨询归属" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="divpanel">
        <table class="table" cellspacing="0" width="100%" border="0">
            <tr>
                <th colspan="2">
                    查找咨询归属
                </th>
            </tr>
            <tr>
                <td>
                    校区：
                </td>
                <td>
                    <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    姓名：
                </td>
                <td>
                    <asp:TextBox ID="tbxStudentName" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    电话/手机号：
                </td>
                <td>
                    <asp:TextBox ID="tbxTel" runat="server" Width="160px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    <label class="lab_buttom">
<asp:Button ID="btnSelect" runat="server" Text="查询" OnClick="btnSelect_Click"></asp:Button>
</label>
                </td>
            </tr>
        </table>
    </div>
    <div class="divpanel">
        <asp:Label ID="labTitle" runat="server" Text="潜在学员信息" Visible="false" Font-Bold="true"></asp:Label>
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="PotentialID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="咨询号">
                    <ItemTemplate>
                        <asp:Label ID="labPotentialID" runat="server" Text='<%# Eval("PotentialID") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="姓名">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labPotentialName" ForeColor='<%# Convert.ToInt32(Eval("StatusID")) == 3 ? System.Drawing.Color.ForestGreen:System.Drawing.Color.Black%>'
                            Text='<%#Eval("PotentialName")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="来源">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labSourceType" Text='<%#Rs.Items.GetSourceType(Eval("SourceType"))%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="CourseName" ReadOnly="True" HeaderText="课程" />
                <asp:BoundField DataField="DateAndTime" ReadOnly="True" HeaderText="咨询日期" />
                <asp:TemplateField HeaderText="客户状态">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labStatusName" Text='<%# Eval("StatusName") %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="咨询顾问">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labTrueName" Text='<%#Eval("TrueName") %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="最后回访信息">
                    <ItemTemplate>
                        <%#Eval("LastPostName")%>|<%#Eval("LastPostTime")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="回访">
                    <ItemTemplate>
                        <font color="red">
                            <%#Eval("ReCount")%>
                        </font>次|<a href='Reply.aspx?PotentialID=<%#Eval("PotentialID")%>&GetURL=<% = swq.Web.PathAndQuery() %>'>回访</a>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="divpanel">
        <asp:Label ID="labTitle2" runat="server" Text="正式学员信息" Visible="false" Font-Bold="true"></asp:Label>
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView2" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="StudentID" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="学号">
                    <ItemTemplate>
                        <asp:Label ID="labStudentID" runat="server" Text='<%# Eval("StudentID") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="姓名">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labStudentName" Text='<%#Eval("StudentName")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="隶属顾问">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labConsultantName" Text='<%#Eval("ConsultantName")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员关怀">
                    <ItemTemplate>
                        <span style="color: red">
                            <%#Eval("ReCount")%>
                        </span>次|<a href='StuReply.aspx?StudentID=<%#Eval("StudentID")%>&GetURL=<% = swq.Web.PathAndQuery() %>'>关怀</a>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    </form>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、此功能用于值班时有正式/潜在学员电话来访，我们需要暂时释放权限让值班人员将学员来访信息记录下来。<br />
        2、使用方法：按姓名/电话查询学员信息，如果是潜在学员，找到后点击“回访”登记来访信息，如果是正式学员点击“关怀”登记来访信息。<br />
    </div>
</body>
</html>
