﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TuneOut.aspx.cs" Inherits="SWTraining.Commodity.TuneOut"
    Title="仓库管理-调拨处理" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript"> 
<!--

        function Focus() {
            if (!document.getElementById("tbxBarcode").disabled) {
                document.getElementById("tbxBarcode").focus();
            }
        }

//--> 
    </script>
</head>
<body onload="Focus();">
    <form id="form1" runat="server" defaultbutton="btnGoto">
    <div class="tool_Search">
        条形码：<asp:TextBox ID="tbxBarcode" runat="server"></asp:TextBox>
        &nbsp;分类：<asp:DropDownList ID="ddlCommodityType" runat="server" DataTextField="CommodityTypeName"
            DataValueField="CommodityTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCommodityType_SelectedIndexChanged">
        </asp:DropDownList>
        商品：<asp:DropDownList ID="ddlCommodity" runat="server" DataTextField="CommodityName"
            DataValueField="CommodityID">
        </asp:DropDownList>
        仓库：<asp:DropDownList ID="ddlStoreroom" runat="server" DataTextField="StoreroomName"
            DataValueField="StoreroomID">
        </asp:DropDownList>
        <label class="lab_buttom">
<asp:Button ID="btnGoto" runat="server" OnClick="btnGoto_Click" Text="转到" />
</label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="StoCommodityID"
            CssClass="gridview" Width="100%" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="CommodityID" HeaderText="商品编号" InsertVisible="False" ReadOnly="True"
                    SortExpression="CommodityID" />
                <asp:TemplateField HeaderText="商品名称" SortExpression="CommodityName">
                    <ItemTemplate>
                        <asp:Label ID="labCommodityName" runat="server" Text='<%# Bind("CommodityName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="仓库" SortExpression="CommodityName">
                    <ItemTemplate>
                        <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                        (<asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount") %>' ForeColor="Red"
                            Font-Bold="true"></asp:Label>)
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="PurchasePrice" HeaderText="进价" SortExpression="PurchasePrice"
                    ReadOnly="True" DataFormatString="{0:f2}" HtmlEncode="False" />
                <asp:TemplateField HeaderText="库存调拨" ShowHeader="False">
                    <ItemTemplate>
                        <asp:ImageButton ID="ImageButton1" ImageUrl='<%# accTheme("move.gif") %>' runat="server" />
                        <asp:HyperLink runat="server" ID="hlkOut" Text="由此调出" NavigateUrl='<%# string.Format("PostTuneOut.aspx?StoCommodityID={0}&GetUrl={1}",Eval("StoCommodityID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
