﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="OutBatch.aspx.cs" Inherits="SWTraining.Commodity.OutBatch"
    Title="仓库管理-商品退货查询" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script src="../Jscript/CreateSubMenu.js" type="text/javascript"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="tool_Search">
        单号：<asp:TextBox ID="tbxBatchID" runat="server"></asp:TextBox>
        日期：<asp:TextBox ID="tbxStartDate" runat="server" Width="79px"></asp:TextBox>
        -<asp:TextBox ID="tbxEndDate" runat="server" Width="79px"></asp:TextBox>
        仓库：<asp:DropDownList ID="ddlStoreroom" runat="server" DataTextField="StoreroomName"
            DataValueField="StoreroomID">
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" Text="查询" />
        </label>
        <label class="lab_buttom">
            <input id="btnBatchDetails" type="button" value="按明细管理" onclick="location='OutBatchDetails.aspx'" />
        </label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="BatchID"
            CssClass="gridview" OnRowDeleting="GridView1_RowDeleting" Width="100%" OnRowDataBound="GridView1_RowDataBound"
            OnSelectedIndexChanging="GridView1_SelectedIndexChanging">
            <Columns>
                <asp:TemplateField InsertVisible="False" HeaderText="编号" SortExpression="BatchID">
                    <ItemTemplate>
                        <asp:ImageButton ID="ibnSelect" CommandName="Select" ImageUrl='<%# accTheme("node_close.gif") %>'
                            runat="server" />
                        <asp:LinkButton ID="lbnSelect" runat="server" Text='<%# Eval("BatchID") %>' CommandName="Select" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="TotalAmount" HeaderText="数量" SortExpression="TotalAmount" />
                <asp:BoundField DataField="TotalPurchasePrice" HeaderText="总进价" SortExpression="TotalPurchasePrice"
                    DataFormatString="{0:f2}" HtmlEncode="False" />
                <asp:BoundField DataField="DateAndTime" HeaderText="时间" SortExpression="DateAndTime"
                    HtmlEncode="False" />
                <asp:BoundField DataField="ProviderName" HeaderText="供应商" SortExpression="ProviderName" />
                <asp:BoundField DataField="Remark" HeaderText="备注" SortExpression="Remark" />
                <asp:TemplateField HeaderText="编辑">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkEdit" runat="server" Text="编辑" NavigateUrl='<%# string.Format("PostInBatch.aspx?BatchID={0}&GetURL={1}",Eval("BatchID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除" ShowHeader="False">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" CausesValidation="False" CommandName="Delete"
                            Text="删除" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </div>
    <div id="divItems" style="display: none">
        <div style="width: 50%">
            <asp:GridView ID="gvItems" runat="server" AutoGenerateColumns="false" CssClass="smallgridview">
                <Columns>
                    <asp:BoundField DataField="CommodityID" HeaderText="编号" ReadOnly="True" />
                    <asp:BoundField DataField="CommodityName" HeaderText="项目" ReadOnly="True" />
                    <asp:TemplateField HeaderText="进价">
                        <ItemTemplate>
                            <asp:Label ID="labPurchasePrice" runat="server" Text='<%# Bind("PurchasePrice","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="数量">
                        <ItemTemplate>
                            <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="合计">
                        <ItemTemplate>
                            <asp:Label ID="labTotalPrice" runat="server" Text='<%# Bind("TotalPrice","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="仓库">
                        <ItemTemplate>
                            <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
    </form>
</body>
</html>
