﻿<%@ Page Language="c#" CodeBehind="CommodityType.aspx.cs" AutoEventWireup="True"
    Inherits="SWTraining.Commodity.CommodityType" Title="仓库管理-商品分类" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        商品分类：<asp:TextBox ID="tbxCommodityTypeName" runat="server"></asp:TextBox>
        <label class="lab_buttom">
<asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click"></asp:Button>
</label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="CommodityTypeID" OnRowCancelingEdit="GridView1_RowCancelingEdit"
            OnRowCommand="GridView1_RowCommand" OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating"
            OnRowCreated="GridView1_RowCreated" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="CommodityTypeID" ReadOnly="True" HeaderText="分类编号" />
                <asp:BoundField DataField="CommodityTypeName" HeaderText="分类名称" />
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <%# (int)Eval("LockState") == 0 ? "禁用" : "启用"%>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                            <asp:ListItem Value="0" Selected="True" Text="禁用"></asp:ListItem>
                            <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                        <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" Text="↑"></asp:LinkButton>
                        <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" Text="↓"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="return confirm('你是否确定删除这条记录？');"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
