﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonDegree.aspx.cs" Inherits="SWTraining.Class.LessonDegree"
    Title="教务管理-排课信息" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<%@ Register Src="../UserCol/Ann.ascx" TagName="Ann" TagPrefix="uc3" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .ld {
            margin: 0px;
            padding: 0px;
            list-style: none;
        }

            .ld li {
                float: left;
            }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div class="divpanel">
            <uc3:Ann ID="Ann1" runat="server" />
            <asp:FormView ID="fvClass" runat="server" Width="100%">
                <ItemTemplate>
                    <table class="table" cellspacing="0">
                        <tr>
                            <th colspan="6">班级信息
                            </th>
                        </tr>
                        <tr>
                            <td>班号：<%#Eval("ClassID")%>
                            </td>
                            <td>班级名称：<%#Eval("ClassName")%>
                            </td>
                            <td>上课规律：<%#Eval("TimeRule")%>
                            </td>
                            <td>开课时间：<%#Eval("StartDate","{0:d}")%>
                            </td>
                            <td>总课时：<%#Eval("Lessons")%>
                            </td>
                            <td>每课分钟：<%#Eval("LessonMinute")%>
                            </td>
                        </tr>
                    </table>
                </ItemTemplate>
            </asp:FormView>
        </div>
        <div class="divpanel">
            <table class="table" cellspacing="0">
                <tr>
                    <th colspan="2">排课面板
                    </th>
                </tr>
                <tr>
                    <td>排课参数：
                    </td>
                    <td>
                        <table border="0" width="100%">
                            <tr>
                                <td>
                                    <ul class="ld">
                                        <li>周期：<asp:DropDownList ID="ddlWeek" runat="server">
                                            <asp:ListItem Text="周日" Value="0"></asp:ListItem>
                                            <asp:ListItem Text="周一" Value="1"></asp:ListItem>
                                            <asp:ListItem Text="周二" Value="2"></asp:ListItem>
                                            <asp:ListItem Text="周三" Value="3"></asp:ListItem>
                                            <asp:ListItem Text="周四" Value="4"></asp:ListItem>
                                            <asp:ListItem Text="周五" Value="5"></asp:ListItem>
                                            <asp:ListItem Text="周六" Value="6"></asp:ListItem>
                                            <asp:ListItem Text="全周" Value="-1"></asp:ListItem>
                                        </asp:DropDownList></li>
                                        <li>时间段：<asp:DropDownList ID="ddlTimes" runat="server">
                                        </asp:DropDownList>
                                            <asp:DropDownList ID="ddlGroupType" runat="server" DataTextField="PeriodTimeGroupName"
                                                DataValueField="PeriodTimeGroupID" AutoPostBack="True" OnSelectedIndexChanged="ddlGroupType_SelectedIndexChanged">
                                            </asp:DropDownList></li>
                                        <li>讲师：<asp:DropDownList runat="server" ID="ddlTeacher" DataTextField="TrueName" DataValueField="UserID">
                                        </asp:DropDownList>
                                            <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlTeacher" />
                                        </li>
                                        <li>助教：<asp:DropDownList runat="server" ID="ddlAssistant" DataTextField="TrueName" DataValueField="UserID">
                                        </asp:DropDownList>
                                            <uc1:SimpleCode ID="SimpleCode2" runat="server" UsersControlID="ddlAssistant" />
                                        </li>
                                        <li>教室：<asp:DropDownList ID="ddlClassroom" runat="server" DataTextField="ClassroomName"
                                            DataValueField="ClassroomID">
                                        </asp:DropDownList></li>
                                        <li>课题：<asp:TextBox runat="server" ID="tbxSubject" Width="60px"></asp:TextBox></li>
                                        <li>
                                            <label class="lab_buttom">
                                                <asp:Button ID="btnAddTime" runat="server" CausesValidation="False" OnClick="btnAddTime_Click"
                                                    Text="添加" />
                                            </label>
                                            <label class="lab_buttom">
                                                <asp:Button ID="btnClear" runat="server" OnClick="btnClear_Click" Text="清除" Visible="false" />
                                            </label>
                                        </li>
                                    </ul>
                                    <div class="both"></div>
                                </td>
                            </tr>
                            <tr>
                                <td style="border: 0px">
                                    <ul class="ld">
                                        <li style="min-width:60%">
                                            <asp:GridView ID="gvCycPeriodTime" runat="server" AutoGenerateColumns="False"
                                                DataKeyNames="ClassID,PeriodTimeID,Week" OnRowCancelingEdit="gvCycPeriodTime_RowCancelingEdit"
                                                OnRowDeleting="gvCycPeriodTime_RowDeleting" OnRowEditing="gvCycPeriodTime_RowEditing"
                                                OnRowUpdating="gvCycPeriodTime_RowUpdating" CssClass="smallgridview" CellSpacing="0"
                                                CellPadding="0">
                                                <Columns>
                                                    <asp:TemplateField HeaderText="周期">
                                                        <ItemTemplate>
                                                            <asp:Label ID="Week0" runat="server" Text='<%# Rs.Items.GetWeekText(Eval("Week")) %>'></asp:Label>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:BoundField DataField="PeriodTimeName" HeaderText="时间段" ReadOnly="true" />
                                                    <asp:BoundField DataField="Minute" HeaderText="分钟" ReadOnly="true" />
                                                    <asp:TemplateField HeaderText="课时" ShowHeader="False">
                                                        <ItemTemplate>
                                                            <asp:Label ID="labLessons" runat="server" Text='<%# Eval("Lessons") %>'></asp:Label>
                                                        </ItemTemplate>
                                                        <EditItemTemplate>
                                                            <asp:TextBox ID="tbxLessons" runat="server" Text='<%# Eval("Lessons") %>' Width="40px"></asp:TextBox>
                                                        </EditItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="讲师" ShowHeader="False">
                                                        <ItemTemplate>
                                                            <asp:Label ID="labTeacherName" runat="server" Text='<%# Eval("TeacherName") %>'></asp:Label>
                                                        </ItemTemplate>
                                                        <EditItemTemplate>
                                                            <asp:DropDownList runat="server" ID="ddlTeacher" SelectedValue='<%# Eval("TeacherID") %>'
                                                                DataSource='<%# swq.Cache.GetUsers() %>' DataTextField="TrueName" DataValueField="UserID">
                                                            </asp:DropDownList>
                                                        </EditItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="助教" ShowHeader="False">
                                                        <ItemTemplate>
                                                            <asp:Label ID="labAssistantName" runat="server" Text='<%# Eval("AssistantName") %>'></asp:Label>
                                                        </ItemTemplate>
                                                        <EditItemTemplate>
                                                            <asp:DropDownList runat="server" ID="ddlAssistant" SelectedValue='<%# Eval("AssistantID") %>'
                                                                DataSource='<%# swq.Cache.Fill(swq.Cache.GetUsers()," ") %>' DataTextField="TrueName"
                                                                DataValueField="UserID">
                                                            </asp:DropDownList>
                                                        </EditItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="教室" ShowHeader="False">
                                                        <ItemTemplate>
                                                            <asp:Label ID="labClassroomName" runat="server" Text='<%# Eval("ClassroomName") %>'></asp:Label>
                                                        </ItemTemplate>
                                                        <EditItemTemplate>
                                                            <asp:DropDownList runat="server" ID="ddlClassroom" SelectedValue='<%# Eval("ClassroomID") %>'
                                                                DataSource='<%# swq.Cache.GetClassroom() %>' DataTextField="ClassroomName" DataValueField="ClassroomID">
                                                            </asp:DropDownList>
                                                        </EditItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="课题" ShowHeader="False">
                                                        <ItemTemplate>
                                                            <asp:Label ID="labSubject" runat="server" Text='<%# Eval("Subject") %>'></asp:Label>
                                                        </ItemTemplate>
                                                        <EditItemTemplate>
                                                            <asp:TextBox runat="server" ID="tbxSubject" Width="60px" Text='<%# Eval("Subject") %>'></asp:TextBox>
                                                        </EditItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:CommandField CancelText="取消" EditText="编辑" HeaderText="编辑" ShowEditButton="true"
                                                        UpdateText="更新" />
                                                    <asp:TemplateField HeaderText="删除" ShowHeader="False">
                                                        <ItemTemplate>
                                                            <asp:LinkButton ID="lbnDelete" runat="server" CausesValidation="False" CommandName="Delete"
                                                                OnClientClick="<%# Rs.Messages.确定删除%>" Text="删除"></asp:LinkButton>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                </Columns>
                                            </asp:GridView>
                                        </li>
                                    </ul>
                                    <div class="both"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td>排课起始日：
                    </td>
                    <td>
                        <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>可排课时数：
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlLessons" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>排课完成度：
                    </td>
                    <td>
                        <uc2:Progress ID="Progress1" runat="server" Text="课时" Width="40%" />
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;
                    </td>
                    <td>
                        <label class="lab_buttom">
                            <asp:Button ID="btnAutoAddLessonDegree" runat="server" OnClick="btnAutoAddLessonDegree_Click"
                                Text="自动排课" />
                        </label>
                        <label class="lab_buttom">
                            <asp:Button ID="btnAddOneLessonDegree" runat="server" OnClick="btnAddOneLessonDegree_Click"
                                Text="逐个排课" />
                        </label>
                        <label class="lab_buttom">
                            <asp:Button ID="btnClearLessonDegree" runat="server" OnClick="btnClearLessonDegree_Click"
                                Text="清除排课" OnClientClick="return confirm('执行此操作，将删除所有未上课的排课信息，您确定要这么做？');" />
                        </label>
                    </td>
                </tr>
            </table>
        </div>
        <div class="divpanel">
            <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
                DataKeyNames="LessonDegreeID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <asp:ImageButton runat="server" Enabled="false" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                                ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' CommandName="LeStateID"
                                CommandArgument='<%#Eval("LeStateID")%>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Subject" HeaderText="课题"></asp:BoundField>
                    <asp:TemplateField HeaderText="上课日期">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                                NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonDegreeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonDegreeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                            <span style="color: Red; font-size: 9px">[<%#GetWeek(Eval("StartDate"))%>]</span>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课时段">
                        <ItemTemplate>
                            <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>'
                                ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Lessons" HeaderText="课时"></asp:BoundField>
                    <asp:BoundField DataField="FactCount" HeaderText="出勤" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="TruancyCount" HeaderText="旷课" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="LateCount" HeaderText="迟到" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="AdvanceCount" HeaderText="早退" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="LeaveCount" HeaderText="请假" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="TeacherName" HeaderText="讲师" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="AssistantName" HeaderText="助教" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="ClassroomName" HeaderText="教室" ReadOnly="True"></asp:BoundField>
                    <asp:TemplateField HeaderText="点名控制">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" ID="hlkAttend" Text="点名控制" NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonDegreeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonDegreeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true"
                        Visible="false" />
                    <asp:TemplateField HeaderText="编辑" ShowHeader="False">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" NavigateUrl='<%#string.Format("PostLessonDegree.aspx?LessonDegreeID={0}&ClassID={1}&GetUrl={2}",Eval("LessonDegreeID"),Eval("ClassID"),swq.Web.PathAndQuery())%>'
                                ID="hlkEdit" Text="编辑" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
        <div class="divpanel">
            &nbsp;<asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="backpanel">
            <label class="lab_buttom">
                <input id="back" causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
            </label>
        </div>
        <div class="divremark">
            <b>注意事项：</b><br />
            1、点击日期进入学员考勤。<br />
            2、日期后面红色数字表示当天是星期几。<br />
            3、点击“清除排课”仅删除未上课的排课，不影响已考勤的排课。<br />
        </div>
    </form>
</body>
</html>
