﻿<%@ Import Namespace="SWTraining" %>

<%@ Page Language="c#" CodeBehind="Holiday.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Class.Holiday"
    Title="教务管理-假日设置" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        假日名称：
        <asp:TextBox ID="tbxHolidayName" runat="server"></asp:TextBox>
        日期：
        <asp:TextBox ID="tbxStartDate" runat="server" onfocus="javascript:return showCalendar(this);"></asp:TextBox>
        至
        <asp:TextBox ID="tbxEndDate" runat="server" onfocus="javascript:return showCalendar(this);"></asp:TextBox>
        <label class="lab_buttom">
<asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click"></asp:Button>
</label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="HolidayID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
            OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
            OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="HolidayName" HeaderText="假日名称" />
                <asp:BoundField DataField="StartDate" HeaderText="开始日期" HtmlEncode="False" DataFormatString="{0:d}"
                    ApplyFormatInEditMode="True" />
                <asp:BoundField DataField="EndDate" HeaderText="结束日期" HtmlEncode="False" DataFormatString="{0:d}"
                    ApplyFormatInEditMode="True" />
                <asp:TemplateField HeaderText="排序" Visible="false">
                    <ItemTemplate>
                        <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" Text="↑"></asp:LinkButton>
                        <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" Text="↓"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="divpanel">
        <b>注意事项：</b><br />
        1、预先设置好假期，排课时才会自动跳过假期。<br />
    </div>
    </form>
</body>
</html>
