﻿<%@ Page Language="c#" CodeBehind="ClassList.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Class.ClassList"
    Title="教务管理-班级列表" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="divpanel">
        <table class="table" cellspacing="0" width="100%" border="0">
            <tr>
                <th colspan="2">
                    班级快速查询
                </th>
            </tr>
            <tr>
                <td>
                    校区：
                </td>
                <td>
                    <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    课程分类：
                </td>
                <td>
                    <asp:DropDownList ID="ddlCourseType" runat="server" DataTextField="CourseTypeName"
                        DataValueField="CourseTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCourseType_SelectedIndexChanged">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    课程：
                </td>
                <td>
                    <asp:DropDownList ID="ddlCourse" runat="server" DataTextField="CourseName" DataValueField="CourseID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    班号：
                </td>
                <td>
                    <asp:TextBox ID="tbxClassID" runat="server" Width="159px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    名称：
                </td>
                <td>
                    <asp:TextBox ID="tbxClassName" runat="server" Width="160px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    日期：
                </td>
                <td>
                    <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                    -<asp:TextBox ID="tbxEndDate" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    班级类型：
                </td>
                <td>
                    <asp:DropDownList ID="ddlClassType" runat="server">
                        <asp:ListItem Value="-1" Text=" "></asp:ListItem>
                        <asp:ListItem Value="0">一对多</asp:ListItem>
                        <asp:ListItem Value="1">一对一</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    状态：
                </td>
                <td>
                    <asp:DropDownList ID="ddlState" runat="server">
                        <asp:ListItem Value="0" Text=""></asp:ListItem>
                        <asp:ListItem Value="1" Text="未开课"></asp:ListItem>
                        <asp:ListItem Value="2" Text="开课中"></asp:ListItem>
                        <asp:ListItem Value="3" Text="已结束"></asp:ListItem>
                        <asp:ListItem Selected="True" Value="4" Text="未结束"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    讲师：
                </td>
                <td>
                    <asp:DropDownList ID="ddlTeacher" runat="server" DataTextField="TrueName" DataValueField="UserID">
                    </asp:DropDownList>
                    <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlTeacher" />
                </td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    <label class="lab_buttom">
                        <asp:Button ID="btnSelect" runat="server" Text="查询" OnClick="btnSelect_Click"></asp:Button>
                    </label>
                </td>
            </tr>
        </table>
    </div>
    <div class="tool_ControlPanel">
        <table cellpadding="0" cellspacing="0">
            <tr>
                <td style="padding-left: 2px">
                    排序：
                </td>
                <td>
                    <asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                        <asp:ListItem Value="0">默认排序</asp:ListItem>
                        <asp:ListItem Value="1">开班日期</asp:ListItem>
                        <asp:ListItem Value="2">班级编号</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
        </table>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" DataKeyNames="ClassID"
            AutoGenerateColumns="False" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="ClassID" ReadOnly="True" HeaderText="班号"></asp:BoundField>
                <asp:TemplateField HeaderText="班级名称">
                    <ItemTemplate>
                        <asp:Image ID="imgClass" ImageUrl='<%# accTheme("Class.gif")%>' ToolTip='<%#Eval("ClassID") %>'
                            runat="server" />
                        <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("ClassName") %>' NavigateUrl='<%# string.Format("ClassFrame.aspx?ClassID={0}&GetUrl={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="StartDate" HeaderText="开课日期" DataFormatString="{0:d}">
                </asp:BoundField>
                <asp:BoundField DataField="TeacherName" HeaderText="老师"></asp:BoundField>
                <asp:BoundField DataField="TimeRule" HeaderText="上课规律"></asp:BoundField>
                <asp:BoundField DataField="SchoolName" HeaderText="校区"></asp:BoundField>
                <asp:TemplateField HeaderText="招生比例">
                    <ItemTemplate>
                        <uc2:Progress ID="Progress1" runat="server" MaxNum='<%#Eval("PlanCount") %>' MinNum='<%#Eval("StuCount") %>'
                            ProgressWidth="50px" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="上课进度">
                    <ItemTemplate>
                        <uc2:Progress ID="Progress3" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                            ProgressWidth="50px" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="排课进度">
                    <ItemTemplate>
                        <uc2:Progress ID="Progress2" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("ArrangeLessons") %>'
                            ProgressWidth="50px" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="课程表">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="hlkLessons" Text="课程表" ImageUrl='<%# accTheme("Lessons.gif")%>'
                            CssClass="noborder" NavigateUrl='<%# string.Format("ClassFrame.aspx?ClassID={0}&pageindex=2&GetUrl={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="控制面板">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkShow" runat="server" Text="控制面板" NavigateUrl='<%# string.Format("ClassFrame.aspx?ClassID={0}&GetUrl={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="hlkEdit" Text="编辑" NavigateUrl='<%# string.Format("ClassFrame.aspx?ClassID={0}&PageIndex=0&action=edit&GetURL={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="divpanel">
        <b>注意事项：</b><br />
        1、当您发现开好的班不见了，请不要着急，看清楚查询控制面板上的状态为“未结束”，把它修改了空白，再点击查询试试。<br />
    </div>
    </form>
</body>
</html>
