﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Attend.aspx.cs" Inherits="SWTraining.Class.Attend"
    Title="教务管理-上课点名" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }
      
    </script>
    <script type="text/javascript">
        function Send(lid) {
            var StuClassID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StuClassID += "," + e.value;
                    }
                }
            }

            if (StuClassID.length > 0) {
                StuClassID = StuClassID.substring(1, StuClassID.length);
                document.getElementById("StuClassID").value = StuClassID;
                document.formStudent.action = "../SMS/SendHighToStudent.aspx?action=attend&LessonDegreeID=" + lid;
                document.formStudent.submit();
            }
        }
    </script>
</head>
<body>
    <script type="text/javascript">
        var IsPrint = false;
    </script>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>
    </div>
    <form id="form1" runat="server">
    <div class="divpanel">
        <table cellspacing="0" border="0" style="width: 100%">
            <tr>
                <td style="width: 120px; vertical-align: top">
                    <table class="table" cellspacing="0">
                        <tr>
                            <th>
                                学员名单簿
                            </th>
                        </tr>
                        <tr>
                            <td>
                                <asp:ListBox ID="lbxStudents" runat="server" Height="320px" Width="100%" DataTextField="RichStudentName" ToolTip="拖放鼠标可多选。"
                                    DataValueField="StuClassID" SelectionMode="Multiple"></asp:ListBox>
                                <asp:CheckBox ID="cbxAll" runat="server" Text="显示全部" AutoPostBack="True" OnCheckedChanged="cbxAll_CheckedChanged" /><br />
                                <label class="lab_buttom">
                                    <asp:Button ID="btnSelectAll" runat="server" Text="全选" OnClick="btnSelectAll_Click" />
                                </label>
                                <label class="lab_buttom">
                                    <asp:Button ID="btnCancel" runat="server" OnClick="btnCancel_Click" Text="取消" />
                                </label>
                            </td>
                        </tr>
                    </table>
                </td>
                <td style="vertical-align: top">
                    <div class="divpanel">
                        <table class="table" cellspacing="0">
                            <tr>
                                <th>
                                    上课主题
                                </th>
                            </tr>
                            <tr>
                                <td style="vertical-align: bottom;">
                                    <table cellpadding="0" cellspacing="0">
                                        <tr>
                                            <td>
                                                上课日期：
                                            </td>
                                            <td>
                                                <asp:Label ID="labDateAndTime" runat="server"></asp:Label>
                                                <asp:Label ID="labLessonType" runat="server"></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                本课课题：
                                            </td>
                                            <td>
                                                <asp:TextBox ID="tbxSubject" runat="server" Width="184px"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                备注/作业：
                                            </td>
                                            <td>
                                                <div id="msg" style="color: #676767">
                                                </div>
                                                <asp:TextBox ID="tbxCourseRemark" runat="server" Height="48px" TextMode="MultiLine"
                                                    Width="333px"></asp:TextBox>
                                                <label class="lab_buttom">
                                                    <asp:Button ID="btnSave" runat="server" Text="更新" OnClick="btnSave_Click" />
                                                </label>
                                                &nbsp;
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="tool_ControlPanel">
                        <table cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <input onclick="Checks(this)" type="checkbox">
                                </td>
                                <td>
                                    全选
                                </td>
                                <td class="ico_sms">
                                </td>
                                <td>
                                    <asp:HyperLink ID="hlkSMS" runat="server" NavigateUrl='<%#string.Format("javascript:Send("+Request["LessonDegreeID"]+");void(0);") %>'
                                        Text="发短信" />
                                </td>
                                <td class="ico_separator">
                                </td>
                                <td>
                                    考勤类型：
                                </td>
                                <td>
                                    <asp:RadioButtonList ID="rblAtStateID" runat="server" RepeatDirection="Horizontal">
                                        <asp:ListItem Value="1" Text="出勤" Selected="True"></asp:ListItem>
                                        <asp:ListItem Value="2" Text="迟到"></asp:ListItem>
                                        <asp:ListItem Value="3" Text="早退"></asp:ListItem>
                                        <asp:ListItem Value="4" Text="旷课"></asp:ListItem>
                                        <asp:ListItem Value="5" Text="请假"></asp:ListItem>
                                    </asp:RadioButtonList>
                                </td>
                                <td>
                                    备注：
                                </td>
                                <td>
                                    <asp:TextBox ID="tbxRemark" runat="server"></asp:TextBox><label class="lab_buttom"><asp:Button
                                        ID="btnExe" runat="server" Text="执行考勤" OnClick="btnExe_Click" /></label>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="both">
                    </div>
                    <div class="divpanel">
                        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
                            DataKeyNames="AttendID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing"
                            OnRowUpdating="GridView1_RowUpdating" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                            <Columns>
                                <asp:TemplateField HeaderText="学号" ItemStyle-Width="120">
                                    <ItemTemplate>
                                        <input type="checkbox" id="id" value='<%#Eval("StuClassID")%>' />
                                        <%#Eval("StudentID")%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="姓名">
                                    <ItemTemplate>
                                        <%#Eval("StudentName")%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="选班状态">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="ScStateID" Text='<%# Rs.Items.GetScState(Eval("ScStateID")) %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="课时">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="labCurrentLessons" Text='<%#Eval("CurrentLessons") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="ddlLessons" runat="server">
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="出勤状态">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="AtStateID" Text='<%# Rs.Items.GetAtState(Eval("AtStateID"))%>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="ddlAtStateID" runat="server">
                                            <asp:ListItem Value="1" Text="正常"></asp:ListItem>
                                            <asp:ListItem Value="2" Text="迟到"></asp:ListItem>
                                            <asp:ListItem Value="3" Text="早退"></asp:ListItem>
                                            <asp:ListItem Value="4" Text="旷课"></asp:ListItem>
                                            <asp:ListItem Value="5" Text="请假"></asp:ListItem>
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="签到">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="labSignOn" Text='<%#Eval("SignOn","{0:HH:mm}")%>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="签退">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="labSignOut" Text='<%#Eval("SignOut","{0:HH:mm}")%>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="备注/课堂表现">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="RemarkText" Text='<%#Eval("Remark")%>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:TextBox ID="tbxRemark" Text='<%#Eval("Remark")%>' runat="server" TextMode="SingleLine"
                                            Rows="2" Columns="30"></asp:TextBox>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="个人课时进度">
                                    <ItemTemplate>
                                        <uc1:Progress ID="Progress1" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>' StartDate='<%#Eval("DateAndTime") %>' ExpiryDate='<%#Eval("ExpiryDate") %>'
                                            ProgressParentWidth="60%" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="打印">
                                    <ItemTemplate>
                                        <asp:HyperLink ID="hlkPrint" runat="server" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("AttendID")) %>'
                                            ImageUrl='<%# accTheme("print.gif")%>' CssClass="noborder"></asp:HyperLink>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                                <asp:TemplateField HeaderText="删除">
                                    <ItemTemplate>
                                        <asp:LinkButton ID="lbnDelete" runat="server" CommandName="Delete" Text="删除" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </div>
                    <div class="divpanel">
                        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                    </div>
                </td>
            </tr>
        </table>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input id="Button1" causesvalidation="false" type="button" runat="server" onclick="back()"
                value="返回" />
        </label>
        <label class="lab_buttom">
            <input id="btnTop" causesvalidation="false" type="button" onclick="window.location='LessonDegree.aspx?ClassID=<%=Request.QueryString["ClassID"] %>'"
                value="返回列表" />
        </label>
    </div>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、选班日期在上课日期之后的学员不会出现在名单簿上。<br />
        2、考勤方法：先选中左边学员（可多选）,然后选择考勤类型，点击“执行考勤”即可。<br />
        3、选择显示全部，将出现课时已上完的学员姓名及选班日期在本次上课日期之后的学员。<br />
        4、当勾选“显示全部”，学员名单簿姓名后面的数字表示剩余课时，负数表示已上超的课时数。<br />
    </div>
    </form>
    <!--短信Post传递参数代码S-->
    <form id="formStudent" name="formStudent" method="post">
    <input id="StuClassID" name="StuClassID" type="hidden" value="" />
    </form>
    <!--短信Post传递参数代码E-->
</body>
</html>
