﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AddStudent.aspx.cs" Inherits="SWTraining.Class.AddStudent" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div class="tool_Search">
        校区：<asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
        </asp:DropDownList>
        ID卡号：<asp:TextBox ID="tbxSignInID" runat="server" Width="109px"></asp:TextBox>
        学号：<asp:TextBox ID="tbxStudentID" runat="server" Width="96px"></asp:TextBox>
        姓名：<asp:TextBox ID="tbxStudentName" runat="server" Width="96px"></asp:TextBox>
        <label class="lab_buttom">
            <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" Text="查询" />
        </label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="BillID" OnRowDataBound="GridView1_RowDataBound">
            <SelectedRowStyle CssClass="selected" />
            <Columns>
                <asp:TemplateField HeaderText="学号">
                    <ItemTemplate>
                        <%#Eval("StudentID")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员姓名">
                    <ItemTemplate>
                        <%#Eval("StudentName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="ProductName" HeaderText="课程" ReadOnly="True" />
                <asp:TemplateField HeaderText="日期">
                    <ItemTemplate>
                        <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="单号">
                    <ItemTemplate>
                        <asp:Label ID="labBillID" runat="server" Text='<%# Bind("BillID") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="单价">
                    <ItemTemplate>
                        <asp:Label ID="labUnitPrice" runat="server" Text='<%# Bind("UnitPrice","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="数量">
                    <ItemTemplate>
                        <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="单位">
                    <ItemTemplate>
                        <asp:Label ID="labUnitName" runat="server" Text='<%# Bind("UnitName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="优惠">
                    <ItemTemplate>
                        <asp:Label ID="labFavorable" runat="server" Text='<%# Eval("Favorable","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="合计">
                    <ItemTemplate>
                        <asp:Label ID="labTotalPrice" runat="server" Text='<%# Bind("TotalPrice","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="备注">
                    <ItemTemplate>
                        <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="增加">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="增加" CommandName="Delete" CommandArgument='<%#Eval("BillItemID")%>'></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
