﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuSignIn.aspx.cs" Inherits="SWTraining.Attend.StuSignIn"
    Title="教务管理-学员签到管理" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <script type="text/javascript">
        var IsPrint = false;
    </script>
    <form id="form1" runat="server">
    <div class="tool_Search">
        ＩＤ卡号：<asp:TextBox ID="tbxSignInID" runat="server"></asp:TextBox>
        学号：<asp:TextBox ID="tbxStudentID" runat="server"></asp:TextBox>
        校区：<asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
        </asp:DropDownList>
        日期：<asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
        状态：
        <asp:DropDownList ID="ddlAtStateID" runat="server">
            <asp:ListItem Value="-2">全部</asp:ListItem>
            <asp:ListItem Value="-1">未考勤</asp:ListItem>
            <asp:ListItem Value="0">已考勤</asp:ListItem>
            <asp:ListItem Text="正常" Value="1"></asp:ListItem>
            <asp:ListItem Text="迟到" Value="2"></asp:ListItem>
            <asp:ListItem Text="早退" Value="3"></asp:ListItem>
            <asp:ListItem Text="旷课" Value="4"></asp:ListItem>
            <asp:ListItem Text="请假" Value="5"></asp:ListItem>
        </asp:DropDownList>
        筛选：<asp:DropDownList ID="ddlLessonState" runat="server">
            <asp:ListItem Value="0" Text=""></asp:ListItem>
            <asp:ListItem Value="1" Text="课时未上完"></asp:ListItem>
            <asp:ListItem Value="2" Text="课时已上完"></asp:ListItem>
            <asp:ListItem Value="3" Text="课时已上超"></asp:ListItem>
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnSelect" runat="server" OnClick="btnSelect_Click" Text="查询" />
        </label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="gridview"
            DataKeyNames="AttendID,StuClassID,LessonDegreeID" OnRowCancelingEdit="GridView1_RowCancelingEdit"
            OnRowDataBound="GridView1_RowDataBound" OnRowDeleting="GridView1_RowDeleting"
            OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating">
            <Columns>
                <asp:BoundField DataField="StudentID" HeaderText="学号" ReadOnly="True" />
                <asp:TemplateField HeaderText="姓名">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkControlPanel" runat="server" Text='<%#Eval("StudentName")%>'
                            NavigateUrl='<%# string.Format("../Affairs/StudentFrame.aspx?StudentID={0}&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="班号">
                    <ItemTemplate>
                        <asp:Label ID="ClassID" runat="server" Text='<%# Eval("ClassID") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="班级名称">
                    <ItemTemplate>
                        <asp:Label ID="ClassName" runat="server" Text='<%# Eval("ClassName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="选班状态">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="ScStateID" Text='<%# Rs.Items.GetScState(Eval("ScStateID")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="上课日期">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                            NavigateUrl='<%# string.Format("../Class/ClassFrame.aspx?ClassID={0}&LessonDegreeID={1}&pageindex=2&action=attend&GetUrl={2}",Eval("ClassID"),Eval("LessonDegreeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        <span style="color: Red; font-size: 9px">[<%#GetWeek(Eval("StartDate"))%>]</span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="上课时段">
                    <ItemTemplate>
                        <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="出勤状态">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="AtStateID" Text='<%# Rs.Items.GetAtState(Eval("AtStateID"))%>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlAtStateID" runat="server">
                            <asp:ListItem Text="正常" Value="1"></asp:ListItem>
                            <asp:ListItem Text="迟到" Value="2"></asp:ListItem>
                            <asp:ListItem Text="早退" Value="3"></asp:ListItem>
                            <asp:ListItem Text="旷课" Value="4"></asp:ListItem>
                            <asp:ListItem Text="请假" Value="5"></asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="课时">
                    <ItemTemplate>
                        <asp:Label ID="labCurrentLessons" runat="server" Text='<%#Eval("CurrentLessons") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlLessons" runat="server">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="备注">
                    <ItemTemplate>
                        <asp:Label ID="RemarkText" runat="server" Text='<%#Eval("Remark")%>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxRemark" runat="server" Columns="30" Rows="2" Text='<%#Eval("Remark")%>'
                            TextMode="SingleLine"></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="个人课时进度">
                    <ItemTemplate>
                        <uc1:Progress ID="Progress1" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                            StartDate='<%#Eval("DateAndTime") %>' ExpiryDate='<%#Eval("ExpiryDate") %>' Width="90%">
                        </uc1:Progress>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="打印">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkPrint" runat="server" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("AttendID")) %>'
                            ImageUrl='<%# accTheme("print.gif")%>' CssClass="noborder"></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="签到" ShowEditButton="true" />
                <asp:TemplateField HeaderText="清除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"
                            Text="清除"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>
    </div>
</body>
</html>
