﻿<%@ Page Language="c#" CodeBehind="FeeItem.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Admin.FeeItem"
    Title="系统设置-收费项设置" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        <asp:Label ID="labFeeItemName" Text="收费名称：" runat="server"></asp:Label>
        <asp:TextBox ID="tbxFeeItemName" runat="server"></asp:TextBox>
        金额：<asp:TextBox runat="server" ID="tbxPrice"></asp:TextBox>
        <label class="lab_buttom">
        <asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click"></asp:Button>
        </label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="FeeItemID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
            OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
            OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="FeeItemID" ReadOnly="True" HeaderText="编号" />
                <asp:BoundField DataField="FeeItemName" HeaderText="收费名称" />
                <asp:TemplateField HeaderText="金额">
                    <EditItemTemplate>
                        <asp:TextBox runat="server" ID="tbxPrice" Text='<%# Eval("Price","{0:f2}") %>'></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labPrice" Text='<%# Eval("Price","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态">
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlLockState" runat="server" SelectedIndex='<%# Eval("LockState") %>'>
                            <asp:ListItem Selected="True" Text="禁用" Value="0"></asp:ListItem>
                            <asp:ListItem Text="启用" Value="1"></asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                        <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" Text="↑"></asp:LinkButton>
                        <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" Text="↓"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="btnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick=" <%# Rs.Messages.确定删除%> "></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>

        <div class="divpanel">
        <b>注意事项：</b><br />
        1、收费项指除课程、教材之外的第三类收费项目，比如：空调费、报名费等。</span><br />
        2、严禁在此处设置课程费用。<br />
    </div>
    </form>
</body>
</html>
