﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CoursePrice.aspx.cs" Inherits="SWTraining.Admin.CoursePrice"
    Title="系统设置-课程设置-课程价格" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .style1
        {
            color: #FF0000;
        }
    </style>
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        课程：<asp:Label ID="labCourseName" runat="server" Font-Bold="True"></asp:Label>
        单位：<asp:Label ID="labUnitName" runat="server" Font-Bold="True"></asp:Label>
        &nbsp;标准价：<asp:Label ID="labUnitPrice" runat="server" Font-Bold="True"></asp:Label><br />
        校区：
        <asp:DropDownList ID="ddlSchool" runat="server"
            DataValueField="SchoolID" DataTextField="SchoolName">
        </asp:DropDownList>
        金额：<asp:TextBox ID="tbxUnitPrice" runat="server" Width="57px"></asp:TextBox>
        数量范围：<asp:TextBox ID="tbxStart" runat="server" Width="57px"></asp:TextBox>
        -<asp:TextBox ID="tbxEnd" runat="server" Width="57px"></asp:TextBox>
        <label class="lab_buttom">
            <asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click"></asp:Button>
        </label>
        &nbsp;<asp:HyperLink ID="hlkUp" runat="server" ImageUrl='<%#accTheme("up.gif") %>' />
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="CoursePriceID" OnRowCancelingEdit="GridView1_RowCancelingEdit"
            OnRowCommand="GridView1_RowCommand" OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating"
            OnRowCreated="GridView1_RowCreated" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound"
            EnableModelValidation="True">
            <Columns>
                <asp:TemplateField HeaderText="校区">
                    <ItemTemplate>
                        <%# Eval("SchoolName") %>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlSchool" runat="server" DataSource='<%# swq.Cache.Fill(swq.Cache.GetSchool(), "","全校区") %>'
                            SelectedValue='<%# Eval("SchoolID") %>' DataValueField="SchoolID" DataTextField="SchoolName">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="价格">
                    <ItemTemplate>
                        <%# Eval("UnitPrice","{0:c2}")%>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:f2}")%>' Width="50px"></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="数量范围">
                    <ItemTemplate>
                        <%# Eval("StartAmount")%>-<%# Eval("EndAmount")%>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxStart" runat="server" Text='<%# Eval("StartAmount") %>' Width="50px"></asp:TextBox>-<asp:TextBox ID="tbxEnd" runat="server" Text='<%# Eval("EndAmount") %>' Width="50px"></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、此处用于设置课程在每个校区的不同价格，也可以根据购买数量设置不同价格。<br />
        2、<span class="style1">格式如：0-0 
        表示不限数量；1-5表示一次购买数量在1至5（包括5）区间的价格；6-0表示数量大于等于6时的价格。</span><br />
    </div>
    </form>
</body>
</html>
