﻿<%@ Page Language="c#" CodeBehind="Course.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Admin.Course"
    Title="系统设置-课程设置" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/Ann.ascx" TagName="Ann" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .style1
        {
            color: #FF0000;
        }
    </style>
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <uc1:Ann ID="Ann1" runat="server" />
    <div class="tool_Search">
        <asp:Literal Text="课程名称：" runat="server" />
        <asp:TextBox ID="tbxCourseName" runat="server"></asp:TextBox>
        <asp:Label ID="labUnitPrice" runat="server" Text="价格："></asp:Label>
        <%=swq.CurrentCurrencySymbol %>
        <asp:TextBox ID="tbxUnitPrice" runat="server" Width="65px"></asp:TextBox>
        单位：
        <asp:DropDownList ID="ddlUnit" runat="server" DataSource='<%# swq.Cache.Fill(swq.Cache.GetSysUnit(),"UnitType=1",Rs.Strings.请选择) %>'
            DataValueField="UnitID" DataTextField="UnitName" AutoPostBack="True" OnSelectedIndexChanged="ddlUnit_SelectedIndexChanged">
        </asp:DropDownList>
        <asp:DropDownList ID="ddlTermUnit" runat="server" Visible="False">
            <asp:ListItem Text="" Value=""></asp:ListItem>
            <asp:ListItem>天</asp:ListItem>
            <asp:ListItem>周</asp:ListItem>
            <asp:ListItem>月</asp:ListItem>
            <asp:ListItem>季</asp:ListItem>
            <asp:ListItem>年</asp:ListItem>
        </asp:DropDownList>
        每课时：<asp:TextBox ID="tbxLessonMinute" runat="server" Width="55px"></asp:TextBox>
        分钟&nbsp; 分类：
        <asp:DropDownList ID="ddlCourseType" runat="server" DataSource="<%# swq.Cache.Fill(swq.Cache.GetCourseType(),Rs.Strings.请选择) %>"
            DataValueField="CourseTypeID" DataTextField="CourseTypeName">
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click"></asp:Button>
        </label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="CourseID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
            OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
            OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="CourseID" ReadOnly="True" HeaderText="编号" />
                <asp:BoundField DataField="CourseName" HeaderText="课程名称" />
                <asp:TemplateField HeaderText="价格(默认)">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:c2}")%>'
                            NavigateUrl='<%# string.Format("CoursePrice.aspx?CourseID={0}&GetURL={1}",Eval("CourseID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:f2}")%>'></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="单位">
                    <ItemTemplate>
                        <%# Eval("UnitName")%><%# string.IsNullOrEmpty(Eval("TermUnit").ToString()) ? "" : "(" + Eval("TermUnit") + ")"%>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlUnit" runat="server" DataSource='<%# swq.Cache.Fill(swq.Cache.GetSysUnit(),"UnitType=1",null) %>'
                            AutoPostBack="true" OnSelectedIndexChanged="gvddlUnit_SelectedIndexChanged" SelectedValue='<%# Eval("UnitID") %>'
                            DataValueField="UnitID" DataTextField="UnitName">
                        </asp:DropDownList>
                        <asp:DropDownList ID="ddlTermUnit" runat="server" Visible="False" SelectedValue='<%# Eval("TermUnit") %>'>
                            <asp:ListItem Text="" Value=""></asp:ListItem>
                            <asp:ListItem>天</asp:ListItem>
                            <asp:ListItem>周</asp:ListItem>
                            <asp:ListItem>月</asp:ListItem>
                            <asp:ListItem>季</asp:ListItem>
                            <asp:ListItem>年</asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="分钟/课时">
                    <ItemTemplate>
                        <%# Eval("LessonMinute")%>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxLessonMinute" runat="server" Width="40px" Text='<%# Eval("LessonMinute")%>'></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="分类">
                    <ItemTemplate>
                        <asp:Label ID="labCourseTypeName" runat="server" Text='<%# Eval("CourseTypeName")%>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlCourseType" runat="server" DataSource="<%# swq.Cache.GetCourseType() %>"
                            DataValueField="CourseTypeID" DataTextField="CourseTypeName">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                            <asp:ListItem Value="0" Selected="True" Text="禁用"></asp:ListItem>
                            <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                        <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" Text="↑"></asp:LinkButton>
                        <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" Text="↓"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="tool_Search">
        课程名称：
        <asp:TextBox ID="tbxFCourseName" runat="server"></asp:TextBox>
        <label class="lab_buttom">
            <asp:Button ID="btnSearch" runat="server" Text="查找" OnClick="btnSearch_Click" />
        </label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <b>注意事项：</b><br />
        1、<span class="style1">点击具体课程的金额可设定课程在各校区的不同价格，还可以根据购买数量设置不同价格。</span><br />
        2、以“<b>课时</b>”为单位，一般用于课外辅导、乐器类培训、一对一教学模式等，是一种高精度、高度量化的管理模式。<br />
        3、当设置以“<strong>课时</strong>”为单位时，课程价格应设置为1课时的价格，另外每个班级的1课时=?分钟是可以不同的，所以先确定您每课时分钟数是多少，再确定课时单价。<br />
        4、以“<strong>学期</strong>”为单位的模式又分为：按课时量化，按时间量化。按课时量化时与课时制类似但略逊于课时制，可以做到较高的精度。按时间量化适合班级总课时不确定，学员购买课程课时数也不确定的情况，灵活易用，但量化精度不高，无法动态准确分析学员课时学费消耗情况等，通常我们称为按月收费、按年收费等等。<br />
    </div>
    </form>
</body>
</html>
