﻿<%@ Page Language="c#" ValidateRequest="false" CodeBehind="Basic.aspx.cs" AutoEventWireup="True"
    Inherits="SWTraining.Admin.Basic" Title="系统设置-基础参数" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/CodeBox.ascx" TagName="CodeBox" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .style1
        {
            color: #009933;
        }
        .style2
        {
            color: #CC6600;
        }
    </style>
</head>
<body>
    <form id="Form1" method="post" runat="server" enctype="multipart/form-data">
    <div class="divpanel">
        <table class="table" border="0" cellspacing="0">
            <tr>
                <th colspan="2">
                    基础设置
                </th>
            </tr>
            <tr>
                <td>
                    系统名称：
                </td>
                <td>
                    <asp:TextBox ID="tbxSystemName" runat="server" Width="229px"></asp:TextBox>
                    <span style="color: #ff0000">*</span>
                </td>
            </tr>
            <tr>
                <td>
                    样式设置：
                </td>
                <td>
                    <asp:DropDownList ID="ddlStyleType" runat="server">
                        <asp:ListItem Value="Green" Text="春意盎然"></asp:ListItem>
                        <asp:ListItem Value="Blue" Text="清凉之夏"></asp:ListItem>
                        <asp:ListItem Value="Orange" Text="金秋时节"></asp:ListItem>
                        <asp:ListItem Value="Red" Text="冬暖如春"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    文字设置：
                </td>
                <td>
                    <asp:TextBox ID="tbxFontName" runat="server" ToolTip="fontName" Width="120px"></asp:TextBox>
                    <asp:DropDownList ID="ddlFontSize" runat="server" ToolTip="fontSize">
                        <asp:ListItem>9</asp:ListItem>
                        <asp:ListItem>10</asp:ListItem>
                        <asp:ListItem>11</asp:ListItem>
                        <asp:ListItem Selected="True">12</asp:ListItem>
                        <asp:ListItem>13</asp:ListItem>
                        <asp:ListItem>14</asp:ListItem>
                        <asp:ListItem>15</asp:ListItem>
                        <asp:ListItem>16</asp:ListItem>
                    </asp:DropDownList>
                    px
                </td>
            </tr>
            <tr>
                <td>
                    需验证码登录：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblValidateNum" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Text="否" Value="0"></asp:ListItem>
                        <asp:ListItem Text="是" Value="1"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    显示禁用内容：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblLockedVisible" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    在线超时：
                </td>
                <td>
                    <asp:TextBox ID="tbxOnlineOvertime" runat="server" Width="40px"></asp:TextBox><asp:Literal
                        Text="分钟" runat="server" />
                    <asp:RegularExpressionValidator ID="_tbxOnlineOvertime" runat="server" ControlToValidate="tbxOnlineOvertime"
                        Display="Dynamic" ValidationExpression="\d{0,8}"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr visible="false">
                <td>
                    限时编辑：
                </td>
                <td>
                    <asp:TextBox ID="tbxMinutes" runat="server" Width="48px"></asp:TextBox><asp:Literal
                        Text="分钟" runat="server" />
                    <asp:RegularExpressionValidator ID="_tbxMinutes" runat="server" ControlToValidate="tbxMinutes"
                        Display="Dynamic" ValidationExpression="\d{0,8}"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    缓存过期：
                </td>
                <td style="height: 26px">
                    <asp:TextBox ID="tbxCacheTimeOut" runat="server" Width="48px"></asp:TextBox><asp:Literal
                        Text="分钟" runat="server" />
                    <asp:RegularExpressionValidator ID="_tbxCacheOutTime" runat="server" ControlToValidate="tbxCacheTimeOut"
                        Display="Dynamic" ValidationExpression="\d{0,8}"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    数据库备份路径：
                </td>
                <td style="height: 26px">
                    <asp:TextBox ID="tbxBackupPath" runat="server" Width="256px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    上传图片宽度：
                </td>
                <td style="height: 26px">
                    <asp:TextBox ID="tbxPicWidth" runat="server" Width="48px"></asp:TextBox>px<asp:RegularExpressionValidator
                        ID="_tbxPicWidth" runat="server" ControlToValidate="tbxPicWidth" Display="Dynamic"
                        ValidationExpression="\d{0,4}"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td>
                    上传相片高度：
                </td>
                <td>
                    <asp:TextBox ID="tbxPicHeight" runat="server" Width="48px"></asp:TextBox>px<asp:RegularExpressionValidator
                        ID="_tbxPicHeight" runat="server" ControlToValidate="tbxPicHeight" Display="Dynamic"
                        ValidationExpression="\d{0,4}"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td>
                    默认“全局管理”：(当具备权限时)
                </td>
                <td>
                    <asp:RadioButtonList ID="rblGlobalLogin" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    允许手动编号：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblCustomID" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    学员默认密码：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblStuDefaultPassword" runat="server" Width="299px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="空"></asp:ListItem>
                        <asp:ListItem Value="1" Text="生日"></asp:ListItem>
                        <asp:ListItem Value="2" Text="学号"></asp:ListItem>
                        <asp:ListItem Value="3" Text="手机号后6位"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    班级模式：
                </td>
                <td>
                    <table>
                        <tr>
                            <td style="background-color: White; border: solid 1px #cccccc">
                                <asp:CheckBoxList ID="cblClassMode" runat="server">
                                    <asp:ListItem Value="1">一对多模式(以“学期”为单位)</asp:ListItem>
                                    <asp:ListItem Value="2">一对多模式(以“课时”为单位)</asp:ListItem>
                                    <asp:ListItem Value="3">一对一模式</asp:ListItem>
                                </asp:CheckBoxList>
                            </td>
                            <td>
                                <span style="color: #ff0000">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td style="background-color: White; border: solid 1px #cccccc">
                                扩展学期：<asp:DropDownList ID="ddlTimeMetric" runat="server">
                                    <asp:ListItem Value="0">关闭</asp:ListItem>
                                    <asp:ListItem Value="1">开启</asp:ListItem>
                                </asp:DropDownList>
                                （支持按天、周、月、季、年方式收费）
                            </td>
                            <td>
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td>
                    根据身份设定筛选员工：
                </td>
                <td>
                    <asp:DropDownList ID="ddlFilterUsers" runat="server">
                        <asp:ListItem Value="0">否</asp:ListItem>
                        <asp:ListItem Value="1">是</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp; 参考依据并非用户组（角色），而是根据员工基本信息“是否授课”等字段设定。
                </td>
            </tr>
            <tr>
                <td>
                    软件ICO图标：
                </td>
                <td>
                    <asp:FileUpload ID="fudIco" runat="server" />
                    <label class="lab_buttom">
                        <asp:Button ID="btnUpIco" runat="server" OnClick="btnUpIco_Click" Text="上传Ico" />
                    </label>
                    <asp:Image ID="imgIco" runat="server" Height="20px" />
                </td>
            </tr>
            <tr>
                <td>
                    机构LOGO：<br />
                    (出现在登录系统后左上角)
                </td>
                <td>
                    <asp:TextBox ID="tbxLogo" runat="server" Width="258px"></asp:TextBox>
                    <asp:Image ID="imgLogo" runat="server" Height="20px" />
                    <br />
                    <asp:FileUpload ID="fudLogo" runat="server" />
                    <label class="lab_buttom">
                        <asp:Button ID="btnUpLogo" runat="server" OnClick="btnUpLogo_Click" Text="上传Logo" />
                    </label>
                    (164px X 39px)
                </td>
            </tr>
            <tr>
                <td>
                    登录框图片设置：<br />
                    (出现在登录系统窗口)
                </td>
                <td>
                    <table cellspacing="0">
                        <tr>
                            <td>
                                <asp:TextBox ID="tbxLoginLogo" runat="server" Width="258px"></asp:TextBox>
                                <asp:Image ID="imgLoginLogo" runat="server" Height="20px" Width="20px" />
                                <br />
                                <asp:FileUpload ID="fudLoginLogo" runat="server" />
                                <label class="lab_buttom">
                                    <asp:Button ID="btnUpLoginLogo" runat="server" OnClick="btnUpLoginLogo_Click" Text="上传Logo" />
                                </label>
                                &nbsp;(60px&nbsp;X 60px)<br />
                                字体：<asp:DropDownList ID="ddlLoginTitleFonts" runat="server">
                                </asp:DropDownList>
                                &nbsp;样式：<asp:DropDownList ID="ddlLoginTitleFontStyle" runat="server">
                                    <asp:ListItem Value="0">普通</asp:ListItem>
                                    <asp:ListItem Value="1">粗体</asp:ListItem>
                                    <asp:ListItem Value="2">斜体</asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:CheckBox ID="cbxAutoLoginLogo" runat="server" Text="自动合成" />
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td>
                    版权信息：
                </td>
                <td>
                    <uc1:CodeBox ID="tbxCopyright" runat="server" Rendering="RenderingXsl" Height="60px"
                        Width="350px" />
                </td>
            </tr>
            <tr>
                <td>
                    积分累加方式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlPointsMode" runat="server">
                        <asp:ListItem Value="0">根据消费自动增加</asp:ListItem>
                        <asp:ListItem Value="1">纯手动增减</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    “查询分析”显示方式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlSearchShowType" runat="server">
                        <asp:ListItem Value="0">简单</asp:ListItem>
                        <asp:ListItem Value="1">舒适</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    办理异动后，选班状态可修改：
                </td>
                <td>
                    <asp:DropDownList ID="ddlChangeMode" runat="server">
                        <asp:ListItem Value="0">禁止</asp:ListItem>
                        <asp:ListItem Value="1">允许</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    班主任（助教、学管）角色：
                </td>
                <td>
                    <asp:DropDownList ID="ddlHeadTeacher" runat="server">
                        <asp:ListItem Value="0">禁用</asp:ListItem>
                        <asp:ListItem Value="1">启用</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    分页查询最大数据量：
                </td>
                <td>
                    <asp:DropDownList ID="ddlTopLoop" runat="server">
                        <asp:ListItem Value="0">不限</asp:ListItem>
                        <asp:ListItem>100</asp:ListItem>
                        <asp:ListItem>500</asp:ListItem>
                        <asp:ListItem>1000</asp:ListItem>
                        <asp:ListItem>2000</asp:ListItem>
                        <asp:ListItem>3000</asp:ListItem>
                        <asp:ListItem>4000</asp:ListItem>
                        <asp:ListItem>5000</asp:ListItem>
                        <asp:ListItem>10000</asp:ListItem>
                        <asp:ListItem>100000</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    权限策略：</td>
                <td>
                    <asp:DropDownList ID="ddlAdvancedPurview" runat="server">
                        <asp:ListItem Value="0">经典</asp:ListItem>
                        <asp:ListItem Value="1">高级</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    咨询设置
                </th>
            </tr>
            <tr>
                <td>
                    允许重复录入咨询信息：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblRepeatConsult" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    咨询信息可重复录入限期：
                </td>
                <td>
                    <asp:TextBox ID="tbxPreDays" runat="server" Width="40px"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="_tbxPreDays" runat="server" ControlToValidate="tbxPreDays"
                        Display="Dynamic" ValidationExpression="\d{0,8}"></asp:RegularExpressionValidator>
                    天（超过N天没有回访将可以重复录入）
                </td>
            </tr>
            <tr>
                <td>
                    私有咨询信息释放天数：
                </td>
                <td>
                    <asp:TextBox ID="tbxPrivateDays" runat="server" Width="40px"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="_tbxPrivateDays" runat="server" ControlToValidate="tbxPrivateDays"
                        Display="Dynamic" ValidationExpression="\d{0,8}"></asp:RegularExpressionValidator>
                    天（顾问工作台混合模式时，超过N天没有回访将被释放为共享资源）
                </td>
            </tr>
            <tr>
                <td>
                    顾问工作台可跨校区：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblConsultantAcrossSchool" runat="server" Width="104px"
                        RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    顾问工作台模式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlPotentialMode" runat="server">
                        <asp:ListItem Value="1">独立模式</asp:ListItem>
                        <asp:ListItem Value="2">协同模式</asp:ListItem>
                        <asp:ListItem Value="3">混合模式</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    正式报名咨询顾问采集模式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlConsultantGatherMode" runat="server">
                        <asp:ListItem Value="0">手工指定</asp:ListItem>
                        <asp:ListItem Value="1">自动（可为空）</asp:ListItem>
                        <asp:ListItem Value="2">自动（不为空）</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    网上报名自动分配顾问：
                </td>
                <td>
                    <asp:CheckBox ID="cbxAutoAllocation" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td>
                    必需设置回访预约时间：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblNextReplyDate" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    网络设置
                </th>
            </tr>
            <tr>
                <td>
                    可访问的网域：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblIPType" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="单机"></asp:ListItem>
                        <asp:ListItem Value="1" Text="局域网"></asp:ListItem>
                        <asp:ListItem Value="2" Text="广域网"></asp:ListItem>
                        <asp:ListItem Value="3" Text="局＋广网"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    可访问的ＩＰ段：
                </td>
                <td>
                    <asp:TextBox ID="tbxOpenIP" runat="server" Width="293px"></asp:TextBox>
                    格式：192.168.1.*;192.168.1.1-192.168.1.100
                </td>
            </tr>
            <tr>
                <td>
                    被封锁的ＩＰ段：
                </td>
                <td>
                    <asp:TextBox ID="tbxCloseIP" runat="server" Width="293px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    访问时间：
                </td>
                <td>
                    <asp:CheckBoxList ID="cblOpenTime" runat="server" RepeatColumns="6" RepeatDirection="Horizontal">
                        <asp:ListItem Value="1">1点</asp:ListItem>
                        <asp:ListItem Value="2">2点</asp:ListItem>
                        <asp:ListItem Value="3">3点</asp:ListItem>
                        <asp:ListItem Value="4">4点</asp:ListItem>
                        <asp:ListItem Value="5">5点</asp:ListItem>
                        <asp:ListItem Value="6">6点</asp:ListItem>
                        <asp:ListItem Value="7">7点</asp:ListItem>
                        <asp:ListItem Value="8">8点</asp:ListItem>
                        <asp:ListItem Value="9">9点</asp:ListItem>
                        <asp:ListItem Value="10">10点</asp:ListItem>
                        <asp:ListItem Value="11">11点</asp:ListItem>
                        <asp:ListItem Value="12">12点</asp:ListItem>
                        <asp:ListItem Value="13">13点</asp:ListItem>
                        <asp:ListItem Value="14">14点</asp:ListItem>
                        <asp:ListItem Value="15">15点</asp:ListItem>
                        <asp:ListItem Value="16">16点</asp:ListItem>
                        <asp:ListItem Value="17">17点</asp:ListItem>
                        <asp:ListItem Value="18">18点</asp:ListItem>
                        <asp:ListItem Value="19">19点</asp:ListItem>
                        <asp:ListItem Value="20">20点</asp:ListItem>
                        <asp:ListItem Value="21">21点</asp:ListItem>
                        <asp:ListItem Value="22">22点</asp:ListItem>
                        <asp:ListItem Value="23">23点</asp:ListItem>
                        <asp:ListItem Value="0">24点</asp:ListItem>
                    </asp:CheckBoxList>
                </td>
            </tr>
            <tr>
                <td>
                    学员查询：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblStuLogin" runat="server" Width="134px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="关闭"></asp:ListItem>
                        <asp:ListItem Value="1" Text="运行"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    外部报名(网上报名)：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblNetReg" runat="server" Width="134px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="关闭"></asp:ListItem>
                        <asp:ListItem Value="1" Text="运行"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    短信设置
                </th>
            </tr>
            <tr>
                <td>
                    启用：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblSMSState" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    发送方式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlsmsSendMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlsmsSendMode_SelectedIndexChanged">
                        <asp:ListItem Value="1">麦田平台发送</asp:ListItem>
                        <asp:ListItem Value="2">GET方式发送</asp:ListItem>
                        <asp:ListItem Value="3">定制程序发送</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    接收方式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlsmsReceiveMode" runat="server">
                        <asp:ListItem Value="0">不接收</asp:ListItem>
                        <asp:ListItem Value="1">主动接收</asp:ListItem>
                        <asp:ListItem Value="3">被动接收</asp:ListItem>
                        <asp:ListItem Value="2">手动</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    单条短信最大长度：
                </td>
                <td>
                    <asp:DropDownList ID="ddlsmsMaxLength" runat="server">
                        <asp:ListItem>64</asp:ListItem>
                        <asp:ListItem>70</asp:ListItem>
                        <asp:ListItem>300</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    接口地址：
                </td>
                <td>
                    <asp:TextBox ID="tbxsmsServiceUrl" runat="server" Width="571px" AutoCompleteType="Disabled"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    帐号：
                </td>
                <td>
                    <asp:TextBox ID="tbxsmsAccount" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    密码：
                </td>
                <td>
                    <asp:TextBox ID="tbxsmsPassword" runat="server" AutoCompleteType="Disabled"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    成功短信返回码：
                </td>
                <td>
                    <asp:TextBox ID="tbxsmsSuccessCode" runat="server" AutoCompleteType="Disabled"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    URL编码方式：
                </td>
                <td>
                    <asp:TextBox ID="tbxsmsUrlEncoding" runat="server" AutoCompleteType="Disabled"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    短信签名：
                </td>
                <td>
                    <asp:TextBox ID="tbxsmsSign" runat="server" Width="73px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    短信默认发送模式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlsmsGangway" runat="server">
                        <asp:ListItem Value="0">App/短信</asp:ListItem>
                        <asp:ListItem Value="1">短信+App</asp:ListItem>
                        <asp:ListItem Value="2">短信</asp:ListItem>
                        <asp:ListItem Value="3">App</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    发送事件短信时，可选不发送：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblSMSSelectBox" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    事件短信发送模式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlsmsEventGangway" runat="server">
                        <asp:ListItem Value="0">App/短信</asp:ListItem>
                        <asp:ListItem Value="1">短信+App</asp:ListItem>
                        <asp:ListItem Value="2">短信</asp:ListItem>
                        <asp:ListItem Value="3">App</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    学员/员工考勤设置
                </th>
            </tr>
            <tr>
                <td>
                    学员签到/签退时间（缺省）：
                </td>
                <td>
                    上课前<asp:TextBox ID="tbxUpStart" runat="server" Width="35px"></asp:TextBox>
                    分钟<span style="display: none">－－上课后<asp:TextBox ID="tbxUpEnd" runat="server" Width="35px"></asp:TextBox>
                        分钟－－</span><span class="style1">－－(签到)－－</span>下课前<asp:TextBox ID="tbxUpEndAndDownStart"
                            runat="server" Width="35px"></asp:TextBox>
                    分钟<span class="style2">－－(签退)－－</span>下课后<asp:TextBox ID="tbxDownEnd" runat="server"
                        Width="35px"></asp:TextBox>
                    分钟
                </td>
            </tr>
            <tr>
                <td>
                    考勤时间分界：
                </td>
                <td>
                    上、下午时间分界：<asp:TextBox ID="tbxMA" runat="server" Width="49px"></asp:TextBox>
                    下午、晚上时间分界：<asp:TextBox ID="tbxAN" runat="server" Width="49px"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="_tbxMA" runat="server" ControlToValidate="tbxMA"
                        ValidationExpression="^((0?[0-9])|((1[0-9])|(2[0-4])))[\:]((0?[0-9])|((1|2|3|4|5)[0-9]))$"
                        Display="Dynamic" ErrorMessage="时间格式不正确，正确格式如12:00。"></asp:RegularExpressionValidator>
                    <asp:RegularExpressionValidator ID="_tbxAN" runat="server" ControlToValidate="tbxAN"
                        ValidationExpression="^((0?[0-9])|((1[0-9])|(2[0-4])))[\:]((0?[0-9])|((1|2|3|4|5)[0-9]))$"
                        Display="Dynamic" ErrorMessage="时间格式不正确，正确格式如12:00。"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td>
                    自动处理旷课请假（缺省）：&nbsp;
                </td>
                <td>
                    一对多班：<asp:DropDownList ID="rblAutoAbsent" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;一对一班：<asp:DropDownList ID="rblAutoAbsent1v1" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    学员旷课消耗课时（缺省）：
                </td>
                <td>
                    一对多班：<asp:DropDownList ID="rblAbsentDepleteLesson" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;一对一班：<asp:DropDownList ID="rblAbsentDepleteLesson1v1" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    学员请假消耗课时（缺省）：&nbsp;
                </td>
                <td>
                    一对多班：<asp:DropDownList ID="rblLeaveDepleteLesson" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;一对一班：<asp:DropDownList ID="rblLeaveDepleteLesson1v1" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    不排课也能考勤（一对一）：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblAutoPPAttend" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    学员考勤规则：
                </td>
                <td>
                    <asp:DropDownList ID="ddlStuSignMode" runat="server">
                        <asp:ListItem Value="0">课时段模式(按时)</asp:ListItem>
                        <asp:ListItem Value="1">全日制模式</asp:ListItem>
                        <asp:ListItem Value="2">课时段模式(按次)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    高精度学员课次金额计算：
                </td>
                <td>
                    <asp:DropDownList ID="ddlAttendIncomeDetails" runat="server">
                        <asp:ListItem Value="0">关闭</asp:ListItem>
                        <asp:ListItem Value="1">开启</asp:ListItem>
                    </asp:DropDownList>
                    开启此功能可以计算出每次考勤的课次产出金额，但比较占用资源。
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    区域性语言设置
                </th>
            </tr>
            <tr>
                <td>
                    系统语言：
                </td>
                <td>
                    <asp:DropDownList ID="ddlLanguage" runat="server" Enabled="False">
                        <asp:ListItem Value="Auto" Text="自动"></asp:ListItem>
                        <asp:ListItem Value="zh-cn" Text="简体中文" Selected="True"></asp:ListItem>
                        <asp:ListItem Value="zh-CHT" Text="繁体中文"></asp:ListItem>
                        <asp:ListItem Value="en-us" Text="美国英语" Enabled="false"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    区域性：（国家／地区）
                </td>
                <td>
                    <asp:DropDownList ID="ddlArea" runat="server">
                        <asp:ListItem Value="Auto" Text="自动"></asp:ListItem>
                        <asp:ListItem Value="zh-CN" Text="中国"></asp:ListItem>
                        <asp:ListItem Value="zh-HK" Text="香港"></asp:ListItem>
                        <asp:ListItem Value="zh-TW" Text="台湾"></asp:ListItem>
                        <asp:ListItem Value="zh-MO" Text="澳门"></asp:ListItem>
                        <asp:ListItem Value="zh-SG" Text="新加坡"></asp:ListItem>
                        <asp:ListItem Value="en-GB" Text="英国"></asp:ListItem>
                        <asp:ListItem Value="en-US" Text="美国"></asp:ListItem>
                        <asp:ListItem Value="fr-FR" Text="法国"></asp:ListItem>
                        <asp:ListItem Value="en-CA" Text="加拿大"></asp:ListItem>
                        <asp:ListItem Value="ru-RU" Text="俄罗斯"></asp:ListItem>
                        <asp:ListItem Value="ja-JP" Text="日本"></asp:ListItem>
                        <asp:ListItem Value="ko-KR" Text="韩国"></asp:ListItem>
                        <asp:ListItem Value="it-IT" Text="意大利"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    货币符号：
                </td>
                <td>
                    <asp:TextBox ID="tbxCurrencySymbol" runat="server" Width="45px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    日期格式：
                </td>
                <td>
                    <asp:TextBox ID="tbxShortDatePattern" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td style="height: 21px">
                    时间格式：
                </td>
                <td style="height: 21px">
                    <asp:TextBox ID="tbxLongTimePattern" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    上午字符：
                </td>
                <td>
                    <asp:TextBox ID="tbxAMDesignator" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    下午字符：
                </td>
                <td>
                    <asp:TextBox ID="tbxPMDesignator" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr runat="server" id="trTimeZone">
                <td>
                    时区：
                </td>
                <td>
                    <asp:DropDownList ID="ddlTimeZone" runat="server">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    财务设置
                </th>
            </tr>
            <tr>
                <td>
                    锁定收费金额：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblLockPay" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    允许优惠：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblFavEnabled" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    单笔优惠最大限额：
                </td>
                <td>
                    <%=swq.CurrentCurrencySymbol %><asp:TextBox ID="tbxFavMax" runat="server" Width="48px"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="_tbxFavMax" runat="server" ControlToValidate="tbxFavMax"
                        Display="Dynamic" ValidationExpression="^-?\d+(\.\d+)?$"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td>
                    允许学员借款：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblCreditEnabled" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    系统借款总额上限：
                </td>
                <td>
                    <%=swq.CurrentCurrencySymbol %><asp:TextBox ID="tbxCreditSysMax" runat="server" Width="48px"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="_tbxCreditSysMax" runat="server" ControlToValidate="tbxCreditSysMax"
                        Display="Dynamic" ValidationExpression="^-?\d+(\.\d+)?$"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td>
                    单笔借款最大限额：
                </td>
                <td>
                    <%=swq.CurrentCurrencySymbol %><asp:TextBox ID="tbxCreditMax" runat="server" Width="48px"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="_tbxCreditMax" runat="server" ControlToValidate="tbxCreditMax"
                        Display="Dynamic" ValidationExpression="^-?\d+(\.\d+)?$"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr style="visibility: hidden; display: none">
                <td>
                    允许修改退费课时：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblEditChangeLessons" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr style="visibility: hidden; display: none">
                <td>
                    允许修改退费金额：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblEditChangePrice" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    充值金额允许编辑：
                </td>
                <td>
                    <table cellspacing="0" cellpadding="0">
                        <tr>
                            <td>
                                <asp:RadioButtonList ID="rblEditRecharge" runat="server" Width="104px" RepeatDirection="Horizontal">
                                    <asp:ListItem Value="0" Text="否"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="是"></asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td>
                                仅限财务模块的“学员帐户”。
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td>
                    同一课程重复出现在消费单：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblRepeatCourseItems" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    销售物品时校区与仓库不做关联：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblSchoolSto" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    课程设置、每课时最大单价：
                </td>
                <td>
                    <%=swq.CurrentCurrencySymbol %><asp:TextBox ID="tbxMaxUnitPrice" runat="server" Width="72px"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="_tbxMaxUnitPrice" runat="server" ControlToValidate="tbxMaxUnitPrice"
                        Display="Dynamic" ValidationExpression="^-?\d+(\.\d+)?$"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td>
                    学员帐户允许负数金额：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblAllowNegative" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    允许学员通过支付宝充值：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblAlipayState" runat="server" Width="104px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    支付宝身份ID：
                </td>
                <td>
                    <asp:TextBox ID="tbxAlipayPartner" runat="server" Width="236px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    支付宝安全检验码：
                </td>
                <td>
                    <asp:TextBox ID="tbxAlipayKey" runat="server" Width="235px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    签约支付宝账号：
                </td>
                <td>
                    <asp:TextBox ID="tbxAlipayAccount" runat="server" Width="234px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    支付宝充值短信提醒（手机号）：
                </td>
                <td>
                    <asp:TextBox ID="tbxPaymentSMS" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    购买物品默认发放状态：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblCommodityGiveState" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0">未发</asp:ListItem>
                        <asp:ListItem Value="1">已发</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    安全隐私
                </th>
            </tr>
            <tr>
                <td>
                    启用凭证登录：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblCertEnabled" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0">禁用</asp:ListItem>
                        <asp:ListItem Value="1">启用</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    凭证安装密码：
                </td>
                <td>
                    <asp:TextBox ID="tbxCertPwd" runat="server" AutoCompleteType="Disabled"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    凭证使用环境：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblCertNet" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="1" Text="局域网"></asp:ListItem>
                        <asp:ListItem Value="2" Text="广域网"></asp:ListItem>
                        <asp:ListItem Value="3" Text="局＋广网"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    (针对客服)学员电话：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblTelPrivacy" runat="server" Width="123px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="隐藏"></asp:ListItem>
                        <asp:ListItem Value="1" Text="显示"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    (针对客服)学员身份证：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblIDcardPrivacy" runat="server" Width="123px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="隐藏"></asp:ListItem>
                        <asp:ListItem Value="1" Text="显示"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    (针对客服)学员出生：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblBirthdayPrivacy" runat="server" Width="123px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="隐藏"></asp:ListItem>
                        <asp:ListItem Value="1" Text="显示"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    (针对讲师)学员电话：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblTeachTelPrivacy" runat="server" Width="123px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="隐藏"></asp:ListItem>
                        <asp:ListItem Value="1" Text="显示"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    (针对讲师)学员身份证：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblTeachIDcardPrivacy" runat="server" Width="123px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="隐藏"></asp:ListItem>
                        <asp:ListItem Value="1" Text="显示"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    (针对讲师)学员出生：
                </td>
                <td>
                    <asp:RadioButtonList ID="rblTeachBirthdayPrivacy" runat="server" Width="123px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="隐藏"></asp:ListItem>
                        <asp:ListItem Value="1" Text="显示"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    API帐号：
                </td>
                <td>
                    <asp:TextBox ID="tbxAPIUsers" runat="server" Width="196px"></asp:TextBox>
                    多个用英文模式下的逗号隔开，设置的API帐号只能通过客户端工具登录。
                </td>
            </tr>
            <tr>
                <td>
                    时间锁总锁：
                </td>
                <td>
                    锁定<asp:TextBox ID="tbxAllTimeLock" runat="server" Width="46px"></asp:TextBox>
                    天前的数据，为空表示不启用时间锁。
                </td>
            </tr>
            <tr>
                <td>
                    财务时间锁：
                </td>
                <td>
                    锁定<asp:TextBox ID="tbxFinanceTimeLock" runat="server" Width="46px"></asp:TextBox>
                    天前的数据。
                </td>
            </tr>
            <tr>
                <td>
                    教务时间锁：
                </td>
                <td>
                    锁定<asp:TextBox ID="tbxAffairsTimeLock" runat="server" Width="46px"></asp:TextBox>
                    天前的数据。
                </td>
            </tr>
            <tr>
                <td>
                    学员档案时间锁：
                </td>
                <td>
                    锁定<asp:TextBox ID="tbxStudentTimeLock" runat="server" Width="46px"></asp:TextBox>
                    天前的数据。
                </td>
            </tr>
            <tr>
                <td>
                    排课时间锁：
                </td>
                <td>
                    锁定<asp:TextBox ID="tbxLessonDegreeTimeLock" runat="server" Width="46px"></asp:TextBox>
                    天前的数据。
                </td>
            </tr>
            <tr>
                <td>
                    考勤时间锁：
                </td>
                <td>
                    锁定<asp:TextBox ID="tbxAttendTimeLock" runat="server" Width="46px"></asp:TextBox>
                    天前的数据。
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    打印设置
                </th>
            </tr>
            <tr>
                <td style="height: 26px">
                    打印模式：
                </td>
                <td style="height: 26px">
                    <asp:DropDownList ID="ddlPrintMode" runat="server">
                        <asp:ListItem Value="1" Text="直接打印"></asp:ListItem>
                        <asp:ListItem Value="2" Text="预览打印"></asp:ListItem>
                        <asp:ListItem Value="3" Text="设置打印"></asp:ListItem>
                        <asp:ListItem Value="4" Text="选择打印"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    学员充值后询问是否打印：
                </td>
                <td style="height: 26px">
                    <asp:RadioButtonList ID="rblInputPaymentAfterAskPrint" runat="server" Width="104px"
                        RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    学员消费后询问是否打印：
                </td>
                <td style="height: 26px">
                    <asp:RadioButtonList ID="rblInputBillAfterAskPrint" runat="server" Width="104px"
                        RepeatDirection="Horizontal">
                        <asp:ListItem Value="0" Text="否"></asp:ListItem>
                        <asp:ListItem Value="1" Text="是"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    考勤自动打印凭条：
                </td>
                <td style="height: 26px">
                    <asp:DropDownList ID="rblAutoPrintAttend" runat="server">
                        <asp:ListItem Value="0">禁用</asp:ListItem>
                        <asp:ListItem Value="1">允许</asp:ListItem>
                    </asp:DropDownList>
                    针对ID/指纹硬件考勤，当考勤成功时可自动打印凭条。
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    报表系统：
                </td>
                <td style="height: 26px">
                    <asp:DropDownList ID="ddlAdvancedReport" runat="server">
                        <asp:ListItem Value="0">简单模式(兼容)</asp:ListItem>
                        <asp:ListItem Value="1">高级模式</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    学校名称：
                </td>
                <td style="height: 26px">
                    <asp:TextBox ID="tbxSchoolName" runat="server" Width="149px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td style="height: 26px">
                    网站地址：
                </td>
                <td style="height: 26px">
                    <asp:TextBox ID="tbxSiteUrl" runat="server" Width="256px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    电子信箱：
                </td>
                <td>
                    <asp:TextBox ID="tbxEmail" runat="server" Width="178px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    电话：
                </td>
                <td>
                    <asp:TextBox ID="tbxTel" runat="server" Width="312px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td style="height: 21px">
                    传真：
                </td>
                <td style="height: 21px">
                    <asp:TextBox ID="tbxFax" runat="server" Width="178px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    地址：
                </td>
                <td>
                    <asp:TextBox ID="tbxAddress" runat="server" Width="446px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    邮编：
                </td>
                <td>
                    <asp:TextBox ID="tbxPostCode" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    <label class="lab_buttom">
                        <asp:Button ID="btnReset" runat="server" Text="重启" OnClick="btnReset_Click"></asp:Button>
                    </label>
                </td>
            </tr>
        </table>
    </div>
    </form>
</body>
</html>
