﻿using System;
using System.Threading;
using System.Windows.Forms;

namespace UPlateCopy
{
    static class Program
    {
        /// <summary>
        /// 应用程序的主入口点。
        /// </summary>
        [STAThread]
        static void Main()
        {
            bool LimitCharacter;//程序只能运行一次
            using (Mutex mutex = new Mutex(true, Application.ProductName, out LimitCharacter))
            {
                if (LimitCharacter)
                {
                    Application.EnableVisualStyles();
                    Application.SetCompatibleTextRenderingDefault(false);
                    Application.Run(new Load());
                }
                else//程序已经运行的情况，则弹出消息提示并终止此次运行  
                {
                    MessageBox.Show("应用程序已启动");
                    Thread.Sleep(1000);
                    //终止此进程并为基础操作系统提供指定的退出代码。  
                    Environment.Exit(1);
                }
            }
        }
    }
}