﻿using System;
using System.IO;
using System.Windows.Forms;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;

namespace UPlateCopy
{
    public partial class Main : Form
    {
        public Main()
        {
            InitializeComponent();
        }
        private void Main_Load(object sender, EventArgs e)//程序加载完成时
        {
            if (!File.Exists("Hide.ini")) File.AppendAllText("Hide.ini", "False");
            try { cbo_hide.Checked = Convert.ToBoolean(File.ReadAllText("Hide.ini")); } catch { }
        }
        private void cbo_hide_CheckedChanged(object sender, EventArgs e)//选择是否隐藏窗体
        {
            File.Delete(@"Hide.ini");//删除原配置文件
            File.AppendAllText("Hide.ini", cbo_hide.Checked.ToString());//新建配置文件
        }
        private void btn_file_Click(object sender, EventArgs e)//单击复制到哪个位置的按钮
        {
            if (fBD.ShowDialog() == DialogResult.OK)//确定是否已经选择文件夹
            {
                File.Delete(@"File.ini");//删除原配置文件
                File.AppendAllText("File.ini", fBD.SelectedPath);//新建配置文件
            }
        }
        private void btn_format_Click(object sender, EventArgs e)//单击复制格式的按钮
        {
            System.Diagnostics.Process.Start("notepad.exe", "Format.ini");//调用记事本打开
        }
        private void btn_format_MouseEnter(object sender, EventArgs e) { hint.Visible = true; }//鼠标进入控件时
        private void btn_format_MouseLeave(object sender, EventArgs e) { hint.Visible = false; }//鼠标离开控件时
        private void txt_Click(object sender, EventArgs e)
        {
            try
            {
                System.Diagnostics.Process.Start("http://zgcwkj.top/");//调用默认的浏览器打开
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
    }
}