/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.WebClientPro;

import com.rhinosoft.WebClientPro.CWebClientProApp;
import com.rhinosoft.WebClientPro.CWebClientProApplet;
import com.rhinosoft.WebClientPro.CWebClientProAppletCommMsg;
import com.rhinosoft.WebClientPro.CWebPageGridItem;
import com.rhinosoft.attrs.CStringURLAttr;
import com.rhinosoft.files.CFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CDeleteMsg;
import com.rhinosoft.messages.CUploadMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CAsyncMsgQueue;
import com.rhinosoft.threads.CAsynchQueue;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.applet.CRhinoApplet;
import com.rhinosoft.ui.applet.CRhinoAppletCommThread;
import com.rhinosoft.utils.CSpeedTest;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class CWebClientProAppletCommThread
extends CRhinoAppletCommThread {
    private static boolean DEBUG_UI_FILE_UPDATES;
    public static boolean DEBUG_WEBPAGE_PROCESSING_GRID_ITEMS;
    public static boolean DEBUG_SPEED;
    public static final boolean IS_HANDSHAKING = false;
    private static final int MAX_COL_FILE = 16;
    public static final int TIMER_INITIAL_DELAY_PROCESS_ITEMS = 100;
    public static final int TIMER_DELAY_PROCESS_ITEMS = 100;
    public static final int TIMER_EXPIRATION = 250;
    private CAsyncMsgQueue m_AsynchMsgQueue;
    private boolean m_bWaitingForUI = false;
    private LinkedList<CWebPageGridItem> m_arGridItems;
    private int m_nNumOfGridItemsProcessed = 0;
    private Timer m_ProcessTimer;
    private long m_lExpiration = 0L;

    public CWebClientProAppletCommThread(CRhinoApplet rApplet, CWorkerThread rPostBackToMainThread) {
        super(rApplet, rPostBackToMainThread);
        this._CWebClientProAppletCommThread();
    }

    private void _CWebClientProAppletCommThread() {
        this.m_arGridItems = new LinkedList();
        this.SetThreadName("AppletComm_Worker");
        this.InitProcessTimer();
    }

    @Override
    public void Destroy() {
        if (this.m_AsynchMsgQueue != null) {
            this.m_AsynchMsgQueue.Destroy();
        }
        this.m_AsynchMsgQueue = null;
        if (this.m_arGridItems != null) {
            Iterator itr = this.m_arGridItems.iterator();
            while (itr.hasNext()) {
                CWebPageGridItem rNextItem = (CWebPageGridItem)itr.next();
                if (rNextItem != null) {
                    rNextItem.Destroy();
                }
                rNextItem = null;
                itr.remove();
            }
            this.m_arGridItems.clear();
        }
        this.m_arGridItems = null;
        super.Destroy();
    }

    @Override
    protected CAsynchQueue CreateAsynchQueue() {
        this.m_AsynchMsgQueue = new CAsyncMsgQueue();
        return this.m_AsynchMsgQueue;
    }

    @Override
    protected CWebClientProApplet GetApplet() {
        return (CWebClientProApplet)super.GetApplet();
    }

    public boolean SendOnInit() {
        boolean bSucceeded = false;
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(8011, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_INIT.GetValue());
            rMsg.SetFunctionParms(CWebClientProApplet.WEB_PAGE_ITEMS.APPLET_ID.GetValue());
            this.OnMessage(rMsg);
            Object[] arRetVal = rMsg.GetReturnObjs();
            if (arRetVal != null && arRetVal.length > 0) {
                bSucceeded = (Boolean)arRetVal[0];
            }
        }
        return bSucceeded;
    }

    public boolean SendCantAccessFileSys() {
        boolean bSucceeded = false;
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(8011, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_CANT_ACCESS_FILE_SYS.GetValue());
            this.OnMessage(rMsg);
            Object[] arRetVal = rMsg.GetReturnObjs();
            if (arRetVal != null && arRetVal.length > 0) {
                bSucceeded = (Boolean)arRetVal[0];
            }
        }
        return bSucceeded;
    }

    public void PostUpdateDynamicBtns(String[] abBtnFlags) {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20007, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_UPDATE_TRANSFER_BTNS.GetValue());
            rMsg.SetFunctionParms(abBtnFlags);
            this.NewMessage(rMsg);
        }
    }

    public void PostUpdateStartBtnText(String sStartBtnText, String sRestartBtnText) {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20011, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_UPDATE_START_BTN_TEXT.GetValue());
            if (sStartBtnText == null) {
                sStartBtnText = CString.LoadString("IDS_START_MENU");
            }
            if (sRestartBtnText == null) {
                sRestartBtnText = CString.LoadString("IDS_RESTART_MENU");
            }
            String[] asParms = new String[]{sStartBtnText, sRestartBtnText};
            rMsg.SetFunctionParms(asParms);
            this.NewMessage(rMsg);
        }
    }

    public void PostShowWaitCursor() {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20013, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_SHOW_WAIT_CURSOR.GetValue());
            this.NewMessage(rMsg);
        }
    }

    public void PostHideWaitCursor() {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20015, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_HIDE_WAIT_CURSOR.GetValue());
            this.NewMessage(rMsg);
        }
    }

    public void PostShowOpaqueLayer() {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20003, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_SHOW_OPAQUE_LAYER.GetValue());
            this.NewMessage(rMsg);
        }
    }

    public void PostHideOpaqueLayer() {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20005, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_HIDE_OPAQUE_LAYER.GetValue());
            this.NewMessage(rMsg);
        }
        this.PostReactivateBrowser();
    }

    private void PostReactivateBrowser() {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20009, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_ACTIVATE_BROWSER.GetValue());
            this.NewMessage(rMsg);
        }
    }

    public boolean SendAllDoneInCurDir() {
        boolean bSucceeded = false;
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(8011, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_ALL_DONE_IN_CUR_DIR.GetValue());
            this.OnMessage(rMsg);
            Object[] arRetVal = rMsg.GetReturnObjs();
            if (arRetVal != null && arRetVal.length > 0) {
                bSucceeded = (Boolean)arRetVal[0];
            }
        }
        return bSucceeded;
    }

    public void PostSendPageGridItems(String[] asItemsToProcessFlat) {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20001, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            rMsg.SetFunctionName(CWebClientProApplet.WEB_PAGE_ITEMS.ON_PROCESS_GRID_ITEMS.GetValue());
            rMsg.SetFunctionParms(asItemsToProcessFlat);
            this.NewMessage(rMsg);
        }
    }

    @Override
    public String GetThreadName() {
        return "Applet Communication Thread";
    }

    private String[] IterateGridItemQueue(int nNumOfItemsToProcess) {
        String[] asFileData = null;
        if (nNumOfItemsToProcess > 0) {
            asFileData = new String[nNumOfItemsToProcess * 16];
            Iterator itr = this.m_arGridItems.iterator();
            for (int nIdx = 0; itr.hasNext() && nIdx < nNumOfItemsToProcess; ++nIdx) {
                CWebPageGridItem rItem = (CWebPageGridItem)itr.next();
                if (rItem == null) continue;
                String[] asItemData = rItem.GetFileData();
                for (int nIdx3 = 0; nIdx3 < asItemData.length; ++nIdx3) {
                    asFileData[nIdx * 16 + nIdx3] = asItemData[nIdx3];
                }
            }
        }
        return asFileData;
    }

    private boolean OnProcessGridItemQueue() {
        boolean bIsProcessing = false;
        if (this.m_arGridItems != null) {
            if (!this.IsWaitingForUI()) {
                if (DEBUG_WEBPAGE_PROCESSING_GRID_ITEMS) {
                    System.out.printf("%s | BEFORE pending grid items - nNumOfItemsToProcess = %d\r\n", Thread.currentThread().getName(), this.m_arGridItems.size());
                }
                this.AddPendingGridItems();
                int nNumOfItemsToProcess = this.m_arGridItems.size();
                if (DEBUG_WEBPAGE_PROCESSING_GRID_ITEMS) {
                    System.out.printf("%s | AFTER pending grid items - nNumOfItemsToProcess = %d\r\n", Thread.currentThread().getName(), this.m_arGridItems.size());
                }
                if (nNumOfItemsToProcess > 0 && this.m_lExpiration < System.currentTimeMillis()) {
                    this.m_nNumOfGridItemsProcessed = 0;
                    String[] asFileData = this.IterateGridItemQueue(nNumOfItemsToProcess);
                    if (this.GetApplet() != null && asFileData != null && asFileData.length > 0) {
                        bIsProcessing = true;
                        this.SetWaitingForUI(true);
                        if (DEBUG_WEBPAGE_PROCESSING_GRID_ITEMS) {
                            System.out.printf("%s | OnProcessGridItemQueue - WaitingForUI -->\r\n", Thread.currentThread().getName());
                        }
                        this.m_nNumOfGridItemsProcessed = nNumOfItemsToProcess;
                        if (DEBUG_WEBPAGE_PROCESSING_GRID_ITEMS) {
                            System.out.printf("%s | OnProcessGridItemQueue - m_nNumOfGridItemsProcessed: %d\r\n", Thread.currentThread().getName(), this.m_nNumOfGridItemsProcessed);
                        }
                        this.PostSendPageGridItems(asFileData);
                        this.m_lExpiration = System.currentTimeMillis() + 250L;
                    }
                }
            } else if (DEBUG_WEBPAGE_PROCESSING_GRID_ITEMS) {
                System.out.printf("%s | OnProcessGridItemQueue - WaitingForUI --?\r\n", Thread.currentThread().getName());
            }
        }
        return bIsProcessing;
    }

    protected void InitProcessTimer() {
        if (this.m_ProcessTimer == null) {
            this.m_ProcessTimer = new Timer(true);
            this.m_ProcessTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    CWebClientProAppletCommThread.this.OnProcessGridItemQueue();
                }
            }, 100L, 100L);
        }
    }

    private void OnRecvPageGridItemsDone() {
        if (this.m_arGridItems != null && this.m_nNumOfGridItemsProcessed > 0) {
            for (int nIdx = this.m_nNumOfGridItemsProcessed - 1; nIdx >= 0; --nIdx) {
                this.m_arGridItems.remove(nIdx);
            }
        }
        if (DEBUG_WEBPAGE_PROCESSING_GRID_ITEMS) {
            System.out.printf("%s | OnRecvPageGridItemsDone (DONE) - m_nNumOfGridItemsProcessed: %d\r\n", Thread.currentThread().getName(), this.m_nNumOfGridItemsProcessed);
            System.out.printf("%s | OnRecvPageGridItemsDone - WaitingForUI <--\r\n", Thread.currentThread().getName());
        }
        this.SetWaitingForUI(false);
    }

    private boolean IsWaitingForUI() {
        return this.m_bWaitingForUI;
    }

    private void SetWaitingForUI(boolean bWaitingForUI) {
        this.m_bWaitingForUI = bWaitingForUI;
    }

    public void PostOnRecvPageGridItemsDone() {
        CWebClientProAppletCommMsg rMsg = new CWebClientProAppletCommMsg(20002, this.GetApplet(), this.GetPostBackTo());
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void OnDeleteComplete(CDeleteMsg rDeleteMsg) {
        CFile fDeleted;
        if (rDeleteMsg != null && (fDeleted = rDeleteMsg.GetSourceFile()) != null) {
            String sAbsPath = fDeleted.GetAbsPath();
            if (DEBUG_UI_FILE_UPDATES) {
                CDebugLog.INFO(String.format("OnDeleteFile - FilePath: %s\r\n", sAbsPath));
            }
            String[] asFileData = new String[16];
            asFileData[0] = "1";
            String sParentPath = CString.GetParentPath(sAbsPath, false);
            if (DEBUG_UI_FILE_UPDATES) {
                CDebugLog.INFO(String.format("OnUploadFile - File ParentPath: %s\r\n", sParentPath));
            }
            asFileData[1] = CStringURLAttr.URLEncode(sParentPath);
            this.FillInFileData(asFileData, 2, fDeleted);
            CWebPageGridItem rItem = new CWebPageGridItem(asFileData, CWebPageGridItem.TYPE.DELETED);
            this.PostAddGridItem(rItem);
        }
    }

    public void OnUploadComplete(CUploadMsg rUploadMsg) {
        CFile fTarget;
        if (rUploadMsg != null && (fTarget = rUploadMsg.GetTargetFile()) != null) {
            String sAbsPath = fTarget.GetAbsPath();
            if (DEBUG_UI_FILE_UPDATES) {
                CDebugLog.INFO(String.format("OnUploadFile - FilePath: %s\r\n", sAbsPath));
            }
            String[] asFileData = new String[16];
            asFileData[0] = "0";
            String sParentPath = CString.GetParentPath(sAbsPath, false);
            if (DEBUG_UI_FILE_UPDATES) {
                CDebugLog.INFO(String.format("OnUploadFile - File ParentPath: %s\r\n", sParentPath));
            }
            asFileData[1] = CStringURLAttr.URLEncode(sParentPath);
            int nStart = 2;
            this.FillInFileData(asFileData, nStart, fTarget);
            CFile fSource = rUploadMsg.GetSourceFile();
            if (fSource != null) {
                asFileData[nStart + 1] = this.FillInSize(fSource);
                asFileData[nStart + 2] = this.FillInTimestamp(fSource);
            }
            CWebPageGridItem rItem = new CWebPageGridItem(asFileData, CWebPageGridItem.TYPE.UPLOADED);
            this.PostAddGridItem(rItem);
        }
    }

    private String FillInSize(CFile fFile) {
        String sSize = "";
        if (fFile != null) {
            sSize = Long.toString(fFile.GetSize());
        }
        return sSize;
    }

    private String FillInTimestamp(CFile fFile) {
        String sTimestamp = "";
        if (fFile != null) {
            long lTimestamp = fFile.GetTimestampModified() / 1000L;
            sTimestamp = Long.toString(lTimestamp);
        }
        return sTimestamp;
    }

    private void FillInFileData(String[] asFileData, int nFileDataIdx, CFile fFile) {
        if (asFileData != null && fFile != null) {
            String sData = "";
            int nMax = 14;
            if (nMax <= asFileData.length - nFileDataIdx) {
                for (int nIdx = 0; nIdx < nMax && nFileDataIdx < asFileData.length; ++nIdx, ++nFileDataIdx) {
                    sData = "";
                    switch (nIdx) {
                        case 0: {
                            sData = CStringURLAttr.URLEncode(fFile.GetDisplayName());
                            break;
                        }
                        case 1: {
                            sData = this.FillInSize(fFile);
                            break;
                        }
                        case 2: {
                            sData = this.FillInTimestamp(fFile);
                            break;
                        }
                        case 3: {
                            sData = CStringURLAttr.URLEncode(fFile.GetAbsPath());
                            break;
                        }
                        case 4: {
                            if (fFile.IsDirectory()) {
                                sData = "1";
                                break;
                            }
                            sData = "0";
                            break;
                        }
                        case 5: {
                            if (fFile.IsImage()) {
                                sData = "1";
                                break;
                            }
                            sData = "0";
                            break;
                        }
                        case 6: {
                            sData = CStringURLAttr.URLEncode(fFile.GetDriveLabel());
                            break;
                        }
                        case 7: {
                            if (fFile.IsDrive()) {
                                sData = "1";
                                break;
                            }
                            sData = "0";
                            break;
                        }
                        case 8: {
                            sData = Integer.toString(fFile.GetDriveType());
                            break;
                        }
                        case 9: {
                            sData = "0";
                            break;
                        }
                        case 10: {
                            if (fFile.IsAudio()) {
                                sData = "1";
                                break;
                            }
                            sData = "0";
                            break;
                        }
                        case 11: {
                            if (fFile.IsVideo()) {
                                sData = "1";
                                break;
                            }
                            sData = "0";
                            break;
                        }
                        case 12: {
                            if (fFile.IsCompressed()) {
                                sData = "1";
                                break;
                            }
                            sData = "0";
                            break;
                        }
                        case 13: {
                            if (fFile.IsEncrypted()) {
                                sData = "1";
                                break;
                            }
                            sData = "0";
                            break;
                        }
                    }
                    if (sData == null) {
                        sData = "";
                    }
                    asFileData[nFileDataIdx] = sData;
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CWebClientProApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error; Not enough space in the array to contain the file data.");
            }
        }
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        switch (rMsg.GetMsgID()) {
            case 20000: {
                if (rMsg instanceof CWebClientProAppletCommMsg) {
                    CWebClientProAppletCommMsg rCommMsg = (CWebClientProAppletCommMsg)rMsg;
                    this.AddGridItem(rCommMsg.TakeGridItem(), true);
                }
                rMsg.Destroy();
                break;
            }
            case 20002: {
                if (!(rMsg instanceof CWebClientProAppletCommMsg)) break;
                CWebClientProAppletCommMsg rCommMsg = (CWebClientProAppletCommMsg)rMsg;
                this.OnRecvPageGridItemsDone();
                break;
            }
        }
    }

    private void PostAddGridItem(CWebPageGridItem rItem) {
        CWebClientProAppletCommMsg rMsg;
        CSpeedTest sp = null;
        if (DEBUG_SPEED) {
            sp = new CSpeedTest();
            sp.Start();
        }
        if ((rMsg = new CWebClientProAppletCommMsg(20000, this.GetApplet(), this.GetPostBackTo())) != null) {
            rMsg.SetGridItem(rItem);
            this.NewMessage(rMsg);
        }
        if (DEBUG_SPEED && sp != null) {
            sp.Stop();
            sp.PrintResults(String.format("%s | PostAddGridItem", Thread.currentThread().getName()));
        }
    }

    protected void AddGridItem(CWebPageGridItem rGridItem, boolean bProcessQueue) {
        CSpeedTest sp = null;
        if (DEBUG_SPEED) {
            sp = new CSpeedTest();
            sp.Start();
        }
        if (this.m_arGridItems != null) {
            this.m_arGridItems.add(rGridItem);
        }
        if (DEBUG_SPEED && sp != null) {
            sp.Stop();
            sp.PrintResults(String.format("%s | AddGridItem | GridItemSize: %d", Thread.currentThread().getName(), this.m_arGridItems.size()));
        }
    }

    protected void AddPendingGridItems() {
        if (this.m_AsynchMsgQueue != null) {
            CSpeedTest sp = null;
            if (DEBUG_SPEED) {
                sp = new CSpeedTest();
                sp.Start();
            }
            LinkedList aPulledMsgs = this.m_AsynchMsgQueue.PullMessages(20000);
            Iterator itr = aPulledMsgs.iterator();
            while (itr.hasNext()) {
                Object rNextObj = itr.next();
                if (rNextObj == null || !(rNextObj instanceof CWebClientProAppletCommMsg)) continue;
                CWebClientProAppletCommMsg rCommMsg = (CWebClientProAppletCommMsg)rNextObj;
                this.AddGridItem(rCommMsg.TakeGridItem(), false);
                rCommMsg.Destroy();
                rCommMsg = null;
                itr.remove();
            }
            itr = null;
            aPulledMsgs.clear();
            aPulledMsgs = null;
            if (DEBUG_SPEED && sp != null) {
                sp.Stop();
                sp.PrintResults(String.format("%s | AddPendingGridItems: %d", Thread.currentThread().getName(), aPulledMsgs.size()));
            }
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UI_FILE_UPDATES = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_WEBPAGE_PROCESSING_GRID_ITEMS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SPEED = false;
    }
}

