/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.WebClientPro;

import com.rhinosoft.WebClientPro.CWebClientProApp;
import com.rhinosoft.WebClientPro.CWebClientProAppletCommThread;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CDeleteMsg;
import com.rhinosoft.messages.CFetchCurWorkingDirMsg;
import com.rhinosoft.messages.CUpdateDynamicBtns;
import com.rhinosoft.messages.CUpdateTransferBtns;
import com.rhinosoft.messages.CUploadMsg;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.applet.CRhinoApplet;
import com.rhinosoft.ui.applet.CRhinoAppletApp;
import com.rhinosoft.ui.applet.CRhinoAppletCommThread;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JOptionPane;

public class CWebClientProApplet
extends CRhinoApplet {
    public static boolean DEBUG_PROCESS_GRID_ITEMS;
    private boolean m_bInitializedOnPage = false;
    private int m_nOpaqueCounter = 0;
    private boolean m_bAppletIsHidden = false;
    private int m_nShowWaitCursor = 0;
    private String m_sCurWorkingDir = null;
    private boolean m_bAppletIsWorking = false;

    @Override
    protected String[] GetExpectedStartupParameters() {
        String[] asParms;
        String[] asKeys = asParms = new String[]{"-debug", "-FutureFeatures", "-hh", "-sp", "-hp", "-esi", "-li", "-hl", "-is", "-ila", null};
        WEB_PAGE_ITEMS[] aItems = WEB_PAGE_ITEMS.values();
        if (aItems != null && aItems.length > 0) {
            asKeys = new String[asParms.length + aItems.length];
            System.arraycopy(asParms, 0, asKeys, 0, asParms.length);
            for (int nIdx = 0; nIdx < aItems.length; ++nIdx) {
                WEB_PAGE_ITEMS rNext = aItems[nIdx];
                if (rNext == null) continue;
                asKeys[asParms.length - 1 + nIdx] = rNext.GetKey();
            }
        }
        return asKeys;
    }

    @Override
    protected void InitParameter(String sKey, String sVal) {
        WEB_PAGE_ITEMS[] aItems;
        super.InitParameter(sKey, sVal);
        if (sKey != null && !sKey.isEmpty() && (aItems = WEB_PAGE_ITEMS.values()) != null && aItems.length > 0) {
            for (int nIdx = 0; nIdx < aItems.length; ++nIdx) {
                String sItemKey;
                WEB_PAGE_ITEMS rNext = aItems[nIdx];
                if (rNext == null || (sItemKey = rNext.GetKey()) == null || sItemKey.isEmpty() || !sItemKey.equals(sKey)) continue;
                rNext.SetValue(sVal);
                break;
            }
        }
    }

    @Override
    public void OnAppletStart() {
        super.OnAppletStart();
        this.CheckFileSysAccess();
        this.SendOnInit();
        if (CWebClientProApp.GET_APP() != null) {
            CWorkerThreadMsg rAttrMsg = new CWorkerThreadMsg(4004);
            CWebClientProApp.GET_APP().NewMessage(rAttrMsg);
        }
        this.CheckRepaintTableHeader();
    }

    protected void CheckRepaintTableHeader() {
        if (this.IsInternetExplorerBrowser() && CWebClientProApp.GET_APP() != null && CWebClientProApp.GET_APP().GetMainWnd() != null) {
            CWebClientProApp.GET_APP().GetMainWnd().PostRepaintTreeTableHeader();
        }
    }

    protected void CheckFileSysAccess() {
        boolean bCanAccessFileSystem;
        block6: {
            bCanAccessFileSystem = false;
            try {
                File fTemp;
                File fTempFolder;
                block7: {
                    String sTempDir = System.getProperty("java.io.tmpdir");
                    fTempFolder = new File(sTempDir);
                    if (fTempFolder == null || !fTempFolder.exists()) break block6;
                    fTemp = null;
                    try {
                        fTemp = File.createTempFile("Temp", ".txt");
                    }
                    catch (IOException ioe) {
                        if (!DEBUG) break block7;
                        ioe.printStackTrace();
                    }
                }
                if (fTemp != null && fTemp.exists()) {
                    fTempFolder = fTemp.getParentFile();
                    bCanAccessFileSystem = true;
                    fTemp.deleteOnExit();
                    fTemp.delete();
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (!bCanAccessFileSystem) {
            this.SendCantAccessFileSys();
        }
    }

    private void SendOnInit() {
        if (this.GetCommunicationThread() != null) {
            this.m_bInitializedOnPage = this.GetCommunicationThread().SendOnInit();
        }
    }

    private void SendCantAccessFileSys() {
        if (this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().SendCantAccessFileSys();
        }
    }

    private void CallUpdateDynamicBtns(String[] abBtnFlags) {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().PostUpdateDynamicBtns(abBtnFlags);
        }
    }

    private void CallUpdateStartBtnText(String sStartBtnText, String sRestartBtnText) {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().PostUpdateStartBtnText(sStartBtnText, sRestartBtnText);
        }
    }

    public void InitLocale(String sLanguageCountryCode) {
        if (CWebClientProApp.GET_APP() != null) {
            CWebClientProApp.GET_APP().PostInitLocale(sLanguageCountryCode);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
        }
    }

    @Override
    protected CRhinoAppletApp CreateApp() {
        String[] asKeys = this.GetExpectedStartupParameters();
        String[] asArgs = new String[asKeys.length];
        for (int nIdx = 0; nIdx < asKeys.length; ++nIdx) {
            String sKey = asKeys[nIdx];
            if (sKey == null || sKey.isEmpty()) continue;
            asArgs[nIdx] = String.format("%s,%s", sKey, this.GetParam(sKey));
        }
        return new CWebClientProApp(asArgs, this);
    }

    public void OnAppletDownload(final String sAbsSourcePathsArray) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null && sAbsSourcePathsArray != null) {
                    CWebClientProApp.GET_APP().PostDownloadItems(sAbsSourcePathsArray);
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletUpload(final String sAbsTargetDir) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null && sAbsTargetDir != null && !sAbsTargetDir.isEmpty()) {
                    CWebClientProApp.GET_APP().PostUploadItems(sAbsTargetDir);
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletDelete(final String sAbsSourcePathsArray) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null && sAbsSourcePathsArray != null) {
                    CWebClientProApp.GET_APP().PostDeleteItems(sAbsSourcePathsArray);
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnShowConnectionInfo() {
        if (CWebClientProApp.GET_APP() != null) {
            CWebClientProApp.GET_APP().PostShowConnectionInfo();
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
        }
    }

    public void OnShowLocale() {
        if (CWebClientProApp.GET_APP() != null) {
            CWebClientProApp.GET_APP().PostShowLocale();
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
        }
    }

    public void OnAppletTransferShowInFolder() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferShowInFolder();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferOpenFile() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferOpenFile();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferStopAfter() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferStopAfter();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferSkip() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferSkip();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferPause() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferPause();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferResume() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferResume();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferStart() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferStart();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRestart() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRestart();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferCancel() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferCancel();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRemove() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRemove();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRemoveAll() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRemoveAll();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRemoveCompleted() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRemoveCompleted();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRemoveCancelled() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRemoveCancelled();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRemoveSkipped() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRemoveSkipped();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRemovePaused() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRemovePaused();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRemoveWaiting() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRemoveWaiting();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletTransferRemoveStopped() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferRemoveStopped();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletShowOptionsDlg() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnShowOptionsDlg();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    public void OnAppletShowAboutDlg() {
        if (CRhinoApp.DEBUG_ICED_TEA) {
            JOptionPane.showMessageDialog(null, "OnAppletShowAboutDlg");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnShowAboutDlg();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    protected void OnUpdateDynamicBtns(CUpdateDynamicBtns rBtnMsg) {
        if (rBtnMsg != null) {
            if (rBtnMsg.GetDispatchBtns()) {
                this.CallUpdateDynamicBtns(rBtnMsg.MakeBtnStateFlagArray());
            }
            if (rBtnMsg instanceof CUpdateTransferBtns) {
                CUpdateTransferBtns rTransferUpdateMsg = (CUpdateTransferBtns)rBtnMsg;
                if (rBtnMsg.GetDispatchText()) {
                    this.CallUpdateStartBtnText(rTransferUpdateMsg.GetStartBtnDesc(), rTransferUpdateMsg.GetRestartBtnDesc());
                }
            }
        }
    }

    private void CallShowWaitCursor() {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().PostShowWaitCursor();
        }
    }

    private void CallHideWaitCursor() {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().PostHideWaitCursor();
        }
    }

    protected void OnShowWaitCursor() {
        if (DEBUG) {
            System.out.println("OnShowWaitCursor -->");
        }
        ++this.m_nShowWaitCursor;
        if (this.m_nShowWaitCursor == 1) {
            this.CallShowWaitCursor();
        }
        if (DEBUG) {
            System.out.println("OnShowWaitCursor <--");
        }
    }

    protected void OnHideWaitCursor() {
        if (DEBUG) {
            System.out.println("OnHideWaitCursor -->");
        }
        if (this.m_nShowWaitCursor > 0) {
            --this.m_nShowWaitCursor;
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error; investigate the invalid counter!");
        }
        if (this.m_nShowWaitCursor == 0) {
            this.CallHideWaitCursor();
        }
        if (DEBUG) {
            System.out.println("OnHideWaitCursor <--");
        }
    }

    private void CallShowOpaqueLayer() {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().PostShowOpaqueLayer();
        }
    }

    private void CallHideOpaqueLayer() {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().PostHideOpaqueLayer();
        }
    }

    protected void OnShowOpaqueLayer() {
        if (DEBUG) {
            System.out.println("OnShowOpaqueLayer -->");
        }
        ++this.m_nOpaqueCounter;
        if (this.m_nOpaqueCounter == 1) {
            this.CallShowOpaqueLayer();
        }
        if (DEBUG) {
            System.out.println("OnShowOpaqueLayer <--");
        }
    }

    protected void OnHideOpaqueLayer() {
        if (DEBUG) {
            System.out.println("OnHideOpaqueLayer -->");
        }
        --this.m_nOpaqueCounter;
        if (this.m_nOpaqueCounter == 0) {
            this.CallHideOpaqueLayer();
        }
        if (DEBUG) {
            System.out.println("OnHideOpaqueLayer <--");
        }
    }

    private void SendAllDoneInCurDir() {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().SendAllDoneInCurDir();
        }
    }

    public void OnAllDoneInCurDir() {
        this.SendAllDoneInCurDir();
    }

    public void OnAppletSetWorkingDir(final String sURLEncodedCurWorkingDir) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (sURLEncodedCurWorkingDir != null) {
                    CWebClientProApplet.this.SetWorkingDir(CString.URLDecode(sURLEncodedCurWorkingDir));
                }
                return null;
            }
        });
    }

    private void SetWorkingDir(String sWorkingDir) {
        this.m_sCurWorkingDir = sWorkingDir;
    }

    public String GetWorkingDir() {
        return this.m_sCurWorkingDir;
    }

    public boolean IsAppletHidden() {
        return this.m_bAppletIsHidden;
    }

    public void OnAppletIsHidden(final int nContainerWidth, final int nContainerHeight) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!CWebClientProApplet.this.m_bAppletIsHidden && CRhinoApp.GET_RHINO_APP() != null) {
                    CRhinoApp.GET_RHINO_APP().PostOnUpdateCenterPoint(nContainerWidth, nContainerHeight);
                }
                CWebClientProApplet.this.m_bAppletIsHidden = true;
                if (CRhinoApp.GET_RHINO_APP() != null) {
                    CRhinoApp.GET_RHINO_APP().PostProcessDlgQueue();
                }
                return null;
            }
        });
    }

    public void OnAppletIsVisible() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CWebClientProApplet.this.m_bAppletIsHidden = false;
                CWebClientProApplet.this.CheckRepaintTableHeader();
                return null;
            }
        });
    }

    public void OnAppletGridItemDone() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DEBUG_PROCESS_GRID_ITEMS) {
                    System.out.println("OnAppletGridItemDone -->");
                }
                if (CWebClientProApplet.this.m_bInitializedOnPage && CWebClientProApplet.this.GetCommunicationThread() != null) {
                    CWebClientProApplet.this.GetCommunicationThread().PostOnRecvPageGridItemsDone();
                }
                if (DEBUG_PROCESS_GRID_ITEMS) {
                    System.out.println("OnAppletGridItemDone <--");
                }
                return null;
            }
        });
    }

    @Override
    public boolean GetSupportsFileExplorerDragDrop() {
        boolean bSupportsFileExplorerDragDrop = super.GetSupportsFileExplorerDragDrop();
        if (this.IsMacintoshOS()) {
            bSupportsFileExplorerDragDrop = false;
        } else if (CLocalFileSystem.GetLocalFileSystem() != null) {
            if (CLocalFileSystem.GetLocalFileSystem().IsMac() || CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
                bSupportsFileExplorerDragDrop = false;
            } else if (CLocalFileSystem.GetLocalFileSystem().IsWindows()) {
                bSupportsFileExplorerDragDrop = true;
            }
        }
        return bSupportsFileExplorerDragDrop;
    }

    @Override
    public boolean AllowDragDropStringFlavors() {
        boolean bAllowDragDropStringFlavors = super.AllowDragDropStringFlavors();
        if (this.IsMacintoshOS()) {
            bAllowDragDropStringFlavors = false;
        } else if (CLocalFileSystem.GetLocalFileSystem() != null) {
            if (CLocalFileSystem.GetLocalFileSystem().IsMac() || CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
                bAllowDragDropStringFlavors = false;
            } else if (CLocalFileSystem.GetLocalFileSystem().IsWindows()) {
                bAllowDragDropStringFlavors = false;
            }
        }
        return bAllowDragDropStringFlavors;
    }

    public void OnFetchCurWorkingDir(CFetchCurWorkingDirMsg rFetchCurWorkingDirMsg) {
        if (rFetchCurWorkingDirMsg != null) {
            rFetchCurWorkingDirMsg.SetCurWorkingDir(this.GetWorkingDir());
        }
    }

    public void SetAppletIsWorking(boolean bIsAppletWorking) {
        this.m_bAppletIsWorking = bIsAppletWorking;
        if (CRhinoApp.DEBUG_TRANSFERS_IN_PROGRESS) {
            CDebugLog.INFO("Applet Is Working: " + Boolean.toString(this.m_bAppletIsWorking));
        }
    }

    public boolean GetAppletIsWorking() {
        return this.m_bAppletIsWorking;
    }

    public int OnAppletIsWorking() {
        Object rIsWorking = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int nIsWorking = 0;
                if (CWebClientProApplet.this.GetAppletIsWorking()) {
                    nIsWorking = 1;
                }
                return nIsWorking;
            }
        });
        int nRetIsWorking = 0;
        if (rIsWorking != null && rIsWorking instanceof Integer) {
            nRetIsWorking = (Integer)rIsWorking;
        }
        return nRetIsWorking;
    }

    @Override
    protected CRhinoAppletCommThread CreateCommunicationThread() {
        return new CWebClientProAppletCommThread(this, CRhinoApp.GET_RHINO_APP());
    }

    @Override
    protected CWebClientProAppletCommThread GetCommunicationThread() {
        return (CWebClientProAppletCommThread)super.GetCommunicationThread();
    }

    public void OnDeleteComplete(CDeleteMsg rDeleteMsg) {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().OnDeleteComplete(rDeleteMsg);
        }
    }

    public void OnUploadComplete(CUploadMsg rUploadMsg) {
        if (this.m_bInitializedOnPage && this.GetCommunicationThread() != null) {
            this.GetCommunicationThread().OnUploadComplete(rUploadMsg);
        }
    }

    @Override
    public void start() {
        super.start();
    }

    public void OnAppletCancelActiveOperations() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CWebClientProApp.GET_APP() != null) {
                    CWebClientProApp.GET_APP().PostOnTransferCancelAll();
                } else if (CRhinoApplet.DEBUG) {
                    CDebugLog.ASSERT(CWebClientProApplet.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                }
                return null;
            }
        });
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PROCESS_GRID_ITEMS = false;
    }

    public static enum WEB_PAGE_ITEMS {
        APPLET_ID("appletid", "MultiTransferAppletID"),
        ON_INIT("oninitfunc", "OnInit"),
        ON_SHOW_OPAQUE_LAYER("onshowopaquelayer", "OnShowOpaqueLayer"),
        ON_HIDE_OPAQUE_LAYER("onhideopaquelayer", "OnHideOpaqueLayer"),
        ON_UPDATE_TRANSFER_BTNS("onupdatetransferbtns", "OnUpdateTransferBtns"),
        ON_UPDATE_START_BTN_TEXT("onupdatestartbtntext", "OnUpdateStartBtnText"),
        ON_ALL_DONE_IN_CUR_DIR("onalldoneincurdir", "OnAllDoneInCurDir"),
        ON_CANT_ACCESS_FILE_SYS("oncantaccessfilesys", "OnCantAccessFileSys"),
        ON_ACTIVATE_BROWSER("onactivatebrowser", "OnActivateBrowser"),
        ON_SHOW_WAIT_CURSOR("onshowwaitcursor", "OnShowWaitCursor"),
        ON_HIDE_WAIT_CURSOR("onhidewaitcursor", "OnHideWaitCursor"),
        ON_PROCESS_GRID_ITEMS("onprocessgriditems", "OnProcessGridItems");

        private String m_sKey;
        private String m_sValue;

        private WEB_PAGE_ITEMS(String sKey, String sValue) {
            this.m_sKey = sKey;
            this.m_sValue = sValue;
        }

        public final String GetKey() {
            return this.m_sKey;
        }

        public final String GetValue() {
            return this.m_sValue;
        }

        public void SetValue(String sValue) {
            this.m_sValue = sValue;
        }
    }
}

