/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.WebClientPro;

import com.rhinosoft.WebClientPro.CWCPConnection;
import com.rhinosoft.WebClientPro.CWCPURLFactory;
import com.rhinosoft.WebClientPro.CWebClientProActionFactory;
import com.rhinosoft.WebClientPro.CWebClientProApplet;
import com.rhinosoft.WebClientPro.CWebClientProLookAndFeel;
import com.rhinosoft.WebClientPro.CWebClientProMainWnd;
import com.rhinosoft.WebClientPro.IWebClientProConsts;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.attrs.CContainerAttr;
import com.rhinosoft.attrs.CStringURLAttr;
import com.rhinosoft.dialogs.CConfirmDeleteDlg;
import com.rhinosoft.dialogs.CConfirmErrorDlg;
import com.rhinosoft.dialogs.CConfirmMultiDeleteDlg;
import com.rhinosoft.dialogs.CConfirmOverwriteDlg;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CLocalFile;
import com.rhinosoft.images.CCachedImageIcon;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAddDeleteItemsMsg;
import com.rhinosoft.messages.CAddDownloadItemsMsg;
import com.rhinosoft.messages.CAddUploadItemsMsg;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CConnectionInfoMsg;
import com.rhinosoft.messages.CDeleteMsg;
import com.rhinosoft.messages.CFetchCurWorkingDirMsg;
import com.rhinosoft.messages.CRightClickMsg;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.messages.CSUSourceMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.messages.CUpdateDynamicBtns;
import com.rhinosoft.messages.CUploadMsg;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.net.HTTP.SU.CSUConnection;
import com.rhinosoft.net.HTTP.SU.CSUURLFactory;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CActionFactory;
import com.rhinosoft.ui.CLookAndFeel;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.applet.CRhinoApplet;
import com.rhinosoft.ui.applet.CRhinoAppletApp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;

public class CWebClientProApp
extends CRhinoAppletApp
implements ActionListener {
    public static boolean DEBUG_TEST_XFER_FILE_CHOOSERS = true;
    public static String APP_NAME = "Web Client Pro";
    public static int VERSION_MAJOR_1 = 12;
    public static int VERSION_MAJOR_2 = 1;
    public static int VERSION_MINOR_1 = 0;
    public static int VERSION_MINOR_2 = 8;
    public static int FF_VERSION_MAJOR_1 = 12;
    public static int FF_VERSION_MAJOR_2 = 9;
    public static int FF_VERSION_MINOR_1 = 0;
    public static int FF_VERSION_MINOR_2 = 0;
    public static final String FILE_NAME_APP_ARCHIVE = "App.properties";
    public static final String OLD_FOLDER_NAME_IMAGE_CACHE_FOR_FILE_TYPES = "File Types";
    public static final String OLD_FOLDER_APP_NAME = "Web Client Pro";
    public static final String OLD_THUMB_CACHE_ROOT_DIR = "Thumbs";

    public static void main(final String[] asArguments) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                CAttr.InitDebugFlag(asArguments);
                CAttr.InitFutureFeatureFlag(asArguments);
                CRhinoApp.DEBUG_SHOW_EXTRA_XFER_COLS = true;
                final CWebClientProApp rApp = new CWebClientProApp(asArguments, null);
                if (rApp.GetMainWnd() != null && rApp.GetMainWnd().GetTransferTreeTable() != null) {
                    rApp.GetMainWnd().GetTransferTreeTable().InitConnection(rApp.GetHost(), rApp.GetServerPort(), rApp.GetHeaderPort(), "FTP Voyager JV", rApp.GetEncSessionID(), false);
                    rApp.GetMainWnd().GetTransferTreeTable().InitLocale(rApp.GetLanguageCode(), rApp.GetCountryCode());
                }
                JPanel rPanel = new JPanel();
                JButton rAddUploadFiles = new JButton("Add Upload Files");
                rAddUploadFiles.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        if (DEBUG_TEST_XFER_FILE_CHOOSERS) {
                            rApp.GetMainWnd().GetTransferTreeTable().UploadItems("/D:/Temp/Upload/");
                        } else {
                            File[] aSelFiles;
                            JFileChooser fc = new JFileChooser(new File("D:\\Temp"));
                            fc.setMultiSelectionEnabled(true);
                            fc.setFileSelectionMode(2);
                            int nRetVal = fc.showOpenDialog((Component)rEvent.getSource());
                            if (nRetVal == 0 && (aSelFiles = fc.getSelectedFiles()).length > 0) {
                                Object[] aFiles = new Object[aSelFiles.length * 2];
                                int nIdx = 0;
                                for (File fNext : aSelFiles) {
                                    aFiles[nIdx] = fNext.getAbsolutePath();
                                    aFiles[nIdx + 1] = fNext.isDirectory();
                                    nIdx += 2;
                                }
                                rApp.GetMainWnd().GetTransferTreeTable().UploadItems(aFiles, "/D:/Temp/Upload/");
                            }
                        }
                    }
                });
                JButton rAddDownloadFiles = new JButton("Add Download Files");
                rAddDownloadFiles.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        File[] aSelFiles;
                        JFileChooser fc = new JFileChooser(new File("D:\\Temp\\Download\\"));
                        fc.setMultiSelectionEnabled(true);
                        fc.setFileSelectionMode(2);
                        int nRetVal = fc.showOpenDialog((Component)rEvent.getSource());
                        if (nRetVal == 0 && (aSelFiles = fc.getSelectedFiles()).length > 0) {
                            Object[] aFiles = new Object[aSelFiles.length * 2];
                            int nIdx = 0;
                            for (File fNext : aSelFiles) {
                                String sPath = fNext.getAbsolutePath();
                                sPath = CString.EnsureFirstCharIsAForwardSlash(sPath);
                                sPath = sPath.replace('\\', '/');
                                aFiles[nIdx] = sPath;
                                aFiles[nIdx + 1] = fNext.isDirectory();
                                nIdx += 2;
                            }
                            if (DEBUG_TEST_XFER_FILE_CHOOSERS) {
                                rApp.GetMainWnd().GetTransferTreeTable().DownloadItems(aFiles);
                            } else {
                                rApp.GetMainWnd().GetTransferTreeTable().DownloadItems(aFiles, "C:\\Temp2\\");
                            }
                        }
                    }
                });
                JButton rAddDeleteFiles = new JButton("Add Delete Files");
                rAddDeleteFiles.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        File[] aSelFiles;
                        JFileChooser fc = new JFileChooser(new File("C:\\Temp2"));
                        fc.setMultiSelectionEnabled(true);
                        fc.setFileSelectionMode(2);
                        int nRetVal = fc.showOpenDialog((Component)rEvent.getSource());
                        if (nRetVal == 0 && (aSelFiles = fc.getSelectedFiles()).length > 0) {
                            Object[] aFiles = new Object[aSelFiles.length * 2];
                            int nIdx = 0;
                            for (File fNext : aSelFiles) {
                                String sPath = fNext.getAbsolutePath();
                                sPath = CString.EnsureFirstCharIsAForwardSlash(sPath);
                                sPath = sPath.replace('\\', '/');
                                aFiles[nIdx] = sPath;
                                aFiles[nIdx + 1] = fNext.isDirectory();
                                nIdx += 2;
                            }
                            rApp.GetMainWnd().GetTransferTreeTable().DeleteItems(false, aFiles);
                        }
                    }
                });
                JButton rAssignThreads = new JButton("Assign Threads");
                rAssignThreads.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        rApp.OnMessage(new CWorkerThreadMsg(3517));
                    }
                });
                JButton rOptionsDlg = new JButton("Options Dlg");
                rOptionsDlg.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        rApp.PostOnShowOptionsDlg();
                    }
                });
                JButton rAboutDlg = new JButton("About Dlg");
                rAboutDlg.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        rApp.PostOnShowAboutDlg();
                    }
                });
                JButton rOverwriteDlg = new JButton("Overwrite Dlg");
                rOverwriteDlg.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        CConfirmOverwriteDlg dlg = new CConfirmOverwriteDlg(CRhinoApp.GetParentWindow(rApp.GetMainWnd()), null, null, null, null, -1L, false);
                        dlg.SetSourceFile(new CLocalFile(new File("C:\\Temp2\\AboutBox.png")));
                        dlg.SetTargetFile(new CLocalFile(new File("C:\\Temp2\\01.jpg")));
                        dlg.setVisible(true);
                    }
                });
                JButton rDeleteDlg = new JButton("Delete Dlg");
                rDeleteDlg.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        CLocalFile fSource = new CLocalFile(new File("C:\\Temp2\\Test"));
                        CConfirmDeleteDlg dlg = new CConfirmDeleteDlg(CRhinoApp.GetParentWindow(rApp.GetMainWnd()), null, fSource.IsDirectory(), (CFile)fSource, null, null, -1L);
                        dlg.setVisible(true);
                    }
                });
                JButton rMultiDeleteDlg = new JButton("Multi-Delete Dlg");
                rMultiDeleteDlg.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        CLocalFile f1 = new CLocalFile(new File("C:\\Temp2\\AboutBox.png"));
                        CLocalFile f2 = new CLocalFile(new File("C:\\Temp2\\01.jpg"));
                        CLocalFile f3 = new CLocalFile(new File("C:\\Temp2\\011.jpg"));
                        CFile[] afFiles = new CFile[]{f1, f2, f3};
                        CConfirmMultiDeleteDlg dlg = new CConfirmMultiDeleteDlg(CRhinoApp.GetParentWindow(rApp.GetMainWnd()), afFiles.length);
                        dlg.setVisible(true);
                    }
                });
                JButton rErrorDlg = new JButton("Error Dlg");
                rErrorDlg.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent rEvent) {
                        String sTitle = CString.LoadString("IDS_ERROR_FMT_TITLE");
                        sTitle = String.format(sTitle, CString.LoadString("IDS_ERROR_TITLE_NOOP"));
                        int nHTTPCode = 200;
                        int nSUCode = 6;
                        String sMsg = CSUMsg.GetSUError(nSUCode);
                        String sDetails = CSUMsg.FormatErrorMsg(nHTTPCode, nSUCode);
                        CConfirmErrorDlg dlg = new CConfirmErrorDlg(CRhinoApp.GetParentWindow(rApp.GetMainWnd()), null, sTitle, 7, sMsg, sDetails, null);
                        dlg.setVisible(true);
                    }
                });
                GroupLayout layout = new GroupLayout(rPanel);
                rPanel.setLayout(layout);
                layout.setAutoCreateGaps(false);
                layout.setAutoCreateContainerGaps(false);
                layout.setHorizontalGroup(layout.createParallelGroup().addComponent(rApp.GetMainWnd(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(rAddUploadFiles, -1, -2, -2).addComponent(rAddDownloadFiles, -1, -2, -2).addComponent(rAddDeleteFiles, -1, -2, -2).addComponent(rAssignThreads, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(rOptionsDlg, -1, -2, -2).addComponent(rAboutDlg, -1, -2, -2).addComponent(rOverwriteDlg, -1, -2, -2).addComponent(rDeleteDlg, -1, -2, -2).addComponent(rMultiDeleteDlg, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(rErrorDlg, -1, -2, -2)));
                layout.setVerticalGroup(layout.createSequentialGroup().addComponent(rApp.GetMainWnd(), -1, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(rAddUploadFiles, -1, -2, -2).addComponent(rAddDownloadFiles, -1, -2, -2).addComponent(rAddDeleteFiles, -1, -2, -2).addComponent(rAssignThreads, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(rOptionsDlg, -1, -2, -2).addComponent(rAboutDlg, -1, -2, -2).addComponent(rOverwriteDlg, -1, -2, -2).addComponent(rDeleteDlg, -1, -2, -2).addComponent(rMultiDeleteDlg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(rErrorDlg, -1, -2, -2)));
                frame.setContentPane(rPanel);
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        rApp.OnShutdown();
                    }
                });
                frame.pack();
                frame.setLocation(-1650, 10);
                frame.setSize(new Dimension(1600, 1000));
                frame.setVisible(true);
            }
        });
    }

    public CWebClientProApp(String[] asArguments, CRhinoApplet rApplet) {
        super(APP_NAME, asArguments, rApplet);
    }

    public static CWebClientProApp GET_APP() {
        CAttr rAttr = CWebClientProApp.FindGlobalAttr(1L);
        CWebClientProApp rApp = null;
        if (rAttr instanceof CWebClientProApp) {
            rApp = (CWebClientProApp)rAttr;
        }
        if (rApp == null) {
            assert (rApp == null);
            if (DEBUG) {
                System.out.println("CRhinoApplet.GET_RHINO_APPLET_APP is null");
            }
        }
        return rApp;
    }

    @Override
    protected CActionFactory CreateActionFactory() {
        return new CWebClientProActionFactory();
    }

    @Override
    protected CContainerAttr CreateMainWndAttr() {
        CContainerAttr rRet = new CContainerAttr();
        rRet.SetContainer(new CWebClientProMainWnd());
        return rRet;
    }

    @Override
    public CWebClientProMainWnd GetMainWnd() {
        return (CWebClientProMainWnd)super.GetMainWnd();
    }

    public void PostInitLocale(String sLanguageCountryCode) {
        String sCountryCode;
        String[] asTemp;
        String sLanguageCode;
        CConnectionInfoMsg rMsg;
        if (sLanguageCountryCode != null && !sLanguageCountryCode.isEmpty() && (rMsg = new CConnectionInfoMsg(sLanguageCode = (asTemp = sLanguageCountryCode.split(","))[0], sCountryCode = asTemp[1])) != null) {
            this.NewMessage(rMsg);
        }
    }

    @Override
    protected String GetArchiveFileName() {
        return FILE_NAME_APP_ARCHIVE;
    }

    @Override
    protected void InitStrings(String sLanguageCode, String sCountryCode) {
        super.InitStrings(sLanguageCode, sCountryCode);
        CString.InitStringTable("com/rhinosoft/WebClientPro/strings/Strings", sLanguageCode, sCountryCode);
    }

    @Override
    protected void OnCreate() {
        super.OnCreate();
        CConnectionInfoMsg rMsg = new CConnectionInfoMsg(this.GetLanguageCode(), this.GetCountryCode());
        this.NewMessage(rMsg);
    }

    @Override
    protected void OnInitialUpdate() {
        super.OnInitialUpdate();
    }

    @Override
    protected CWebClientProLookAndFeel CreateLookAndFeel() {
        String sDefClassName = CLookAndFeel.GetDefaultLookAndFeelClassName();
        if (!CLocalFileSystem.GetLocalFileSystem().IsWindows()) {
            sDefClassName = CLookAndFeel.GetCrossPlatformClassName();
        }
        return new CWebClientProLookAndFeel(2L, sDefClassName);
    }

    @Override
    public boolean GetShowConfirmLogout() {
        return false;
    }

    public void PostOnTransferShowInFolder() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3520);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferOpenFile() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3519);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferStopAfter() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3500);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferSkip() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3501);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferPause() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3502);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferResume() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3503);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferStart() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3504);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRestart() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3505);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferCancel() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3506);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferCancelAll() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3521);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRemove() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3507);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRemoveAll() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3515);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRemoveCompleted() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3509);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRemoveCancelled() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3510);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRemoveSkipped() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3511);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRemovePaused() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3512);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRemoveWaiting() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3513);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTransferRemoveStopped() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(3514);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnShowOptionsDlg() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(2024);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnShowAboutDlg() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(2144);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostDownloadItems(String sAbsSourcePathsArray) {
        if (sAbsSourcePathsArray != null && !sAbsSourcePathsArray.isEmpty()) {
            CAddDownloadItemsMsg rMsg = new CAddDownloadItemsMsg(sAbsSourcePathsArray, true);
            if (rMsg != null) {
                this.NewMessage(rMsg);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWebClientProApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  Invalid args.");
        }
    }

    public void PostUploadItems(String sAbsEncodedTargetDir) {
        if (sAbsEncodedTargetDir != null && !sAbsEncodedTargetDir.isEmpty()) {
            String sAbsTargetDir = CStringURLAttr.URLDecode(sAbsEncodedTargetDir);
            CAddUploadItemsMsg rMsg = new CAddUploadItemsMsg(sAbsTargetDir, true);
            if (rMsg != null) {
                this.NewMessage(rMsg);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWebClientProApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  Invalid args.");
        }
    }

    public void PostDeleteItems(String sAbsSourcePathsArray) {
        if (sAbsSourcePathsArray != null && !sAbsSourcePathsArray.isEmpty()) {
            CAddDeleteItemsMsg rMsg = new CAddDeleteItemsMsg(false, sAbsSourcePathsArray);
            if (rMsg != null) {
                this.NewMessage(rMsg);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWebClientProApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  Invalid args.");
        }
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 8012: {
                    CUIMessage rUIMsg = (CUIMessage)rMsg;
                    CSUSourceMsg rSUSourceMsg = (CSUSourceMsg)rUIMsg.GetSource();
                    if (this.GetApplet() == null) break;
                    if (rSUSourceMsg instanceof CUploadMsg) {
                        CUploadMsg rUploadMsg = (CUploadMsg)rSUSourceMsg;
                        this.GetApplet().OnUploadComplete(rUploadMsg);
                        break;
                    }
                    if (!(rSUSourceMsg instanceof CDeleteMsg)) break;
                    CDeleteMsg rDeleteMsg = (CDeleteMsg)rSUSourceMsg;
                    this.GetApplet().OnDeleteComplete(rDeleteMsg);
                    break;
                }
                case 5309: {
                    if (this.GetApplet() == null) break;
                    this.GetApplet().OnShowWaitCursor();
                    break;
                }
            }
        }
        super.OnMessage(rMsg);
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 5017: {
                    CRightClickMsg rRightClickMsg = (CRightClickMsg)rMsg;
                    Object rSource = rRightClickMsg.GetSource();
                    Point ptInSourceCoords = rRightClickMsg.GetPoint();
                    if (rSource != null && ptInSourceCoords != null) {
                        int nX = ptInSourceCoords.x;
                        int nY = ptInSourceCoords.y;
                        break;
                    }
                    if (!DEBUG) break;
                    CDebugLog.ASSERT(CWebClientProApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args");
                    break;
                }
                case 8000: {
                    CFetchCurWorkingDirMsg rCurDirMsg = (CFetchCurWorkingDirMsg)rMsg;
                    if (this.GetApplet() == null) break;
                    this.GetApplet().OnFetchCurWorkingDir(rCurDirMsg);
                    break;
                }
                case 4024: {
                    CUpdateDynamicBtns rBtnMsg = (CUpdateDynamicBtns)rMsg;
                    if (this.GetApplet() == null) break;
                    this.GetApplet().OnUpdateDynamicBtns(rBtnMsg);
                    break;
                }
                case 5200: {
                    if (this.GetApplet() == null) break;
                    this.GetApplet().OnShowOpaqueLayer();
                    break;
                }
                case 5201: {
                    if (this.GetApplet() == null) break;
                    this.GetApplet().OnHideOpaqueLayer();
                    break;
                }
                case 3518: {
                    if (this.GetApplet() == null) break;
                    this.GetApplet().OnAllDoneInCurDir();
                    break;
                }
                case 20004: {
                    this.OnRecvShowOpaqueLayer();
                    break;
                }
                case 20006: {
                    this.OnRecvHideOpaqueLayer();
                    break;
                }
                case 20008: {
                    this.OnRecvUpdateDynamicBtns();
                    break;
                }
                case 20012: {
                    this.OnRecvUpdateStartBtnText();
                    break;
                }
                case 20010: {
                    this.OnRecvReactivateBrowser();
                    break;
                }
                case 20014: {
                    this.OnRecvShowWaitCursor();
                    break;
                }
                case 20016: {
                    this.OnRecvHideWaitCursor();
                    break;
                }
                case 5309: {
                    if (this.GetApplet() == null) break;
                    this.GetApplet().OnHideWaitCursor();
                    break;
                }
            }
        }
    }

    @Override
    protected void LoadImageCacheProduct(CConnectionAttrs rConnInfo, CWorkerThread rThread) {
        IWebClientProConsts.CACHE_IMAGES_WCPRO[] arImages = IWebClientProConsts.CACHE_IMAGES_WCPRO.values();
        if (arImages != null) {
            String sClientDirPath = this.GetLocalStoragePathImages();
            String sServerDirPath = this.GetRemoteStoragePathImages(false);
            for (int nIdx = 0; nIdx < arImages.length; ++nIdx) {
                IWebClientProConsts.CACHE_IMAGES_WCPRO rImg = arImages[nIdx];
                if (rImg == null) continue;
                this.AddCachedImage(rImg.GetFileName(), new CCachedImageIcon(rImg.GetFileName(), rImg.IsCommon(), rImg.GetWidth(), rImg.GetHeight(), rConnInfo, rThread, sClientDirPath, sServerDirPath));
            }
        }
    }

    @Override
    public String GetRemoteStoragePathImages(boolean bIsCommon) {
        String sServerDirPath = null;
        sServerDirPath = !bIsCommon ? "Web Client/" + APP_NAME + "/Images/" : super.GetRemoteStoragePathImages(bIsCommon);
        return sServerDirPath;
    }

    @Override
    public CWebClientProApplet GetApplet() {
        return (CWebClientProApplet)super.GetApplet();
    }

    private void OnDeleteComplete(CDeleteMsg rDeleteMsg) {
        if (this.GetApplet() != null) {
            this.GetApplet().OnDeleteComplete(rDeleteMsg);
        }
    }

    private void OnUploadComplete(CUploadMsg rUploadMsg) {
        if (this.GetApplet() != null) {
            this.GetApplet().OnUploadComplete(rUploadMsg);
        }
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
    }

    @Override
    public String GetHTTPHeader_ClientName() {
        return "X-Is-WCP";
    }

    @Override
    protected String GetHelpPath() {
        return "Web%20Client/Help/Help.htm";
    }

    @Override
    public void InitVersionNumbers() {
        this.SetVersionMajor1(VERSION_MAJOR_1);
        this.SetVersionMajor2(VERSION_MAJOR_2);
        this.SetVersionMinor1(VERSION_MINOR_1);
        this.SetVersionMinor2(VERSION_MINOR_2);
        if (CAttr.FUTURE_FEATURES) {
            this.SetVersionMajor1(FF_VERSION_MAJOR_1);
            this.SetVersionMajor2(FF_VERSION_MAJOR_2);
            this.SetVersionMinor1(FF_VERSION_MINOR_1);
            this.SetVersionMinor2(FF_VERSION_MINOR_2);
        }
    }

    @Override
    protected boolean CheckCanShowDialogs() {
        boolean bCanShowDialogs = super.CheckCanShowDialogs();
        if (bCanShowDialogs && this.GetApplet() != null) {
            bCanShowDialogs = this.GetApplet().IsAppletHidden();
        }
        return bCanShowDialogs;
    }

    @Override
    protected void IncTransfersInProgress() {
        super.IncTransfersInProgress();
        if (this.GetApplet() != null) {
            this.GetApplet().SetAppletIsWorking(this.AreTransfersInProgress());
        }
    }

    @Override
    protected void DecTransfersInProgress() {
        super.DecTransfersInProgress();
        if (this.GetApplet() != null) {
            this.GetApplet().SetAppletIsWorking(this.AreTransfersInProgress());
        }
    }

    public void PostRecvShowOpaqueLayer() {
        CWorkerThreadMsg rUIMsg = new CWorkerThreadMsg(20004);
        this.NewMessage(rUIMsg);
    }

    private void OnRecvShowOpaqueLayer() {
        this.PostProcessDlgQueue();
    }

    public void PostRecvHideOpaqueLayer() {
        CWorkerThreadMsg rUIMsg = new CWorkerThreadMsg(20006);
        this.NewMessage(rUIMsg);
    }

    public void PostRecvShowWaitCursor() {
        CWorkerThreadMsg rUIMsg = new CWorkerThreadMsg(20014);
        this.NewMessage(rUIMsg);
    }

    public void PostRecvHideWaitCursor() {
        CWorkerThreadMsg rUIMsg = new CWorkerThreadMsg(20016);
        this.NewMessage(rUIMsg);
    }

    private void OnRecvHideOpaqueLayer() {
    }

    public void PostRecvUpdateDynamicBtns() {
        CWorkerThreadMsg rUIMsg = new CWorkerThreadMsg(20008);
        this.NewMessage(rUIMsg);
    }

    public void PostRecvUpdateStartBtnText() {
        CWorkerThreadMsg rUIMsg = new CWorkerThreadMsg(20012);
        this.NewMessage(rUIMsg);
    }

    private void OnRecvUpdateDynamicBtns() {
    }

    private void OnRecvUpdateStartBtnText() {
    }

    public void PostRecvReactivateBrowser() {
        CWorkerThreadMsg rUIMsg = new CWorkerThreadMsg(20010);
        this.NewMessage(rUIMsg);
    }

    private void OnRecvReactivateBrowser() {
    }

    @Override
    public CSUURLFactory CreateURLFactory(boolean bIsSecure, String sHost, long lPort, String sSessionID) {
        return new CWCPURLFactory(bIsSecure, sHost, lPort, sSessionID);
    }

    @Override
    public CSUConnection CreateSUConnection(String sUserAgent, CConnectionAttrs rConnInfo, int nCompressionType) {
        return new CWCPConnection(sUserAgent, rConnInfo, nCompressionType);
    }

    @Override
    protected String GetLocalStoragePathRoot(boolean bEnsureExists) {
        String sRetPath = null;
        String sUserDir = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        if (sUserDir == null || sUserDir.isEmpty()) {
            sUserDir = System.getenv("USERPROFILE");
        }
        if (sUserDir != null) {
            StringBuilder sTemp = new StringBuilder(sUserDir);
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sTemp.append("RhinoSoft");
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sRetPath = sTemp.toString();
        }
        if (bEnsureExists) {
            CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sRetPath);
        }
        return sRetPath;
    }

    private void DeleteOldLocalStoragePathRoot() {
        File fOldLocation;
        String sAbsOldPath = this.GetLocalStoragePathRoot_Old();
        if (sAbsOldPath != null && !sAbsOldPath.isEmpty() && (fOldLocation = new File(sAbsOldPath)) != null && fOldLocation.exists()) {
            boolean bCanDelete = true;
            File[] afChildren = fOldLocation.listFiles();
            for (int nIdx2 = 0; nIdx2 < afChildren.length && bCanDelete; ++nIdx2) {
                File fChild = afChildren[nIdx2];
                if (fChild == null || !fChild.exists() || !fChild.isDirectory() || fChild.getAbsolutePath().contains(OLD_FOLDER_NAME_IMAGE_CACHE_FOR_FILE_TYPES) || fChild.getAbsolutePath().contains(OLD_THUMB_CACHE_ROOT_DIR)) continue;
                bCanDelete = false;
            }
            if (bCanDelete) {
                CLocalFileSystem.GetLocalFileSystem().Delete(fOldLocation);
            }
        }
    }

    @Override
    protected void DeleteOldLocalStoragePathApp() {
        String[] asOldDiskPaths = new String[]{this.GetLocalStoragePathApp_Old(), OLD_FOLDER_NAME_IMAGE_CACHE_FOR_FILE_TYPES};
        for (int nIdx = 0; nIdx < asOldDiskPaths.length; nIdx += 2) {
            File fOldLocation;
            String sAbsOldPath = asOldDiskPaths[nIdx];
            String sImageCacheFileTypeName = asOldDiskPaths[nIdx + 1];
            if (sAbsOldPath == null || sAbsOldPath.isEmpty() || (fOldLocation = new File(sAbsOldPath)) == null || !fOldLocation.exists()) continue;
            boolean bCanDelete = true;
            File[] afChildren = fOldLocation.listFiles();
            for (int nIdx2 = 0; nIdx2 < afChildren.length && bCanDelete; ++nIdx2) {
                File fChild = afChildren[nIdx2];
                if (fChild == null || !fChild.exists() || !fChild.isDirectory() || sImageCacheFileTypeName == null || sImageCacheFileTypeName.isEmpty() || fChild.getAbsolutePath().contains(sImageCacheFileTypeName)) continue;
                bCanDelete = false;
            }
            if (!bCanDelete) continue;
            CLocalFileSystem.GetLocalFileSystem().Delete(fOldLocation);
        }
        this.DeleteOldLocalStoragePathRoot();
    }

    @Override
    protected void UpgradeOldLocalStoragePathAppEx(String sAbsNewPath) {
        block5: {
            File fOldLocation;
            String sOldPath = this.GetLocalStoragePathApp_Old();
            if (sOldPath != null && !sOldPath.isEmpty() && (fOldLocation = new File(sOldPath)) != null && fOldLocation.exists()) {
                try {
                    File fNewLocation = new File(sAbsNewPath);
                    if (fNewLocation != null) {
                        File[] afChildren = fOldLocation.listFiles();
                        for (int nNextFileIdx = 0; nNextFileIdx < afChildren.length; ++nNextFileIdx) {
                            File fNextChild = afChildren[nNextFileIdx];
                            if (fNextChild == null || !fNextChild.exists() || fNextChild.isDirectory()) continue;
                            String sFromPath = fNextChild.getAbsolutePath();
                            String sName = sFromPath.substring(sOldPath.length());
                            String sToChild = sAbsNewPath;
                            sToChild = CString.EnsureLastCharIsAFileSeparator(sToChild);
                            File fToChild = new File(sToChild = sToChild + sName);
                            if (fToChild == null || fToChild.exists()) continue;
                            CLocalFileSystem.GetLocalFileSystem().Copy(fNextChild, fToChild);
                        }
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
    }

    private String GetLocalStoragePathRoot_Old() {
        String sRetPath = null;
        String sUserDir = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        if (sUserDir == null || sUserDir.isEmpty()) {
            sUserDir = System.getenv("USERPROFILE");
        }
        if (sUserDir != null) {
            StringBuilder sTemp = new StringBuilder(sUserDir);
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sTemp.append("RhinoSoft.com");
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sRetPath = sTemp.toString();
        }
        return sRetPath;
    }

    private String GetLocalStoragePathApp_Old() {
        String sRetPath = null;
        StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathRoot_Old());
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sTemp.append(OLD_FOLDER_APP_NAME);
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sRetPath = sTemp.toString();
        return sRetPath;
    }

    private String GetLocalStoragePathFileTypes_Old() {
        String sRetPath = null;
        StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathRoot_Old());
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sTemp.append(OLD_FOLDER_NAME_IMAGE_CACHE_FOR_FILE_TYPES);
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sRetPath = sTemp.toString();
        return sRetPath;
    }

    @Override
    protected void UpgradeOldLocalStoragePathFileTypesEx(String sAbsNewPath) {
        block4: {
            File fOldLocation;
            String sOldPath = this.GetLocalStoragePathFileTypes_Old();
            if (sOldPath != null && !sOldPath.isEmpty() && (fOldLocation = new File(sOldPath)) != null && fOldLocation.exists()) {
                try {
                    File fNewLocation = new File(sAbsNewPath);
                    if (fNewLocation != null) {
                        CLocalFileSystem.GetLocalFileSystem().Copy(fOldLocation, fNewLocation);
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private String GetLocalStoragePathPathHost_Old() {
        String sRetPath = null;
        String sHost = this.GetHost();
        if (sHost != null && !sHost.isEmpty()) {
            StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathApp_Old());
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sTemp.append(sHost);
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sRetPath = sTemp.toString();
        }
        return sRetPath;
    }

    @Override
    protected void UpgradeOldLocalStoragePathHostEx(String sAbsNewPath) {
        File fOldPath;
        String sOldHostPath;
        File fNewPath;
        if (sAbsNewPath != null && !sAbsNewPath.isEmpty() && (fNewPath = new File(sAbsNewPath)) != null && !fNewPath.exists() && (sOldHostPath = this.GetLocalStoragePathPathHost_Old()) != null && !sOldHostPath.isEmpty() && (fOldPath = new File(sOldHostPath)) != null && fOldPath.exists()) {
            CLocalFileSystem.GetLocalFileSystem().Copy(fOldPath, fNewPath);
            CLocalFileSystem.GetLocalFileSystem().Delete(fOldPath);
        }
    }

    private void OnRecvShowWaitCursor() {
    }

    private void OnRecvHideWaitCursor() {
    }
}

