/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SlidingOverFrameContainer
extends JPanel {
    protected static boolean DEBUG = false;
    protected HashMap<Component, SlidingFrameConstraint> _constraints;
    protected Rectangle rectDebug = new Rectangle();
    protected Container _contentPane = null;
    protected static final Dimension MIN_DIM = new Dimension(0, 0);
    protected static final Dimension MAX_DIM = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public SlidingOverFrameContainer(Container container) {
        super(null);
        this.setLayout(new SlidingFrameLayout());
        this.setOpaque(false);
        this._contentPane = container;
        this._constraints = new HashMap();
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2 = object;
        if (DockableFrame.N == 0) {
            if (!(object2 instanceof SlidingFrameConstraint)) {
                throw new IllegalArgumentException("constraint must be of type " + SlidingFrameConstraint.class.getName());
            }
            object2 = this._constraints.put(component, (SlidingFrameConstraint)object);
        }
        super.addImpl(component, object, n);
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        this.a(component);
    }

    private void a(Component component) {
        this._constraints.remove(component);
    }

    protected void paintComponent(Graphics graphics) {
        if (DEBUG) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.paintRect(graphics2D);
        }
    }

    protected void paintRect(Graphics2D graphics2D) {
        block3: {
            int n = DockableFrame.N;
            if (this.getComponentCount() < 1) {
                return;
            }
            Composite composite = graphics2D.getComposite();
            Color color = graphics2D.getColor();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.15f));
            graphics2D.setColor(Color.BLUE);
            graphics2D.fillRect(this.rectDebug.x, this.rectDebug.y, this.rectDebug.width, this.rectDebug.height);
            graphics2D.setColor(Color.RED);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            Rectangle rectangle = new Rectangle();
            for (int k = 0; k < this.getComponents().length; ++k) {
                Component component = this.getComponent(k);
                rectangle = component.getBounds(rectangle);
                graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 4, 4);
                if (n == 0) {
                    if (n == 0) continue;
                }
                break block3;
            }
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Rectangle computeLayoutBounds(Component var1_1, DockableFrame var2_2, int var3_3, boolean var4_4) {
        var7_5 = DockableFrame.N;
        var5_6 = var1_1.getParent();
        var6_7 = SwingUtilities.convertRectangle(var5_6, var5_6.getBounds(), var5_6);
        v0 = SlidingOverFrameContainer.DEBUG;
        if (var7_5 == 0) {
            if (v0 != 0) {
                this.rectDebug = var6_7;
                this.repaint();
            }
            v0 = var3_3;
        }
        if (var7_5 != 0) ** GOTO lbl14
        switch (v0) {
            case 4: {
                v0 = (int)var4_4;
lbl14:
                // 2 sources

                if (v0 != 0) {
                    var6_7.width = Math.min(var5_6.getWidth(), var2_2.getAutohideWidth());
                    var6_7.x += var5_6.getWidth() - var6_7.width;
                    if (var7_5 == 0) break;
                }
                var6_7.width = Math.min(var5_6.getWidth(), var2_2.getAutohideWidth());
                if (var7_5 == 0) break;
            }
            case 8: {
                if (var4_4) {
                    var6_7.width = Math.min(var5_6.getWidth(), var2_2.getAutohideWidth());
                    if (var7_5 == 0) break;
                }
                var6_7.width = Math.min(var5_6.getWidth(), var2_2.getAutohideWidth());
                var6_7.x += var5_6.getWidth() - var6_7.width;
                if (var7_5 == 0) break;
            }
            case 2: {
                var6_7.height = Math.min(var5_6.getHeight(), var2_2.getAutohideHeight());
                var6_7.y += var5_6.getHeight() - var6_7.height;
                if (var7_5 == 0) break;
            }
            case 1: {
                var6_7.height = Math.min(var5_6.getHeight(), var2_2.getAutohideHeight());
            }
        }
        return var6_7;
    }

    public boolean contains(int n, int n2) {
        boolean bl;
        block4: {
            Component[] componentArray;
            int n3 = DockableFrame.N;
            Component[] componentArray2 = componentArray = this.getComponents();
            int n4 = componentArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                Component component = componentArray2[n5];
                Point point = SwingUtilities.convertPoint(this, n, n2, component);
                if (n3 == 0) {
                    bl = component.contains(point.x, point.y);
                    if (n3 != 0) break block4;
                    if (bl) {
                        return true;
                    }
                    ++n5;
                }
                if (n3 == 0) continue;
            }
            bl = false;
        }
        return bl;
    }

    protected class SlidingFrameLayout
    implements LayoutManager2 {
        protected Rectangle _stepBounds = new Rectangle();

        protected SlidingFrameLayout() {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateLayout(Container container) {
            int n = DockableFrame.N;
            Object object = container.getTreeLock();
            synchronized (object) {
                Component[] componentArray;
                for (Component component : componentArray = SlidingOverFrameContainer.this.getComponents()) {
                    this.setupContainer(container, component, SlidingOverFrameContainer.this._constraints.get(component));
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break;
                }
                return;
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return MAX_DIM;
        }

        public Dimension minimumLayoutSize(Container container) {
            return MIN_DIM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                return SlidingOverFrameContainer.this.getSize();
            }
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            int n = DockableFrame.N;
            Object object = container.getTreeLock();
            synchronized (object) {
                Component[] componentArray;
                for (Component component : componentArray = SlidingOverFrameContainer.this.getComponents()) {
                    this.setupContainer(container, component, SlidingOverFrameContainer.this._constraints.get(component));
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break;
                }
                return;
            }
        }

        public void setupContainer(Container container, Component component, SlidingFrameConstraint slidingFrameConstraint) {
            int n = DockableFrame.N;
            if (slidingFrameConstraint == null) {
                return;
            }
            Rectangle rectangle = SlidingOverFrameContainer.this.computeLayoutBounds(slidingFrameConstraint.dockingComponent, slidingFrameConstraint.frame, slidingFrameConstraint.side, slidingFrameConstraint.isLeftToRight);
            this._stepBounds.setBounds(rectangle);
            if (n == 0) {
                switch (slidingFrameConstraint.side) {
                    case 4: {
                        if (slidingFrameConstraint.isLeftToRight) {
                            this._stepBounds.width = slidingFrameConstraint.currentStep * rectangle.width / slidingFrameConstraint.steps;
                            this._stepBounds.x = rectangle.x + rectangle.width - this._stepBounds.width;
                            if (n == 0) break;
                        }
                        this._stepBounds.width = slidingFrameConstraint.currentStep * rectangle.width / slidingFrameConstraint.steps;
                        if (n == 0) break;
                    }
                    case 8: {
                        if (slidingFrameConstraint.isLeftToRight) {
                            this._stepBounds.width = slidingFrameConstraint.currentStep * rectangle.width / slidingFrameConstraint.steps;
                            if (n == 0) break;
                        }
                        this._stepBounds.width = slidingFrameConstraint.currentStep * rectangle.width / slidingFrameConstraint.steps;
                        this._stepBounds.x = rectangle.x + rectangle.width - this._stepBounds.width;
                        if (n == 0) break;
                    }
                    case 2: {
                        this._stepBounds.height = slidingFrameConstraint.currentStep * rectangle.height / slidingFrameConstraint.steps;
                        this._stepBounds.y = rectangle.y + rectangle.height - this._stepBounds.height;
                        if (n == 0) break;
                    }
                    case 1: {
                        this._stepBounds.height = slidingFrameConstraint.currentStep * rectangle.height / slidingFrameConstraint.steps;
                    }
                }
                component.setBounds(this._stepBounds);
            }
        }
    }

    public class SlidingFrameConstraint {
        public DockableFrame frame;
        public Component dockingComponent;
        public int steps;
        public int currentStep;
        public int side;
        public boolean isLeftToRight;
        public boolean opening;
    }
}

