/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgThumb;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgCreateDirRemote;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class CThreadMsgThumbRemote
extends CThreadMsgThumb {
    public CThreadMsgThumbRemote(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType, int nThumbWidth, int nThumbHeight, boolean bIsPreview) {
        super(tThread, rSource, rClientInfo, nCompressionType, nThumbWidth, nThumbHeight, bIsPreview);
        this.InitVars();
    }

    protected CThreadMsgThumbRemote(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgThumbRemote) {
            this.Copy((CThreadMsgThumbRemote)rCopyFrom, false);
        }
    }

    private void InitVars() {
    }

    public boolean Copy(CThreadMsgThumbRemote rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null && bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
            bChanged = true;
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgThumbRemote(this);
    }

    @Override
    protected int[] RetrieveThumb(String sFromPath, long lFromSize, String sToPath, int nThumbWidth, int nThumbHeight) {
        int[] anRetCodes = null;
        if (this.GetSUConnection() != null) {
            String sExt;
            File fThumb;
            int nLastPos;
            String sName = CString.GetFileName(sToPath);
            if (sName != null && (nLastPos = sName.lastIndexOf(46)) >= 0 && nLastPos < sName.length()) {
                sName = sName.substring(0, nLastPos);
            }
            if ((fThumb = CThreadMsgThumbRemote.CreateTempFile(sName, sExt = CString.GetFileExtension(sToPath, false, true))) != null) {
                long lResumeStartIdx = -1L;
                if (this.CanUsePrevListPath(sToPath)) {
                    lResumeStartIdx = this.GetPrevListPathSize();
                }
                if ((anRetCodes = this.GetSUConnection().SendDownload(sFromPath, lFromSize, fThumb.getAbsolutePath(), true, nThumbWidth, nThumbHeight, lResumeStartIdx)) != null && anRetCodes.length == 2 && anRetCodes[1] == 0) {
                    BufferedImage rImage;
                    block9: {
                        rImage = null;
                        try {
                            rImage = ImageIO.read(fThumb);
                        }
                        catch (IOException ioe) {
                            if (!DEBUG) break block9;
                            ioe.printStackTrace();
                        }
                    }
                    if (rImage != null) {
                        this.SetThumbImage(new ImageIcon(rImage));
                    }
                }
            }
            if (fThumb != null && fThumb.exists() && !fThumb.delete()) {
                fThumb.deleteOnExit();
            }
        }
        return anRetCodes;
    }

    public static File CreateTempFile(String sName, String sExt) {
        File fRet;
        block6: {
            fRet = null;
            try {
                fRet = File.createTempFile(sName, sExt);
            }
            catch (IOException ioe) {
                if (DEBUG) {
                    ioe.printStackTrace();
                }
            }
            catch (IllegalArgumentException iae) {
                sName = "TEMP_" + sName;
                try {
                    fRet = File.createTempFile(sName, sExt);
                }
                catch (Exception e) {
                    if (!DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }
        return fRet;
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir(CThreadMsg rCopyFrom) {
        CThreadMsgCreateDirRemote rMsg = null;
        if (rCopyFrom != null) {
            rMsg = new CThreadMsgCreateDirRemote(rCopyFrom.GetThread(), rCopyFrom.GetSource(), rCopyFrom.GetClientInfo(), rCopyFrom.GetCompressionType(), false);
        }
        return rMsg;
    }
}

