/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.TransferPanel.CTransferRowSyncFolders;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmTransferFailedDlg;
import com.rhinosoft.fvjv.gui.dialogs.CRhinoOverwriteDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgPaths;
import com.rhinosoft.fvjv.threads.local.CThreadMsgCreateDirLocal;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgCreateDirRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgTransferRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgUploadRemote;
import java.awt.Dimension;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;

public class CThreadMsgSyncFoldersExecute
extends CThreadMsgTransferRemote {
    public static boolean DEBUG_SYNC_FOLDERS;
    private CPath m_rLocalPath;
    private CPath m_rRemotePath;
    private Vector<CSyncTableRow> m_aSyncData;

    public CThreadMsgSyncFoldersExecute(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 41, rSource, rClientInfo, nCompressionType);
        this.InitVars();
    }

    protected CThreadMsgSyncFoldersExecute(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        this.InitVars();
        if (rCopyFrom instanceof CThreadMsgSyncFoldersExecute) {
            this.Copy((CThreadMsgSyncFoldersExecute)rCopyFrom, false);
        }
    }

    private void InitVars() {
        this.m_aSyncData = new Vector();
    }

    public boolean Copy(CThreadMsgSyncFoldersExecute rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetLocalPath(rCopyFrom.GetLocalPath())) {
                bChanged = true;
            }
            if (this.SetRemotePath(rCopyFrom.GetRemotePath())) {
                bChanged = true;
            }
            this.SetSyncData(rCopyFrom);
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgSyncFoldersExecute(this);
    }

    @Override
    protected void ProcessError() {
        switch (this.GetErrorID()) {
            case 6054: {
                this.OnFailedToPrepareTransfer();
                break;
            }
            default: {
                super.ProcessError();
            }
        }
    }

    public boolean SetLocalPath(CPath rLocalPath) {
        boolean bChanged = false;
        if (this.m_rLocalPath != rLocalPath) {
            this.m_rLocalPath = rLocalPath;
            bChanged = true;
        }
        return bChanged;
    }

    protected CPath GetLocalPath() {
        return this.m_rLocalPath;
    }

    public boolean SetRemotePath(CPath rRemotePath) {
        boolean bChanged = false;
        if (this.m_rRemotePath != rRemotePath) {
            this.m_rRemotePath = rRemotePath;
            bChanged = true;
        }
        return bChanged;
    }

    public CPath GetRemotePath() {
        return this.m_rRemotePath;
    }

    private boolean SetSyncData(CThreadMsgSyncFoldersExecute rCopyFrom) {
        boolean bChanged = false;
        if (rCopyFrom != null && this.m_aSyncData != null) {
            this.m_aSyncData.removeAllElements();
            this.m_aSyncData.setSize(rCopyFrom.m_aSyncData.size());
            for (int nIdx = 0; nIdx < rCopyFrom.m_aSyncData.size(); ++nIdx) {
                CSyncTableRow rCopyDataFrom = rCopyFrom.m_aSyncData.get(nIdx);
                if (rCopyDataFrom == null) continue;
                CSyncTableRow rCopy = new CSyncTableRow(rCopyDataFrom);
                this.m_aSyncData.set(nIdx, rCopy);
            }
        }
        return bChanged;
    }

    public void SetSyncData(Vector<CSyncTableRow> aSyncData) {
        this.m_aSyncData.removeAllElements();
        if (this.m_aSyncData != null && aSyncData != null) {
            this.m_aSyncData.setSize(aSyncData.size());
            for (int nIdx = 0; nIdx < aSyncData.size(); ++nIdx) {
                this.m_aSyncData.set(nIdx, aSyncData.get(nIdx));
            }
        }
    }

    protected Vector<CSyncTableRow> GetSyncData() {
        return this.m_aSyncData;
    }

    @Override
    protected void PrepareTransfer(boolean bPostInitTransfer) {
        if (!this.IsPrepDone()) {
            Vector<CSyncTableRow> aData = this.GetSyncData();
            if (aData != null) {
                boolean bContinue = true;
                boolean bAlreadyNotified = false;
                for (int nIndex = this.GetPathIndex(); nIndex < aData.size() && bContinue && !this.GetCancel(); ++nIndex) {
                    boolean bIsDownload = false;
                    boolean bIsDelete = false;
                    CPath rFromPath = null;
                    this.SetPathIndex(nIndex);
                    CSyncTableRow rSyncRow = aData.get(nIndex);
                    if (rSyncRow != null) {
                        switch (rSyncRow.GetAction()) {
                            case UPLOAD: {
                                if (rSyncRow.GetLocalFile() == null) break;
                                rFromPath = rSyncRow.GetLocalFile().CreatePath();
                                this.ExpandLink(rFromPath);
                                break;
                            }
                            case DOWNLOAD: {
                                bIsDownload = true;
                                if (rSyncRow.GetRemoteFile() == null) break;
                                rFromPath = rSyncRow.GetRemoteFile().CreatePath();
                                break;
                            }
                            case DELETE: {
                                bIsDelete = true;
                                rFromPath = this.GetDeletionPath(rSyncRow);
                                break;
                            }
                        }
                    }
                    if (bIsDelete) {
                        boolean bCanDelete = this.VerifyDelete();
                        if (bCanDelete || this.GetResume()) {
                            this.ResetFlags();
                            int[] anRetCodes = this.Delete(rFromPath);
                            if (anRetCodes != null && anRetCodes.length == 2) {
                                if (anRetCodes[0] == 200 && (anRetCodes[1] == 0 || anRetCodes[1] == 6)) {
                                    this.PostDelete(rFromPath);
                                    continue;
                                }
                                bContinue = false;
                                bAlreadyNotified = true;
                                this.SetErrorID(20);
                                this.PostEvent(3005, this);
                                continue;
                            }
                            bContinue = false;
                            bAlreadyNotified = true;
                            this.SetErrorID(20);
                            this.PostEvent(3005, this);
                            continue;
                        }
                        this.SetFileRead(0L);
                        this.SetFileTotal(rFromPath.GetSize());
                        this.PostEvent(6052, this.clone());
                        this.SetErrorID(42);
                        this.PostEvent(3005, this);
                        bContinue = false;
                        bAlreadyNotified = true;
                        continue;
                    }
                    if (rFromPath == null) continue;
                    this.AddFromPath(rFromPath);
                    this.AdjustOverallTotal(rFromPath);
                    this.AddAllChildFiles(rFromPath, bIsDownload);
                }
                if (bContinue && !this.GetCancel()) {
                    this.RemoveDeletions();
                    this.SetPathIndex(0);
                    this.SetPrepDone(true);
                    if (bPostInitTransfer && this.GetFromPathSize() > 0) {
                        this.PostNewTransferEvent();
                    }
                    this.PostEvent(6053, this.clone());
                } else if (!bAlreadyNotified) {
                    this.PostEvent(6054, this);
                }
            } else {
                this.PostEvent(6054, this);
            }
        }
    }

    private void AddAllChildFiles(CPath rFromPath, boolean bIsDownload) {
        if (rFromPath != null && rFromPath.IsDir()) {
            this.TurnOffListUpdates();
            int[] anRet = this.ListPath(rFromPath);
            this.TurnOnListUpdates();
            if (anRet[0] == 200 && anRet[1] == 0) {
                CFile fListed = this.GetListFile();
                if (bIsDownload) {
                    fListed = this.GetSUConnection().GetListDir();
                }
                if (fListed != null) {
                    for (int nIdx2 = 0; nIdx2 < fListed.GetChildFileCount(); ++nIdx2) {
                        CFile fChild = fListed.GetChildFile(nIdx2);
                        if (fChild == null) continue;
                        if (bIsDownload) {
                            this.AddFromPath(fChild);
                        }
                        this.AdjustOverallTotal(fChild);
                        if (!fChild.IsDir()) continue;
                        this.AddAllChildFiles(fChild, bIsDownload);
                    }
                }
            }
        }
    }

    public CSyncTableRow GetSyncTableRow(int nIdx) {
        CSyncTableRow rRow = null;
        if (this.GetSyncData() != null && nIdx > -1 && nIdx < this.GetSyncData().size()) {
            rRow = this.GetSyncData().get(nIdx);
        }
        return rRow;
    }

    @Override
    public String GetTransferFromPath() {
        String sPathFrom = null;
        CSyncTableRow rSyncRow = this.GetSyncTableRow(this.GetPathIndex());
        if (rSyncRow == null) {
            for (int nIdx = this.GetPathIndex(); nIdx >= 0 && rSyncRow == null; --nIdx) {
                rSyncRow = this.GetSyncTableRow(nIdx);
            }
        }
        if (rSyncRow != null) {
            switch (rSyncRow.GetAction()) {
                case UPLOAD: {
                    sPathFrom = rSyncRow.GetLocalRootPath();
                    break;
                }
                case DOWNLOAD: {
                    sPathFrom = rSyncRow.GetRemoteRootPath();
                    break;
                }
                case DELETE: {
                    if (rSyncRow.GetResult() == CSyncTableRow.ROW_RESULT.NOT_ON_LOCAL) {
                        sPathFrom = rSyncRow.GetRemoteRootPath();
                        break;
                    }
                    if (rSyncRow.GetResult() != CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE) break;
                    sPathFrom = rSyncRow.GetLocalRootPath();
                    break;
                }
            }
        }
        return sPathFrom;
    }

    @Override
    public String GetTransferToPath() {
        String sPathTo = null;
        CSyncTableRow rSyncRow = this.GetSyncTableRow(this.GetPathIndex());
        if (rSyncRow == null) {
            for (int nIdx = this.GetPathIndex(); nIdx >= 0 && rSyncRow == null; --nIdx) {
                rSyncRow = this.GetSyncTableRow(nIdx);
            }
        }
        if (rSyncRow != null) {
            switch (rSyncRow.GetAction()) {
                case UPLOAD: {
                    sPathTo = rSyncRow.GetRemoteRootPath();
                    break;
                }
                case DOWNLOAD: {
                    sPathTo = rSyncRow.GetLocalRootPath();
                    break;
                }
                case DELETE: {
                    if (rSyncRow.GetResult() == CSyncTableRow.ROW_RESULT.NOT_ON_LOCAL) {
                        sPathTo = rSyncRow.GetLocalRootPath();
                        break;
                    }
                    if (rSyncRow.GetResult() != CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE) break;
                    sPathTo = rSyncRow.GetRemoteRootPath();
                    break;
                }
            }
        }
        return sPathTo;
    }

    @Override
    public boolean IsDownload() {
        boolean bIsDownload = false;
        CSyncTableRow rSyncRow = this.GetSyncTableRow(this.GetPathIndex());
        if (rSyncRow == null) {
            for (int nIdx = this.GetPathIndex(); nIdx >= 0 && rSyncRow == null; --nIdx) {
                rSyncRow = this.GetSyncTableRow(nIdx);
            }
        }
        if (rSyncRow != null && rSyncRow.GetAction() == CSyncTableRow.ROW_ACTION.DOWNLOAD) {
            bIsDownload = true;
        }
        return bIsDownload;
    }

    @Override
    protected boolean IsOverwritePathAvailable(CPath rToPath) {
        boolean bIsPathAvailable = false;
        if (rToPath != null) {
            bIsPathAvailable = rToPath.IsLocal() ? this.IsLocalPathAvailable(rToPath) : this.IsRemotePathAvailable(rToPath);
        }
        return bIsPathAvailable;
    }

    @Override
    protected boolean Transfer(CPath rFromPath, CPath rToPath) {
        boolean bContinue = false;
        if (this.GetStartTime() <= 0L || this.GetResume()) {
            this.SetStartTime(System.currentTimeMillis());
        }
        if (rFromPath != null && rToPath != null) {
            if (rFromPath.IsLocal()) {
                int[] anRetCodes = this.UploadFile(rFromPath.GetPath(), rFromPath.GetSize(), rToPath.GetPath());
                if (anRetCodes != null && anRetCodes.length == 2) {
                    this.SetHTTPCode(anRetCodes[0]);
                    this.SetSUResult(anRetCodes[1]);
                    if ((anRetCodes[0] == 200 || anRetCodes[0] == 206) && anRetCodes[1] == 0) {
                        bContinue = true;
                    }
                }
            } else {
                int[] anRetCodes = this.DownloadFile(rFromPath.GetPath(), rFromPath.GetSize(), rToPath.GetPath());
                if (anRetCodes != null && anRetCodes.length == 2) {
                    this.SetHTTPCode(anRetCodes[0]);
                    this.SetSUResult(anRetCodes[1]);
                    if ((anRetCodes[0] == 200 || anRetCodes[0] == 206) && anRetCodes[1] == 0) {
                        bContinue = true;
                    }
                }
            }
        }
        return bContinue;
    }

    protected int[] DownloadFile(String sFromPath, long lFromSize, String sToPath) {
        int[] anRetCodes = null;
        if (this.GetSUConnection() != null) {
            long lResumeStartIdx = -1L;
            if (this.CanUsePrevListPath(sToPath)) {
                lResumeStartIdx = this.GetPrevListPathSize();
            }
            anRetCodes = this.GetSUConnection().SendDownload(sFromPath, lFromSize, sToPath, false, 0, 0, lResumeStartIdx);
        }
        return anRetCodes;
    }

    protected int[] UploadFile(String sFromPath, long lFromSize, String sToPath) {
        int[] anRetCodes = null;
        if (this.GetSUConnection() != null) {
            long lResumeStartIdx = -1L;
            if (this.CanUsePrevListPath(sToPath)) {
                lResumeStartIdx = this.GetPrevListPathSize();
            } else if (this.GetApplyToAllOverwrite() && this.GetApplyToAllOverwriteResult() == CRhinoOverwriteDlg.RESULT.OVERWRITE_TARGET) {
                lResumeStartIdx = 0L;
            }
            anRetCodes = this.GetSUConnection().SendUpload(CThreadMsgUploadRemote.GetNewTransferID(), sFromPath, lFromSize, sToPath, lResumeStartIdx);
        }
        return anRetCodes;
    }

    @Override
    protected CFile CreateTargetDir(CPath rPath) {
        CFile fCreatedDir = null;
        if (rPath != null) {
            if (rPath.IsLocal()) {
                this.SetHTTPCode(200);
                File fNewDir = new File(rPath.GetPath());
                if (fNewDir != null) {
                    if (!fNewDir.exists()) {
                        fNewDir = CFileSystemUtils.GetFileSysUtils().CreateAllDirs(fNewDir.getAbsolutePath());
                        if (fNewDir.exists()) {
                            this.SetSUResult(0);
                            fCreatedDir = new CLocalFile(fNewDir);
                        }
                    } else {
                        fCreatedDir = new CLocalFile(fNewDir);
                        this.SetSUResult(0);
                    }
                }
            } else {
                int[] anRet = CThreadMsgCreateDirRemote.CreateDir(this, this.GetSUConnection(), rPath);
                fCreatedDir = this.GetListFile();
            }
        }
        return fCreatedDir;
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir(CThreadMsg rCopyFrom) {
        CThreadMsgCreateDir rMsg = null;
        if (rCopyFrom != null && (rMsg = this.IsDownload() ? new CThreadMsgCreateDirLocal(rCopyFrom.GetThread(), rCopyFrom.GetSource(), rCopyFrom.GetClientInfo(), rCopyFrom.GetCompressionType(), false) : new CThreadMsgCreateDirRemote(rCopyFrom.GetThread(), rCopyFrom.GetSource(), rCopyFrom.GetClientInfo(), rCopyFrom.GetCompressionType(), false)) != null && rCopyFrom instanceof CThreadMsgPaths) {
            CThreadMsgPaths rMsgPaths = (CThreadMsgPaths)rCopyFrom;
            CPath rToPath = rMsgPaths.GetFromPath(rMsgPaths.GetPathIndex());
            rMsg.SetToPath(0, rToPath);
        }
        return rMsg;
    }

    @Override
    protected boolean GetDefConfirmOverwrite() {
        return true;
    }

    @Override
    protected CPath GetDelPath(boolean bIsFromPath) {
        CPath rDelPath = this.GetDeletionPath(this.GetSyncTableRow(this.GetPathIndex()));
        return rDelPath;
    }

    @Override
    public void OnDeleteConfirmed() {
        this.SetResume(false);
        super.OnDeleteConfirmed();
    }

    @Override
    protected boolean GetDefConfirmDelete() {
        return true;
    }

    private CPath GetDeletionPath(CSyncTableRow rSyncRow) {
        CPath rDelPath = null;
        if (rSyncRow != null) {
            if (rSyncRow.GetResult() == CSyncTableRow.ROW_RESULT.NOT_ON_LOCAL) {
                if (rSyncRow.GetRemoteFile() != null) {
                    rDelPath = rSyncRow.GetRemoteFile().CreatePath();
                }
            } else if (rSyncRow.GetResult() == CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE && rSyncRow.GetLocalFile() != null) {
                rDelPath = rSyncRow.GetLocalFile().CreatePath();
            }
        }
        return rDelPath;
    }

    @Override
    protected JFrame GetDeleteFrame() {
        JFrame rFrame = null;
        if (CMainFrame.GET_APP() != null) {
            rFrame = CMainFrame.GET_APP().GetSourceFrame(this.GetSource());
        }
        if (rFrame == null) {
            rFrame = super.GetDeleteFrame();
        }
        return rFrame;
    }

    @Override
    protected boolean GetShowConfirmDeleteSkipBtn() {
        boolean bShowSkipBtn = true;
        return bShowSkipBtn;
    }

    @Override
    protected boolean GetShowConfirmDeleteApplyToAllBtn() {
        return true;
    }

    private void RemoveDeletions() {
        if (this.GetSyncData() != null) {
            Iterator<CSyncTableRow> itr = this.GetSyncData().iterator();
            while (itr.hasNext()) {
                CSyncTableRow rSyncRow = itr.next();
                if (rSyncRow == null) continue;
                switch (rSyncRow.GetAction()) {
                    case DELETE: {
                        itr.remove();
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected void PostNewTransferEvent() {
        CTransferRowSyncFolders rNewRow = new CTransferRowSyncFolders(new CThreadMsgSyncFoldersExecute(this), this);
        this.PostEvent(6051, rNewRow);
        this.PostEvent(2902, this.clone());
    }

    public void OnFailedToPrepareTransfer() {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null) {
            long lThreadID = this.GetThread().getId();
            CConfirmTransferFailedDlg dlg = new CConfirmTransferFailedDlg(this.GetDeleteFrame(), true, lThreadID, 2, 0);
            dlg.setMinimumSize(new Dimension(380, 150));
            dlg.setMaximumSize(new Dimension(380, 150));
            dlg.setTitle(CString.LoadString("IDS_SYNC_FOLDERS_PREP_ERROR_TITLE"));
            String sMsg = CString.LoadString("IDS_SYNC_FOLDERS_PREP_ERROR_DEF_MSG");
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            String sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
            sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    @Override
    protected boolean IsTargetLocal(int nPathIdx) {
        boolean bIsTargetLocal = super.IsTargetLocal(nPathIdx);
        CSyncTableRow rSyncRow = this.GetSyncTableRow(nPathIdx);
        if (rSyncRow == null) {
            for (int nIdx = nPathIdx; nIdx >= 0 && rSyncRow == null; --nIdx) {
                rSyncRow = this.GetSyncTableRow(nIdx);
            }
        }
        if (rSyncRow != null && rSyncRow.GetAction() == CSyncTableRow.ROW_ACTION.UPLOAD) {
            bIsTargetLocal = false;
        }
        return bIsTargetLocal;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SYNC_FOLDERS = false;
    }
}

