/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.files.WindowsLink.CWindowsLink;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmTransferFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgListRemote;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;

public class CThreadMsgSyncFoldersCompare
extends CThreadMsgListRemote {
    public static boolean DEBUG_COMPARE;
    private CPath m_rLocalPath;
    private CPath m_rRemotePath;
    private boolean m_bIsRecvItemDone;
    private boolean m_bCompareSize = true;
    private boolean m_bCompareDateModified = true;
    private boolean m_bIncludeDeletions = true;
    private boolean m_bIncludeSubFolders = true;
    private Object m_Crit;
    private boolean m_bConfirmingDuplicates;
    private boolean m_bApplyToAllDuplicates;
    private MULTIPLE_LOCAL_FILE_ACTION m_nActionForMultipleLocalFiles;
    private volatile boolean m_bSuppressError = false;

    public CThreadMsgSyncFoldersCompare(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 40, rSource, rClientInfo, nCompressionType);
        this.InitVars();
    }

    protected CThreadMsgSyncFoldersCompare(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgSyncFoldersCompare) {
            this.Copy((CThreadMsgSyncFoldersCompare)rCopyFrom, false);
        }
    }

    private void InitVars() {
        this.m_bIsRecvItemDone = false;
        this.m_Crit = new Object();
        this.m_bConfirmingDuplicates = false;
        this.m_bApplyToAllDuplicates = false;
        this.m_nActionForMultipleLocalFiles = MULTIPLE_LOCAL_FILE_ACTION.RENAME;
    }

    public boolean Copy(CThreadMsgSyncFoldersCompare rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null && bCallSuper) {
            if (super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetLocalPath(rCopyFrom.GetLocalPath())) {
                bChanged = true;
            }
            if (this.SetRemotePath(rCopyFrom.GetRemotePath())) {
                bChanged = true;
            }
            if (this.SetIsRecvItemDone(rCopyFrom.IsRecvItemDone())) {
                bChanged = true;
            }
            if (this.SetCompareSize(rCopyFrom.GetCompareSize())) {
                bChanged = true;
            }
            if (this.SetCompareDateModified(rCopyFrom.GetCompareDateModified())) {
                bChanged = true;
            }
            if (this.SetIncludeDeletions(rCopyFrom.GetIncludeDeletions())) {
                bChanged = true;
            }
            if (this.SetIncludeSubFolders(rCopyFrom.GetIncludeSubFolders())) {
                bChanged = true;
            }
            if (this.SetApplyToAllDuplicates(rCopyFrom.GetApplyToAllDuplicates())) {
                bChanged = true;
            }
            if (this.SetActionForMultipleLocalFile(rCopyFrom.GetActionForMultipleLocalFile())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgSyncFoldersCompare(this);
    }

    @Override
    public void ProcessEvent() {
        this.OnCompare();
    }

    @Override
    protected void ProcessError() {
        switch (this.GetErrorID()) {
            case 110: {
                this.OnFailedToCompareSyncFolders();
                break;
            }
            default: {
                super.ProcessError();
            }
        }
    }

    public boolean SetLocalPath(CPath rLocalPath) {
        boolean bChanged = false;
        if (this.m_rLocalPath != rLocalPath) {
            this.m_rLocalPath = rLocalPath;
            bChanged = true;
        }
        return bChanged;
    }

    protected CPath GetLocalPath() {
        return this.m_rLocalPath;
    }

    public boolean SetRemotePath(CPath rRemotePath) {
        boolean bChanged = false;
        if (this.m_rRemotePath != rRemotePath) {
            this.m_rRemotePath = rRemotePath;
            bChanged = true;
        }
        return bChanged;
    }

    public CPath GetRemotePath() {
        return this.m_rRemotePath;
    }

    private boolean IsSuccessfulList(int[] anRetCodes) {
        boolean bIsSuccessful = false;
        if (anRetCodes != null && anRetCodes.length == 2 && anRetCodes[0] == 200 && anRetCodes[1] == 0) {
            bIsSuccessful = true;
        }
        return bIsSuccessful;
    }

    private void OnCompare() {
        if (this.GetLocalPath() != null && this.GetRemotePath() != null) {
            this.CompareDirectories(this.GetLocalPath().GetPath(), this.GetRemotePath().GetPath(), this.GetCompareSize(), this.GetCompareDateModified(), this.GetIncludeSubFolders(), this.GetIncludeDeletions());
        } else if (DEBUG_COMPARE) {
            System.out.println("ASSERT:  Local or Remote path is NULL");
        }
        if (!this.GetCancel()) {
            this.PostEvent(3021, this.clone());
            this.PostEvent(3022, this);
        } else {
            if (DEBUG_COMPARE) {
                System.out.println("CThreadMsgSyncFoldersCompare.OnCompare | Cancelled");
            }
            this.PostEvent(3020, this);
        }
    }

    @Override
    public CBaseThread GetThread() {
        return (CBaseThread)super.GetThread();
    }

    @Override
    public int GetPathIndex() {
        int nIndex = super.GetPathIndex();
        if (this.GetThread() != null) {
            nIndex = this.GetThread().GetPathIndex();
        }
        return nIndex;
    }

    @Override
    public boolean SetPathIndex(int nIdx) {
        boolean bChanged = super.SetPathIndex(nIdx);
        if (this.GetThread() != null) {
            bChanged = this.GetThread().SetPathIndex(nIdx);
        }
        return bChanged;
    }

    public boolean IsRecvItemDone() {
        return this.m_bIsRecvItemDone;
    }

    public boolean SetIsRecvItemDone(boolean bIsRecvItemDone) {
        boolean bChanged = false;
        if (this.m_bIsRecvItemDone != bIsRecvItemDone) {
            bChanged = true;
            this.m_bIsRecvItemDone = bIsRecvItemDone;
        }
        return bChanged;
    }

    @Override
    public boolean GetCancel() {
        boolean bCancel = super.GetCancel();
        if (this.GetThread() != null) {
            bCancel = this.GetThread().GetCancel();
        }
        return bCancel;
    }

    public boolean GetCompareSize() {
        return this.m_bCompareSize;
    }

    public boolean SetCompareSize(boolean bCompareSize) {
        boolean bChanged = false;
        if (this.m_bCompareSize != bCompareSize) {
            this.m_bCompareSize = bCompareSize;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean GetCompareDateModified() {
        return this.m_bCompareDateModified;
    }

    public boolean SetCompareDateModified(boolean bCompareDateModified) {
        boolean bChanged = false;
        if (this.m_bCompareDateModified != bCompareDateModified) {
            this.m_bCompareDateModified = bCompareDateModified;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean GetIncludeDeletions() {
        return this.m_bIncludeDeletions;
    }

    public boolean SetIncludeDeletions(boolean bIncludeDeletions) {
        boolean bChanged = false;
        if (this.m_bIncludeDeletions != bIncludeDeletions) {
            this.m_bIncludeDeletions = bIncludeDeletions;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean GetIncludeSubFolders() {
        return this.m_bIncludeSubFolders;
    }

    public boolean SetIncludeSubFolders(boolean bIncludeSubFolders) {
        boolean bChanged = false;
        if (this.m_bIncludeSubFolders != bIncludeSubFolders) {
            this.m_bIncludeSubFolders = bIncludeSubFolders;
            bChanged = true;
        }
        return bChanged;
    }

    private Vector<File> GetLocalFile(String sFileName, Vector<File> arLocalFiles, boolean bIgnoreCase) {
        Vector<File> afLocalMatches = new Vector<File>();
        if (sFileName != null && !sFileName.isEmpty() && arLocalFiles != null) {
            if (bIgnoreCase) {
                sFileName = sFileName.toLowerCase();
            }
            Iterator<File> itr = arLocalFiles.iterator();
            while (itr.hasNext() && !this.GetCancel()) {
                CWindowsLink link;
                String sResolvedPath;
                String sAbsPath;
                String sNextName;
                File fNext = itr.next();
                if (fNext == null || !fNext.exists() || (sNextName = CString.GetFileName(sAbsPath = fNext.getAbsolutePath())) == null || sNextName.isEmpty()) continue;
                if (sAbsPath.endsWith("lnk") && (sResolvedPath = (link = new CWindowsLink(sAbsPath)).GetResolvedPath()) != null && !sResolvedPath.isEmpty()) {
                    sNextName = CString.GetFileName(sResolvedPath);
                }
                if (bIgnoreCase) {
                    sNextName = sNextName.toLowerCase();
                }
                if (!sFileName.equals(sNextName)) continue;
                afLocalMatches.add(fNext);
            }
        }
        return afLocalMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void PauseToConfirmDuplicates() {
        if (!this.GetCancel()) {
            Object object = this.m_Crit;
            synchronized (object) {
                block7: {
                    this.m_bConfirmingDuplicates = true;
                    try {
                        while (this.m_bConfirmingDuplicates) {
                            this.m_Crit.wait();
                            if (!DEBUG_COMPARE) continue;
                            System.out.println("Resuming thread.");
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG_COMPARE) break block7;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ResumeFromConfirmDuplicates() {
        Object object = this.m_Crit;
        synchronized (object) {
            this.m_bConfirmingDuplicates = false;
            this.m_Crit.notify();
        }
    }

    public boolean GetApplyToAllDuplicates() {
        return this.m_bApplyToAllDuplicates;
    }

    public boolean SetApplyToAllDuplicates(boolean bApplyToAllDuplicates) {
        boolean bChanged = false;
        if (this.m_bApplyToAllDuplicates != bApplyToAllDuplicates) {
            this.m_bApplyToAllDuplicates = bApplyToAllDuplicates;
            bChanged = true;
        }
        return bChanged;
    }

    public MULTIPLE_LOCAL_FILE_ACTION GetActionForMultipleLocalFile() {
        return this.m_nActionForMultipleLocalFiles;
    }

    public boolean SetActionForMultipleLocalFile(MULTIPLE_LOCAL_FILE_ACTION nActionForMultipleLocalFile) {
        boolean bChanged = false;
        if (this.m_nActionForMultipleLocalFiles != nActionForMultipleLocalFile) {
            this.m_nActionForMultipleLocalFiles = nActionForMultipleLocalFile;
            bChanged = true;
        }
        return bChanged;
    }

    private boolean CompareFiles(File fLocalFile, CFile fRemoteFile, boolean bCompareSize, boolean bCompareDateModified, boolean bIncludeSubDirs, boolean bIncludeDeletions) {
        boolean bContinue = true;
        CSyncTableRow.ROW_ACTION rLocalAction = CSyncTableRow.ROW_ACTION.EXCLUDE;
        CSyncTableRow.ROW_RESULT rLocalResult = CSyncTableRow.ROW_RESULT.EXCLUDE;
        CSyncTableRow.ROW_ACTION rRemoteAction = CSyncTableRow.ROW_ACTION.EXCLUDE;
        CSyncTableRow.ROW_RESULT rRemoteResult = CSyncTableRow.ROW_RESULT.EXCLUDE;
        CLocalFile rNewLocalFile = null;
        if (fLocalFile != null) {
            rNewLocalFile = new CLocalFile(fLocalFile);
        }
        if (rNewLocalFile == null) {
            rLocalAction = CSyncTableRow.ROW_ACTION.DOWNLOAD;
            rLocalResult = CSyncTableRow.ROW_RESULT.NOT_ON_LOCAL;
            rRemoteAction = CSyncTableRow.ROW_ACTION.DELETE;
            rRemoteResult = CSyncTableRow.ROW_RESULT.NOT_ON_LOCAL;
        } else if (fRemoteFile == null) {
            rLocalAction = CSyncTableRow.ROW_ACTION.DOWNLOAD;
            rLocalResult = CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE;
            rRemoteAction = CSyncTableRow.ROW_ACTION.DELETE;
            rRemoteResult = CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE;
        } else {
            if (bCompareSize) {
                if (rNewLocalFile.GetSize(true) < fRemoteFile.GetSize()) {
                    rLocalAction = CSyncTableRow.ROW_ACTION.DOWNLOAD;
                    rLocalResult = CSyncTableRow.ROW_RESULT.SMALLER;
                    rRemoteAction = CSyncTableRow.ROW_ACTION.UPLOAD;
                    rRemoteResult = CSyncTableRow.ROW_RESULT.LARGER;
                } else if (rNewLocalFile.GetSize(true) > fRemoteFile.GetSize()) {
                    rLocalAction = CSyncTableRow.ROW_ACTION.DOWNLOAD;
                    rLocalResult = CSyncTableRow.ROW_RESULT.LARGER;
                    rRemoteAction = CSyncTableRow.ROW_ACTION.UPLOAD;
                    rRemoteResult = CSyncTableRow.ROW_RESULT.SMALLER;
                }
            }
            if (bCompareDateModified) {
                Date dtLocal = rNewLocalFile.GetModifiedDate(true);
                Date dtRemote = fRemoteFile.GetModifiedDate();
                if (dtLocal != null && dtRemote != null) {
                    long lRemoteNumOfSecsFromEpoch;
                    long lLocalNumOfSecsFromEpoch = CUtils.ConvertDateToTimeT(dtLocal.getTime());
                    if (lLocalNumOfSecsFromEpoch < (lRemoteNumOfSecsFromEpoch = CUtils.ConvertDateToTimeT(dtRemote.getTime()))) {
                        rLocalAction = CSyncTableRow.ROW_ACTION.DOWNLOAD;
                        rLocalResult = CSyncTableRow.ROW_RESULT.OLDER;
                        rRemoteAction = CSyncTableRow.ROW_ACTION.UPLOAD;
                        rRemoteResult = CSyncTableRow.ROW_RESULT.NEWER;
                    } else if (lLocalNumOfSecsFromEpoch > lRemoteNumOfSecsFromEpoch) {
                        rLocalAction = CSyncTableRow.ROW_ACTION.DOWNLOAD;
                        rLocalResult = CSyncTableRow.ROW_RESULT.NEWER;
                        rRemoteAction = CSyncTableRow.ROW_ACTION.UPLOAD;
                        rRemoteResult = CSyncTableRow.ROW_RESULT.OLDER;
                    }
                } else {
                    if (DEBUG_COMPARE) {
                        System.out.println("ASSERT:  Remote file LastModifiedDate is NULL");
                    }
                    bContinue = false;
                }
            }
        }
        if (rLocalAction != CSyncTableRow.ROW_ACTION.EXCLUDE && rLocalResult != CSyncTableRow.ROW_RESULT.EXCLUDE && rRemoteAction != CSyncTableRow.ROW_ACTION.EXCLUDE && rRemoteResult != CSyncTableRow.ROW_RESULT.EXCLUDE) {
            boolean bCanShowDirs = true;
            if (!bIncludeSubDirs && (rNewLocalFile != null && rNewLocalFile.IsDirectory() || fRemoteFile != null && fRemoteFile.IsDirectory())) {
                bCanShowDirs = false;
            }
            if (bCanShowDirs && (rLocalAction != CSyncTableRow.ROW_ACTION.DELETE || bIncludeDeletions)) {
                CSyncTableRow LocalRow = this.CreateSyncTableRow(rNewLocalFile, fRemoteFile, this.FormatName(rNewLocalFile, fRemoteFile, true), rLocalAction, rLocalResult);
                this.PostEvent(9601, LocalRow);
            }
            if (bCanShowDirs && (rRemoteAction != CSyncTableRow.ROW_ACTION.DELETE || bIncludeDeletions)) {
                CSyncTableRow RemoteRow = this.CreateSyncTableRow(rNewLocalFile, fRemoteFile, this.FormatName(rNewLocalFile, fRemoteFile, false), rRemoteAction, rRemoteResult);
                this.PostEvent(9602, RemoteRow);
            }
        } else if (DEBUG_COMPARE) {
            System.out.println("We're excluding the files from synchronize operation, so don't update the GUI.");
        }
        return bContinue;
    }

    private boolean CompareDirectories(String sLocalPath, String sRemotePath, boolean bCompareSize, boolean bCompareDateModified, boolean bIncludeSubDirs, boolean bIncludeDeletions) {
        boolean bContinue = true;
        if (sLocalPath != null && !sLocalPath.isEmpty() && sRemotePath != null && !sRemotePath.isEmpty()) {
            File fLocalDir = new File(sLocalPath);
            boolean bLocalExists = fLocalDir != null && fLocalDir.exists();
            boolean bRemoteExists = false;
            CRemoteFile fRemoteDir = null;
            boolean bSuccessfulList = false;
            if (this.GetSUConnection() != null) {
                int[] anRetCodesRemote = this.GetSUConnection().SendListDir(sRemotePath);
                bSuccessfulList = this.IsSuccessfulList(anRetCodesRemote);
                if (bSuccessfulList) {
                    fRemoteDir = this.GetSUConnection().GetListDir();
                    bRemoteExists = fRemoteDir != null;
                } else if (anRetCodesRemote[1] == 6) {
                    bSuccessfulList = true;
                }
            }
            if (bLocalExists && bRemoteExists) {
                int nIdx;
                if (DEBUG_COMPARE) {
                    System.out.printf("Local (%s) and Remote (%s) exist\r\n", fLocalDir.getAbsolutePath(), fRemoteDir.GetPath());
                }
                Vector<File> afLocalFiles = new Vector<File>();
                Vector<CFile> afRemoteFiles = new Vector<CFile>();
                File[] afTemp = fLocalDir.listFiles();
                if (afTemp.length > 0) {
                    afLocalFiles.setSize(afTemp.length);
                    for (nIdx = 0; nIdx < afTemp.length; ++nIdx) {
                        File fLocalFile = afTemp[nIdx];
                        afLocalFiles.set(nIdx, fLocalFile);
                    }
                }
                if (fRemoteDir.GetChildFileCount() > 0) {
                    afRemoteFiles.setSize(fRemoteDir.GetChildFileCount());
                    for (nIdx = 0; nIdx < fRemoteDir.GetChildFileCount(); ++nIdx) {
                        afRemoteFiles.set(nIdx, fRemoteDir.GetChildFile(nIdx));
                    }
                }
                if (afRemoteFiles != null && afLocalFiles != null) {
                    Iterator itr = afRemoteFiles.iterator();
                    while (itr.hasNext() && !this.GetCancel() && bContinue) {
                        Vector<File> afLocalMatches;
                        CFile fRemoteFile = (CFile)itr.next();
                        if (fRemoteFile == null) continue;
                        String sFileName = CString.GetFileName(fRemoteFile.GetPath());
                        boolean bIgnoreCase = false;
                        if (CFileSystemUtils.GetFileSysUtils() != null) {
                            bIgnoreCase = CFileSystemUtils.GetFileSysUtils().IsWindows();
                        }
                        if ((afLocalMatches = this.GetLocalFile(sFileName, afLocalFiles, bIgnoreCase)) != null && afLocalMatches.size() > 0) {
                            if (DEBUG_COMPARE) {
                                System.out.printf("Found %d LOCAL matches for %s\r\n", afLocalMatches.size(), sFileName);
                            }
                            if (afLocalMatches.size() > 1 && !this.GetApplyToAllDuplicates()) {
                                this.PostEvent(9600, this);
                                this.PauseToConfirmDuplicates();
                            }
                            Iterator<File> itrLocal = afLocalMatches.iterator();
                            while (itrLocal.hasNext() && !this.GetCancel() && bContinue) {
                                File fNext = itrLocal.next();
                                if (fNext != null && fNext.exists()) {
                                    if (fNext.isDirectory() && fRemoteFile.IsDirectory()) {
                                        if (DEBUG_COMPARE) {
                                            System.out.printf("CompareDirectories:  %s - %s\r\n", fNext.getAbsolutePath(), fRemoteFile.GetPath());
                                        }
                                        if (bIncludeSubDirs) {
                                            bContinue = this.CompareDirectories(fNext.getAbsolutePath(), fRemoteFile.GetPath(), bCompareSize, bCompareDateModified, bIncludeSubDirs, bIncludeDeletions);
                                        }
                                    } else {
                                        if (DEBUG_COMPARE) {
                                            System.out.printf("CompareFiles:  %s - %s\r\n", fNext.getAbsolutePath(), fRemoteFile.GetPath());
                                        }
                                        bContinue = this.CompareFiles(fNext, fRemoteFile, bCompareSize, bCompareDateModified, bIncludeSubDirs, bIncludeDeletions);
                                    }
                                    afLocalFiles.remove(fNext);
                                    continue;
                                }
                                if (!DEBUG_COMPARE) continue;
                                System.out.println("ASSERT:  Local file no longer exists?");
                            }
                        } else {
                            if (DEBUG_COMPARE) {
                                System.out.printf("No LOCAL match was found for %s\r\n", sFileName);
                            }
                            this.CompareFiles(null, fRemoteFile, bCompareSize, bCompareDateModified, bIncludeSubDirs, bIncludeDeletions);
                        }
                        itr.remove();
                    }
                    Iterator itrLocal = afLocalFiles.iterator();
                    while (itrLocal.hasNext() && !this.GetCancel() && bContinue) {
                        File fLocal = (File)itrLocal.next();
                        if (fLocal == null || !fLocal.exists() || fLocal.isDirectory() && !bIncludeSubDirs) continue;
                        CLocalFile fNewLocal = new CLocalFile(fLocal);
                        if (bIncludeDeletions) {
                            CSyncTableRow LocalRow = this.CreateSyncTableRow(fNewLocal, null, this.FormatName(fNewLocal, null, true), CSyncTableRow.ROW_ACTION.DELETE, CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE);
                            this.PostEvent(9601, LocalRow);
                        }
                        CSyncTableRow RemoteRow = this.CreateSyncTableRow(fNewLocal, null, this.FormatName(fNewLocal, null, false), CSyncTableRow.ROW_ACTION.UPLOAD, CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE);
                        this.PostEvent(9602, RemoteRow);
                    }
                } else {
                    if (DEBUG_COMPARE) {
                        System.out.println("ASSERT:  We should never get here if both directories exist!");
                    }
                    this.SetErrorID(110);
                    this.PostEvent(3005, 30);
                    bContinue = false;
                }
            } else if (bIncludeSubDirs) {
                CLocalFile fNewLocal = new CLocalFile(fLocalDir);
                if (!bLocalExists) {
                    if (DEBUG_COMPARE) {
                        System.out.printf("Local (%s) does not exist\r\n", fLocalDir != null ? fLocalDir.getAbsolutePath() : "null");
                    }
                    CSyncTableRow LocalRow = this.CreateSyncTableRow(fNewLocal, fRemoteDir, this.FormatName(fNewLocal, fRemoteDir, true), CSyncTableRow.ROW_ACTION.DOWNLOAD, CSyncTableRow.ROW_RESULT.NOT_ON_LOCAL);
                    this.PostEvent(9601, LocalRow);
                    if (bIncludeDeletions) {
                        CSyncTableRow RemoteRow = this.CreateSyncTableRow(fNewLocal, fRemoteDir, this.FormatName(fNewLocal, fRemoteDir, false), CSyncTableRow.ROW_ACTION.DELETE, CSyncTableRow.ROW_RESULT.NOT_ON_LOCAL);
                        this.PostEvent(9602, RemoteRow);
                    }
                } else if (!bRemoteExists) {
                    if (DEBUG_COMPARE) {
                        System.out.printf("Remote (%s) does not exist\r\n", fRemoteDir != null ? fRemoteDir.GetPath() : "null");
                    }
                    if (bSuccessfulList) {
                        if (bIncludeDeletions) {
                            CSyncTableRow LocalRow = this.CreateSyncTableRow(fNewLocal, fRemoteDir, this.FormatName(fNewLocal, fRemoteDir, true), CSyncTableRow.ROW_ACTION.DELETE, CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE);
                            this.PostEvent(9601, LocalRow);
                        }
                        CSyncTableRow RemoteRow = this.CreateSyncTableRow(fNewLocal, fRemoteDir, this.FormatName(fNewLocal, fRemoteDir, false), CSyncTableRow.ROW_ACTION.UPLOAD, CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE);
                        this.PostEvent(9602, RemoteRow);
                    } else {
                        if (DEBUG_COMPARE) {
                            System.out.println("Could not determine Remote listing");
                        }
                        this.SetErrorID(110);
                        this.PostEvent(3005, this.clone());
                        bContinue = false;
                    }
                }
            }
        } else {
            if (DEBUG_COMPARE) {
                System.out.println("Local or Remote path is invalid");
            }
            this.SetErrorID(110);
            this.PostEvent(3005, this.clone());
            bContinue = false;
        }
        if (!bContinue && this.GetSuppressError()) {
            this.SetErrorID(0);
        }
        return bContinue;
    }

    private String GetRelativePath(String sRootPath, String sFilePath) {
        String sName = "";
        if (sFilePath != null && !sFilePath.isEmpty()) {
            sName = CString.GetFileName(sFilePath);
            if (sRootPath != null && !sRootPath.isEmpty() && (sName = CString.GetRelativePath(sRootPath, sFilePath)) != null && sName.lastIndexOf(47) < 1) {
                sName = CString.EnsureFirstCharIsNotAForwardSlash(sName);
            }
        }
        if (sName != null && sName.length() > 1) {
            sName = CString.EnsureLastCharIsNotAForwardSlash(sName);
        }
        return sName;
    }

    private String FormatName(CFile rLocalPath, CFile rRemotePath, boolean bIsLocal) {
        String sDisplayName;
        String sRootPath = "";
        String sFilePath = "";
        if (rLocalPath != null && rRemotePath != null) {
            if (bIsLocal) {
                if (this.GetRemotePath() != null) {
                    sRootPath = this.GetRemotePath().GetPath();
                }
                sFilePath = rRemotePath.GetPath();
            } else {
                if (this.GetLocalPath() != null) {
                    sRootPath = this.GetLocalPath().GetPath();
                }
                sFilePath = rLocalPath.GetPath();
            }
        } else if (rLocalPath != null) {
            if (this.GetLocalPath() != null) {
                sRootPath = this.GetLocalPath().GetPath();
            }
            sFilePath = rLocalPath.GetPath();
        } else if (rRemotePath != null) {
            if (this.GetRemotePath() != null) {
                sRootPath = this.GetRemotePath().GetPath();
            }
            sFilePath = rRemotePath.GetPath();
        }
        String sName = this.GetRelativePath(sRootPath, sFilePath);
        if (rLocalPath != null && rLocalPath.IsLink() && (sDisplayName = rLocalPath.GetDisplayName()) != null && !sDisplayName.isEmpty()) {
            if (sName.indexOf("/") >= 0) {
                sName = CString.GetFilePath(sName, true);
                sName = sName + sDisplayName;
            } else {
                sName = sDisplayName;
            }
        }
        return sName;
    }

    private CSyncTableRow CreateSyncTableRow(CFile rLocalFile, CFile rRemoteFile, String sName, CSyncTableRow.ROW_ACTION nAction, CSyncTableRow.ROW_RESULT nResult) {
        CSyncTableRow SyncTableRow = new CSyncTableRow();
        if (this.GetLocalPath() != null) {
            SyncTableRow.SetLocalRootPath(this.GetLocalPath().GetPath());
        }
        if (this.GetRemotePath() != null) {
            SyncTableRow.SetRemoteRootPath(this.GetRemotePath().GetPath());
        }
        SyncTableRow.SetLocalFile(rLocalFile);
        SyncTableRow.SetRemoteFile(rRemoteFile);
        SyncTableRow.SetFileName(sName);
        SyncTableRow.SetAction(nAction);
        SyncTableRow.SetResult(nResult);
        return SyncTableRow;
    }

    protected void OnFailedToCompareSyncFolders() {
        if (this.GetLocalPath() != null && this.GetRemotePath() != null && !this.GetSuppressError()) {
            CPath rLocalPath = this.GetLocalPath();
            CPath rRemotePath = this.GetRemotePath();
            if (CMainFrame.GET_APP() != null && this.GetThread() != null) {
                String sDetails;
                long lThreadID = this.GetThread().getId();
                CConfirmTransferFailedDlg dlg = new CConfirmTransferFailedDlg(this.GetDeleteFrame(), true, lThreadID, 2, 0);
                dlg.setTitle(CString.LoadString("IDS_SYNC_FOLDERS_COMPARE_ERROR_TITLE"));
                String sMsg = CString.LoadString("IDS_SYNC_FOLDERS_COMPARE_ERROR_DEF_MSG");
                if (rLocalPath != null && rRemotePath != null) {
                    sMsg = String.format(CString.LoadString("IDS_SYNC_FOLDERS_COMPARE_ERROR_FMT_MSG"), rLocalPath.GetPath(), rRemotePath.GetPath());
                }
                if (this.GetSUResult() == 3) {
                    sMsg = String.format("%s\r\n\r\n%s", sMsg, CString.LoadString("IDS_SYNC_FOLDERS_COMPARE_ERROR_FMT_MSG_PERM_DENIED"));
                }
                dlg.SetMainMsg(sMsg);
                String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
                dlg.SetBtnMsg(sBtnMsg);
                if (rLocalPath.IsLocal() && rRemotePath.IsLocal()) {
                    sDetails = String.format("%s\r\n\r\n%s", CThreadMsgSyncFoldersCompare.GetSUError(this.GetSUResult()), CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
                } else {
                    sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
                    sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
                }
                dlg.SetDetailMsg(sDetails);
                dlg.setVisible(true);
                switch (dlg.GetExitCode()) {
                    case 0: {
                        this.OnRetry();
                        break;
                    }
                    default: {
                        this.OnCancel(true);
                    }
                }
            }
        }
    }

    @Override
    protected JFrame GetDeleteFrame() {
        JFrame rFrame = null;
        if (CMainFrame.GET_APP() != null) {
            rFrame = CMainFrame.GET_APP().GetSourceFrame(this.GetSource());
        }
        if (rFrame == null) {
            rFrame = super.GetDeleteFrame();
        }
        return rFrame;
    }

    public void SetSuppressError(boolean bSuppressError) {
        this.m_bSuppressError = bSuppressError;
    }

    public boolean GetSuppressError() {
        return this.m_bSuppressError;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_COMPARE = false;
    }

    public static enum MULTIPLE_LOCAL_FILE_ACTION {
        EXCLUDE,
        RENAME;

    }
}

