/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmNoopFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.awt.Frame;

public class CThreadMsgNoop
extends CThreadMsg {
    private boolean m_bCheckingCommunication;

    public CThreadMsgNoop(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType, boolean bCheckingCommunication) {
        super(tThread, 30, rSource, rClientInfo, nCompressionType);
        this.InitVars(bCheckingCommunication);
    }

    protected CThreadMsgNoop(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgNoop) {
            this.Copy((CThreadMsgNoop)rCopyFrom, false);
        }
    }

    private void InitVars(boolean bCheckingCommunication) {
        this.m_bCheckingCommunication = bCheckingCommunication;
    }

    public boolean Copy(CThreadMsgNoop rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetCheckingCommunication(rCopyFrom.IsCheckingCommunication())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgNoop(this);
    }

    @Override
    public void ProcessEvent() {
        this.OnNoop();
    }

    private void OnNoop() {
        boolean bContinue = true;
        this.SetErrorID(0);
        this.SetHTTPCode(503);
        this.SetSUResult(1);
        if (this.GetSUConnection() != null) {
            int[] anRetCodes = this.GetSUConnection().SendNoop();
            if (anRetCodes != null && anRetCodes.length == 2) {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUResult(anRetCodes[1]);
            }
            if (this.GetHTTPCode() == 200 && this.GetSUResult() == 0) {
                this.PostEvent(3021, this.clone());
            } else {
                this.SetErrorID(100);
                this.PostEvent(3005, this);
                bContinue = false;
            }
        }
    }

    @Override
    public void OnError() {
        switch (this.GetErrorID()) {
            case 100: {
                this.OnConfirmNoopError();
                break;
            }
            default: {
                if (!DEBUG) break;
                System.out.println("Unhandled error | CThreadMsgNoop.OnError");
            }
        }
    }

    private void OnConfirmNoopError() {
        if (this.IsCheckingCommunication()) {
            long lThreadID = -1L;
            if (this.GetThread() != null) {
                lThreadID = this.GetThread().getId();
            }
            CConfirmNoopFailedDlg dlg = new CConfirmNoopFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = String.format(CString.LoadString("IDS_CONFIRM_NOOP_FAILED_CONNECTION_FMT_MSG"), "FTP Voyager JV");
            dlg.SetMainMsg(sMsg);
            dlg.setVisible(true);
            int nRc = dlg.GetExitCode();
            switch (nRc) {
                case 0: {
                    break;
                }
                default: {
                    if (CMainFrame.GET_APP() == null) break;
                    CMainFrame.GET_APP().IncFailedToListInitialHomeDir();
                }
            }
        }
    }

    public boolean SetCheckingCommunication(boolean bCheckingCommunication) {
        boolean bChanged = false;
        if (this.m_bCheckingCommunication != bCheckingCommunication) {
            this.m_bCheckingCommunication = bCheckingCommunication;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsCheckingCommunication() {
        return this.m_bCheckingCommunication;
    }
}

