/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.threads.CWorkerThread;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmLogoutFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.awt.Frame;

public class CThreadMsgLogout
extends CThreadMsg {
    public CThreadMsgLogout(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 31, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgLogout(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgLogout) {
            this.Copy((CThreadMsgLogout)rCopyFrom, false);
        }
    }

    public boolean Copy(CThreadMsgLogout rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null && bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
            bChanged = true;
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgLogout(this);
    }

    @Override
    public void ProcessEvent() {
        this.OnLogout();
    }

    private void OnLogout() {
        boolean bContinue = true;
        this.SetErrorID(0);
        this.SetHTTPCode(503);
        this.SetSUResult(1);
        if (this.GetSUConnection() != null) {
            int[] anRetCodes = this.GetSUConnection().SendLogout();
            if (anRetCodes != null && anRetCodes.length == 2) {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUResult(anRetCodes[1]);
            }
            if (this.GetHTTPCode() == 200 && this.GetSUResult() == 0) {
                this.PostEvent(3021, this.clone());
            } else {
                this.SetErrorID(90);
                this.PostEvent(3005, this);
                bContinue = false;
            }
        }
    }

    @Override
    public void OnError() {
        switch (this.GetErrorID()) {
            case 90: {
                this.OnConfirmLogoutError();
                break;
            }
            default: {
                if (!DEBUG) break;
                System.out.println("Unhandled error | CThreadMsgChangePassword.OnError");
            }
        }
    }

    private void OnConfirmLogoutError() {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && !this.GetCancel()) {
            long lThreadID = this.GetThread().getId();
            CConfirmLogoutFailedDlg dlg = new CConfirmLogoutFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = String.format(CString.LoadString("IDS_CONFIRM_LOGOUT_FAILED_FMT_MSG"), "FTP Voyager JV");
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            String sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
            sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    public void OnRetry() {
        this.SetStop(false);
        this.SetCancel(false);
        if (this.GetThread() != null && this.GetThread() instanceof CWorkerThread) {
            CWorkerThread tThread = (CWorkerThread)this.GetThread();
            tThread.PostMessage(this);
        }
    }

    public void OnCancel(boolean bPostEvent) {
        this.SetStop(false);
        this.SetCancel(true);
        if (bPostEvent) {
            this.PostEvent(3020, this);
        }
    }
}

