/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmListFailedInitialDirDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import com.rhinosoft.fvjv.threads.remote.CRemoteThread;
import java.awt.Frame;

public class CThreadMsgListRemote
extends CThreadMsgList {
    private boolean m_bFailedToListInitialHomeDir = false;

    public CThreadMsgListRemote(Thread tThread, int nMsgID, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, nMsgID, rSource, rClientInfo, nCompressionType);
        this.InitVars();
    }

    protected CThreadMsgListRemote(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgListRemote) {
            this.Copy((CThreadMsgListRemote)rCopyFrom, false);
        }
    }

    private void InitVars() {
    }

    public boolean Copy(CThreadMsgListRemote rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null && bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
            bChanged = true;
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgListRemote(this);
    }

    private boolean GetFailedToListInitialHomeDir() {
        return this.m_bFailedToListInitialHomeDir;
    }

    private boolean SetFailedToListInitialHomeDir(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bFailedToListInitialHomeDir != bVal) {
            this.m_bFailedToListInitialHomeDir = bVal;
            bChanged = true;
            if (CMainFrame.GET_APP() != null) {
                if (this.m_bFailedToListInitialHomeDir) {
                    CMainFrame.GET_APP().IncFailedToListInitialHomeDir();
                } else {
                    CMainFrame.GET_APP().DecFailedToListInitialHomeDir();
                }
            }
        }
        return bChanged;
    }

    @Override
    protected void OnSendListOK() {
        this.SetListInitialHomeDir(false);
        this.SetFailedToListInitialHomeDir(false);
        super.OnSendListOK();
    }

    @Override
    protected void ProcessError() {
        if (DEBUG) {
            System.out.println("CThreadMsgListRemote.ProcessError -->");
        }
        if (CMainFrame.GET_APP() != null && this.GetThread() != null) {
            long lThreadID = this.GetThread().getId();
            int nHTTPRespCode = this.GetHTTPCode();
            int nSUResult = this.GetSUResult();
            if (this.GetListInitialHomeDir()) {
                if (DEBUG) {
                    System.out.println("if | GetListInitialHomeDir");
                }
                this.SetListInitialHomeDir(false);
                this.SetFailedToListInitialHomeDir(true);
                int nIdx = this.GetPathIndex();
                CPath rFromPath = this.GetFromPath(nIdx);
                this.RemoveFromPath(rFromPath);
                rFromPath = new CPath("~", true, false);
                this.AddFromPath(rFromPath);
                this.OnList(false);
            } else {
                if (DEBUG) {
                    System.out.println("else | GetListInitialHomeDir");
                }
                if (this.GetFailedToListInitialHomeDir()) {
                    if (DEBUG) {
                        System.out.println("if | GetFailedToListInitialHomeDir");
                    }
                    this.OnConfirmFailedToListInitialHomeDir();
                } else {
                    if (DEBUG) {
                        System.out.println("else | GetFailedToListInitialHomeDir");
                    }
                    super.ProcessError();
                }
            }
        } else {
            throw new IllegalArgumentException("GetThread() or CMainFrame.GET_APP() == null");
        }
        if (DEBUG) {
            System.out.println("CThreadMsgListRemote.ProcessError <--");
        }
    }

    private void OnConfirmFailedToListInitialHomeDir() {
        if (DEBUG) {
            System.out.println("CThreadMsgListRemote.OnConfirmFailedToListInitialHomeDir -->");
        }
        long lThreadID = -1L;
        if (this.GetThread() != null) {
            lThreadID = this.GetThread().getId();
        }
        CConfirmListFailedInitialDirDlg dlg = new CConfirmListFailedInitialDirDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
        String sMsg = CString.LoadString("IDS_CONFIRM_LIST_FAILED_DEF_MSG");
        CPath rFromPath = this.GetFromPath(this.GetPathIndex());
        if (rFromPath != null) {
            sMsg = String.format(CString.LoadString("IDS_CONFIRM_LIST_FAILED_INITIAL_FMT_MSG"), "FTP Voyager JV", rFromPath.GetPath(), "FTP Voyager JV", "Serv-U");
        }
        dlg.SetMainMsg(sMsg);
        String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
        dlg.SetBtnMsg(sBtnMsg);
        dlg.setVisible(true);
        int nRc = dlg.GetExitCode();
        switch (nRc) {
            case 0: {
                this.OnList(false);
                break;
            }
            default: {
                if (CMainFrame.GET_APP() == null) break;
                CMainFrame.GET_APP().IncFailedToListInitialHomeDir();
            }
        }
        if (DEBUG) {
            System.out.println("CThreadMsgListRemote.OnConfirmFailedToListInitialHomeDir <--");
        }
    }

    private boolean GetListInitialHomeDir() {
        boolean bVal = true;
        if (this.GetWorkerThread() != null && this.GetWorkerThread() instanceof CRemoteThread) {
            CRemoteThread tThread = (CRemoteThread)this.GetWorkerThread();
            bVal = tThread.GetListInitialHomeDir();
        }
        return bVal;
    }

    private boolean SetListInitialHomeDir(boolean bVal) {
        boolean bChanged = false;
        if (this.GetWorkerThread() != null && this.GetWorkerThread() instanceof CRemoteThread) {
            CRemoteThread tThread = (CRemoteThread)this.GetWorkerThread();
            bChanged = tThread.SetListInitialHomeDir(bVal);
        }
        return bChanged;
    }
}

