/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmChangePasswordFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.awt.Frame;

public class CThreadMsgChangePassword
extends CThreadMsg {
    private String m_sOldPassword;
    private String m_sNewPassword;

    public CThreadMsgChangePassword(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 32, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgChangePassword(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgChangePassword) {
            this.Copy((CThreadMsgChangePassword)rCopyFrom, false);
        }
    }

    public boolean Copy(CThreadMsgChangePassword rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetOldPassword(rCopyFrom.GetOldPassword())) {
                bChanged = true;
            }
            if (this.SetNewPassword(rCopyFrom.GetNewPassword())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgChangePassword(this);
    }

    private String GetOldPassword() {
        return this.m_sOldPassword;
    }

    public boolean SetOldPassword(String sOldPassword) {
        boolean bChanged = false;
        if (sOldPassword != null && !sOldPassword.equals(this.m_sOldPassword)) {
            this.m_sOldPassword = sOldPassword;
            bChanged = true;
        }
        return bChanged;
    }

    private String GetNewPassword() {
        return this.m_sNewPassword;
    }

    public boolean SetNewPassword(String sNewPassword) {
        boolean bChanged = false;
        if (sNewPassword != null && !sNewPassword.equals(this.m_sNewPassword)) {
            this.m_sNewPassword = sNewPassword;
            bChanged = true;
        }
        return bChanged;
    }

    @Override
    public void ProcessEvent() {
        this.OnChangePassword();
    }

    private void OnChangePassword() {
        boolean bContinue = true;
        this.SetErrorID(0);
        this.SetHTTPCode(503);
        this.SetSUResult(1);
        String sOldPword = this.GetOldPassword();
        String sNewPword = this.GetNewPassword();
        if (this.GetSUConnection() != null) {
            int[] anRetCodes = this.GetSUConnection().SendChangePassword(sOldPword, sNewPword);
            if (anRetCodes != null && anRetCodes.length == 2) {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUResult(anRetCodes[1]);
            }
            if (this.GetHTTPCode() == 200 && this.GetSUResult() == 0) {
                this.PostEvent(3021, this.clone());
            } else {
                this.SetErrorID(80);
                this.PostEvent(3005, this);
                bContinue = false;
            }
        }
    }

    @Override
    public void OnError() {
        switch (this.GetErrorID()) {
            case 80: {
                this.OnConfirmChangePasswordError();
                break;
            }
            default: {
                if (!DEBUG) break;
                System.out.println("Unhandled error | CThreadMsgChangePassword.OnError");
            }
        }
    }

    private void OnConfirmChangePasswordError() {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && !this.GetCancel()) {
            long lThreadID = this.GetThread().getId();
            CConfirmChangePasswordFailedDlg dlg = new CConfirmChangePasswordFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_CHANGE_PASSWORD_FAILED_DEF_MSG");
            sMsg = String.format("%s\r\n\r\n%s", sMsg, CThreadMsgChangePassword.GetSUError(this.GetSUResult()));
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            String sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    public void OnRetry() {
        this.OnCancel(true);
        this.PostEvent(2013);
    }

    public void OnCancel(boolean bPostEvent) {
        this.SetStop(false);
        this.SetCancel(true);
        if (bPostEvent) {
            this.PostEvent(3020, this);
        }
    }
}

