/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmChangeEmailFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.awt.Frame;

public class CThreadMsgChangeEmail
extends CThreadMsg {
    private boolean m_bIsRetry = false;
    private String m_sNewEmail;

    public CThreadMsgChangeEmail(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 35, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgChangeEmail(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgChangeEmail) {
            this.Copy((CThreadMsgChangeEmail)rCopyFrom, false);
        }
    }

    public boolean Copy(CThreadMsgChangeEmail rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetNewEmail(rCopyFrom.GetNewEmail())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgChangeEmail(this);
    }

    public String GetNewEmail() {
        return this.m_sNewEmail;
    }

    public boolean SetNewEmail(String sNewEmail) {
        boolean bChanged = false;
        if (sNewEmail != null && !sNewEmail.equals(this.m_sNewEmail)) {
            this.m_sNewEmail = sNewEmail;
            bChanged = true;
        }
        return bChanged;
    }

    @Override
    public void ProcessEvent() {
        this.OnChangeEmail();
    }

    private void OnChangeEmail() {
        boolean bContinue = true;
        this.m_bIsRetry = false;
        this.SetErrorID(0);
        this.SetHTTPCode(503);
        this.SetSUResult(1);
        String sNewEmail = this.GetNewEmail();
        if (this.GetSUConnection() != null) {
            int[] anRetCodes = this.GetSUConnection().SendChangeEmail(sNewEmail);
            if (anRetCodes != null && anRetCodes.length == 2) {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUResult(anRetCodes[1]);
            }
            if (this.GetHTTPCode() == 200 && this.GetSUResult() == 0) {
                this.PostEvent(3021, this.clone());
            } else {
                this.SetErrorID(120);
                this.PostEvent(3005, this);
                bContinue = false;
            }
        }
    }

    @Override
    public void OnError() {
        switch (this.GetErrorID()) {
            case 120: {
                this.OnConfirmChangeEmailError();
                break;
            }
            default: {
                if (!DEBUG) break;
                System.out.println("Unhandled error | CThreadMsgChangeEmail.OnError");
            }
        }
    }

    private void OnConfirmChangeEmailError() {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && !this.GetCancel()) {
            long lThreadID = this.GetThread().getId();
            CConfirmChangeEmailFailedDlg dlg = new CConfirmChangeEmailFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_CHANGE_EMAIL_FAILED_DEF_MSG");
            String sError = CThreadMsgChangeEmail.GetSUError(this.GetSUResult());
            if (this.GetSUResult() == 3) {
                sError = CString.LoadString("IDS_CONFIRM_CHANGE_EMAIL_FAILED_MSG_PERM_DENIED");
            }
            sMsg = String.format("%s\r\n\r\n%s", sMsg, sError);
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            String sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
            if (this.GetSUResult() == 3) {
                String sHTTPError = CThreadMsg.FormatHTTPTextError(this.GetHTTPCode());
                String sSUError = CThreadMsg.FormatSUTextError(this.GetSUResult());
                sError = CString.LoadString("IDS_CONFIRM_CHANGE_EMAIL_FAILED_MSG_PERM_DENIED");
                sDetails = String.format(CString.LoadString("IDS_HTTP_ERROR_SU_RESULT"), sHTTPError, sSUError, sError);
            }
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    public void OnRetry() {
        this.m_bIsRetry = true;
        this.OnCancel(true);
        this.PostEvent(2014);
    }

    public void OnCancel(boolean bPostEvent) {
        this.SetStop(false);
        this.SetCancel(true);
        if (bPostEvent) {
            this.PostEvent(3020, this);
        }
    }

    public boolean IsRetry() {
        return this.m_bIsRetry;
    }
}

