/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.files.CPath;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgDelete;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import com.rhinosoft.fvjv.threads.CThreadMsgRename;
import com.rhinosoft.fvjv.threads.CThreadMsgThumb;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgChangeEmail;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgChangePassword;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgCopyRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgCreateDirRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgDeleteRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgDownloadRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgListRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgLogout;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgNoop;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgRenameRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgSyncFoldersCompare;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgSyncFoldersExecute;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgThumbRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgUploadRemote;
import java.awt.Component;
import java.util.Timer;
import java.util.Vector;

public class CRemoteThread
extends CBaseThread {
    public static final String THREAD_NAME_GENERAL = "RemoteGeneralThread";
    public static final String THREAD_NAME_THUMBS = "RemoteThumbThread";
    public static final String THREAD_NAME_DELETE = "RemoteDeleteThread";
    public static final String THREAD_NAME_COPY = "RemoteCopyThread";
    public static final String THREAD_NAME_DOWNLOAD = "RemoteDownloadThread";
    public static final String THREAD_NAME_UPLOAD = "RemoteUploadThread";
    public static final String THREAD_NAME_OPEN = "RemoteOpenThread";
    public static final String THREAD_NAME_SYNC_FOLDERS_COMPARISON = "SyncFoldersComparisonThread";
    public static final String THREAD_NAME_SYNC_FOLDERS_EXECUTE = "SyncFoldersExecuteThread";
    public static final int TIMER_INITIAL_DELAY_NOOP = 50000;
    public static final int TIMER_DELAY_NOOP = 55000;
    public static final boolean DEF_LIST_INITIAL_HOME_DIR = true;
    private Timer m_Timer;
    private boolean m_bListInitialHomeDir = true;

    public CRemoteThread(Component rcEventSource, String sThreadName) {
        super(rcEventSource, sThreadName);
        this.InitVars();
    }

    private void InitVars() {
    }

    @Override
    public void finalize() throws Throwable {
        if (this.m_Timer != null) {
            this.m_Timer.cancel();
        }
        this.m_Timer = null;
        super.finalize();
    }

    @Override
    protected CThreadMsgList CreateThreadMsgList(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        return new CThreadMsgListRemote(tThread, 5, rSource, rClientInfo, nCompressionType);
    }

    @Override
    protected CThreadMsgThumb CreateThreadMsgThumb(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType, int nThumbWidth, int nThumbHeight, boolean bIsPreview) {
        return new CThreadMsgThumbRemote(this, rSource, rClientInfo, nCompressionType, nThumbWidth, nThumbHeight, bIsPreview);
    }

    public boolean SendLogout(Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        boolean bRet = false;
        CThreadMsgLogout rMsg = new CThreadMsgLogout(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            this.OnMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    @Override
    public boolean PostCopyFiles(Object rSource, CClientInfo rClientInfo, int nCompressionType, String sAbsFromPath, String sAbsToPath, CPath[] arTransferPaths, boolean bMovingFiles) {
        boolean bRet = false;
        CThreadMsgCopyRemote rMsg = new CThreadMsgCopyRemote(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            rMsg.SetMovingFiles(bMovingFiles);
            rMsg.SetTransferFromPath(sAbsFromPath);
            rMsg.SetTransferToPath(sAbsToPath);
            if (arTransferPaths != null) {
                for (int nIdx = 0; nIdx < arTransferPaths.length; ++nIdx) {
                    rMsg.AddFromPath(arTransferPaths[nIdx]);
                }
            }
            rMsg.SetPathIndex(0);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    @Override
    public boolean PostDownloadFiles(Object rSource, CClientInfo rClientInfo, int nCompressionType, String sAbsFromPath, String sAbsToPath, CPath[] arTransferPaths, boolean bMovingFiles, boolean bOpeningFiles, boolean bIsSearch) {
        boolean bRet = false;
        CThreadMsgDownloadRemote rMsg = new CThreadMsgDownloadRemote(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            rMsg.SetIsSearch(bIsSearch);
            rMsg.SetMovingFiles(bMovingFiles);
            rMsg.SetOpeningFiles(bOpeningFiles);
            rMsg.SetTransferFromPath(sAbsFromPath);
            rMsg.SetTransferToPath(sAbsToPath);
            if (arTransferPaths != null) {
                for (int nIdx = 0; nIdx < arTransferPaths.length; ++nIdx) {
                    rMsg.AddFromPath(arTransferPaths[nIdx]);
                }
            }
            rMsg.SetPathIndex(0);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    public boolean PostDownloadMedia(Object rSource, CClientInfo rClientInfo, int nCompressionType, String sAbsFromPath, String sAbsToPath, CPath[] arTransferPaths) {
        boolean bRet = false;
        CThreadMsgDownloadRemote rMsg = new CThreadMsgDownloadRemote(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            rMsg.SetIsMedia(true);
            rMsg.SetTransferFromPath(sAbsFromPath);
            rMsg.SetTransferToPath(sAbsToPath);
            if (arTransferPaths != null) {
                for (int nIdx = 0; nIdx < arTransferPaths.length; ++nIdx) {
                    rMsg.AddFromPath(arTransferPaths[nIdx]);
                }
            }
            rMsg.SetPathIndex(0);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    @Override
    public boolean PostUploadFiles(Object rSource, CClientInfo rClientInfo, int nCompressionType, String sAbsFromPath, String sAbsToPath, CPath[] arTransferPaths, boolean bMovingFiles, boolean bIsSearch) {
        boolean bRet = false;
        CThreadMsgUploadRemote rMsg = new CThreadMsgUploadRemote(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            rMsg.SetIsSearch(bIsSearch);
            rMsg.SetMovingFiles(bMovingFiles);
            rMsg.SetTransferFromPath(sAbsFromPath);
            rMsg.SetTransferToPath(sAbsToPath);
            if (arTransferPaths != null) {
                for (int nIdx = 0; nIdx < arTransferPaths.length; ++nIdx) {
                    rMsg.AddFromPath(arTransferPaths[nIdx]);
                }
            }
            rMsg.SetPathIndex(0);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    @Override
    protected CThreadMsgDelete CreateThreadMsgDelete(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        return new CThreadMsgDeleteRemote(tThread, rSource, rClientInfo, nCompressionType);
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType, boolean bWhenDoneEnterRename) {
        return new CThreadMsgCreateDirRemote(tThread, rSource, rClientInfo, nCompressionType, bWhenDoneEnterRename);
    }

    @Override
    protected CThreadMsgRename CreateThreadMsgRename(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        return new CThreadMsgRenameRemote(tThread, rSource, rClientInfo, nCompressionType);
    }

    public boolean PostChangePassword(Object rSource, CClientInfo rClientInfo, int nCompressionType, String sOldPassword, String sNewPassword) {
        boolean bRet = false;
        CThreadMsgChangePassword rMsg = new CThreadMsgChangePassword(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            rMsg.SetOldPassword(sOldPassword);
            rMsg.SetNewPassword(sNewPassword);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    public boolean PostChangeEmail(Object rSource, CClientInfo rClientInfo, int nCompressionType, String sNewEmail) {
        boolean bRet = false;
        CThreadMsgChangeEmail rMsg = new CThreadMsgChangeEmail(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            rMsg.SetNewEmail(sNewEmail);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    public boolean PostNoop(Object rSource, CClientInfo rClientInfo, int nCompressionType, boolean bCheckingCommunication) {
        boolean bRet = false;
        CThreadMsgNoop rMsg = new CThreadMsgNoop((Thread)this, rSource, rClientInfo, nCompressionType, bCheckingCommunication);
        if (rMsg != null) {
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    public synchronized boolean GetListInitialHomeDir() {
        return this.m_bListInitialHomeDir;
    }

    public synchronized boolean SetListInitialHomeDir(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bListInitialHomeDir != bVal) {
            this.m_bListInitialHomeDir = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean PostSyncFoldersCompare(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath rLocalPath, CPath rRemotePath, boolean bCompareSize, boolean bCompareDateModified, boolean bIncludeDeletions, boolean bIncludeSubfolders, CThreadMsgSyncFoldersCompare[] arRetMsg) {
        CThreadMsgSyncFoldersCompare rMsg;
        boolean bRet = false;
        if (rLocalPath != null && rRemotePath != null && (rMsg = new CThreadMsgSyncFoldersCompare(this, rSource, rClientInfo, nCompressionType)) != null) {
            if (arRetMsg != null && arRetMsg.length > 0) {
                arRetMsg[0] = rMsg;
            }
            rMsg.SetLocalPath(rLocalPath);
            rMsg.SetRemotePath(rRemotePath);
            rMsg.SetCompareSize(bCompareSize);
            rMsg.SetCompareDateModified(bCompareDateModified);
            rMsg.SetIncludeDeletions(bIncludeDeletions);
            rMsg.SetIncludeSubFolders(bIncludeSubfolders);
            this.SetCancel(false);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    public boolean PostCompareItemDone(CThreadMsgSyncFoldersCompare rThreadMsg) {
        CThreadMsgSyncFoldersCompare msg;
        boolean bRet = false;
        if (rThreadMsg != null && (msg = (CThreadMsgSyncFoldersCompare)rThreadMsg.clone()) != null) {
            msg.SetIsRecvItemDone(true);
            this.PostMessage(msg);
            bRet = true;
        }
        return bRet;
    }

    public boolean PostSyncFoldersExecute(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath rLocalPath, CPath rRemotePath, Vector<CSyncTableRow> aSyncData, boolean bConfirmOverwrite, boolean bConfirmDelete) {
        CThreadMsgSyncFoldersExecute rMsg;
        boolean bRet = false;
        if (rLocalPath != null && rRemotePath != null && (rMsg = new CThreadMsgSyncFoldersExecute(this, rSource, rClientInfo, nCompressionType)) != null) {
            rMsg.SetIsSearch(false);
            rMsg.SetMovingFiles(false);
            rMsg.SetLocalPath(rLocalPath);
            rMsg.SetRemotePath(rRemotePath);
            this.SetConfirmOverwrite(bConfirmOverwrite);
            this.SetConfirmDelete(bConfirmDelete);
            rMsg.SetSyncData(aSyncData);
            this.SetCancel(false);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }
}

