/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.local;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCopy;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.local.CThreadMsgCreateDirLocal;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class CThreadMsgCopyLocal
extends CThreadMsgCopy {
    public CThreadMsgCopyLocal(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgCopyLocal(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgCopyLocal) {
            this.Copy((CThreadMsgCopyLocal)rCopyFrom, false);
        }
    }

    @Override
    public Object clone() {
        return new CThreadMsgCopyLocal(this);
    }

    @Override
    public boolean IsDownload() {
        return false;
    }

    @Override
    protected CFile CreateTargetDir(CPath rPath) {
        CLocalFile fCreatedDir = null;
        if (rPath != null) {
            this.SetHTTPCode(200);
            File fNewDir = new File(rPath.GetPath());
            if (!fNewDir.exists()) {
                fNewDir = CFileSystemUtils.GetFileSysUtils().CreateAllDirs(fNewDir.getAbsolutePath());
                if (fNewDir.exists()) {
                    this.SetSUResult(0);
                    fCreatedDir = new CLocalFile(fNewDir);
                }
            } else {
                fCreatedDir = new CLocalFile(fNewDir);
                this.SetSUResult(0);
            }
        }
        return fCreatedDir;
    }

    @Override
    protected int[] CopyFile(CPath rFromPath, CPath rToPath) {
        int[] anRetCodes = new int[]{200, 1};
        if (this.GetMovingFiles()) {
            if (rFromPath != null && rToPath != null) {
                anRetCodes[1] = this.Rename(new File(rFromPath.GetPath()), new File(rToPath.GetPath()));
            }
            if (anRetCodes[0] == 200 && anRetCodes[1] == 0) {
                this.PostDelete(rFromPath);
            }
        } else {
            anRetCodes[1] = this.Copy(new File(rFromPath.GetPath()), new File(rToPath.GetPath()));
        }
        return anRetCodes;
    }

    private int Rename(File fSource, File fDestination) {
        int nRetCode;
        block6: {
            nRetCode = 1;
            if (fSource != null && fDestination != null && fSource.exists()) {
                this.CheckFileReplace(new CPath(fDestination.getAbsolutePath(), fDestination.isDirectory(), true));
                try {
                    if (fSource.renameTo(fDestination)) {
                        nRetCode = 0;
                    }
                }
                catch (SecurityException se) {
                    if (DEBUG) {
                        se.printStackTrace();
                    }
                }
                catch (NullPointerException npe) {
                    if (!DEBUG) break block6;
                    npe.printStackTrace();
                }
            }
        }
        return nRetCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int Copy(File fFrom, File fTo) {
        int nResult = 1;
        if (fFrom != null && fFrom.exists() && fTo != null) {
            block37: {
                if (!fTo.exists()) {
                    try {
                        fTo.createNewFile();
                    }
                    catch (IOException ioe) {
                        if (DEBUG) {
                            ioe.printStackTrace();
                        }
                    }
                    catch (SecurityException se) {
                        if (!DEBUG) break block37;
                        se.printStackTrace();
                    }
                }
            }
            if (fTo.exists()) {
                FileInputStream rInStream = null;
                FileOutputStream rOutStream = null;
                try {
                    long nTotalRead;
                    rInStream = new FileInputStream(fFrom);
                    rOutStream = new FileOutputStream(fTo);
                    byte[] aReadBuf = new byte[0x100000];
                    long nLen = fFrom.length();
                    int nRead = 0;
                    for (nTotalRead = 0L; nTotalRead < nLen && !this.GetCancel(); nTotalRead += (long)nRead) {
                        nRead = rInStream.read(aReadBuf);
                        rOutStream.write(aReadBuf, 0, nRead);
                    }
                    if (nTotalRead == nLen) {
                        nResult = 0;
                    }
                }
                catch (FileNotFoundException fnfe) {
                    if (DEBUG) {
                        System.out.println(String.format("EXCEPTION:  We couldn't find the file that the Streams are trying to connect to. (%s)", fnfe.getMessage()));
                    }
                }
                catch (IOException ioe) {
                    if (DEBUG) {
                        System.out.println(String.format("EXCEPTION:  EXCEPTION:  We couldn't read or write to the streams. (%s)", ioe.getMessage()));
                    }
                }
                finally {
                    if (rInStream != null) {
                        try {
                            rInStream.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    if (rOutStream != null) {
                        try {
                            rOutStream.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
                fTo.setLastModified(fFrom.lastModified());
                fTo.setWritable(fFrom.canWrite());
                fTo.setReadable(fFrom.canRead());
            }
        } else {
            nResult = 6;
        }
        return nResult;
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir(CThreadMsg rCopyFrom) {
        CThreadMsgCreateDirLocal rMsg = null;
        if (rCopyFrom != null) {
            rMsg = new CThreadMsgCreateDirLocal(rCopyFrom.GetThread(), rCopyFrom.GetSource(), rCopyFrom.GetClientInfo(), rCopyFrom.GetCompressionType(), false);
        }
        return rMsg;
    }
}

