/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.net.CTransferStatsEvent;
import com.rhinosoft.fvjv.threads.CThreadMsgDownload;
import javax.swing.ImageIcon;

public abstract class CThreadMsgThumb
extends CThreadMsgDownload {
    private boolean m_bIsPreview = true;
    private int m_nThumbWidth = 100;
    private int m_nThumbHeight = 100;
    private ImageIcon m_ThumbImage = null;

    public CThreadMsgThumb(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType, int nThumbWidth, int nThumbHeight, boolean bIsPreview) {
        super(tThread, 22, rSource, rClientInfo, nCompressionType);
        this.InitVars(nThumbWidth, nThumbHeight, bIsPreview);
    }

    protected CThreadMsgThumb(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgThumb) {
            CThreadMsgThumb rCopyFromMsg = (CThreadMsgThumb)rCopyFrom;
            this.Copy(rCopyFromMsg, false);
            if (rCopyFromMsg.m_ThumbImage != null) {
                this.m_ThumbImage = new ImageIcon(rCopyFromMsg.m_ThumbImage.getImage());
            }
        }
    }

    protected abstract int[] RetrieveThumb(String var1, long var2, String var4, int var5, int var6);

    private void InitVars(int nThumbWidth, int nThumbHeight, boolean bIsPreview) {
        this.m_bIsPreview = bIsPreview;
        this.m_nThumbWidth = nThumbWidth;
        this.m_nThumbHeight = nThumbHeight;
    }

    public boolean Copy(CThreadMsgThumb rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetIsPreview(rCopyFrom.IsPreview())) {
                bChanged = true;
            }
            if (this.SetThumbWidth(rCopyFrom.GetThumbWidth())) {
                bChanged = true;
            }
            if (this.SetThumbHeight(rCopyFrom.GetThumbHeight())) {
                bChanged = true;
            }
            if (this.SetThumbImage(rCopyFrom.GetThumbImage())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    public boolean SetThumbWidth(int nThumbWidth) {
        boolean bChanged = false;
        if (this.m_nThumbWidth != nThumbWidth) {
            this.m_nThumbWidth = nThumbWidth;
            bChanged = true;
        }
        return bChanged;
    }

    public int GetThumbWidth() {
        return this.m_nThumbWidth;
    }

    public boolean SetThumbHeight(int nThumbHeight) {
        boolean bChanged = false;
        if (this.m_nThumbHeight != nThumbHeight) {
            this.m_nThumbHeight = nThumbHeight;
            bChanged = true;
        }
        return bChanged;
    }

    public int GetThumbHeight() {
        return this.m_nThumbHeight;
    }

    public boolean SetThumbImage(ImageIcon rImage) {
        boolean bChanged = false;
        if (this.m_ThumbImage != rImage) {
            this.m_ThumbImage = rImage;
            bChanged = true;
        }
        return bChanged;
    }

    public ImageIcon GetThumbImage() {
        return this.m_ThumbImage;
    }

    public boolean SetIsPreview(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsPreview != bVal) {
            this.m_bIsPreview = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsPreview() {
        return this.m_bIsPreview;
    }

    @Override
    protected boolean IsOverwritePathAvailable(CPath rToPath) {
        return this.IsLocalPathAvailable(rToPath);
    }

    @Override
    protected boolean Transfer(CPath rFromPath, CPath rToPath) {
        int[] anRetCodes;
        boolean bContinue = false;
        if (this.GetStartTime() <= 0L || this.GetResume()) {
            this.SetStartTime(System.currentTimeMillis());
        }
        if ((anRetCodes = this.RetrieveThumb(rFromPath.GetPath(), rFromPath.GetSize(), rToPath.GetPath(), this.GetThumbWidth(), this.GetThumbHeight())) != null && anRetCodes.length == 2) {
            this.SetHTTPCode(anRetCodes[0]);
            this.SetSUResult(anRetCodes[1]);
            if ((anRetCodes[0] == 200 || anRetCodes[0] == 206) && anRetCodes[1] == 0) {
                bContinue = true;
            }
        }
        return bContinue;
    }

    @Override
    public void OnUpdateTransferStats(CTransferStatsEvent event) {
        this.SetFileRead(event.GetReadPos());
        this.SetFileTotal(event.GetReadMax());
        this.PostEvent(6052, this.clone());
    }

    @Override
    public void OnError() {
        if (!this.IsPreview()) {
            this.OnSkip();
        } else {
            super.OnError();
        }
    }

    @Override
    protected boolean OnTransferItemFailed() {
        this.PostEvent(3005, this);
        return true;
    }

    @Override
    protected boolean VerifyOverwrite(boolean bIgnoreDirs) {
        return true;
    }
}

