/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.files.WindowsLink.CWindowsLink;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.docking.fvjv.search.CSearchEvent;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import java.io.File;
import java.util.Calendar;

public class CThreadMsgSearch
extends CThreadMsgList {
    private CFile m_rRootDir;
    private String m_sSearchFilter;
    private CSearchEvent.DATE_TYPE m_nDateType;
    private CSearchEvent.DATE_CONTEXT m_nDateContext;
    private long m_lSearchDate;
    private CSearchEvent.SIZE_CONTEXT m_nSizeContext;
    private long m_lSearchFileSize;
    private int m_nBitmaskFileAttribs;
    private int m_nDirAndFilesOpt;
    private boolean m_bIsRecvItemDone;

    public CThreadMsgSearch(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 7, rSource, rClientInfo, nCompressionType);
        this.InitVars();
    }

    protected CThreadMsgSearch(CWorkerThreadID rCopyFrom, boolean bCallSuper) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgSearch) {
            CThreadMsgSearch rMsg = (CThreadMsgSearch)rCopyFrom;
            this.Copy(rMsg, bCallSuper);
        }
    }

    private void InitVars() {
        if (this.GetSUConnection() != null) {
            this.GetSUConnection().AddListDirListener(this);
        }
        this.ResetPrevListData();
        this.m_bIsRecvItemDone = false;
    }

    public boolean Copy(CThreadMsgSearch rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            CFile rRootDir = null;
            if (rCopyFrom.GetRootDir() != null) {
                rRootDir = rCopyFrom.GetRootDir().clone();
            }
            if (this.SetRootDir(rRootDir)) {
                bChanged = true;
            }
            if (this.SetSearchFilter(rCopyFrom.GetSearchFilter())) {
                bChanged = true;
            }
            if (this.SetDateType(rCopyFrom.GetDateType())) {
                bChanged = true;
            }
            if (this.SetDateContext(rCopyFrom.GetDateContext())) {
                bChanged = true;
            }
            if (this.SetSearchDate(rCopyFrom.GetSearchDate())) {
                bChanged = true;
            }
            if (this.SetSizeContext(rCopyFrom.GetSizeContext())) {
                bChanged = true;
            }
            if (this.SetSearchSize(rCopyFrom.GetSearchSize())) {
                bChanged = true;
            }
            if (this.SetBitmaskFileAttribs(rCopyFrom.GetBitmaskFileAttribs())) {
                bChanged = true;
            }
            if (this.SetDirAndFilesOpt(rCopyFrom.GetDirAndFilesOpt())) {
                bChanged = true;
            }
            if (this.SetThrottleCount(rCopyFrom.GetThrottleCount())) {
                bChanged = true;
            }
            if (this.SetIsRecvItemDone(rCopyFrom.IsRecvItemDone())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgSearch(this, true);
    }

    public CFile GetRootDir() {
        return this.m_rRootDir;
    }

    public boolean SetRootDir(CFile rRootDir) {
        boolean bChanged = false;
        if (rRootDir != null && rRootDir.GetPath() != null && this.m_rRootDir != null && !this.m_rRootDir.GetPath().equals(rRootDir.GetPath())) {
            bChanged = true;
            this.m_rRootDir = rRootDir;
        } else {
            this.m_rRootDir = rRootDir;
        }
        return bChanged;
    }

    public String GetSearchFilter() {
        return this.m_sSearchFilter;
    }

    public boolean SetSearchFilter(String sSearchFilter) {
        boolean bChanged = false;
        if (sSearchFilter != null && this.m_sSearchFilter != null && !this.m_sSearchFilter.equals(sSearchFilter)) {
            bChanged = true;
            this.m_sSearchFilter = sSearchFilter;
        } else {
            this.m_sSearchFilter = sSearchFilter;
        }
        return bChanged;
    }

    public CSearchEvent.DATE_TYPE GetDateType() {
        return this.m_nDateType;
    }

    public boolean SetDateType(CSearchEvent.DATE_TYPE nDateType) {
        boolean bChanged = false;
        if (this.m_nDateType != nDateType) {
            bChanged = true;
            this.m_nDateType = nDateType;
        }
        return bChanged;
    }

    public CSearchEvent.DATE_CONTEXT GetDateContext() {
        return this.m_nDateContext;
    }

    public boolean SetDateContext(CSearchEvent.DATE_CONTEXT nDateContext) {
        boolean bChanged = false;
        if (this.m_nDateContext != nDateContext) {
            bChanged = true;
            this.m_nDateContext = nDateContext;
        }
        return bChanged;
    }

    public long GetSearchDate() {
        return this.m_lSearchDate;
    }

    public boolean SetSearchDate(long lDate) {
        boolean bChanged = false;
        if (this.m_lSearchDate != lDate) {
            bChanged = true;
            this.m_lSearchDate = lDate;
        }
        return bChanged;
    }

    public CSearchEvent.SIZE_CONTEXT GetSizeContext() {
        return this.m_nSizeContext;
    }

    public boolean SetSizeContext(CSearchEvent.SIZE_CONTEXT nSizeContext) {
        boolean bChanged = false;
        if (this.m_nSizeContext != nSizeContext) {
            bChanged = true;
            this.m_nSizeContext = nSizeContext;
        }
        return bChanged;
    }

    public long GetSearchSize() {
        return this.m_lSearchFileSize;
    }

    public boolean SetSearchSize(long lFileSize) {
        boolean bChanged = false;
        if (this.m_lSearchFileSize != lFileSize) {
            bChanged = true;
            this.m_lSearchFileSize = lFileSize;
        }
        return bChanged;
    }

    public int GetBitmaskFileAttribs() {
        return this.m_nBitmaskFileAttribs;
    }

    public boolean SetBitmaskFileAttribs(int nBitmaskFileAttribs) {
        boolean bChanged = false;
        if (this.m_nBitmaskFileAttribs != nBitmaskFileAttribs) {
            bChanged = true;
            this.m_nBitmaskFileAttribs = nBitmaskFileAttribs;
        }
        return bChanged;
    }

    public int GetDirAndFilesOpt() {
        return this.m_nDirAndFilesOpt;
    }

    public boolean SetDirAndFilesOpt(int nDirAndFilesOpt) {
        boolean bChanged = false;
        if (this.m_nDirAndFilesOpt != nDirAndFilesOpt) {
            bChanged = true;
            this.m_nDirAndFilesOpt = nDirAndFilesOpt;
        }
        return bChanged;
    }

    @Override
    protected boolean OnList(boolean bUpdateGUIStopBtn) {
        boolean bContinue = true;
        if (DEBUG) {
            System.out.println("CThreadMsgSearch.OnList -->");
        }
        if (this.IsRecvItemDone()) {
            this.SetIsRecvItemDone(false);
            this.DecThrottleCount();
        }
        if (this.CheckResumeThrottleCount() && !this.CheckPaused()) {
            this.SetErrorID(0);
            this.SetHTTPCode(503);
            this.SetSUResult(1);
            this.SetListFile(null);
            if (this.GetPathIndex() == 0) {
                this.ExpandPath(this.GetRootDir(), false);
            }
            while (this.GetPathIndex() < this.GetFromPathSize() && !this.GetCancel() && !this.CheckExceedsThrottleCount()) {
                CFile rFile = (CFile)this.GetFromPath(this.GetPathIndex());
                if (rFile != null) {
                    String sPath;
                    if (DEBUG) {
                        System.out.printf("Search within %s for %s\r\n", rFile.GetPath(), this.GetSearchFilter());
                    }
                    if ((sPath = rFile.GetPath()) != null && !sPath.isEmpty()) {
                        String sName = CString.MakeForwardSlashes(sPath);
                        int nLastSlash = (sName = CString.EnsureLastCharIsNotAForwardSlash(sName)).lastIndexOf("/") + 1;
                        if (nLastSlash >= 0 && nLastSlash < sName.length()) {
                            sName = sName.substring(nLastSlash, sName.length());
                        }
                        boolean bIsMatch = this.CheckSearchDate(rFile) && this.CheckSearchSize(rFile) && this.CheckFileAttribs(rFile) && this.CheckDirAndFilesOpt(rFile);
                        String sSearchFilter = this.GetSearchFilter();
                        if (bIsMatch && sSearchFilter != null && !sSearchFilter.isEmpty()) {
                            boolean bIgnoreCase = false;
                            if (rFile.IsLocal()) {
                                if (CFileSystemUtils.GetFileSysUtils() != null) {
                                    bIgnoreCase = CFileSystemUtils.GetFileSysUtils().IsWindows();
                                }
                            } else if (CMainFrame.GET_APP() != null) {
                                bIgnoreCase = !CMainFrame.GET_APP().IsCaseSensitiveOS();
                            }
                            bIsMatch = CString.WildcardCompare(this.GetSearchFilter(), sName, bIgnoreCase);
                        }
                        if (bIsMatch) {
                            this.PostEvent(9500, rFile);
                        }
                    }
                    if (rFile.IsDir()) {
                        this.ExpandPath(rFile, false);
                    }
                    if (!this.GetCancel()) {
                        this.IncThrottleCount();
                        this.PostEvent(3021, this);
                    }
                }
                if (this.GetCancel()) continue;
                this.SetPathIndex(this.GetPathIndex() + 1);
            }
            if (this.GetCancel()) {
                if (DEBUG) {
                    System.out.println("CThreadMsgSearch.OnList | Cancelled");
                }
                this.PostEvent(3020, this);
                bContinue = false;
            } else if (!this.CheckPaused() && this.GetThrottleCount() < 1) {
                this.PostEvent(3022, this);
            }
        } else {
            bContinue = false;
        }
        if (DEBUG) {
            System.out.println("CThreadMsgSearch.OnList <--");
        }
        return bContinue;
    }

    private boolean CheckSearchDate(CFile rFile) {
        boolean bIsMatch = true;
        if (rFile != null) {
            long lSearchDate = this.GetSearchDate();
            long lFileDate = -1L;
            switch (this.GetDateType()) {
                case MODIFIED: {
                    lFileDate = rFile.GetLastModified();
                    break;
                }
                case CREATED: {
                    break;
                }
                case ACCESSED: {
                    break;
                }
            }
            switch (this.GetDateContext()) {
                case ANY: {
                    bIsMatch = true;
                    break;
                }
                case EQUALS: {
                    Calendar calSearch = Calendar.getInstance();
                    calSearch.setTimeInMillis(lSearchDate);
                    Calendar calFile = Calendar.getInstance();
                    calFile.setTimeInMillis(lFileDate);
                    bIsMatch = calFile.get(1) == calSearch.get(1) && calFile.get(2) == calSearch.get(2) && calFile.get(5) == calSearch.get(5);
                    break;
                }
                case IS_BEFORE: {
                    bIsMatch = lFileDate < lSearchDate;
                    break;
                }
                case IS_AFTER: {
                    bIsMatch = lFileDate > lSearchDate;
                    break;
                }
                default: {
                    bIsMatch = false;
                }
            }
        }
        return bIsMatch;
    }

    private boolean CheckSearchSize(CFile rFile) {
        boolean bIsMatch = true;
        if (rFile != null) {
            long lSearchSize = this.GetSearchSize();
            long lFileSize = rFile.GetSize();
            switch (this.GetSizeContext()) {
                case ANY: {
                    bIsMatch = true;
                    break;
                }
                case EQUALS: {
                    bIsMatch = lFileSize == lSearchSize;
                    break;
                }
                case IS_GREATER_THAN: {
                    bIsMatch = lFileSize > lSearchSize;
                    break;
                }
                case IS_LESS_THAN: {
                    bIsMatch = lFileSize < lSearchSize;
                    break;
                }
                default: {
                    bIsMatch = false;
                }
            }
        }
        return bIsMatch;
    }

    public boolean GetIncludeAll() {
        return (this.m_nBitmaskFileAttribs & 0x1E) == 30;
    }

    public boolean GetIncludeReadOnly() {
        return (this.m_nBitmaskFileAttribs & 2) == 2;
    }

    public boolean GetIncludeHidden() {
        return (this.m_nBitmaskFileAttribs & 4) == 4;
    }

    public boolean GetIncludeCompressed() {
        return (this.m_nBitmaskFileAttribs & 8) == 8;
    }

    public boolean GetIncludeEncrypted() {
        return (this.m_nBitmaskFileAttribs & 0x10) == 16;
    }

    private boolean CheckFileAttribs(CFile rFile) {
        boolean bIsMatch = true;
        if (rFile != null && !this.GetIncludeAll()) {
            bIsMatch = false;
            if (this.GetIncludeReadOnly() && rFile.IsReadOnly()) {
                bIsMatch = true;
            }
            if (this.GetIncludeHidden() && rFile.IsHidden()) {
                bIsMatch = true;
            }
            if (this.GetIncludeCompressed() && rFile.IsCompressed()) {
                bIsMatch = true;
            }
            if (this.GetIncludeEncrypted() && rFile.IsEncrypted()) {
                bIsMatch = true;
            }
        }
        return bIsMatch;
    }

    private boolean CheckDirAndFilesOpt(CFile rFile) {
        boolean bIsMatch = true;
        if (rFile != null) {
            switch (this.GetDirAndFilesOpt()) {
                case 1: {
                    if (rFile.IsDirectory()) break;
                    bIsMatch = false;
                    break;
                }
                case 2: {
                    if (!rFile.IsDirectory()) break;
                    bIsMatch = false;
                    break;
                }
            }
        }
        return bIsMatch;
    }

    private int GetThrottleCount() {
        int nThrottleCount = 0;
        if (this.GetThread() != null) {
            nThrottleCount = this.GetThread().GetThrottleCount();
        }
        return nThrottleCount;
    }

    private boolean SetThrottleCount(int nThrottleCount) {
        boolean bChanged = false;
        if (this.GetThread() != null) {
            bChanged = this.GetThread().SetThrottleCount(nThrottleCount);
        }
        return bChanged;
    }

    private void IncThrottleCount() {
        if (this.GetThread() != null) {
            this.GetThread().IncThrottleCount();
        }
    }

    private void DecThrottleCount() {
        if (this.GetThread() != null) {
            this.GetThread().DecThrottleCount();
        }
    }

    private boolean CheckExceedsThrottleCount() {
        boolean bExceedsCount = false;
        if (this.GetThread() != null) {
            bExceedsCount = this.GetThread().CheckExceedsThrottleCount();
        }
        return bExceedsCount;
    }

    private boolean CheckResumeThrottleCount() {
        boolean bCanResume = false;
        if (this.GetThread() != null) {
            bCanResume = this.GetThread().CheckResumeThrottleCount();
        }
        return bCanResume;
    }

    @Override
    public CBaseThread GetThread() {
        return (CBaseThread)super.GetThread();
    }

    @Override
    public int GetPathIndex() {
        int nIndex = super.GetPathIndex();
        if (this.GetThread() != null) {
            nIndex = this.GetThread().GetPathIndex();
        }
        return nIndex;
    }

    @Override
    public boolean SetPathIndex(int nIdx) {
        boolean bChanged = super.SetPathIndex(nIdx);
        if (this.GetThread() != null) {
            bChanged = this.GetThread().SetPathIndex(nIdx);
        }
        return bChanged;
    }

    public boolean IsRecvItemDone() {
        return this.m_bIsRecvItemDone;
    }

    public boolean SetIsRecvItemDone(boolean bIsRecvItemDone) {
        boolean bChanged = false;
        if (this.m_bIsRecvItemDone != bIsRecvItemDone) {
            bChanged = true;
            this.m_bIsRecvItemDone = bIsRecvItemDone;
        }
        return bChanged;
    }

    @Override
    public boolean GetCancel() {
        boolean bCancel = super.GetCancel();
        if (this.GetThread() != null) {
            bCancel = this.GetThread().GetCancel();
        }
        return bCancel;
    }

    @Override
    protected CPath CreateResolvedLinkPath(File fChild) {
        File fTarget;
        CWindowsLink link;
        String sTargetPath;
        String sPath;
        CPath rRetPath = null;
        String sResolvedPath = null;
        if (fChild != null && CPath.IsWindowsLink(sPath = fChild.getAbsolutePath()) && (sTargetPath = (link = new CWindowsLink(sPath)).GetResolvedPath()) != null && !sTargetPath.isEmpty() && (fTarget = new File(sTargetPath)) != null && (sResolvedPath = fTarget.getAbsolutePath()) != null && this.GetSearchLinkTargets()) {
            CLocalFile fLocal = this.CreateLocalFile(new File(sResolvedPath));
            this.AddFromPath(fLocal);
        }
        if (rRetPath == null) {
            rRetPath = super.CreateResolvedLinkPath(fChild);
        }
        return rRetPath;
    }

    private boolean CheckPaused() {
        boolean bIsPaused = false;
        if (this.GetThread() != null) {
            bIsPaused = this.GetThread().CheckPaused();
        }
        return bIsPaused;
    }

    protected boolean GetSearchLinkTargets() {
        boolean bSearchLinkTargets = false;
        if (this.GetThread() != null) {
            bSearchLinkTargets = this.GetThread().GetSearchLinkTargets();
        }
        return bSearchLinkTargets;
    }
}

