/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmRenameFailedDlg;
import com.rhinosoft.fvjv.gui.dialogs.CRhinoOverwriteDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import java.awt.Component;
import java.awt.Frame;

public abstract class CThreadMsgRename
extends CThreadMsgList {
    public CThreadMsgRename(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 9, rSource, rClientInfo, nCompressionType);
        this.InitVars();
    }

    protected CThreadMsgRename(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgRename) {
            this.Copy((CThreadMsgRename)rCopyFrom, false);
        }
    }

    protected abstract int[] Rename(CPath var1, CPath var2);

    private void InitVars() {
    }

    public boolean Copy(CThreadMsgRename rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null && bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
            bChanged = true;
        }
        return bChanged;
    }

    @Override
    public void ProcessEvent() {
        this.OnRename();
    }

    private void OnRename() {
        boolean bContinue = true;
        for (int nIdx = this.GetPathIndex(); nIdx < this.GetFromPathSize() && bContinue && !this.GetCancel(); ++nIdx) {
            this.SetErrorID(0);
            this.SetHTTPCode(503);
            this.SetSUResult(1);
            this.SetPathIndex(nIdx);
            CPath rFromPath = this.GetFromPath(nIdx);
            CPath rToPath = this.GetToPath(nIdx);
            if (rFromPath == null || rToPath == null) continue;
            boolean bCanOverwrite = this.VerifyOverwrite(false);
            if (bCanOverwrite) {
                int[] anRetCodes = this.Rename(rFromPath, rToPath);
                if (anRetCodes != null && anRetCodes.length == 2) {
                    this.SetHTTPCode(anRetCodes[0]);
                    this.SetSUResult(anRetCodes[1]);
                }
                if (this.GetHTTPCode() == 200 && this.GetSUResult() == 0) {
                    this.PostEvent(3021, this.clone());
                    continue;
                }
                this.SetErrorID(60);
                this.PostEvent(3005, this);
                bContinue = false;
                continue;
            }
            this.SetErrorID(41);
            this.PostEvent(3005, this);
            bContinue = false;
        }
    }

    @Override
    protected void ProcessError() {
        switch (this.GetErrorID()) {
            case 41: {
                this.OnConfirmOverwrite(false);
                break;
            }
            case 60: {
                this.OnConfirmFailedToRename();
                break;
            }
            default: {
                if (!DEBUG) break;
                System.out.println("Unhandled error | CThreadMsgDelete.ProcessError");
            }
        }
    }

    private void OnConfirmOverwrite(boolean bIsReadOnly) {
        CPath rToPath = this.GetToPath(this.GetPathIndex());
        if (rToPath != null) {
            long lThreadID = -1L;
            if (this.GetThread() != null) {
                lThreadID = this.GetThread().getId();
            }
            CRhinoOverwriteDlg dlg = new CRhinoOverwriteDlg((Component)this.GetDeleteFrame(), CString.LoadString("IDS_CONFIRM_OVERWRITE_DLG_TITLE"), true);
            CMainFrame.GET_APP().SetOverwriteDlg(dlg);
            dlg.ShowResumeBtn(false);
            dlg.ShowApplyToAllBtn(false);
            dlg.ShowDoNotAskAgain(false);
            CPath rSource = this.GetFromPath(this.GetPathIndex());
            CPath rTarget = this.GetToPath(this.GetPathIndex());
            dlg.SetSource(rSource);
            dlg.SetTarget(rTarget);
            dlg.SetAbsRenameTo(this.GetAbsRenameTo(rTarget));
            dlg.setVisible(true);
            CRhinoOverwriteDlg.RESULT result = dlg.GetResult();
            this.SetApplyToAllOverwrite(dlg.GetApplyToAll());
            this.SetApplyToAllOverwriteResult(CRhinoOverwriteDlg.RESULT.CANCELLED);
            this.OnConfirmOverwriteResult(result);
        }
    }

    private void OnConfirmOverwriteResult(CRhinoOverwriteDlg.RESULT result) {
        switch (result) {
            case OVERWRITE_TARGET: {
                this.SetApplyToAllOverwriteResult(CRhinoOverwriteDlg.RESULT.OVERWRITE_TARGET);
                this.OnOverwrite();
                break;
            }
            case RENAME_TARGET: {
                this.SetApplyToAllOverwriteResult(CRhinoOverwriteDlg.RESULT.RENAME_TARGET);
                this.OnOverwriteRename();
                break;
            }
            default: {
                this.OnCancel(true);
                this.SetErrorID(60);
                this.PostEvent(3005, this);
            }
        }
    }

    private void OnConfirmFailedToRename() {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && !this.GetCancel()) {
            String sDetails;
            long lThreadID = this.GetThread().getId();
            CConfirmRenameFailedDlg dlg = new CConfirmRenameFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_RENAME_FAILED_DEF_MSG");
            CPath rFromPath = this.GetFromPath(this.GetPathIndex());
            CPath rToPath = this.GetToPath(this.GetPathIndex());
            if (rFromPath != null && rToPath != null) {
                sMsg = this.GetSUResult() == 3 ? String.format(CString.LoadString("IDS_CONFIRM_RENAME_FAILED_FMT_MSG_PERM_DENIED"), rFromPath.GetPath(), rToPath.GetPath()) : String.format(CString.LoadString("IDS_CONFIRM_RENAME_FAILED_FMT_MSG"), rFromPath.GetPath(), rToPath.GetPath());
            }
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            if (rFromPath != null && !rFromPath.IsLocal()) {
                sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
                sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            } else {
                sDetails = String.format("%s\r\n\r\n%s", CThreadMsgRename.GetSUError(this.GetSUResult()), CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            }
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    if (this.GetSUResult() == 6) {
                        this.PostDelete(rFromPath);
                    }
                    this.OnCancel(true);
                }
            }
        }
    }

    protected void CheckFileReplace(CPath rSourcePath, CPath rDestinationPath) {
        boolean bCanOverwrite;
        if (rSourcePath != null && rDestinationPath != null && (bCanOverwrite = this.GetCanOverwrite())) {
            int[] anRc;
            boolean bCanDelete;
            boolean bl = bCanDelete = !this.GetPathsMatch(rSourcePath.GetPath(), rDestinationPath.GetPath(), !rDestinationPath.IsLocal());
            if (bCanDelete && (anRc = this.Delete(rDestinationPath)) != null && anRc.length == 2 && (anRc[1] == 0 || anRc[1] == 6)) {
                this.SetIsRenameReplace(true);
                this.PostDelete(rDestinationPath);
                this.SetIsRenameReplace(false);
            }
        }
    }

    @Override
    protected boolean VerifyOverwrite(boolean bIgnoreDirs) {
        boolean bCanOverwrite = super.VerifyOverwrite(bIgnoreDirs);
        if (!bCanOverwrite) {
            CPath rFromPath = this.GetFromPath(this.GetPathIndex());
            CPath rToPath = this.GetToPath(this.GetPathIndex());
            if (rFromPath != null && rToPath != null && this.GetPathsMatch(rFromPath.GetPath(), rToPath.GetPath(), !rToPath.IsLocal())) {
                this.SetCanOverwrite(true);
                bCanOverwrite = true;
            }
        }
        return bCanOverwrite;
    }

    private boolean GetPathsMatch(String sFromPath, String sToPath, boolean bIsRemote) {
        return CString.GetPathsMatch(sFromPath, sToPath, bIsRemote);
    }

    private void OnOverwriteRename() {
        this.SetStop(false);
        this.SetCancel(false);
        this.SetCanOverwrite(true);
        this.SetCanDelReadOnly(true);
        this.ResetPrevListData();
        Thread tThread = this.GetThread();
        if (tThread != null && tThread instanceof CBaseThread) {
            CBaseThread tCurThread = (CBaseThread)tThread;
            CPath rToPath = this.GetToPath(this.GetPathIndex());
            if (rToPath != null) {
                String sPath = rToPath.GetPath();
                sPath = this.GetAbsRenameTo(rToPath);
                if (sPath != null) {
                    rToPath.SetPath(sPath);
                }
            }
            tCurThread.PostMessage(this);
        }
    }

    private String GetAbsRenameTo(CPath rTarget) {
        String sRenameTo = null;
        if (rTarget != null) {
            CFile fParent;
            CFile fChild;
            sRenameTo = rTarget.GetPath();
            CFile fRoot = null;
            fRoot = rTarget.IsLocal() ? CMainFrame.GET_APP().GetLocalRoot() : CMainFrame.GET_APP().GetRemoteRoot();
            if (fRoot != null && (fChild = fRoot.FindFile(rTarget.GetPath(), false)) != null && (fParent = fChild.GetParent()) != null) {
                sRenameTo = fParent.FmtRenameTo(rTarget.GetPath());
            }
        }
        return sRenameTo;
    }
}

