/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThread;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.util.Vector;

public abstract class CThreadMsgPaths
extends CThreadMsg {
    private final Object m_FromPathCrit = new Object();
    private Vector<CPath> m_aFromPaths = new Vector();
    private final Object m_ToPathCrit = new Object();
    private Vector<CPath> m_aToPaths = new Vector();
    private int m_nPathIdx = 0;
    private boolean m_bPrepDone = false;

    public CThreadMsgPaths(Thread tThread, int nMsgID, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, nMsgID, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgPaths(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgPaths) {
            this.Copy((CThreadMsgPaths)rCopyFrom, false);
        }
    }

    public boolean Copy(CThreadMsgPaths rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetFromPaths(rCopyFrom)) {
                bChanged = true;
            }
            if (this.SetToPaths(rCopyFrom)) {
                bChanged = true;
            }
            if (this.SetPathIndex(rCopyFrom.GetPathIndex())) {
                bChanged = true;
            }
            if (this.SetPrepDone(rCopyFrom.IsPrepDone())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPath GetFromPath(int nIdx) {
        CPath rPath = null;
        Object object = this.m_FromPathCrit;
        synchronized (object) {
            if (this.m_aFromPaths != null && nIdx >= 0 && nIdx < this.m_aFromPaths.size()) {
                rPath = this.m_aFromPaths.get(nIdx);
            }
        }
        return rPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddFromPath(CPath rFromPath) {
        boolean bRet = false;
        if (rFromPath != null && this.m_aFromPaths != null) {
            rFromPath.SetForThread(true);
            Object object = this.m_FromPathCrit;
            synchronized (object) {
                bRet = this.m_aFromPaths.add(rFromPath);
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean RemoveFromPath(CPath rFromPath) {
        boolean bRet = true;
        Object object = this.m_FromPathCrit;
        synchronized (object) {
            if (this.m_aFromPaths != null) {
                bRet = this.m_aFromPaths.remove(rFromPath);
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPath RemoveFromPath(int nIdx) {
        CPath rPath = null;
        Object object = this.m_FromPathCrit;
        synchronized (object) {
            if (this.m_aFromPaths != null && nIdx >= 0 && nIdx < this.m_aFromPaths.size()) {
                rPath = this.m_aFromPaths.remove(nIdx);
            }
        }
        return rPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetFromPathSize() {
        int nSize = 0;
        Object object = this.m_FromPathCrit;
        synchronized (object) {
            if (this.m_aFromPaths != null) {
                nSize = this.m_aFromPaths.size();
            }
        }
        return nSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetFromPathSize(boolean bIncludeDirs) {
        int nSize = 0;
        if (bIncludeDirs) {
            nSize = this.GetFromPathSize();
        } else {
            Object object = this.m_FromPathCrit;
            synchronized (object) {
                if (this.m_aFromPaths != null) {
                    for (int nIdx = 0; nIdx < this.m_aFromPaths.size(); ++nIdx) {
                        CPath rPath = this.m_aFromPaths.get(nIdx);
                        if (rPath == null || rPath.IsDir()) continue;
                        ++nSize;
                    }
                }
            }
        }
        return nSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPath GetToPath(int nIdx) {
        CPath rPath = null;
        Object object = this.m_ToPathCrit;
        synchronized (object) {
            if (this.m_aToPaths != null && nIdx >= 0 && nIdx < this.m_aToPaths.size()) {
                rPath = this.m_aToPaths.get(nIdx);
            }
        }
        return rPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddToPath(CPath rFromPath) {
        boolean bRet = false;
        if (rFromPath != null && this.m_aToPaths != null) {
            rFromPath.SetForThread(true);
            Object object = this.m_ToPathCrit;
            synchronized (object) {
                bRet = this.m_aToPaths.add(rFromPath);
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SetToPath(int nIdx, CPath rToPath) {
        boolean bRet = false;
        if (rToPath != null && this.m_aToPaths != null) {
            rToPath.SetForThread(true);
            Object object = this.m_ToPathCrit;
            synchronized (object) {
                if (nIdx >= 0 && nIdx < this.m_aToPaths.size()) {
                    this.m_aToPaths.set(nIdx, rToPath);
                } else {
                    this.m_aToPaths.add(nIdx, rToPath);
                }
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean RemoveToPath(CPath rFromPath) {
        boolean bRet = true;
        Object object = this.m_ToPathCrit;
        synchronized (object) {
            if (this.m_aToPaths != null) {
                bRet = this.m_aToPaths.remove(rFromPath);
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPath RemoveToPath(int nIdx) {
        CPath rPath = null;
        Object object = this.m_ToPathCrit;
        synchronized (object) {
            if (this.m_aToPaths != null && nIdx >= 0 && nIdx < this.m_aToPaths.size()) {
                rPath = this.m_aToPaths.remove(nIdx);
            }
        }
        return rPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetToPathSize() {
        int nSize = 0;
        Object object = this.m_ToPathCrit;
        synchronized (object) {
            if (this.m_aToPaths != null) {
                nSize = this.m_aToPaths.size();
            }
        }
        return nSize;
    }

    public int GetPathIndex() {
        return this.m_nPathIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetPathIndex(boolean bRemoveDirs) {
        int nRet = this.GetPathIndex();
        if (bRemoveDirs) {
            Vector<CPath> vector = this.m_aFromPaths;
            synchronized (vector) {
                if (this.m_aFromPaths != null) {
                    for (int nIdx = nRet; nIdx >= 0; --nIdx) {
                        CPath rPath = this.m_aFromPaths.get(nIdx);
                        if (rPath == null || !rPath.IsDir()) continue;
                        --nRet;
                    }
                }
            }
        }
        return nRet;
    }

    public boolean SetPathIndex(int nIdx) {
        boolean bChanged = false;
        if (this.m_nPathIdx != nIdx) {
            this.m_nPathIdx = nIdx;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean SetPrepDone(boolean bPrepDone) {
        boolean bChanged = false;
        if (this.m_bPrepDone != bPrepDone) {
            this.m_bPrepDone = bPrepDone;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsPrepDone() {
        return this.m_bPrepDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetFromPaths(CThreadMsgPaths rCopyFrom) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (this.GetFromPathSize() != rCopyFrom.GetFromPathSize()) {
                bChanged = true;
            } else {
                for (int nIdx = 0; nIdx < this.GetFromPathSize() && !bChanged; ++nIdx) {
                    CPath rTest1 = this.GetFromPath(nIdx);
                    CPath rTest2 = rCopyFrom.GetFromPath(nIdx);
                    if (rTest1 != null && rTest2 != null && rTest1.GetPath().equals(rTest2.GetPath())) continue;
                    bChanged = true;
                }
            }
            if (bChanged) {
                Object object = this.m_FromPathCrit;
                synchronized (object) {
                    this.m_aFromPaths = rCopyFrom.m_aFromPaths;
                }
            }
        }
        return bChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetToPaths(CThreadMsgPaths rCopyFrom) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (this.GetToPathSize() != rCopyFrom.GetToPathSize()) {
                bChanged = true;
            } else {
                for (int nIdx = 0; nIdx < this.GetToPathSize() && !bChanged; ++nIdx) {
                    CPath rTest1 = this.GetToPath(nIdx);
                    CPath rTest2 = rCopyFrom.GetToPath(nIdx);
                    if (rTest1 != null && rTest2 != null && rTest1.GetPath().equals(rTest2.GetPath())) continue;
                    bChanged = true;
                }
            }
            if (bChanged) {
                Object object = this.m_ToPathCrit;
                synchronized (object) {
                    this.m_aToPaths = rCopyFrom.m_aToPaths;
                }
            }
        }
        return bChanged;
    }

    protected CWorkerThread GetWorkerThread() {
        CWorkerThread tThread = null;
        if (this.GetThread() instanceof CWorkerThread) {
            tThread = (CWorkerThread)this.GetThread();
        }
        return tThread;
    }

    protected CBaseThread GetBaseThread() {
        CBaseThread tThread = null;
        if (this.GetThread() instanceof CBaseThread) {
            tThread = (CBaseThread)this.GetThread();
        }
        return tThread;
    }
}

