/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.files.WindowsLink.CWindowsLink;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmDirInfoFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CSUConnection;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;

public class CThreadMsgDirSize
extends CThreadMsgList {
    private Dialog m_rDlg;

    public CThreadMsgDirSize(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 33, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgDirSize(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgDirSize) {
            this.Copy((CThreadMsgDirSize)rCopyFrom, false);
        }
    }

    @Override
    public Object clone() {
        return new CThreadMsgDirSize(this);
    }

    @Override
    public boolean Copy(CThreadMsgList rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null && bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
            bChanged = true;
        }
        return bChanged;
    }

    @Override
    public void ProcessEvent() {
        if (this.GetMsgID() == 33) {
            this.OnDirectorySize();
        }
    }

    public int[] GetDirSize(CPath rPath) {
        return this.GetDirSize(this.GetSUConnection(), rPath);
    }

    protected int[] GetDirSize(CSUConnection rSUConn, CPath rPath) {
        int[] anRetCodes = new int[]{503, 1};
        anRetCodes = rPath.IsLocal() ? this.GetDirSizeLocal(rSUConn, rPath) : this.GetDirSizeRemote(rSUConn, rPath);
        return anRetCodes;
    }

    private void OnDirectorySize() {
        this.SetErrorID(0);
        this.SetHTTPCode(503);
        this.SetSUResult(1);
        int nIdx = this.GetPathIndex();
        CPath rPath = this.GetFromPath(nIdx);
        if (rPath != null) {
            int[] anRetCodes = this.GetDirSize(rPath);
            if (anRetCodes != null && anRetCodes.length == 2) {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUResult(anRetCodes[1]);
            }
            if (this.GetCancel()) {
                if (DEBUG) {
                    System.out.println("CThreadMsg.OnGetDirInfo | Cancelled");
                }
                this.PostEvent(3020, this);
            } else {
                if (DEBUG) {
                    System.out.printf("CThreadMsg.OnGetDirInfo | RetCodes: %d, %d\r\n", this.GetHTTPCode(), this.GetSUResult());
                }
                if (this.GetHTTPCode() == 200 && this.GetSUResult() == 0) {
                    this.PostEvent(3021, this.clone());
                } else {
                    this.SetErrorID(31);
                    this.PostEvent(3005, this);
                }
            }
        }
    }

    protected int[] GetDirSizeLocal(CSUConnection rSUConn, CPath rPath) {
        if (DEBUG) {
            System.out.println("CThreadMsgDirInfo.GetDirInfoLocal -->");
        }
        int[] anRetCodes = new int[]{200, 1};
        File fFile = null;
        Object afFiles = null;
        if (rPath != null) {
            fFile = this.GetJavaFile(rPath.GetPath());
        }
        if (fFile != null && fFile.exists()) {
            String sAbsPath = rPath.GetPath();
            if (sAbsPath != null && sAbsPath.endsWith("lnk")) {
                CWindowsLink link = new CWindowsLink(sAbsPath);
                String sResolvedPath = link.GetResolvedPath();
                fFile = sResolvedPath != null && !sResolvedPath.isEmpty() ? new File(sResolvedPath) : null;
            }
            if (fFile == null || !fFile.exists()) {
                anRetCodes[1] = 33;
            }
        } else {
            anRetCodes[1] = 33;
        }
        if (DEBUG) {
            System.out.println("CThreadMsgDirInfo.GetDirInfoLocal <--");
        }
        return anRetCodes;
    }

    protected int[] GetDirSizeRemote(CSUConnection rSUConn, CPath rPath) {
        if (DEBUG) {
            System.out.println("CThreadMsgDirInfo.GetDirInfoRemote -->");
        }
        int[] anRetCodes = new int[]{503, 1};
        if (rSUConn != null) {
            if (rPath.IsDir()) {
                anRetCodes = rSUConn.SendGetDirectorySize(rPath.GetPath());
            } else {
                anRetCodes[0] = 200;
                anRetCodes[1] = 14;
            }
        }
        if (DEBUG) {
            System.out.println("CThreadMsgDirInfo.GetDirInfoRemote <--");
        }
        return anRetCodes;
    }

    public long GetDirectorySize() {
        long lSize = 0L;
        if (this.GetSUConnection() != null) {
            lSize = this.GetSUConnection().GetDirSize();
        }
        return lSize;
    }

    @Override
    protected void ProcessError() {
        super.ProcessError();
        switch (this.GetErrorID()) {
            case 31: {
                CPath rFromPath = this.GetFromPath(this.GetPathIndex());
                this.OnConfirmFailedToGetDirInfo(rFromPath);
                break;
            }
            default: {
                super.ProcessError();
            }
        }
    }

    protected void OnConfirmFailedToGetDirInfo(CPath rListPath) {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && rListPath != null) {
            String sDetails;
            long lThreadID = this.GetThread().getId();
            CConfirmDirInfoFailedDlg dlg = null;
            dlg = this.GetOwnerDlg() != null ? new CConfirmDirInfoFailedDlg(this.GetOwnerDlg(), true, lThreadID) : new CConfirmDirInfoFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_DIR_INFO_FAILED_DEF_MSG");
            sMsg = this.GetSUResult() == 3 ? String.format(CString.LoadString("IDS_CONFIRM_DIR_INFO_FAILED_FMT_MSG_PERM_DENIED"), rListPath.GetPath()) : String.format(CString.LoadString("IDS_CONFIRM_DIR_INFO_FAILED_FMT_MSG"), rListPath.GetPath());
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            if (!rListPath.IsLocal()) {
                sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
                sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            } else {
                sDetails = String.format("%s\r\n\r\n%s", CThreadMsgDirSize.GetSUError(this.GetSUResult()), CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            }
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    public Dialog GetOwnerDlg() {
        return this.m_rDlg;
    }

    public void SetOwnerDlg(Dialog rDlg) {
        this.m_rDlg = rDlg;
    }
}

