/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmCreateDirFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import java.awt.Frame;

public abstract class CThreadMsgCreateDir
extends CThreadMsgList {
    private boolean m_bEnterRenameMode = false;

    public CThreadMsgCreateDir(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType, boolean bWhenDoneEnterRename) {
        super(tThread, 10, rSource, rClientInfo, nCompressionType);
        this.InitVars(bWhenDoneEnterRename);
    }

    protected CThreadMsgCreateDir(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgCreateDir) {
            this.Copy((CThreadMsgCreateDir)rCopyFrom, false);
        }
    }

    protected abstract int[] CreateDir(CPath var1);

    private void InitVars(boolean bWhenDoneEnterRename) {
        this.m_bEnterRenameMode = bWhenDoneEnterRename;
    }

    public boolean Copy(CThreadMsgCreateDir rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null && bCallSuper) {
            if (super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetEnterRenameMode(rCopyFrom.GetEnterRenameMode())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    @Override
    public void ProcessEvent() {
        this.OnCreateDir();
    }

    private void OnCreateDir() {
        boolean bContinue = true;
        for (int nIdx = this.GetPathIndex(); nIdx < this.GetFromPathSize() && bContinue && !this.GetCancel(); ++nIdx) {
            int[] anRetCodes;
            this.SetErrorID(0);
            this.SetHTTPCode(503);
            this.SetSUResult(1);
            this.SetPathIndex(nIdx);
            CPath rDestinationPath = this.GetFromPath(nIdx);
            CPath rToPath = this.GetToPath(nIdx);
            if (rDestinationPath != null && (anRetCodes = this.CreateDir(rDestinationPath)) != null && anRetCodes.length == 2) {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUResult(anRetCodes[1]);
            }
            if (this.GetHTTPCode() == 200 && this.GetSUResult() == 0) {
                this.PostEvent(3021, this);
                continue;
            }
            this.SetErrorID(70);
            this.PostEvent(3005, this);
            bContinue = false;
        }
    }

    @Override
    protected void ProcessError() {
        switch (this.GetErrorID()) {
            case 70: {
                this.OnConfirmFailedToCreateDir();
                break;
            }
            default: {
                if (!DEBUG) break;
                System.out.println("Unhandled error | CThreadMsgDelete.ProcessError");
            }
        }
    }

    private void OnConfirmFailedToCreateDir() {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null) {
            String sDetails;
            long lThreadID = this.GetThread().getId();
            CConfirmCreateDirFailedDlg dlg = new CConfirmCreateDirFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_CREATE_DIR_FAILED_DEF_MSG");
            CPath rCreateDirPath = this.GetFromPath(this.GetPathIndex());
            if (rCreateDirPath != null) {
                sMsg = this.GetSUResult() == 3 ? String.format(CString.LoadString("IDS_CONFIRM_CREATE_DIR_FAILED_FMT_MSG_PERM_DENIED"), rCreateDirPath.GetPath()) : String.format(CString.LoadString("IDS_CONFIRM_CREATE_DIR_FAILED_FMT_MSG"), rCreateDirPath.GetPath());
            }
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            if (rCreateDirPath != null && !rCreateDirPath.IsLocal()) {
                sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
                sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            } else {
                sDetails = String.format("%s\r\n\r\n%s", CThreadMsgCreateDir.GetSUError(this.GetSUResult()), CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            }
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    public boolean SetEnterRenameMode(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bEnterRenameMode != bVal) {
            bChanged = true;
            this.m_bEnterRenameMode = bVal;
        }
        return bChanged;
    }

    public boolean GetEnterRenameMode() {
        return this.m_bEnterRenameMode;
    }
}

