/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThread;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.docking.fvjv.search.CSearchEvent;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CHistoryItem;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgDelete;
import com.rhinosoft.fvjv.threads.CThreadMsgDirSize;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import com.rhinosoft.fvjv.threads.CThreadMsgRename;
import com.rhinosoft.fvjv.threads.CThreadMsgSearch;
import com.rhinosoft.fvjv.threads.CThreadMsgSpaceAvailable;
import com.rhinosoft.fvjv.threads.CThreadMsgThumb;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;

public abstract class CBaseThread
extends CWorkerThread {
    public static final int SESS_GUI_HAS_BEEN_NOTIFIED = -5;
    public static boolean DEBUG_THROTTLING = DEBUG;
    private static final int THROTTLE_MAX = 10;
    private static final int THROTTLE_MIN = 5;
    private boolean m_bConfirmOverwrite = true;
    private boolean m_bConfirmDelete = true;
    private int m_nThrottleCount;
    private int m_nPathIndex;
    private boolean m_bPaused;
    private CWorkerThreadID m_rPauseMsg;
    private boolean m_bSearchLinkTargets;

    public CBaseThread(Component rcEventSource, String sThreadName) {
        super(rcEventSource, sThreadName);
        this.InitVars();
    }

    private void InitVars() {
        this.m_nThrottleCount = 0;
        this.m_nPathIndex = 0;
        this.m_bPaused = false;
        this.m_rPauseMsg = null;
        this.m_bSearchLinkTargets = false;
    }

    public static String FmtDestinationPath(String sAbsFrom, String sAbsFromFile, String sAbsTo, boolean bRetFileSeparators) {
        String sRet = null;
        if (sAbsFrom != null && sAbsFromFile != null && sAbsTo != null) {
            sAbsFrom = CString.MakeForwardSlashes(sAbsFrom);
            sAbsFromFile = CString.MakeForwardSlashes(sAbsFromFile);
            sAbsTo = CString.MakeForwardSlashes(sAbsTo);
            sAbsFrom = CString.EnsureLastCharIsAForwardSlash(sAbsFrom);
            sAbsTo = CString.EnsureLastCharIsAForwardSlash(sAbsTo);
            if (sAbsFromFile.startsWith(sAbsFrom)) {
                String sTemp = sAbsFromFile.substring(sAbsFrom.length());
                sAbsTo = sAbsTo + sTemp;
                if (bRetFileSeparators) {
                    sAbsTo = sAbsTo.replace('/', File.separatorChar);
                }
                sRet = sAbsTo;
            }
        }
        return sRet;
    }

    @Override
    public void PostMessage(CWorkerThreadID rMsg) {
        if (rMsg != null) {
            int nMsgID = rMsg.GetMsgID();
            if (nMsgID == 31) {
                this.m_AsynchQueue.Clear();
                this.CancelCurrentOperation();
                this.m_AsynchQueue.AddHead(rMsg);
            } else {
                super.PostMessage(rMsg);
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rMsg = null");
        }
    }

    protected abstract CThreadMsgList CreateThreadMsgList(Thread var1, Object var2, CClientInfo var3, int var4);

    public boolean PostListDir(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath rListPath, boolean bIsSetWorkingDir, boolean bExpandTreeNode, boolean bRenameTreeNode, CHistoryItem rHistoryItem, CFile fListFile, boolean bRelayToLockNav) {
        boolean bRet = false;
        CThreadMsgList msg = this.CreateThreadMsgList(this, rSource, rClientInfo, nCompressionType);
        if (msg != null) {
            msg.SetIsSetWorkingDir(bIsSetWorkingDir);
            msg.SetExpandTreeNode(bExpandTreeNode);
            msg.SetRenameTreeNode(bRenameTreeNode);
            msg.SetHistoryItem(rHistoryItem);
            msg.SetRelayToLockNav(bRelayToLockNav);
            msg.AddFromPath(rListPath);
            msg.SetPathIndex(0);
            msg.SetListFile(fListFile);
            this.PostMessage(msg);
            bRet = true;
        }
        return bRet;
    }

    public boolean PostListWorkingDir(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath rPath, boolean bExpandTreeNode, boolean bRenameTreeNode, CHistoryItem rHistoryItem, CFile fListFile, boolean bRelayToLockNav) {
        return this.PostListDir(rSource, rClientInfo, nCompressionType, rPath, true, bExpandTreeNode, bRenameTreeNode, rHistoryItem, fListFile, bRelayToLockNav);
    }

    public abstract boolean PostCopyFiles(Object var1, CClientInfo var2, int var3, String var4, String var5, CPath[] var6, boolean var7);

    protected abstract CThreadMsgThumb CreateThreadMsgThumb(Thread var1, Object var2, CClientInfo var3, int var4, int var5, int var6, boolean var7);

    public boolean PostDownloadThumbs(Object rSource, CClientInfo rClientInfo, int nCompressionType, String sAbsFromPath, String sAbsToPath, CPath[] aTransferPaths, int nThumbWidth, int nThumbHeight, boolean bIsPreview, boolean bCancelAllJobs) {
        if (bCancelAllJobs) {
            this.CancelAllJobs();
        }
        boolean bRet = false;
        CThreadMsgThumb rMsg = this.CreateThreadMsgThumb(this, rSource, rClientInfo, nCompressionType, nThumbWidth, nThumbHeight, bIsPreview);
        if (rMsg != null) {
            rMsg.SetTransferFromPath(sAbsFromPath);
            rMsg.SetTransferToPath(sAbsToPath);
            if (aTransferPaths != null) {
                for (int nIdx = 0; nIdx < aTransferPaths.length; ++nIdx) {
                    rMsg.AddFromPath(aTransferPaths[nIdx]);
                }
            }
            rMsg.SetPathIndex(0);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    public abstract boolean PostDownloadFiles(Object var1, CClientInfo var2, int var3, String var4, String var5, CPath[] var6, boolean var7, boolean var8, boolean var9);

    public abstract boolean PostUploadFiles(Object var1, CClientInfo var2, int var3, String var4, String var5, CPath[] var6, boolean var7, boolean var8);

    public boolean PostDeleteFiles(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath[] arDeletePaths) {
        boolean bRet = false;
        CThreadMsgDelete rMsg = this.CreateThreadMsgDelete(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            if (arDeletePaths != null) {
                for (int nIdx = 0; nIdx < arDeletePaths.length; ++nIdx) {
                    rMsg.AddFromPath(arDeletePaths[nIdx]);
                }
            }
            rMsg.SetPathIndex(0);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    protected abstract CThreadMsgDelete CreateThreadMsgDelete(Thread var1, Object var2, CClientInfo var3, int var4);

    public boolean PostCreateDirs(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath[] arCreatePaths, boolean bWhenDoneEnterRename) {
        boolean bRet = false;
        CThreadMsgCreateDir rMsg = this.CreateThreadMsgCreateDir(this, rSource, rClientInfo, nCompressionType, bWhenDoneEnterRename);
        if (rMsg != null) {
            if (arCreatePaths != null) {
                for (int nIdx = 0; nIdx < arCreatePaths.length; ++nIdx) {
                    rMsg.AddFromPath(arCreatePaths[nIdx]);
                }
            }
            rMsg.SetPathIndex(0);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    protected abstract CThreadMsgCreateDir CreateThreadMsgCreateDir(Thread var1, Object var2, CClientInfo var3, int var4, boolean var5);

    public boolean PostRenamePaths(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath[] arFromPaths, CPath[] arToPaths) {
        boolean bRet = false;
        CThreadMsgRename rMsg = this.CreateThreadMsgRename(this, rSource, rClientInfo, nCompressionType);
        if (rMsg != null) {
            int nIdx;
            if (arFromPaths != null) {
                for (nIdx = 0; nIdx < arFromPaths.length; ++nIdx) {
                    rMsg.AddFromPath(arFromPaths[nIdx]);
                }
            }
            if (arToPaths != null) {
                for (nIdx = 0; nIdx < arToPaths.length; ++nIdx) {
                    rMsg.AddToPath(arToPaths[nIdx]);
                }
            }
            rMsg.SetPathIndex(0);
            this.PostMessage(rMsg);
            bRet = true;
        }
        return bRet;
    }

    protected abstract CThreadMsgRename CreateThreadMsgRename(Thread var1, Object var2, CClientInfo var3, int var4);

    public synchronized boolean SetConfirmOverwrite(boolean bConfirmOverwrite) {
        boolean bChanged = false;
        if (this.m_bConfirmOverwrite != bConfirmOverwrite) {
            this.m_bConfirmOverwrite = bConfirmOverwrite;
            bChanged = true;
        }
        return bChanged;
    }

    protected synchronized boolean GetConfirmOverwrite() {
        return this.m_bConfirmOverwrite;
    }

    public synchronized boolean SetConfirmDelete(boolean bConfirmDelete) {
        boolean bChanged = false;
        if (this.m_bConfirmDelete != bConfirmDelete) {
            this.m_bConfirmDelete = bConfirmDelete;
            bChanged = true;
        }
        return bChanged;
    }

    protected synchronized boolean GetConfirmDelete() {
        return this.m_bConfirmDelete;
    }

    public boolean PostSearch(Object rSource, CClientInfo rClientInfo, int nCompressionType, CFile rRootDir, String sSearchFilter, CSearchEvent.DATE_TYPE nDateType, CSearchEvent.DATE_CONTEXT nDateContext, long lSearchDate, CSearchEvent.SIZE_CONTEXT nSizeContext, long lSearchFileSize, int nBitmaskFileAttribs, int nDirAndFilesOpt) {
        boolean bRet = false;
        CThreadMsgSearch msg = new CThreadMsgSearch(this, rSource, rClientInfo, nCompressionType);
        if (msg != null) {
            msg.SetRootDir(rRootDir.clone());
            msg.SetPathIndex(0);
            msg.SetIsRecvItemDone(false);
            msg.SetSearchFilter(sSearchFilter);
            msg.SetDateType(nDateType);
            msg.SetDateContext(nDateContext);
            msg.SetSearchDate(lSearchDate);
            msg.SetSizeContext(nSizeContext);
            msg.SetSearchSize(lSearchFileSize);
            msg.SetBitmaskFileAttribs(nBitmaskFileAttribs);
            msg.SetDirAndFilesOpt(nDirAndFilesOpt);
            this.SetCancel(false);
            this.SetIsPaused(false);
            this.PostMessage(msg);
            bRet = true;
        }
        return bRet;
    }

    public boolean PostSearchItemDone(CThreadMsgSearch rThreadMsg) {
        CThreadMsgSearch msg;
        boolean bRet = false;
        if (rThreadMsg != null && (msg = (CThreadMsgSearch)rThreadMsg.clone()) != null) {
            msg.SetIsRecvItemDone(true);
            this.PostMessage(msg);
            bRet = true;
        }
        return bRet;
    }

    public int GetThrottleCount() {
        return this.m_nThrottleCount;
    }

    public boolean SetThrottleCount(int nThrottleCount) {
        boolean bChanged = false;
        if (this.m_nThrottleCount != nThrottleCount) {
            bChanged = true;
            this.m_nThrottleCount = nThrottleCount;
        }
        if (DEBUG) {
            System.out.printf("ThrottleCount: %d\r\n", this.m_nThrottleCount);
            if (this.m_nThrottleCount < 0) {
                String sErr = "Throttle count cannot be less than 0.  Something is seriously wrong.";
                JOptionPane.showConfirmDialog(null, sErr);
            }
        }
        return bChanged;
    }

    public void IncThrottleCount() {
        int nThrottleCount = this.GetThrottleCount();
        this.SetThrottleCount(++nThrottleCount);
    }

    public void DecThrottleCount() {
        int nThrottleCount = this.GetThrottleCount();
        this.SetThrottleCount(--nThrottleCount);
    }

    public boolean CheckExceedsThrottleCount() {
        if (DEBUG_THROTTLING && this.m_nThrottleCount >= 10) {
            System.out.printf("CThreadMsgSearch.CheckExceedsThrottleCount | PathIndex: %d\r\n", this.GetPathIndex());
        }
        return this.m_nThrottleCount >= 10;
    }

    public boolean CheckResumeThrottleCount() {
        return this.m_nThrottleCount <= 5;
    }

    public boolean SetPathIndex(int nIndex) {
        boolean bChanged = false;
        if (this.m_nPathIndex != nIndex) {
            bChanged = true;
            this.m_nPathIndex = nIndex;
        }
        return bChanged;
    }

    public int GetPathIndex() {
        return this.m_nPathIndex;
    }

    public synchronized boolean IsPaused() {
        return this.m_bPaused;
    }

    public synchronized void SetIsPaused(boolean bIsPaused) {
        this.m_bPaused = bIsPaused;
    }

    public void PauseThread() {
        this.SetIsPaused(true);
    }

    public void ResumeThread() {
        this.SetIsPaused(false);
        this.PostMessage(this.GetPauseMsg());
    }

    protected void SetPauseMsg(CWorkerThreadID rPausedMsg) {
        this.m_rPauseMsg = rPausedMsg;
    }

    protected CWorkerThreadID GetPauseMsg() {
        return this.m_rPauseMsg;
    }

    protected boolean CheckPaused() {
        boolean bIsPaused = this.IsPaused();
        if (bIsPaused) {
            this.SetPauseMsg(this.GetCurrentMsg());
        }
        return bIsPaused;
    }

    public synchronized boolean SetSearchLinkTargets(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bSearchLinkTargets != bVal) {
            this.m_bSearchLinkTargets = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public synchronized boolean GetSearchLinkTargets() {
        return this.m_bSearchLinkTargets;
    }

    protected CThreadMsgDirSize CreateThreadMsgGetDirectorySize(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        CThreadMsgDirSize rDirInfo = new CThreadMsgDirSize(tThread, rSource, rClientInfo, nCompressionType);
        return rDirInfo;
    }

    protected CThreadMsgSpaceAvailable CreateThreadMsgGetSpaceAvailable(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        CThreadMsgSpaceAvailable rDirInfo = new CThreadMsgSpaceAvailable(tThread, rSource, rClientInfo, nCompressionType);
        return rDirInfo;
    }

    public boolean PostGetDirectorySize(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath rListPath) {
        boolean bRet = false;
        CThreadMsgDirSize msg = this.CreateThreadMsgGetDirectorySize(this, rSource, rClientInfo, nCompressionType);
        if (msg != null) {
            msg.AddFromPath(rListPath);
            msg.SetPathIndex(0);
            this.PostMessage(msg);
            bRet = true;
        }
        return bRet;
    }

    public boolean PostGetSpaceAvailable(Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath rListPath) {
        boolean bRet = false;
        CThreadMsgSpaceAvailable msg = this.CreateThreadMsgGetSpaceAvailable(this, rSource, rClientInfo, nCompressionType);
        if (msg != null) {
            msg.AddFromPath(rListPath);
            msg.SetPathIndex(0);
            this.PostMessage(msg);
            bRet = true;
        }
        return bRet;
    }
}

