/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.strings;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CStringTable {
    public static final boolean DEBUG;
    private String m_sBundlePath;
    private Locale m_UserLocale;
    private ResourceBundle m_ResourceBundle;

    public CStringTable(String sBundlePath, String sLanguageCode, String sCountryCode) {
        Locale rResourceBundleLocale;
        block7: {
            this.InitVars();
            this.SetBundlePath(sBundlePath);
            rResourceBundleLocale = null;
            try {
                this.m_UserLocale = new Locale(sLanguageCode, sCountryCode);
                if (this.m_UserLocale == null) {
                    this.m_UserLocale = Locale.getDefault();
                }
                if (this.m_UserLocale == null) {
                    this.m_UserLocale = new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                }
                rResourceBundleLocale = this.m_UserLocale;
                String sLang = sLanguageCode.toLowerCase();
                rResourceBundleLocale = sLang.equals("zh") && sCountryCode.toLowerCase().equals("tw") ? this.m_UserLocale : (sLang.equals("en") || sLang.equals("de") || sLang.equals("es") || sLang.equals("fr") || sLang.equals("it") || sLang.equals("ja") || sLang.equals("ru") || sLang.equals("zh") || sLang.equals("sr") ? new Locale(sLanguageCode) : Locale.ENGLISH);
                if (rResourceBundleLocale == null) {
                    rResourceBundleLocale = Locale.getDefault();
                }
                if (rResourceBundleLocale == null) {
                    rResourceBundleLocale = new Locale(Locale.ENGLISH.getLanguage());
                }
                if (DEBUG) {
                    System.out.printf("Loading Locale: %s,%s\r\n", sLanguageCode, sCountryCode);
                    System.out.printf("English Locale: %s, %s\r\n", Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block7;
                System.out.printf("Failed to load Locale: %s,%s\r\n", sLanguageCode, sCountryCode);
                System.out.printf("English Locale: %s, %s\r\n", Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                e.printStackTrace();
            }
        }
        this.LoadStringsFromResourceBundle(this.GetBundlePath(), rResourceBundleLocale);
    }

    private void InitVars() {
        this.m_UserLocale = Locale.US;
    }

    private boolean LoadStringsFromResourceBundle(String sBundlePath, Locale rLocale) {
        boolean bLoaded = false;
        if (sBundlePath != null && rLocale != null) {
            try {
                this.m_ResourceBundle = ResourceBundle.getBundle(sBundlePath, rLocale, new ResourceBundle.Control(){

                    @Override
                    public List<String> getFormats(String baseName) {
                        if (baseName == null) {
                            throw new NullPointerException();
                        }
                        return Arrays.asList("java.properties");
                    }

                    @Override
                    public List<Locale> getCandidateLocales(String baseName, Locale locale) {
                        if (baseName == null) {
                            throw new NullPointerException();
                        }
                        List<Locale> aLocaleList = null;
                        aLocaleList = locale.equals(new Locale("zh", "TW")) ? Arrays.asList(locale, Locale.CHINESE, Locale.ENGLISH, Locale.ROOT) : super.getCandidateLocales(baseName, locale);
                        return aLocaleList;
                    }
                });
                if (DEBUG) {
                    System.out.printf("Loaded ResourceBundle: Path: %s | Locale: %s,%s\r\n", sBundlePath, rLocale.getLanguage(), rLocale.getCountry());
                }
                bLoaded = true;
            }
            catch (MissingResourceException exc) {
                this.m_ResourceBundle = null;
                if (DEBUG) {
                    System.out.printf("Failed to load ResourceBundle: Path: %s | Locale: %s,%s\r\n", sBundlePath, rLocale.getLanguage(), rLocale.getCountry());
                    exc.printStackTrace();
                }
            }
        } else if (DEBUG) {
            CUtils.ASSERT(CStringTable.class.getName(), CUtils.GetLineNumber(), "Failed to load string resources.", false);
        }
        return bLoaded;
    }

    public Locale GetUserLocale() {
        return this.m_UserLocale;
    }

    protected String GetBundlePath() {
        return this.m_sBundlePath;
    }

    protected void SetBundlePath(String sBundlePath) {
        this.m_sBundlePath = sBundlePath;
    }

    public String GetString(String sKey) {
        String sVal = sKey;
        if (this.m_ResourceBundle != null) {
            sVal = this.m_ResourceBundle.getString(sKey);
        }
        return sVal;
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG = false;
    }
}

