/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.strings;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public abstract class CString {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final String RELATIVE_DIR_CURRENT = ".\\";
    public static final String RELATIVE_DIR_PARENT = "..\\";
    public static final boolean OK = true;
    public static final boolean FAIL = false;
    public static final int NOT_FOUND = -1;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static final long ONE_SECOND_FROM_MILLIS = 1000L;
    public static final long ONE_MINUTE_FROM_MILLIS = 60000L;
    public static final long ONE_HOUR_FROM_MILLIS = 3600000L;
    public static final long FORMAT_BYTE_MAX = 10000L;
    public static final long FORMAT_KB_MAX = 10000000L;
    public static final long FORMAT_MB_MAX = 1000000000L;
    public static final long FORMAT_GB_MAX = 1000000000000L;
    private static final char m_chMnemonicIdentifier = '&';

    public static String LoadString(String sResourceID) {
        return CString.LoadString(sResourceID, true);
    }

    public static String LoadString(String sResourceID, boolean bRemoveMnemonic) {
        String sTranslation = CMainFrame.GetString(sResourceID);
        if (bRemoveMnemonic) {
            sTranslation = CString.RemoveMnemonic(sTranslation);
        }
        return sTranslation;
    }

    public static Character GetMnemonic(String sTest) {
        int nLoc;
        Character chMnemonic = null;
        if (sTest != null && CString.IsValidMnemonicLoc(nLoc = CString.GetMnemonicLoc(sTest), sTest)) {
            chMnemonic = Character.valueOf(sTest.charAt(nLoc + 1));
        }
        return chMnemonic;
    }

    public static int GetMnemonicLoc(String sTest) {
        int nLoc = -1;
        if (sTest != null) {
            nLoc = sTest.indexOf(38);
        }
        return nLoc;
    }

    public static boolean IsValidMnemonicLoc(int nLoc, String sTest) {
        boolean bIsValid = false;
        if (sTest != null && nLoc >= 0 && nLoc < sTest.length()) {
            bIsValid = true;
        }
        return bIsValid;
    }

    public static String RemoveMnemonic(String sTest) {
        if (sTest != null) {
            StringBuilder sBuilder = new StringBuilder();
            for (int nNext = 0; nNext < sTest.length(); ++nNext) {
                char chNextChar = sTest.charAt(nNext);
                if (chNextChar == '&') continue;
                sBuilder.append(chNextChar);
            }
            return sBuilder.toString();
        }
        return sTest;
    }

    public static String EnsureFirstChar(Character chFirst, String sTest) {
        String sRet = sTest;
        if (sRet != null && chFirst != null) {
            StringBuilder sbBuilder = new StringBuilder(sRet);
            if (!sRet.isEmpty()) {
                if (chFirst.compareTo(Character.valueOf(sbBuilder.charAt(0))) != 0) {
                    sbBuilder.insert(0, chFirst);
                }
            } else {
                sbBuilder.append(chFirst);
            }
            sRet = sbBuilder.toString();
        }
        return sRet;
    }

    public static String EnsureLastChar(Character chLast, String sTest) {
        String sRet = sTest;
        if (sRet != null && chLast != null) {
            StringBuilder sbBuilder = new StringBuilder(sRet);
            if (!sRet.isEmpty()) {
                int nLastLoc = sbBuilder.length() - 1;
                if (chLast.compareTo(Character.valueOf(sbBuilder.charAt(nLastLoc))) != 0) {
                    sbBuilder.append(chLast);
                }
            } else {
                sbBuilder.append(chLast);
            }
            sRet = sbBuilder.toString();
        }
        return sRet;
    }

    public static String EnsureNotFirstChar(Character chFirst, String sTest) {
        if (sTest != null && sTest.length() > 0) {
            StringBuilder sbBuilder = new StringBuilder(sTest);
            if (chFirst.compareTo(Character.valueOf(sbBuilder.charAt(0))) == 0) {
                sbBuilder.deleteCharAt(0);
            }
            return sbBuilder.toString();
        }
        return sTest;
    }

    public static String EnsureNotLastChar(Character chLast, String sTest) {
        if (sTest != null && sTest.length() > 0) {
            StringBuilder sbBuilder = new StringBuilder(sTest);
            int nLastLoc = sTest.length() - 1;
            if (chLast.compareTo(Character.valueOf(sbBuilder.charAt(nLastLoc))) == 0) {
                sbBuilder.deleteCharAt(nLastLoc);
            }
            return sbBuilder.toString();
        }
        return sTest;
    }

    public static String MakeForwardSlashes(String sTest) {
        if (sTest != null) {
            sTest = sTest.replace('\\', '/');
        }
        return sTest;
    }

    public static String MakeBackSlashes(String sTest) {
        if (sTest != null) {
            sTest = sTest.replace('/', '\\');
        }
        return sTest;
    }

    public static String EnsureFirstSubString(String sSubString, String sTest) {
        if (sTest != null && !sTest.startsWith(sSubString)) {
            StringBuilder sbTemp = new StringBuilder(sTest);
            sbTemp.insert(0, sSubString);
            return sbTemp.toString();
        }
        return sTest;
    }

    public static String EnsureLastSubString(String sSubString, String sTest) {
        if (sTest != null && !sTest.endsWith(sSubString)) {
            StringBuilder sbTemp = new StringBuilder(sTest);
            sbTemp.append(sSubString);
            return sbTemp.toString();
        }
        return sTest;
    }

    public static String EnsureNotFirstSubString(String sSubString, String sTest) {
        if (sTest != null && sTest.startsWith(sSubString)) {
            StringBuilder sbTemp = new StringBuilder(sTest);
            sbTemp.delete(0, sSubString.length());
            return sbTemp.toString();
        }
        return sTest;
    }

    public static String EnsureNotLastSubString(String sSubString, String sTest) {
        if (sTest != null && sTest.endsWith(sSubString)) {
            StringBuilder sbTemp = new StringBuilder(sTest);
            sbTemp.delete(sTest.length() - sSubString.length(), sTest.length());
            return sbTemp.toString();
        }
        return sTest;
    }

    public static String EnsureFirstCharIsABackSlash(String sTest) {
        return CString.EnsureFirstChar(Character.valueOf('\\'), sTest);
    }

    public static StringBuilder EnsureFirstCharIsABackSlash(StringBuilder sbTest) {
        return CString.EnsureFirstChar(Character.valueOf('\\'), sbTest);
    }

    public static String EnsureFirstCharIsAForwardSlash(String sTest) {
        return CString.EnsureFirstChar(Character.valueOf('/'), sTest);
    }

    public static StringBuilder EnsureFirstCharIsAForwardSlash(StringBuilder sbTest) {
        return CString.EnsureFirstChar(Character.valueOf('/'), sbTest);
    }

    public static String EnsureFirstCharIsNotAForwardSlash(String sTest) {
        return CString.EnsureNotFirstChar(Character.valueOf('/'), sTest);
    }

    public static StringBuilder EnsureFirstCharIsNotAForwardSlash(StringBuilder sbTest) {
        return CString.EnsureNotFirstChar(Character.valueOf('/'), sbTest);
    }

    public static String EnsureFirstCharIsNotABackSlash(String sTest) {
        return CString.EnsureNotFirstChar(Character.valueOf('\\'), sTest);
    }

    public static StringBuilder EnsureFirstCharIsNotABackSlash(StringBuilder sbTest) {
        return CString.EnsureNotFirstChar(Character.valueOf('\\'), sbTest);
    }

    public static String EnsureLastCharIsABackSlash(String sTest) {
        return CString.EnsureLastChar(Character.valueOf('\\'), sTest);
    }

    public static StringBuilder EnsureLastCharIsABackSlash(StringBuilder sbTest) {
        return CString.EnsureLastChar(Character.valueOf('\\'), sbTest);
    }

    public static String EnsureLastCharIsAForwardSlash(String sTest) {
        return CString.EnsureLastChar(Character.valueOf('/'), sTest);
    }

    public static StringBuilder EnsureLastCharIsAForwardSlash(StringBuilder sbTest) {
        return CString.EnsureLastChar(Character.valueOf('/'), sbTest);
    }

    public static String EnsureLastCharIsNotAForwardSlash(String sTest) {
        return CString.EnsureNotLastChar(Character.valueOf('/'), sTest);
    }

    public static StringBuilder EnsureLastCharIsNotAForwardSlash(StringBuilder sbTest) {
        return CString.EnsureNotLastChar(Character.valueOf('/'), sbTest);
    }

    public static String EnsureLastCharIsNotABackSlash(String sTest) {
        return CString.EnsureNotLastChar(Character.valueOf('\\'), sTest);
    }

    public static StringBuilder EnsureLastCharIsNotABackSlash(StringBuilder sbTest) {
        return CString.EnsureNotLastChar(Character.valueOf('\\'), sbTest);
    }

    public static String EnsureFirstCharIsNotASlash(String sTest) {
        sTest = CString.EnsureNotFirstChar(Character.valueOf('\\'), sTest);
        sTest = CString.EnsureNotFirstChar(Character.valueOf('/'), sTest);
        return sTest;
    }

    public static StringBuilder EnsureFirstCharIsNotASlash(StringBuilder sbTest) {
        sbTest = CString.EnsureNotFirstChar(Character.valueOf('\\'), sbTest);
        sbTest = CString.EnsureNotFirstChar(Character.valueOf('/'), sbTest);
        return sbTest;
    }

    public static String EnsureLastCharIsNotASlash(String sTest) {
        sTest = CString.EnsureNotLastChar(Character.valueOf('\\'), sTest);
        sTest = CString.EnsureNotLastChar(Character.valueOf('/'), sTest);
        return sTest;
    }

    public static StringBuilder EnsureLastCharIsNotASlash(StringBuilder sbTest) {
        sbTest = CString.EnsureNotLastChar(Character.valueOf('\\'), sbTest);
        sbTest = CString.EnsureNotLastChar(Character.valueOf('/'), sbTest);
        return sbTest;
    }

    public static String EnsureFirstCharIsAFileSeparator(String sTest) {
        return CString.EnsureFirstChar(Character.valueOf(File.separatorChar), sTest);
    }

    public static String EnsureLastCharIsAFileSeparator(String sTest) {
        return CString.EnsureLastChar(Character.valueOf(File.separatorChar), sTest);
    }

    public static StringBuilder EnsureLastCharIsAFileSeparator(StringBuilder sbTest) {
        return CString.EnsureLastChar(Character.valueOf(File.separatorChar), sbTest);
    }

    public static int Find(Character chFind, String sTest, boolean bIgnoreCase) {
        return CString.Find(chFind.toString(), sTest, bIgnoreCase);
    }

    public static int Find(String sFind, String sTest, boolean bIgnoreCase) {
        int nFoundAt = -1;
        String sTest1 = sFind;
        String sTest2 = sTest;
        if (sTest1 != null && sTest2 != null) {
            sTest1 = sTest1.trim();
            sTest2 = sTest2.trim();
            if (sTest1.length() > 0 && sTest2.length() > 0) {
                if (bIgnoreCase) {
                    sTest1 = sTest1.toUpperCase();
                    sTest2 = sTest2.toUpperCase();
                }
                nFoundAt = sTest2.indexOf(sTest1);
            }
        }
        return nFoundAt;
    }

    public static int ReverseFind(Character chFind, String sTest) {
        return CString.ReverseFind(chFind.toString(), sTest, false);
    }

    public static int ReverseFind(Character chFind, String sTest, boolean bIgnoreCase) {
        return CString.ReverseFind(chFind.toString(), sTest, bIgnoreCase);
    }

    public static int ReverseFind(String sFind, String sTest, boolean bIgnoreCase) {
        int nFoundAt = -1;
        String sTest1 = sFind;
        String sTest2 = sTest;
        if (sTest1 != null && sTest2 != null) {
            sTest1 = sTest1.trim();
            sTest2 = sTest2.trim();
            if (sTest1.length() > 0 && sTest2.length() > 0) {
                if (bIgnoreCase) {
                    sTest1 = sTest1.toUpperCase();
                    sTest2 = sTest2.toUpperCase();
                }
                nFoundAt = sTest2.lastIndexOf(sTest1);
            }
        }
        return nFoundAt;
    }

    public static Dimension GetTextSize(String sText, Font jFont, Graphics gGraphics) {
        Rectangle2D rectStringBounds;
        FontRenderContext jFontContext;
        Graphics2D g2d;
        Dimension dimSize = null;
        if (jFont != null && (g2d = (Graphics2D)gGraphics) != null && (jFontContext = g2d.getFontRenderContext()) != null && (rectStringBounds = jFont.getStringBounds(sText, jFontContext)) != null) {
            dimSize = new Dimension();
            dimSize.setSize(rectStringBounds.getWidth(), rectStringBounds.getHeight());
        }
        return dimSize;
    }

    public static String GetFileName(String sAbsPathName) {
        String sName = sAbsPathName;
        if (sName.length() > 0) {
            sName = sName.trim();
            sName = CString.MakeForwardSlashes(sName);
            sName = CString.EnsureLastCharIsNotAForwardSlash(sName);
            int nFoundAt = CString.ReverseFind(Character.valueOf('/'), sName);
            if (nFoundAt > -1) {
                sName = sName.substring(nFoundAt + 1, sName.length());
            }
        }
        return sName;
    }

    public static String ParseParentRemotePath(String sAbsPathName) {
        String sPath = sAbsPathName;
        if (sPath != null) {
            int nFoundAt;
            sPath = sPath.trim();
            sPath = CString.MakeForwardSlashes(sPath);
            if ((sPath = CString.EnsureLastCharIsNotAForwardSlash(sPath)).length() > 1 && (nFoundAt = CString.GetLastSlashLoc(sPath)) > -1) {
                sPath = sPath.substring(0, nFoundAt);
            }
            if (sPath.isEmpty()) {
                sPath = CString.EnsureLastCharIsAForwardSlash(sPath);
            }
        }
        return sPath;
    }

    public static String GetFilePath(String sAbsPathName, boolean bIncludeLastSlash) {
        String sPath = sAbsPathName;
        if (sPath != null) {
            int nFoundAt;
            if (!(sPath = sPath.trim()).isEmpty() && (nFoundAt = CString.GetLastSlashLoc(sAbsPathName)) > -1) {
                sPath = sPath.substring(0, bIncludeLastSlash ? nFoundAt + 1 : nFoundAt);
            }
        } else {
            boolean bl = false;
        }
        return sPath;
    }

    public static String GetFileExtension(String sAbsPathName, boolean bIsDir, boolean bIncludePeriod) {
        int nFoundAt;
        String sExt = null;
        String sAbsTemp = sAbsPathName.trim();
        if (sAbsTemp != null && sAbsTemp.length() > 0 && !bIsDir && (nFoundAt = CString.ReverseFind(Character.valueOf('.'), sAbsTemp)) > -1) {
            sExt = sAbsTemp.substring(bIncludePeriod ? nFoundAt : nFoundAt + 1, sAbsTemp.length());
        }
        return sExt;
    }

    public static String SwapChars(String sTest, char chFrom, char chTo) {
        if (sTest != null) {
            StringBuilder sbTest = new StringBuilder(sTest);
            sbTest = CString.SwapChars(sbTest, chFrom, chTo);
            sTest = sbTest.toString();
        }
        return sTest;
    }

    public static StringBuilder SwapChars(StringBuilder sbTest, char chFrom, char chTo) {
        if (sbTest != null) {
            for (int nIdx = 0; nIdx < sbTest.length(); ++nIdx) {
                Character ch = Character.valueOf(sbTest.charAt(nIdx));
                if (ch.compareTo(Character.valueOf(chFrom)) != 0) continue;
                sbTest.deleteCharAt(nIdx);
                sbTest.insert(nIdx, chTo);
            }
        }
        return sbTest;
    }

    public static StringBuilder MakeForwardSlashes(StringBuilder sbTest) {
        return CString.SwapChars(sbTest, '\\', '/');
    }

    public static StringBuilder MakeBackSlashes(StringBuilder sbTest) {
        return CString.SwapChars(sbTest, '/', '\\');
    }

    public static StringBuilder EnsureFirstChar(Character chFirst, StringBuilder sbTest) {
        if (sbTest != null && sbTest.length() > 0 && chFirst.compareTo(Character.valueOf(sbTest.charAt(0))) != 0) {
            sbTest.insert(0, chFirst);
        }
        return sbTest;
    }

    public static StringBuilder EnsureLastChar(Character chLast, StringBuilder sbTest) {
        int nLastLoc;
        if (sbTest != null && sbTest.length() > 0 && chLast.compareTo(Character.valueOf(sbTest.charAt(nLastLoc = sbTest.length() - 1))) != 0) {
            sbTest.append(chLast);
        }
        return sbTest;
    }

    public static StringBuilder EnsureNotFirstChar(Character chFirst, StringBuilder sbTest) {
        if (sbTest != null && sbTest.length() > 0 && chFirst.compareTo(Character.valueOf(sbTest.charAt(0))) == 0) {
            sbTest.deleteCharAt(0);
        }
        return sbTest;
    }

    public static StringBuilder EnsureNotLastChar(Character chLast, StringBuilder sbTest) {
        int nLastLoc;
        if (sbTest != null && sbTest.length() > 0 && chLast.compareTo(Character.valueOf(sbTest.charAt(nLastLoc = sbTest.length() - 1))) == 0) {
            sbTest.deleteCharAt(nLastLoc);
        }
        return sbTest;
    }

    private static int GetSlashLoc(String sTest) {
        return CString.GetSlashLoc(sTest, 0);
    }

    private static int GetSlashLoc(String sTest, int nStartLoc) {
        boolean bForwardValid;
        int nSlashIdx = -1;
        int nBackSlashIdx = sTest.indexOf(92, nStartLoc);
        int nForwardSlashIdx = sTest.indexOf(47, nStartLoc);
        boolean bBackValid = nBackSlashIdx >= 0 && nBackSlashIdx < sTest.length();
        boolean bl = bForwardValid = nForwardSlashIdx >= 0 && nForwardSlashIdx < sTest.length();
        if (bBackValid && bForwardValid) {
            nSlashIdx = Math.min(nBackSlashIdx, nForwardSlashIdx);
        } else if (bBackValid) {
            nSlashIdx = nBackSlashIdx;
        } else if (bForwardValid) {
            nSlashIdx = nForwardSlashIdx;
        }
        return nSlashIdx;
    }

    private static int GetSlashLoc(StringBuilder sbTest) {
        return CString.GetSlashLoc(sbTest, 0);
    }

    private static int GetSlashLoc(StringBuilder sbTest, int nStartLoc) {
        return CString.GetSlashLoc(sbTest.toString(), nStartLoc);
    }

    private static int GetLastSlashLoc(String sTest) {
        return CString.GetLastSlashLoc(sTest, sTest.length() - 1);
    }

    private static int GetLastSlashLoc(String sTest, int nStartLoc) {
        boolean bForwardValid;
        int nSlashIdx = -1;
        int nBackSlashIdx = sTest.lastIndexOf(92, nStartLoc);
        int nForwardSlashIdx = sTest.lastIndexOf(47, nStartLoc);
        boolean bBackValid = nBackSlashIdx >= 0 && nBackSlashIdx < sTest.length();
        boolean bl = bForwardValid = nForwardSlashIdx >= 0 && nForwardSlashIdx < sTest.length();
        if (bBackValid && bForwardValid) {
            nSlashIdx = Math.max(nBackSlashIdx, nForwardSlashIdx);
        } else if (bBackValid) {
            nSlashIdx = nBackSlashIdx;
        } else if (bForwardValid) {
            nSlashIdx = nForwardSlashIdx;
        }
        return nSlashIdx;
    }

    private static int GetLastSlashLoc(StringBuilder sbTest) {
        return CString.GetLastSlashLoc(sbTest, sbTest.length() - 1);
    }

    private static int GetLastSlashLoc(StringBuilder sbTest, int nStartLoc) {
        return CString.GetLastSlashLoc(sbTest.toString(), nStartLoc);
    }

    public static String BuildAbsDirFromRelDir(String sAbsFileName, String sRelFileName, String sCommonFileName, boolean bChangeToSeparator, char chSeparator, boolean bAppendCommonFileName) {
        String sRet = null;
        String sParseRelPath = sRelFileName;
        sRet = sParseRelPath.startsWith("/") ? CString.BuildAbsDirFromRelDirForward(sAbsFileName, sRelFileName, sCommonFileName, chSeparator) : CString.BuildAbsDirFromRelDirReverse(sAbsFileName, sRelFileName, sCommonFileName, bAppendCommonFileName);
        return sRet;
    }

    private static String BuildAbsDirFromRelDirForward(String sAbsFileName, String sRelFileName, String sCommonFileName, char chSeparator) {
        String sNewAbsDir = null;
        return sNewAbsDir;
    }

    private static String BuildAbsDirFromRelDirReverse(String sAbsFileName, String sRelFileName, String sCommonFileName, boolean bAppendCommonFileName) {
        StringBuilder sbNewAbsFileName = null;
        if (sAbsFileName != null && sRelFileName != null && sCommonFileName != null) {
            sbNewAbsFileName = new StringBuilder(sAbsFileName);
            sbNewAbsFileName = CString.MakeBackSlashes(sbNewAbsFileName);
            sCommonFileName = CString.EnsureFirstCharIsNotASlash(sCommonFileName);
            sCommonFileName = CString.EnsureLastCharIsNotASlash(sCommonFileName);
            String sTest = sRelFileName;
            sTest = CString.EnsureFirstCharIsNotASlash(sTest);
            sTest = CString.EnsureLastCharIsNotASlash(sTest);
            boolean bAbsHasEndFile = sAbsFileName.endsWith(sCommonFileName);
            boolean bRelHasEndFile = !sTest.equals(sCommonFileName);
            int nAbsIdx = sbNewAbsFileName.lastIndexOf("\\");
            sbNewAbsFileName = sbNewAbsFileName.delete(nAbsIdx, sbNewAbsFileName.length());
            if (bAbsHasEndFile && bRelHasEndFile) {
                sRelFileName = CString.MakeBackSlashes(sRelFileName);
                int nRelIdx2 = sRelFileName.lastIndexOf(92);
                int nRelIdx1 = sRelFileName.lastIndexOf(92, nRelIdx2 - 1);
                boolean bDone = false;
                while (!bDone) {
                    if (nRelIdx1 < 0) {
                        bDone = true;
                        nRelIdx1 = -1;
                    }
                    String sRelDir = sRelFileName.substring(nRelIdx1 + 1, nRelIdx2);
                    if (DEBUG) {
                        System.out.println(sRelDir);
                    }
                    nRelIdx2 = nRelIdx1;
                    nRelIdx1 = sRelFileName.lastIndexOf(92, nRelIdx2 - 1);
                    if (sRelDir.equals("..")) {
                        nAbsIdx = sbNewAbsFileName.lastIndexOf("\\");
                        sbNewAbsFileName.delete(nAbsIdx, sbNewAbsFileName.length());
                        continue;
                    }
                    if (sRelDir.equals(".")) continue;
                    sRelDir = CString.EnsureFirstCharIsNotABackSlash(sRelDir);
                    sbNewAbsFileName = CString.EnsureLastCharIsABackSlash(sbNewAbsFileName);
                    sbNewAbsFileName.append(sRelDir);
                }
            }
            if (bAppendCommonFileName) {
                sbNewAbsFileName = CString.EnsureLastCharIsABackSlash(sbNewAbsFileName);
                sbNewAbsFileName.append(sCommonFileName);
            }
        }
        if (sbNewAbsFileName != null) {
            return sbNewAbsFileName.toString();
        }
        return null;
    }

    public static String GetFileRootPath(String sAbsDir, boolean bEnsureLastChar, char chFileSep) {
        StringBuilder sbRootPath = new StringBuilder();
        int nSlashIdx = CString.GetSlashLoc(sAbsDir);
        if (nSlashIdx == 0) {
            sbRootPath.append(sAbsDir.charAt(0));
        } else if (nSlashIdx > 0 && nSlashIdx <= sAbsDir.length()) {
            sbRootPath.append(sAbsDir.substring(0, nSlashIdx));
            if (bEnsureLastChar) {
                sbRootPath = CString.EnsureLastChar(Character.valueOf(chFileSep), sbRootPath);
            }
        }
        return sbRootPath.toString();
    }

    public static boolean IsValidCharIndex(int nIndex, String sText) {
        boolean bValid = false;
        if (nIndex >= 0 && nIndex < sText.length()) {
            bValid = true;
        }
        return bValid;
    }

    public static String FormatNumberForThousands(long nNum) {
        NumberFormat Formatter2;
        String sRet = Long.toString(nNum);
        if (CMainFrame.GET_APP() != null && (Formatter2 = NumberFormat.getNumberInstance(CMainFrame.GET_APP().GetUserLocale())) != null) {
            sRet = Formatter2.format(nNum);
        }
        return sRet;
    }

    public static String FormatFloat(float fValue, int nNumDigitsPastDecimal) {
        DecimalFormat decFormatter;
        DecimalFormatSymbols decSymbols;
        String sRet = Float.toString(fValue);
        NumberFormat Formatter2 = NumberFormat.getNumberInstance(CMainFrame.GET_APP().GetUserLocale());
        if (Formatter2 != null) {
            sRet = Formatter2.format(fValue);
        }
        if (Formatter2 instanceof DecimalFormat && (decSymbols = (decFormatter = (DecimalFormat)Formatter2).getDecimalFormatSymbols()) != null) {
            char chDecimalSep = decSymbols.getDecimalSeparator();
            int nDecimalLoc = sRet.indexOf(chDecimalSep);
            if (nDecimalLoc > -1) {
                int nDigitsPastDecimal = nDecimalLoc + nNumDigitsPastDecimal + 1;
                if (nDigitsPastDecimal < sRet.length()) {
                    sRet = sRet.substring(0, nDigitsPastDecimal);
                } else {
                    int nIdx = nDecimalLoc + 1;
                    do {
                        if (nIdx <= sRet.length() - 1) continue;
                        sRet = sRet + "0";
                    } while (++nIdx < nDigitsPastDecimal);
                }
            } else {
                sRet = sRet + chDecimalSep;
                for (int nIdx = 0; nIdx < nNumDigitsPastDecimal; ++nIdx) {
                    sRet = sRet + "0";
                }
            }
        }
        return sRet;
    }

    public static String FormatNumberForThousandsDouble(double dNum, int nNumDigitsPastDecimal) {
        return CString.FormatNumberForThousandsDouble(dNum, nNumDigitsPastDecimal, false);
    }

    public static String FormatNumberForThousandsDouble(double dNum, int nNumDigitsPastDecimal, boolean bAppendDecimalToWholeNum) {
        String sRet = Double.toString(dNum);
        Locale rLocale = Locale.getDefault();
        if (CMainFrame.GET_APP() != null) {
            rLocale = CMainFrame.GET_APP().GetUserLocale();
        }
        if (rLocale != null) {
            DecimalFormat decFormatter;
            DecimalFormatSymbols decSymbols;
            NumberFormat Formatter2 = NumberFormat.getNumberInstance(rLocale);
            if (Formatter2 != null) {
                sRet = Formatter2.format(dNum);
            }
            if (Formatter2 instanceof DecimalFormat && (decSymbols = (decFormatter = (DecimalFormat)Formatter2).getDecimalFormatSymbols()) != null) {
                char chDecimalSep = decSymbols.getDecimalSeparator();
                int nDecimalLoc = sRet.indexOf(chDecimalSep);
                if (nDecimalLoc > -1) {
                    int nDigitsPastDecimal = nDecimalLoc + nNumDigitsPastDecimal + 1;
                    if (nDigitsPastDecimal < sRet.length()) {
                        sRet = sRet.substring(0, nDigitsPastDecimal);
                    } else {
                        int nIdx = nDecimalLoc + 1;
                        do {
                            if (nIdx <= sRet.length() - 1) continue;
                            sRet = sRet + "0";
                        } while (++nIdx < nDigitsPastDecimal);
                    }
                } else if (bAppendDecimalToWholeNum) {
                    sRet = sRet + chDecimalSep;
                    for (int nIdx = 0; nIdx < nNumDigitsPastDecimal; ++nIdx) {
                        sRet = sRet + "0";
                    }
                }
            }
        }
        return sRet;
    }

    private static String FormatNumOfBytes(long nNumOfBytes, String[] asSuffixes, boolean bShowByteSuffix) {
        String sRet = CString.FormatNumberForThousands(nNumOfBytes);
        if (nNumOfBytes < 10000L) {
            if (bShowByteSuffix) {
                sRet = sRet + " " + asSuffixes[0];
            }
        } else if (nNumOfBytes < 10000000L) {
            long nConverted = CString.ToKB(nNumOfBytes);
            sRet = CString.FormatNumberForThousands(nConverted) + " " + asSuffixes[1];
        } else if (nNumOfBytes < 1000000000L) {
            long nConverted = CString.ToMB(nNumOfBytes);
            sRet = CString.FormatNumberForThousands(nConverted) + " " + asSuffixes[2];
        } else if (nNumOfBytes < 1000000000000L) {
            long nConverted = CString.ToGB(nNumOfBytes);
            sRet = CString.FormatNumberForThousands(nConverted) + " " + asSuffixes[3];
        } else {
            long nConverted = CString.ToTB(nNumOfBytes);
            sRet = CString.FormatNumberForThousands(nConverted) + " " + asSuffixes[4];
        }
        return sRet;
    }

    public static String FormatNumOfBytes(long nNumOfBytes, boolean bShowByteSuffix) {
        String[] asSuffixes = new String[]{CString.LoadString("IDS_BYTES"), CString.LoadString("IDS_KB"), CString.LoadString("IDS_MB"), CString.LoadString("IDS_GB"), CString.LoadString("IDS_TB"), null};
        return CString.FormatNumOfBytes(nNumOfBytes, asSuffixes, bShowByteSuffix);
    }

    private static String FormatNumOfBytesDouble(long nNumOfBytes, String[] asSuffixes, boolean bShowByteSuffix, int nNumDigitsPastDecimal) {
        String sRet = CString.FormatNumberForThousandsDouble(nNumOfBytes, nNumDigitsPastDecimal);
        if (nNumOfBytes < 10000L) {
            if (bShowByteSuffix) {
                sRet = sRet + " " + asSuffixes[0];
            }
        } else if (nNumOfBytes < 10000000L) {
            double dConverted = CString.ToKBDouble(nNumOfBytes);
            sRet = CString.FormatNumberForThousandsDouble(dConverted, nNumDigitsPastDecimal) + " " + asSuffixes[1];
        } else if (nNumOfBytes < 1000000000L) {
            double dConverted = CString.ToMBDouble(nNumOfBytes);
            sRet = CString.FormatNumberForThousandsDouble(dConverted, nNumDigitsPastDecimal) + " " + asSuffixes[2];
        } else if (nNumOfBytes < 1000000000000L) {
            double dConverted = CString.ToGBDouble(nNumOfBytes);
            sRet = CString.FormatNumberForThousandsDouble(dConverted, nNumDigitsPastDecimal) + " " + asSuffixes[3];
        } else {
            double dConverted = CString.ToTBDouble(nNumOfBytes);
            sRet = CString.FormatNumberForThousandsDouble(dConverted, nNumDigitsPastDecimal) + " " + asSuffixes[4];
        }
        return sRet;
    }

    public static String FormatNumOfBytesDouble(long nNumOfBytes, boolean bShowByteSuffix, int nNumDigitsPastDecimal) {
        String[] asSuffixes = new String[]{CString.LoadString("IDS_BYTES"), CString.LoadString("IDS_KB"), CString.LoadString("IDS_MB"), CString.LoadString("IDS_GB"), CString.LoadString("IDS_TB"), null};
        return CString.FormatNumOfBytesDouble(nNumOfBytes, asSuffixes, bShowByteSuffix, nNumDigitsPastDecimal);
    }

    public static String FormatBytesPerSecond(long nBytesPerSecond) {
        return CString.FormatBytesPerSecond(nBytesPerSecond, -1);
    }

    public static String FormatBytesPerSecond(long nBytesPerSecond, int nNumDigitsPastDecimal) {
        String[] asSuffixes = new String[]{CString.LoadString("IDS_BYTES_PER_SEC"), CString.LoadString("IDS_KB_PER_SEC"), CString.LoadString("IDS_MB_PER_SEC"), CString.LoadString("IDS_GB_PER_SEC"), CString.LoadString("IDS_TB_PER_SEC"), null};
        String sRet = "";
        sRet = nNumDigitsPastDecimal < 1 ? CString.FormatNumOfBytes(nBytesPerSecond, asSuffixes, true) : CString.FormatNumOfBytesDouble(nBytesPerSecond, asSuffixes, true, nNumDigitsPastDecimal);
        return sRet;
    }

    public static long ToKB(long nVal) {
        long nRet = nVal / 1024L;
        if (nVal % 1024L >= 512L) {
            ++nRet;
        }
        return nRet;
    }

    public static long ToMB(long nVal) {
        long nRet = nVal / 0x100000L;
        if (nVal % 0x100000L >= 524288L) {
            ++nRet;
        }
        return nRet;
    }

    public static long ToGB(long nVal) {
        long nRet = nVal / 0x40000000L;
        if (nVal % 0x40000000L >= 0x20000000L) {
            ++nRet;
        }
        return nRet;
    }

    public static long ToTB(long nVal) {
        long nRet = nVal / 0x10000000000L;
        if (nVal % 0x10000000000L >= 0x8000000000L) {
            ++nRet;
        }
        return nRet;
    }

    public static double ToKBDouble(long lVal) {
        return (double)lVal / 1024.0;
    }

    public static double ToMBDouble(long lVal) {
        return (double)lVal / 1048576.0;
    }

    public static double ToGBDouble(long lVal) {
        return (double)lVal / 1.073741824E9;
    }

    public static double ToTBDouble(long lVal) {
        return (double)lVal / 1.099511627776E12;
    }

    public static String ConvertRelativePath(String sAbsParentPath, String sRelativePath) {
        StringBuilder sbAbsPath = new StringBuilder(sAbsParentPath);
        sbAbsPath = CString.MakeForwardSlashes(sbAbsPath);
        sbAbsPath = CString.EnsureLastCharIsNotAForwardSlash(sbAbsPath);
        StringBuilder sbRelPath = new StringBuilder(sRelativePath);
        sbRelPath = CString.MakeForwardSlashes(sbRelPath);
        int nFoundIdx = sbRelPath.indexOf("/");
        while (nFoundIdx > -1) {
            String sDir = sbRelPath.substring(0, nFoundIdx);
            if ((sDir = CString.EnsureFirstCharIsNotAForwardSlash(sDir)).equals("..")) {
                int nFoundIdx2 = sbAbsPath.lastIndexOf("/");
                if (nFoundIdx2 >= 0 && nFoundIdx2 < sbAbsPath.length()) {
                    sbAbsPath = sbAbsPath.delete(nFoundIdx2, sbAbsPath.length());
                }
            } else if (!sDir.equals(".")) {
                sbAbsPath = CString.EnsureLastCharIsAForwardSlash(sbAbsPath);
                sbAbsPath.append(sDir);
            }
            sbRelPath = sbRelPath.delete(0, nFoundIdx + 1);
            nFoundIdx = sbRelPath.indexOf("/");
        }
        sbAbsPath = CString.EnsureLastCharIsAForwardSlash(sbAbsPath);
        sbAbsPath.append((CharSequence)sbRelPath);
        return sbAbsPath.toString();
    }

    public static String GetRelativePath(String sAbsParentPath, String sAbsChildPath) {
        String sRelChildPath = null;
        StringBuilder sbAbsParentPath = new StringBuilder(sAbsParentPath);
        sbAbsParentPath = CString.MakeForwardSlashes(sbAbsParentPath);
        sbAbsParentPath = CString.EnsureNotLastChar(Character.valueOf('/'), sbAbsParentPath);
        sbAbsParentPath = CString.EnsureLastCharIsNotAForwardSlash(sbAbsParentPath);
        StringBuilder sbAbsChildPath = new StringBuilder(sAbsChildPath);
        if ((sbAbsChildPath = CString.MakeForwardSlashes(sbAbsChildPath)).length() > sbAbsParentPath.length()) {
            sRelChildPath = sbAbsChildPath.substring(sbAbsParentPath.length());
        }
        return sRelChildPath;
    }

    public static String HTMLEncode(String sText) {
        StringBuilder sbEncoded = null;
        if (sText != null && !sText.isEmpty()) {
            sbEncoded = new StringBuilder();
            for (int nIdx = 0; nIdx < sText.length(); ++nIdx) {
                char ch = sText.charAt(nIdx);
                char nDigit = ch;
                if (nDigit > '\u00ff') {
                    sbEncoded.append("&#" + nDigit + ";");
                    continue;
                }
                sbEncoded.append(ch);
            }
        } else {
            sbEncoded = new StringBuilder(sText);
        }
        return sbEncoded.toString();
    }

    public static boolean CompareCharacter(char sFormat, char sStr, boolean bIgnoreCase) {
        boolean bRet = !bIgnoreCase ? sFormat == sStr : Character.toUpperCase(sFormat) == Character.toUpperCase(sStr);
        return bRet;
    }

    public static boolean WildcardCompare(String sFormat, String sStr, boolean bIgnoreCase) {
        boolean bRet;
        block28: {
            bRet = true;
            try {
                String sBuffer = new String();
                int nMaxIndex = -1;
                int nIndexUp = 0;
                String sPrevFormat = null;
                String sTemp = null;
                int nIdx = 0;
                int nIdx2 = 0;
                block12: while (bRet && nIdx <= sFormat.length() - 1) {
                    switch (sFormat.charAt(nIdx)) {
                        case '*': {
                            int nSymbolIndex;
                            sPrevFormat = sFormat;
                            if (++nIdx == sFormat.length()) continue block12;
                            switch (sFormat.charAt(nIdx)) {
                                case '\u0000': {
                                    nIdx2 += sStr.length();
                                    continue block12;
                                }
                                case '*': 
                                case '?': {
                                    bRet = false;
                                    continue block12;
                                }
                            }
                            sBuffer = sFormat.substring(nIdx, sFormat.length());
                            nMaxIndex = sBuffer.length();
                            int nAsteriskIndex = CString.Find(Character.valueOf('*'), sBuffer, true);
                            int nQuestionIndex = CString.Find(Character.valueOf('?'), sBuffer, true);
                            int nBracketIndex = CString.Find(Character.valueOf('['), sBuffer, true);
                            int nForwardSlashIndex = CString.Find(Character.valueOf('\\'), sBuffer, true);
                            if (nAsteriskIndex == -1) {
                                nAsteriskIndex = nMaxIndex;
                            }
                            if (nQuestionIndex == -1) {
                                nQuestionIndex = nMaxIndex;
                            }
                            if (nBracketIndex == -1) {
                                nBracketIndex = nMaxIndex;
                            }
                            if (nForwardSlashIndex == -1) {
                                nForwardSlashIndex = nMaxIndex;
                            }
                            if ((nSymbolIndex = CString.min(nAsteriskIndex, CString.min(nQuestionIndex, CString.min(nBracketIndex, nForwardSlashIndex)))) != -1) {
                                sTemp = sBuffer.substring(0, nSymbolIndex);
                            }
                            nIndexUp = CString.FindSubstring(sStr, sTemp, bIgnoreCase);
                            if (sStr.substring(nIdx2, sStr.length()).toUpperCase().contains(sTemp.toUpperCase())) {
                                int nLength = sTemp.length();
                                nIdx2 = nIndexUp;
                                if ((nIdx += nLength) >= sFormat.length() - 1 && (nIdx2 += nLength) >= sStr.length() - 1 || nIdx >= sFormat.length() - 1 && sFormat.charAt(sFormat.length() - 1) == '*' || nIdx < sFormat.length() - 1 || nIdx2 >= sStr.length() - 1) continue block12;
                                bRet = false;
                                continue block12;
                            }
                            bRet = false;
                            continue block12;
                        }
                        case '?': {
                            if (nIdx2 != sStr.length() && nIdx2 >= 0) {
                                if (++nIdx < sFormat.length() || ++nIdx2 >= sStr.length()) continue block12;
                                bRet = false;
                                continue block12;
                            }
                            if (nIdx == sFormat.length() && nIdx2 == sStr.length()) {
                                bRet = true;
                                continue block12;
                            }
                            bRet = false;
                            continue block12;
                        }
                        case '[': {
                            ++nIdx;
                            bRet = false;
                            while (nIdx < sFormat.length() && nIdx >= 0 && sFormat.charAt(nIdx) != ']') {
                                if (!bRet) {
                                    if (sFormat.charAt(nIdx) == '\\') {
                                        ++nIdx;
                                    }
                                    if (nIdx2 < sStr.length() && sFormat.toUpperCase().charAt(nIdx) == sStr.toUpperCase().charAt(nIdx2)) {
                                        ++nIdx2;
                                        bRet = true;
                                    }
                                }
                                ++nIdx;
                            }
                            if (nIdx >= sFormat.length() - 1 || sFormat.charAt(nIdx) != ']') continue block12;
                            ++nIdx;
                            continue block12;
                        }
                        case '\\': {
                            ++nIdx;
                        }
                    }
                    if (nIdx > sFormat.length() - 1 || nIdx2 > sStr.length() - 1) {
                        if (nIdx2 > sStr.length() - 1 && nIdx < sFormat.length() - 1) {
                            bRet = false;
                        }
                        ++nIdx;
                        continue;
                    }
                    if (CString.CompareCharacter(sFormat.charAt(nIdx), sStr.charAt(nIdx2), bIgnoreCase)) {
                        ++nIdx;
                        ++nIdx2;
                        continue;
                    }
                    bRet = false;
                }
            }
            catch (Exception e) {
                bRet = true;
                if (!DEBUG) break block28;
                CUtils.ASSERT("CString.WildcardCompare", CUtils.GetLineNumber(), "Possible string manipulation error", false);
            }
        }
        return bRet;
    }

    public static int min(int nOne, int nTwo) {
        if (nOne == -1 && nTwo != -1) {
            return nTwo;
        }
        if (nOne != -1 && nTwo == -1) {
            return nOne;
        }
        if (nOne == -1 && nTwo == -1) {
            return -1;
        }
        if (nOne < nTwo) {
            return nOne;
        }
        if (nTwo < nOne) {
            return nTwo;
        }
        return nOne;
    }

    public static int FindSubstring(String sStr, String sSub, boolean bIgnoreCase) {
        int nRetIndex = -1;
        int nLocation = -1;
        int nSubLen = sSub.length();
        int nIdx = 0;
        int pEnd = sStr.length();
        char cUpper = sSub.toUpperCase().charAt(0);
        char cLower = sSub.toLowerCase().charAt(0);
        if (!bIgnoreCase) {
            return CString.FindSubstringWithCase(sStr, sSub);
        }
        do {
            nLocation = -1;
            while (nIdx < pEnd) {
                if (sStr.charAt(nIdx) == cUpper || sStr.charAt(nIdx) == cLower) {
                    nLocation = nIdx;
                    break;
                }
                ++nIdx;
            }
            if (nLocation == -1) break;
            if (nSubLen == 1) {
                nRetIndex = nLocation;
                break;
            }
            if (nLocation + nSubLen <= sStr.length()) {
                if (sStr.substring(nLocation, nLocation + nSubLen).toLowerCase().equals(sSub.toLowerCase())) {
                    nRetIndex = nLocation;
                    break;
                }
                ++nIdx;
                continue;
            }
            ++nIdx;
        } while (nIdx < pEnd);
        if (nRetIndex != -1) {
            return nRetIndex;
        }
        return 0;
    }

    public static int FindSubstringWithCase(String sString, String sSub) {
        int nSubLen = sSub.length();
        int nIdx = 0;
        while (nIdx + nSubLen < sString.length()) {
            if (sString.substring(nIdx, nIdx + nSubLen).equals(sSub)) {
                return nIdx;
            }
            ++nIdx;
        }
        return -1;
    }

    public static String ReplaceWith(String sStr, int nIdx, char cNew) {
        int nLength = sStr.length();
        char[] sBuffer = new char[nLength];
        for (int nCounter = 0; nCounter < nLength; ++nCounter) {
            if (nCounter != nIdx) {
                sBuffer[nCounter] = sStr.charAt(nCounter);
                continue;
            }
            if (nCounter != nIdx) continue;
            sBuffer[nCounter] = cNew;
        }
        return String.copyValueOf(sBuffer, 0, nLength);
    }

    public static String GetDrive(String sAbsPath, String sFileSep) {
        int nIdx;
        String sDrive = null;
        if (sAbsPath != null && !sAbsPath.isEmpty() && sFileSep != null && !sFileSep.isEmpty() && (nIdx = sAbsPath.indexOf(58)) > 0 && nIdx < sAbsPath.length()) {
            sDrive = sAbsPath.substring(0, nIdx + 1);
        }
        return sDrive;
    }

    public static Vector SplitPaths(Character chFileSep, String sFilePath) {
        Vector<String> asPaths = new Vector<String>();
        int nPrevFileSep = 0;
        int nNextFileSep = -1;
        sFilePath = CString.EnsureLastChar(chFileSep, sFilePath);
        while (nNextFileSep < sFilePath.length() - 1) {
            nPrevFileSep = nNextFileSep + 1;
            String sName = sFilePath.substring(nPrevFileSep, nNextFileSep = sFilePath.indexOf(chFileSep.toString(), nPrevFileSep));
            if (sName.isEmpty() && nNextFileSep == 0) {
                sName = chFileSep.toString();
            }
            asPaths.add(sName);
        }
        return asPaths;
    }

    public static boolean GetPathsMatch(String sFromPath, String sToPath, boolean bIsRemote) {
        boolean bMatch = false;
        if (!(sFromPath.isEmpty() || sToPath.isEmpty() || (bMatch = sFromPath.equals(sToPath)))) {
            boolean bCompareNoCase = false;
            if (!bIsRemote) {
                if (CFileSystemUtils.GetFileSysUtils() != null) {
                    bCompareNoCase = CFileSystemUtils.GetFileSysUtils().IsWindows();
                }
            } else if (CMainFrame.GET_APP() != null) {
                boolean bl = bCompareNoCase = !CMainFrame.GET_APP().IsCaseSensitiveOS();
            }
            if (bCompareNoCase && sFromPath.equalsIgnoreCase(sToPath)) {
                bMatch = true;
            }
        }
        return bMatch;
    }
}

