/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.net;

import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class CSUURLFactory {
    private boolean m_bIsSecure;
    private String m_sHost;
    private long m_lPort;
    private String m_sSessionID;

    public CSUURLFactory(boolean bIsSecure, String sHost, long lPort, String sSessionID) {
        this.m_bIsSecure = bIsSecure;
        this.m_sHost = sHost;
        this.m_lPort = lPort;
        this.m_sSessionID = sSessionID;
    }

    public static String URLEncode(String sEncode) {
        String sRet;
        block3: {
            sRet = null;
            try {
                if (sEncode != null && !sEncode.isEmpty()) {
                    String sEncoded = URLEncoder.encode(sEncode, "UTF-8");
                    sRet = sEncoded = sEncoded.replace("+", "%20");
                }
            }
            catch (Exception e) {
                if (CMainFrame.GetDebugLogger() == null) break block3;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to URL encode %s", sEncode));
            }
        }
        return sRet;
    }

    public static String URLDecode(String sDecode) {
        String sRet;
        block3: {
            sRet = null;
            try {
                if (sDecode != null && !sDecode.isEmpty()) {
                    String sDecoded;
                    sRet = sDecoded = URLDecoder.decode(sDecode, "UTF-8");
                }
            }
            catch (Exception e) {
                if (CMainFrame.GetDebugLogger() == null) break block3;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to URL decode %s", sDecode));
            }
        }
        return sRet;
    }

    private boolean IsSecure() {
        return this.m_bIsSecure;
    }

    private String GetHost() {
        return this.m_sHost;
    }

    private long GetPort() {
        return this.m_lPort;
    }

    private String GetSessionID() {
        return this.m_sSessionID;
    }

    private void StartURL(StringBuilder rsURL) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.StartURL");
        }
        if (rsURL.length() > 0) {
            rsURL.delete(0, rsURL.length());
        }
        if (this.IsSecure()) {
            rsURL.append("https://");
        } else {
            rsURL.append("http://");
        }
        rsURL.append(this.GetHost());
        rsURL.append(":" + this.GetPort());
        CString.EnsureLastCharIsAForwardSlash(rsURL);
    }

    private void EndURL(StringBuilder rsURL) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.EndURL");
        }
    }

    private void FmtURLList(StringBuilder rsURL, String sAbsPath, boolean bIsDir) throws NullPointerException {
        if (rsURL == null || sAbsPath == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLList");
        }
        rsURL.append("?");
        rsURL.append("Command=List");
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/List.csv");
        rsURL.append("&");
        rsURL.append("ListFile=/Java/Responses/List.csv");
        rsURL.append("&");
        if (bIsDir) {
            rsURL.append("Dir=" + CSUURLFactory.URLEncode(sAbsPath));
        } else {
            String sDir = CString.GetFilePath(sAbsPath, true);
            String sName = CString.GetFileName(sAbsPath);
            rsURL.append("Dir=" + CSUURLFactory.URLEncode(sDir));
            rsURL.append("&");
            rsURL.append("File=" + CSUURLFactory.URLEncode(sName));
        }
    }

    private void FmtURLDelete(StringBuilder rsURL, String sAbsPath, boolean bIsDir) throws NullPointerException {
        if (rsURL == null || sAbsPath == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLDelete");
        }
        rsURL.append("?");
        if (bIsDir) {
            rsURL.append("Command=DeleteDir");
        } else {
            rsURL.append("Command=Delete");
        }
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
        rsURL.append("&");
        String sParentPath = CString.GetFilePath(sAbsPath, true);
        rsURL.append("Dir=" + CSUURLFactory.URLEncode(sParentPath));
        rsURL.append("&");
        rsURL.append("File=" + CSUURLFactory.URLEncode(sAbsPath));
    }

    private void FmtURLRename(StringBuilder rsURL, String sAbsPathFrom, String sAbsPathTo) throws NullPointerException {
        if (rsURL == null || sAbsPathFrom == null || sAbsPathTo == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLRename");
        }
        rsURL.append("?");
        rsURL.append("Command=Rename");
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
        rsURL.append("&");
        rsURL.append("OriginalPath=" + CSUURLFactory.URLEncode(sAbsPathFrom));
        rsURL.append("&");
        rsURL.append("NewPath=" + CSUURLFactory.URLEncode(sAbsPathTo));
    }

    private void FmtURLCreate(StringBuilder rsURL, String sAbsPath) throws NullPointerException {
        if (rsURL == null || sAbsPath == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLRename");
        }
        rsURL.append("?");
        rsURL.append("Command=CreateDir");
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
        rsURL.append("&");
        String sParentPath = CString.GetFilePath(sAbsPath, true);
        rsURL.append("Dir=" + CSUURLFactory.URLEncode(sParentPath));
        rsURL.append("&");
        rsURL.append("File=" + CSUURLFactory.URLEncode(sAbsPath));
    }

    private void FmtURLLogout(StringBuilder rsURL) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLRename");
        }
        rsURL.append("?");
        rsURL.append("Command=Logout");
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
    }

    private void FmtURLNoop(StringBuilder rsURL) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLRename");
        }
        rsURL.append("?");
        rsURL.append("Command=Noop");
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Noop.xml");
    }

    private void FmtURLHelpFile(StringBuilder rsURL, String sFile, String sSelTreeNode, String sLangAndCountry) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLRename");
        }
        rsURL = CString.EnsureLastCharIsAForwardSlash(rsURL);
        rsURL.append("FVJV/Help/Help.htm");
        rsURL.append("?");
        if (sFile != null && !sFile.isEmpty()) {
            rsURL.append("helpfile=" + sFile);
            rsURL.append("&");
        }
        if (sSelTreeNode != null && !sSelTreeNode.isEmpty()) {
            rsURL.append("helpnode=" + sSelTreeNode);
            rsURL.append("&");
        }
        if (sLangAndCountry != null && !sLangAndCountry.isEmpty()) {
            rsURL.append("language=" + sLangAndCountry);
            rsURL.append("&");
        }
    }

    private void FmtURLChangePassword(StringBuilder rsURL) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLChangePassword");
        }
        rsURL.append("?");
        rsURL.append("Command=LoginChangePassword");
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
    }

    private void FmtURLChangeEmail(StringBuilder rsURL) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLChangeEmail");
        }
        rsURL.append("?");
        rsURL.append("Command=SetEmailAddress");
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
    }

    private void FmtURLDownload(StringBuilder rsURL, String sAbsPath, boolean bIsThumb, int nThumbWidth, int nThumbHeight) throws NullPointerException {
        if (rsURL == null || sAbsPath == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLRename");
        }
        rsURL.append("?");
        rsURL.append("Command=Download");
        rsURL.append("&");
        rsURL.append("File=" + CSUURLFactory.URLEncode(sAbsPath));
        if (bIsThumb) {
            rsURL.append("&");
            rsURL.append("Thumbnail=1");
            rsURL.append("&");
            rsURL.append("Width=" + nThumbWidth);
            rsURL.append("&");
            rsURL.append("Height=" + nThumbHeight);
        }
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
    }

    private void FmtURLDownloadMedia(StringBuilder rsURL, String sAbsPath, String sSessionID) throws NullPointerException {
        if (rsURL == null || sAbsPath == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLDownloadMedia");
        }
        rsURL.append("?");
        rsURL.append("Command=Download");
        rsURL.append("&");
        rsURL.append("File=" + CSUURLFactory.URLEncode(sAbsPath));
        rsURL.append("&");
        rsURL.append("Media=1");
        rsURL.append("&");
        rsURL.append("Session=" + sSessionID);
    }

    private void FmtURLUpload(StringBuilder rsURL, long lTransferID, String sAbsToPath) throws NullPointerException {
        if (rsURL == null || sAbsToPath == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLRename");
        }
        rsURL.append("?");
        rsURL.append("Command=Upload");
        rsURL.append("&");
        String sParentPath = CString.GetFilePath(sAbsToPath, true);
        rsURL.append("Dir=" + CSUURLFactory.URLEncode(sParentPath));
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
        rsURL.append("&");
        rsURL.append("File=" + CSUURLFactory.URLEncode(CString.GetFileName(sAbsToPath)));
        rsURL.append("&");
        rsURL.append("TransferID=" + lTransferID);
    }

    private void FmtURLTransferStats(StringBuilder rsURL, long lTransferID) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLRename");
        }
        rsURL.append("?");
        rsURL.append("Command=TransferStats");
        rsURL.append("&");
        rsURL.append("InternalDir=Common");
        rsURL.append("&");
        rsURL.append("InternalFile=/Java/Responses/Result.csv");
        rsURL.append("&");
        rsURL.append("TransferID=" + lTransferID);
    }

    private void FmtURLGetDirectorySize(StringBuilder rsURL, String sAbsDirPath) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLGetDirectorySize");
        }
        rsURL.append("?");
        rsURL.append("Command=DirectorySize");
        rsURL.append("&");
        rsURL.append("InternalDir=FVJV");
        rsURL.append("&");
        rsURL.append("InternalFile=/Responses/DirSize.csv");
        rsURL.append("&");
        rsURL.append("Dir=" + CSUURLFactory.URLEncode(sAbsDirPath));
    }

    private void FmtURLSpaceAvailable(StringBuilder rsURL, String sAbsDirPath) throws NullPointerException {
        if (rsURL == null) {
            throw new NullPointerException("Invalid parameter in CSUConnection.FmtURLAvailableSize");
        }
        rsURL.append("?");
        rsURL.append("Command=SpaceAvailable");
        rsURL.append("&");
        rsURL.append("InternalDir=FVJV");
        rsURL.append("&");
        rsURL.append("InternalFile=/Responses/SpaceAvailable.csv");
        rsURL.append("&");
        rsURL.append("Dir=" + CSUURLFactory.URLEncode(sAbsDirPath));
    }

    public URL CreateList(String sAbsPath, boolean bIsDir) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLList(sbURL, sAbsPath, bIsDir);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateDelete(String sAbsPath, boolean bIsDir) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLDelete(sbURL, sAbsPath, bIsDir);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateRename(String sAbsPathFrom, String sAbsPathTo) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLRename(sbURL, sAbsPathFrom, sAbsPathTo);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateDir(String sAbsPath) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLCreate(sbURL, sAbsPath);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateDownload(String sAbsFromPath, boolean bIsThumb, int nThumbWidth, int nThumbHeight) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLDownload(sbURL, sAbsFromPath, bIsThumb, nThumbWidth, nThumbHeight);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateDownloadMedia(String sAbsFromPath) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLDownloadMedia(sbURL, sAbsFromPath, this.GetSessionID());
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateUpload(long lTransferID, String sAbsToPath) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLUpload(sbURL, lTransferID, sAbsToPath);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateNoop() {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLNoop(sbURL);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateLogout() {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLLogout(sbURL);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateChangePassword() {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLChangePassword(sbURL);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateChangeEmail() {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLChangeEmail(sbURL);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateHelp(String sHelpFile, String sSelNode, String sLang) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLHelpFile(sbURL, sHelpFile, sSelNode, sLang);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateTransferStats(long lTransferID) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLTransferStats(sbURL, lTransferID);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateGetDirectorySize(String sAbsDirPath) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLGetDirectorySize(sbURL, sAbsDirPath);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }

    public URL CreateGetSpaceAvailable(String sAbsDirPath) {
        StringBuilder sbURL = new StringBuilder();
        this.StartURL(sbURL);
        this.FmtURLSpaceAvailable(sbURL, sAbsDirPath);
        this.EndURL(sbURL);
        URL rURL = null;
        try {
            rURL = new URL(sbURL.toString());
        }
        catch (MalformedURLException mURLe) {
            rURL = null;
        }
        return rURL;
    }
}

