/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.net;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.net.CHTTPConnection;
import com.rhinosoft.base.parsers.CParsedObj;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CSUURLFactory;
import com.rhinosoft.fvjv.net.CTransferStatsEvent;
import com.rhinosoft.fvjv.net.IListDirListener;
import com.rhinosoft.fvjv.net.ITransferStatsListener;
import com.rhinosoft.fvjv.parsers.CDirSize;
import com.rhinosoft.fvjv.parsers.CListing;
import com.rhinosoft.fvjv.parsers.CNoop;
import com.rhinosoft.fvjv.parsers.CResult;
import com.rhinosoft.fvjv.parsers.CSpaceAvailable;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class CSUConnection
extends CHTTPConnection {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_DYNAMIC_BUFFER;
    public static final boolean DEBUG_TRACK_UPLOAD_INDICES;
    public static final boolean DEBUG_SPEED_LISTING;
    public static final boolean DEBUG_UPLOAD_WATCHDOG;
    public static final int DEFAULT_HTTP_RESPONSE_CODE = 503;
    public static final int DEFAULT_SU_RESULT_CODE = 1;
    private static final int TRANSFER_BUFFER_SIZE_MINIMUM = 1024;
    public static final int TRANSFER_BUFFER_SIZE_DEFAULT = 5120;
    private static final int UPLOAD_MAX = 0x7FFFFBFF;
    public static final boolean DEBUG_UPLOAD_MSGS;
    public static final boolean DEBUG_UPLOAD_FILE_RET_GOOD;
    private CClientInfo m_ClientInfo;
    private CSUURLFactory m_URLFactory;
    private String m_sDirChangeMsg;
    private CRemoteFile m_RemoteFile;
    private int m_nNumOfThumbs = 0;
    private int m_nNumOfDirs = 0;
    private long m_lDirectorySize;
    private long m_lSpaceAvailable;
    private byte[] m_aBuffer;
    private Vector<ITransferStatsListener> m_aTransferStatsListeners;
    private SimpleDateFormat m_DateFormatter;
    private Vector<IListDirListener> m_aListDirListeners;
    private boolean m_bResume = false;
    private long m_lResumeStartIndex = -1L;
    private long m_lResumeEndIndex = -1L;
    private long m_lNumOfBytesRead = 0L;
    private long m_lStartTime = 0L;

    public CSUConnection(CClientInfo rInfo, int nCompressionType) {
        super(nCompressionType);
        this.SetClientInfo(rInfo);
        this.m_aTransferStatsListeners = new Vector();
        this.m_aListDirListeners = new Vector();
        this.m_DateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        this.m_DateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public void finalize() throws Throwable {
        this.m_ClientInfo = null;
        super.finalize();
    }

    protected void SetClientInfo(CClientInfo rClientInfo) {
        this.m_ClientInfo = rClientInfo;
        if (this.m_ClientInfo != null) {
            if (this.m_URLFactory != null) {
                this.m_URLFactory = null;
            }
            this.m_URLFactory = new CSUURLFactory(this.m_ClientInfo.IsSecure(), this.m_ClientInfo.GetHost(), this.m_ClientInfo.GetPublicPort(), this.m_ClientInfo.GetSessionID());
        }
    }

    protected CClientInfo GetClientInfo() {
        return this.m_ClientInfo;
    }

    protected CSUURLFactory GetURLFactory() {
        return this.m_URLFactory;
    }

    private String[] CompileRequestHeader(boolean bAcceptCompression) throws NullPointerException {
        if (this.GetClientInfo() == null) {
            throw new NullPointerException("GetClientInfo == null in CSUConnection.CompileRequestHeader");
        }
        String[] asRet = new String[]{"User-Agent", CMainFrame.GetAppNameVersion(), "Cookie", "Session=" + this.GetClientInfo().GetEncSessionID(), "Accept-Language", "en-us,en;q=0.5", "Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7", "X-User-Agent", CMainFrame.GetAppNameVersion(), "X-Is-FVJV", "1"};
        if (bAcceptCompression) {
            String[] asTemp = new String[asRet.length];
            System.arraycopy(asRet, 0, asTemp, 0, asRet.length);
            asRet = new String[asRet.length + 2];
            System.arraycopy(asTemp, 0, asRet, 0, asTemp.length);
            asRet[asRet.length - 2] = "Accept-Encoding";
            asRet[asRet.length - 1] = "gzip,deflate";
        }
        return asRet;
    }

    private int[] SendListPath(URL rURL, boolean bUseCompression) {
        int[] anRet = new int[]{503, 1};
        if (!this.GetCancel()) {
            anRet = this.GetListing(rURL, bUseCompression);
        }
        return anRet;
    }

    private int[] SendListPath(String sAbsPath, boolean bIsDir) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            if (sAbsPath != null && !sAbsPath.isEmpty()) {
                URL rURL = this.GetURLFactory().CreateList(sAbsPath, bIsDir);
                anRet = this.SendListPath(rURL, this.UseCompression());
            } else if (DEBUG) {
                CUtils.ASSERT(CSUConnection.class.getName(), CUtils.GetLineNumber(), "Programming error:  AbsPath is null for SendListPath!", false);
            }
        } else if (DEBUG) {
            CUtils.ASSERT(CSUConnection.class.getName(), CUtils.GetLineNumber(), "Programming error:  GetURLFactory is null for SendListPath!", false);
        }
        return anRet;
    }

    public int[] SendListDir(String sAbsPath) {
        return this.SendListPath(sAbsPath, true);
    }

    public int[] SendListFile(String sAbsPath) {
        return this.SendListPath(sAbsPath, false);
    }

    public CRemoteFile GetListDir() {
        return this.m_RemoteFile;
    }

    private int[] SendDeletePath(String sAbsPath, boolean bIsDir, boolean bUseCompression) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateDelete(sAbsPath, bIsDir);
            anRet = this.GetResult(rURL, bUseCompression);
        }
        return anRet;
    }

    private int[] SendDeletePath(String sAbsPath, boolean bIsDir) {
        return this.SendDeletePath(sAbsPath, bIsDir, this.UseCompression());
    }

    public int[] SendDeleteDir(String sAbsPath) {
        return this.SendDeletePath(sAbsPath, true);
    }

    public int[] SendDeleteFile(String sAbsPath) {
        return this.SendDeletePath(sAbsPath, false);
    }

    public int[] SendRenamePath(String sAbsPathFrom, String sAbsPathTo, boolean bUseCompression) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateRename(sAbsPathFrom, sAbsPathTo);
            anRet = this.GetResult(rURL, bUseCompression);
        }
        return anRet;
    }

    public int[] SendRenamePath(String sAbsPathFrom, String sAbsPathTo) {
        return this.SendRenamePath(sAbsPathFrom, sAbsPathTo, this.UseCompression());
    }

    public int[] SendCreateDir(String sAbsPath, long lLastModifiedTimestamp, boolean bUseCompression) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateDir(sAbsPath);
            anRet = this.GetResult(rURL, bUseCompression);
        }
        return anRet;
    }

    public int[] SendCreateDir(String sAbsPath, long lLastModifiedTimestamp) {
        return this.SendCreateDir(sAbsPath, lLastModifiedTimestamp, this.UseCompression());
    }

    public int[] SendDownload(String sAbsFromPath, long lFromSize, String sAbsToPath, boolean bIsThumb, int nThumbWidth, int nThumbHeight, long lResumeStart, boolean bUseCompression) {
        int[] anRet = new int[2];
        int nParseRc = 1;
        anRet[0] = 503;
        anRet[1] = 1;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateDownload(sAbsFromPath, bIsThumb, nThumbWidth, nThumbHeight);
            boolean bCanTransfer = true;
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            if (this.GetResume() && asHeaderInfo != null) {
                this.SetResumeRange(0L, lFromSize - 1L);
                if (lResumeStart < 0L) {
                    lResumeStart = this.FindResumeStartIndex(sAbsToPath, false);
                }
                if (lResumeStart >= lFromSize) {
                    bCanTransfer = false;
                    CTransferStatsEvent event = new CTransferStatsEvent(0L, lFromSize, lFromSize, -1L, sAbsToPath);
                    event.SetRecalcOverall(true);
                    event.SetResumeStartIndex(lResumeStart);
                    this.FireTransferStats(event);
                    anRet[0] = 200;
                    anRet[1] = 0;
                } else {
                    this.SetResumeStartIndex(lResumeStart);
                    String[] asTemp = new String[asHeaderInfo.length];
                    System.arraycopy(asHeaderInfo, 0, asTemp, 0, asHeaderInfo.length);
                    asHeaderInfo = new String[asTemp.length + 2];
                    System.arraycopy(asTemp, 0, asHeaderInfo, 0, asTemp.length);
                    asHeaderInfo[asHeaderInfo.length - 2] = "Range";
                    asHeaderInfo[asHeaderInfo.length - 1] = "bytes=" + this.GetResumeStartIndex() + "-" + this.GetResumeEndIndex();
                }
            }
            if (bCanTransfer) {
                String sContentType;
                boolean bIsResume = this.GetResume();
                anRet[0] = this.Get(rURL, asHeaderInfo);
                if (bIsResume && anRet[0] == 206) {
                    anRet[0] = 200;
                }
                if (anRet[0] == 200 && (sContentType = this.GetHeaderValue("Content-Type", anRet)) != null && anRet[0] == 200) {
                    if (sContentType != null) {
                        sContentType = sContentType.toLowerCase();
                    }
                    if (sContentType != null && !sContentType.isEmpty() && (sContentType.equals("application/download") || bIsThumb && sContentType.startsWith("image"))) {
                        this.DownloadToFile(sAbsToPath, anRet);
                    } else {
                        BufferedInputStream inStream = this.GetInputStream(anRet);
                        if (anRet[0] == 200 && inStream != null) {
                            CResult rResult = new CResult(this);
                            nParseRc = rResult.Parse(inStream, bUseCompression);
                            anRet[1] = rResult.GetResult();
                            this.CloseInputStream(inStream);
                        }
                    }
                }
            }
            this.Disconnect();
        }
        if (nParseRc == 3) {
            anRet = this.SendDownload(sAbsFromPath, lFromSize, sAbsToPath, bIsThumb, nThumbWidth, nThumbHeight, lResumeStart, bUseCompression);
        }
        return anRet;
    }

    public int[] SendDownload(String sAbsFromPath, long lFromSize, String sAbsToPath, boolean bIsThumb, int nThumbWidth, int nThumbHeight, long lResumeStart) {
        return this.SendDownload(sAbsFromPath, lFromSize, sAbsToPath, bIsThumb, nThumbWidth, nThumbHeight, lResumeStart, this.UseCompression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void DownloadToFile(String sAbsToPath, int[] anRet) {
        long lLastModified;
        long lStartTime;
        FileOutputStream outStream;
        BufferedInputStream inStream;
        File fRecvFile;
        boolean bIsResume;
        long lStartIndex;
        long lContentLen;
        long lReceivedSize;
        block38: {
            block37: {
                lReceivedSize = 0L;
                lContentLen = 0L;
                lStartIndex = 0L;
                bIsResume = this.GetResume();
                this.SetResume(false);
                if (sAbsToPath == null) return;
                if (sAbsToPath.isEmpty()) return;
                fRecvFile = new File(sAbsToPath);
                if (!fRecvFile.exists()) {
                    try {
                        if (!fRecvFile.createNewFile()) {
                            return;
                        }
                    }
                    catch (IOException ioe) {
                        fRecvFile = null;
                        if (!DEBUG) break block37;
                        CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "Could not create Local target file.", true);
                    }
                }
            }
            if (fRecvFile == null) return;
            if (!fRecvFile.exists()) return;
            inStream = null;
            outStream = null;
            fRecvFile.setWritable(true);
            lLastModified = lStartTime = System.currentTimeMillis();
            try {
                boolean bAppendToFile = false;
                if (bIsResume) {
                    bAppendToFile = true;
                }
                outStream = new FileOutputStream(fRecvFile, bAppendToFile);
            }
            catch (Exception e) {
                if (!DEBUG) break block38;
                e.printStackTrace();
            }
        }
        if (outStream != null) {
            try {
                CTransferStatsEvent event;
                String sContentRange;
                String sHeaderVal;
                block39: {
                    inStream = this.GetInputStream(anRet);
                    if (anRet[0] != 200) return;
                    if (inStream == null) return;
                    if (inStream == null) throw new NullPointerException("Failed to get InputStream or OutputStream");
                    if (outStream == null) {
                        throw new NullPointerException("Failed to get InputStream or OutputStream");
                    }
                    sHeaderVal = null;
                    sHeaderVal = this.GetHeaderValue("Content-Length", anRet);
                    if (sHeaderVal == null) return;
                    if (anRet[0] != 200) return;
                    if (sHeaderVal == null || sHeaderVal.isEmpty()) {
                        sHeaderVal = this.GetHeaderValue("X-Content-Length", anRet);
                    }
                    if (sHeaderVal == null) return;
                    if (anRet[0] != 200) return;
                    lContentLen = Long.parseLong(sHeaderVal);
                    sHeaderVal = this.GetHeaderValue("Last-Modified", anRet);
                    if (sHeaderVal == null) return;
                    if (anRet[0] != 200) return;
                    try {
                        Date dtLastMod = this.m_DateFormatter.parse(sHeaderVal);
                        lLastModified = dtLastMod.getTime();
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block39;
                        e.printStackTrace();
                    }
                }
                sHeaderVal = this.GetHeaderValue("SU-Last-Modified", anRet);
                if (sHeaderVal != null && anRet[0] == 200) {
                    lLastModified = Long.parseLong(sHeaderVal);
                    lLastModified *= 1000L;
                }
                int nOffset = 0;
                long lMarkerTime = 0L;
                long lBytesPerSec = 0L;
                int nRead = 0;
                if (bIsResume && (sContentRange = this.GetHeaderValue("Content-Range", anRet)) != null && anRet[0] == 200) {
                    sHeaderVal = sContentRange;
                    String sRemove = "bytes ";
                    sHeaderVal = sHeaderVal.substring(sRemove.length());
                    int nHyphenIdx = sHeaderVal.indexOf("-");
                    int nSlashIdx = sHeaderVal.indexOf("/");
                    String sStartIndex = sHeaderVal.substring(0, nHyphenIdx);
                    String sEndIndex = sHeaderVal.substring(nHyphenIdx + 1, nSlashIdx);
                    String sFileSize = sHeaderVal.substring(nSlashIdx + 1);
                    lStartIndex = Long.parseLong(sStartIndex);
                    long lFileSize = Long.parseLong(sFileSize);
                    lReceivedSize = lStartIndex;
                    lContentLen = lFileSize;
                    outStream.getChannel().position(lStartIndex);
                }
                if (anRet[0] != 200) return;
                boolean bRecalcOverallOnce = true;
                boolean bRecalcOverall = false;
                long lCalcPerSecSize = lReceivedSize;
                long lResumeReceivedSize = 0L;
                this.m_aBuffer = new byte[5120];
                if (lContentLen == 0L) {
                    event = new CTransferStatsEvent(nRead, lReceivedSize, lContentLen, lBytesPerSec, sAbsToPath);
                    event.SetRecalcOverall(bRecalcOverall);
                    event.SetResumeStartIndex(this.GetResumeStartIndex());
                    event.SetMarkerTime(lMarkerTime);
                    event.SetStartTime(this.m_lStartTime);
                    event.SetIsEmptyFile(true);
                    this.FireTransferStats(event);
                }
                while (nRead > -1 && lReceivedSize < lContentLen && !this.GetCancel()) {
                    bRecalcOverall = false;
                    nRead = inStream.read(this.m_aBuffer, nOffset, this.m_aBuffer.length);
                    lMarkerTime = System.currentTimeMillis();
                    if (nRead > 0) {
                        outStream.write(this.m_aBuffer, nOffset, nRead);
                        lReceivedSize += (long)nRead;
                    }
                    lCalcPerSecSize = lReceivedSize;
                    if (bIsResume) {
                        lCalcPerSecSize = lResumeReceivedSize += (long)nRead;
                        if (bRecalcOverallOnce) {
                            bRecalcOverallOnce = false;
                            bRecalcOverall = true;
                        }
                        if (CThreadMsgTransfer.DEBUG_TRACK_STATS_READ) {
                            System.out.printf("ResumeReceivedSize: %d\r\n", lResumeReceivedSize);
                        }
                    }
                    lBytesPerSec = CSUConnection.CalcBytesPerSecond(lMarkerTime, lStartTime, lCalcPerSecSize);
                    event = new CTransferStatsEvent(nRead, lReceivedSize, lContentLen, lBytesPerSec, sAbsToPath);
                    event.SetRecalcOverall(bRecalcOverall);
                    event.SetResumeStartIndex(this.GetResumeStartIndex());
                    event.SetMarkerTime(lMarkerTime);
                    event.SetStartTime(this.m_lStartTime);
                    this.FireTransferStats(event);
                    if (lMarkerTime - lStartTime <= 2000L) continue;
                    this.AdjustTransferBuffer(lBytesPerSec);
                }
                if (lReceivedSize != lContentLen) return;
                anRet[1] = 0;
                return;
            }
            catch (NullPointerException npe) {
                if (!DEBUG) return;
                npe.printStackTrace();
                return;
            }
            catch (FileNotFoundException fnfe) {
                if (!DEBUG) return;
                fnfe.printStackTrace();
                return;
            }
            catch (IOException ioe) {
                if (DEBUG) {
                    ioe.printStackTrace();
                }
                anRet[1] = -4;
                return;
            }
            catch (NumberFormatException nfe) {
                if (!DEBUG) return;
                nfe.printStackTrace();
                return;
            }
            catch (IllegalArgumentException iae) {
                if (!DEBUG) return;
                iae.printStackTrace();
                return;
            }
            catch (SecurityException se) {
                if (!DEBUG) return;
                se.printStackTrace();
                return;
            }
            finally {
                this.m_aBuffer = null;
                this.CloseInputStream(inStream);
                this.CloseOutputStream(outStream);
                if (fRecvFile != null && !fRecvFile.setLastModified(lLastModified)) {
                    System.out.println("Failed to set \"Last Modified\" timestamp!");
                }
            }
        }
        anRet[1] = -6;
    }

    public int[] SendUpload(long lTransferID, String sAbsFromPath, long lFromSize, String sAbsToPath, long lResumeStart, boolean bUseCompression) {
        int[] anRet = new int[]{503, 1};
        this.m_lNumOfBytesRead = 0L;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateUpload(lTransferID, sAbsToPath);
            String sBoundary = this.CreateBoundary();
            String sContentDispName = "File";
            File fFromFile = new File(sAbsFromPath);
            String sContentDispFileName = fFromFile.getName();
            if (fFromFile != null && fFromFile.exists()) {
                long lLen = fFromFile.length();
                this.SetResumeRange(0L, lLen - 1L);
                if (lResumeStart < 0L) {
                    lResumeStart = this.FindResumeStartIndex(sAbsToPath, true);
                }
                if (!this.GetResume()) {
                    lResumeStart = 0L;
                }
                int nErrorID = 0;
                if (lResumeStart > lFromSize) {
                    CTransferStatsEvent event = new CTransferStatsEvent(0L, lFromSize, lFromSize, -1L, sAbsToPath);
                    event.SetRecalcOverall(true);
                    event.SetResumeStartIndex(lResumeStart);
                    this.FireTransferStats(event);
                    nErrorID = 1;
                } else {
                    this.SetResumeStartIndex(lResumeStart);
                    lLen = this.GetResumeEndIndex() - this.GetResumeStartIndex() + 1L;
                    if (lLen > -1L) {
                        this.SetResume(true);
                        this.m_lStartTime = System.currentTimeMillis();
                        do {
                            int nAttempt = 0;
                            do {
                                ++nAttempt;
                                int nLen = 0;
                                nLen = lLen <= 0x7FFFFBFFL ? (int)lLen : 0x7FFFFBFF;
                                int nBoundaryLength = this.GetFileBoundaryLength(sBoundary, sContentDispName, sContentDispFileName);
                                String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
                                int nInfoSize = asHeaderInfo.length + 8;
                                String[] asHeaderInfo2 = new String[nInfoSize];
                                System.arraycopy(asHeaderInfo, 0, asHeaderInfo2, 0, asHeaderInfo.length);
                                asHeaderInfo2[asHeaderInfo.length] = "Accept";
                                asHeaderInfo2[asHeaderInfo.length + 1] = "*/*";
                                asHeaderInfo2[asHeaderInfo.length + 2] = "Content-Type";
                                asHeaderInfo2[asHeaderInfo.length + 3] = String.format("multipart/form-data; boundary=%s", sBoundary);
                                asHeaderInfo2[asHeaderInfo.length + 4] = "Last-Modified";
                                asHeaderInfo2[asHeaderInfo.length + 5] = this.m_DateFormatter.format(new Date(fFromFile.lastModified())) + " GMT";
                                asHeaderInfo2[asHeaderInfo.length + 6] = "Range";
                                asHeaderInfo2[asHeaderInfo.length + 7] = "bytes=" + this.GetResumeStartIndex() + "-" + (this.GetResumeStartIndex() + (long)(nLen - 1));
                                anRet[0] = this.Post(rURL, asHeaderInfo2, nLen + nBoundaryLength);
                                if (anRet[0] == 1) {
                                    this.UploadFile(nLen, fFromFile, sBoundary, sContentDispName, sContentDispFileName, lTransferID, bUseCompression, anRet);
                                    if (DEBUG_UPLOAD_WATCHDOG && anRet[0] == 408) {
                                        System.out.println("Just encountered an upload watchdog!");
                                    }
                                    if (anRet[0] == 200 && anRet[1] == 0 || anRet[0] == 408) {
                                        if (anRet[0] == 408) {
                                            long lTargetFileSize = this.FindResumeStartIndex(sAbsToPath, true);
                                            this.SetResumeStartIndex(lTargetFileSize);
                                            lLen -= lTargetFileSize;
                                        } else {
                                            this.SetResumeStartIndex(this.GetResumeStartIndex() + this.m_lNumOfBytesRead);
                                            lLen -= this.m_lNumOfBytesRead;
                                        }
                                        if (DEBUG_UPLOAD_FILE_RET_GOOD) {
                                            lLen = 0L;
                                        }
                                    } else {
                                        nErrorID = 3;
                                    }
                                } else {
                                    nErrorID = 2;
                                }
                                this.Disconnect();
                            } while (anRet[0] == 408 && nAttempt <= 3);
                        } while (lLen > 0L && nErrorID == 0);
                        this.SetResume(false);
                    }
                    if (nErrorID > 0) {
                        switch (nErrorID) {
                            case 1: {
                                anRet[0] = 200;
                                anRet[1] = 17;
                                break;
                            }
                            case 2: {
                                if (anRet[0] == 1) {
                                    anRet[0] = 503;
                                }
                                anRet[1] = 1;
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                    }
                }
            }
        }
        return anRet;
    }

    public int[] SendUpload(long lTransferID, String sAbsFromPath, long lFromSize, String sAbsToPath, long lResumeStart) {
        return this.SendUpload(lTransferID, sAbsFromPath, lFromSize, sAbsToPath, lResumeStart, this.UseCompression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void UploadFile(int nLen, File fFile, String sBoundary, String sContentDispName, String sContentDispFileName, long lTransferID, boolean bUseCompression, int[] anRet) {
        boolean bOverrideResult;
        int nParseRc;
        boolean bPollForResult;
        block27: {
            block28: {
                InputStream finStream;
                OutputStream outputStream;
                block26: {
                    if (DEBUG_UPLOAD_FILE_RET_GOOD) {
                        anRet[0] = 200;
                        anRet[1] = 0;
                        return;
                    }
                    if (DEBUG_PRINT_REQUEST_HEADER) {
                        this.PrintRequestHeader();
                    }
                    if (DEBUG_UPLOAD_MSGS) {
                        Date dtTime = new Date(System.currentTimeMillis());
                        System.out.printf("Begin uploading: %s | Timestamp: %s\r\n", fFile.getName(), dtTime.toString());
                    }
                    bPollForResult = false;
                    anRet[1] = 1;
                    this.m_lNumOfBytesRead = 0L;
                    nParseRc = 1;
                    bOverrideResult = false;
                    if (fFile == null || !fFile.exists()) break block27;
                    outputStream = null;
                    finStream = null;
                    try {
                        finStream = new FileInputStream(fFile);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block26;
                        e.printStackTrace();
                    }
                }
                if (finStream == null) break block28;
                try {
                    CTransferStatsEvent event;
                    OutputStream outputStream2 = this.GetOutputStream(bUseCompression);
                    boolean bRet = true;
                    long lBytesRead = 0L;
                    long lMarkerTime = 0L;
                    long lWriteTime = 0L;
                    long lFileSize = fFile.length();
                    long lTotalRead = 0L;
                    boolean bRecalcOverallOnce = true;
                    boolean bRecalcOverall = false;
                    String sTemp = null;
                    sTemp = this.FmtStartBoundary(sBoundary, sContentDispName, sContentDispFileName);
                    outputStream2.write(sTemp.getBytes(), 0, sTemp.getBytes().length);
                    outputStream2.flush();
                    long lResumeStart = this.GetResumeStartIndex();
                    if (lResumeStart >= 0L) {
                        long lSkipped;
                        lTotalRead = lSkipped = finStream.skip(lResumeStart);
                    }
                    long lCalcPerSecSize = lTotalRead;
                    long lResumeReceivedSize = 0L;
                    long lBytesPerSec = 0L;
                    int nBufSize = Math.min(5120, nLen);
                    this.m_aBuffer = new byte[nBufSize];
                    if (nLen == 0) {
                        event = new CTransferStatsEvent(lBytesRead, lTotalRead, lFileSize, lBytesPerSec, fFile.getAbsolutePath());
                        event.SetRecalcOverall(bRecalcOverall);
                        event.SetResumeStartIndex(this.GetResumeStartIndex());
                        event.SetMarkerTime(lMarkerTime);
                        event.SetStartTime(this.m_lStartTime);
                        event.SetIsEmptyFile(true);
                        this.FireTransferStats(event);
                    }
                    while (nLen > 0 && (lBytesRead = (long)finStream.read(this.m_aBuffer, 0, this.m_aBuffer.length)) != -1L && !this.GetCancel()) {
                        bRecalcOverall = false;
                        if (DEBUG_TRACK_UPLOAD_INDICES) {
                            System.out.printf("lBytesRead: %d | nLen: %d | m_aBuffer.length: %d\r\n", lBytesRead, nLen, this.m_aBuffer.length);
                        }
                        outputStream2.write(this.m_aBuffer, 0, (int)lBytesRead);
                        lMarkerTime = System.currentTimeMillis();
                        nLen = (int)((long)nLen - lBytesRead);
                        this.m_lNumOfBytesRead += lBytesRead;
                        lTotalRead += lBytesRead;
                        lCalcPerSecSize = lResumeReceivedSize += lBytesRead;
                        if (bRecalcOverallOnce) {
                            bRecalcOverallOnce = false;
                            bRecalcOverall = true;
                        }
                        lBytesPerSec = CSUConnection.CalcBytesPerSecond(lMarkerTime, this.m_lStartTime, lCalcPerSecSize);
                        event = new CTransferStatsEvent(lBytesRead, lTotalRead, lFileSize, lBytesPerSec, fFile.getAbsolutePath());
                        event.SetRecalcOverall(bRecalcOverall);
                        event.SetResumeStartIndex(this.GetResumeStartIndex());
                        event.SetMarkerTime(lMarkerTime);
                        event.SetStartTime(this.m_lStartTime);
                        this.FireTransferStats(event);
                        if (lMarkerTime - this.m_lStartTime > 2000L) {
                            this.AdjustTransferBuffer(lBytesPerSec);
                        }
                        if (this.m_aBuffer.length <= nLen) continue;
                        this.m_aBuffer = null;
                        this.m_aBuffer = new byte[nLen];
                    }
                    sTemp = this.FmtEndBoundary(sBoundary);
                    outputStream2.write(sTemp.getBytes(), 0, sTemp.getBytes().length);
                    outputStream2.flush();
                    OutputStream outputStream3 = this.CloseOutputStream(outputStream2);
                }
                catch (NullPointerException npe) {
                    if (DEBUG) {
                        npe.printStackTrace();
                    }
                    break block27;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (IOException ioe) {
                        if (DEBUG) {
                            ioe.printStackTrace();
                        }
                        bPollForResult = true;
                        break block27;
                    }
                }
                finally {
                    OutputStream outputStream4 = this.CloseOutputStream(outputStream);
                    finStream = this.CloseInputStream(finStream);
                    this.m_aBuffer = null;
                    if (DEBUG_PRINT_RESPONSE_HEADER) {
                        this.PrintResponseHeader();
                    }
                    if (DEBUG_PRINT_RESPONSE_BODY) {
                        this.PrintResponseBody();
                    }
                }
                finStream = this.CloseInputStream(finStream);
                this.m_aBuffer = null;
                if (DEBUG_PRINT_RESPONSE_HEADER) {
                    this.PrintResponseHeader();
                }
                if (DEBUG_PRINT_RESPONSE_BODY) {
                    this.PrintResponseBody();
                }
                break block27;
            }
            anRet[1] = -6;
            bOverrideResult = true;
        }
        if (DEBUG_UPLOAD_MSGS) {
            Date date = new Date(System.currentTimeMillis());
            System.out.printf("Finished uploading: %s | Timestamp: %s\r\n", fFile.getName(), date.toString());
        }
        if (!bPollForResult) {
            anRet[0] = this.GetHTTPResponseCode();
            if (this.GetCancel()) return;
            if (bOverrideResult) return;
            if (anRet[0] != 200) return;
            BufferedInputStream bufferedInputStream = this.GetInputStream(anRet);
            if (anRet[0] != 200) return;
            if (bufferedInputStream == null) return;
            CResult rResult = new CResult(this);
            nParseRc = rResult.Parse(bufferedInputStream, bUseCompression);
            anRet[1] = rResult.GetResult();
            InputStream inputStream = this.CloseInputStream(bufferedInputStream);
            return;
        }
        anRet = this.PollForResult(lTransferID, bUseCompression);
    }

    private boolean AdjustTransferBuffer(long lBytesPerSecond) {
        boolean bContinue = true;
        long lBufferSize = this.m_aBuffer.length;
        lBufferSize = lBytesPerSecond < 102400L ? lBytesPerSecond / 6L : (lBytesPerSecond < 204800L ? lBytesPerSecond / 5L : (lBytesPerSecond < 307200L ? lBytesPerSecond / 4L : (lBytesPerSecond < 409600L ? lBytesPerSecond / 3L : lBytesPerSecond / 2L)));
        if (lBufferSize < 1024L) {
            lBufferSize = 1024L;
        }
        if ((double)Math.abs(lBufferSize - (long)this.m_aBuffer.length) > (double)this.m_aBuffer.length * 0.05) {
            int nBufSize = this.m_aBuffer.length;
            nBufSize = lBufferSize > 0x7FFFFFFEL ? 0x7FFFFFFE : (int)lBufferSize;
            if (DEBUG_DYNAMIC_BUFFER) {
                System.out.println("AdjustTransferBuffer: " + nBufSize);
            }
            this.m_aBuffer = null;
            try {
                this.m_aBuffer = new byte[nBufSize];
            }
            catch (Exception e) {
                try {
                    System.gc();
                    this.m_aBuffer = new byte[nBufSize];
                }
                catch (Exception ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                        CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "Failed to create a dynamic buffer.", false);
                    }
                    bContinue = false;
                    this.SetCancel(true);
                }
            }
        }
        return bContinue;
    }

    public static long CalcBytesPerSecond(long lCurTime, long lStartTime, long lNumOfBytes) {
        long lBytesPerSecond = 0L;
        long lSecondsElapsed = (lCurTime - lStartTime) / 1000L;
        if (lSecondsElapsed < 1L) {
            lSecondsElapsed = 1L;
        }
        lBytesPerSecond = lNumOfBytes / lSecondsElapsed;
        return lBytesPerSecond;
    }

    protected Vector<ITransferStatsListener> GetTransferStatsListeners() {
        return this.m_aTransferStatsListeners;
    }

    public void AddTransferStatsListener(ITransferStatsListener rListener) {
        if (this.GetTransferStatsListeners() != null && rListener != null) {
            this.GetTransferStatsListeners().add(rListener);
        }
    }

    public void RemoveTransferStatsListener(ITransferStatsListener rListener) {
        if (this.GetTransferStatsListeners() != null && rListener != null) {
            this.GetTransferStatsListeners().remove(rListener);
        }
    }

    protected void FireTransferStats(CTransferStatsEvent rEvent) {
        assert (rEvent != null);
        assert (this.GetTransferStatsListeners() != null);
        for (int nIdx = this.GetTransferStatsListeners().size() - 1; nIdx >= 0; --nIdx) {
            ITransferStatsListener rListener = this.GetTransferStatsListeners().get(nIdx);
            if (rListener == null) continue;
            rListener.OnUpdateTransferStats(rEvent);
        }
    }

    public int[] SendNoop(boolean bUseCompression) {
        int[] anRet = new int[2];
        int nParseRc = 1;
        anRet[0] = 503;
        anRet[1] = 1;
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateNoop();
            anRet[0] = this.Get(rURL, asHeaderInfo = this.CompileRequestHeader(bUseCompression));
            if (anRet[0] == 200) {
                String sAcceptEncoding = this.GetHeaderValue("Accept-Encoding", anRet);
                if (sAcceptEncoding != null && anRet[0] == 200) {
                    sAcceptEncoding = sAcceptEncoding.toLowerCase();
                }
                if (anRet[0] == 200) {
                    BufferedInputStream inStream = this.GetInputStream(anRet);
                    if (anRet[0] == 200 && inStream != null) {
                        CNoop Noop = new CNoop(this);
                        Noop.Parse(inStream, bUseCompression);
                        if (this.GetClientInfo() != null) {
                            this.GetClientInfo().SetCaseSensitiveOS(Noop.IsCaseSensitiveOS());
                        }
                        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetClientInfo() != null && CMainFrame.GET_APP().GetClientInfo() != this.GetClientInfo()) {
                            CMainFrame.GET_APP().GetClientInfo().SetCaseSensitiveOS(Noop.IsCaseSensitiveOS());
                        }
                        anRet[1] = Noop.GetResult();
                        this.CloseInputStream(inStream);
                    }
                }
            }
            this.Disconnect();
        }
        if (nParseRc == 3) {
            anRet = this.SendNoop(false);
        }
        return anRet;
    }

    public int[] SendNoop() {
        return this.SendNoop(this.UseCompression());
    }

    public int[] SendLogout(boolean bUseCompression) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateLogout();
            anRet[0] = this.Get(rURL, asHeaderInfo = this.CompileRequestHeader(bUseCompression));
            if (anRet[0] == 200) {
                anRet[1] = 0;
            }
            this.Disconnect();
        }
        return anRet;
    }

    public int[] SendLogout() {
        return this.SendLogout(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] SendChangePassword(String sOldPword, String sNewPword, boolean bUseCompression) {
        int[] anRet = new int[2];
        int nParseRc = 1;
        anRet[0] = 503;
        anRet[1] = 1;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateChangePassword();
            StringBuilder sData = new StringBuilder();
            sData.append("old_password=" + CSUURLFactory.URLEncode(sOldPword));
            sData.append("&");
            sData.append("new_password=" + CSUURLFactory.URLEncode(sNewPword));
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            byte[] aData = sData.toString().getBytes();
            int nContentLen = aData.length;
            anRet[0] = this.Post(rURL, asHeaderInfo, nContentLen);
            if (anRet[0] == 1) {
                OutputStream outStream = null;
                InputStream inStream = null;
                try {
                    outStream = this.GetOutputStream();
                    outStream.write(aData, 0, nContentLen);
                    outStream.flush();
                    outStream = this.CloseOutputStream(outStream);
                    anRet[0] = this.GetHTTPResponseCode();
                    inStream = this.GetInputStream(anRet);
                    if (anRet[0] == 200 && inStream != null) {
                        CResult rResult = new CResult(this);
                        nParseRc = rResult.Parse(inStream, bUseCompression);
                        anRet[1] = rResult.GetResult();
                        inStream = this.CloseInputStream(inStream);
                    }
                }
                catch (IOException ioe) {
                    if (DEBUG) {
                        ioe.printStackTrace();
                    }
                }
                finally {
                    this.CloseOutputStream();
                    this.CloseInputStream();
                }
            }
            this.Disconnect();
        }
        if (nParseRc == 3) {
            anRet = this.SendChangePassword(sOldPword, sNewPword, false);
        }
        return anRet;
    }

    public int[] SendChangePassword(String sOldPword, String sNewPword) {
        return this.SendChangePassword(sOldPword, sNewPword, this.UseCompression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] SendChangeEmail(String sNewEmail, boolean bUseCompression) {
        int[] anRet = new int[2];
        int nParseRc = 1;
        anRet[0] = 503;
        anRet[1] = 1;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateChangeEmail();
            StringBuilder sData = new StringBuilder();
            sData.append("emailaddress=" + CSUURLFactory.URLEncode(sNewEmail));
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            byte[] aData = sData.toString().getBytes();
            int nContentLen = aData.length;
            anRet[0] = this.Post(rURL, asHeaderInfo, nContentLen);
            if (anRet[0] == 1) {
                OutputStream outStream = null;
                InputStream inStream = null;
                try {
                    outStream = this.GetOutputStream();
                    outStream.write(aData, 0, nContentLen);
                    outStream.flush();
                    outStream = this.CloseOutputStream(outStream);
                    anRet[0] = this.GetHTTPResponseCode();
                    inStream = this.GetInputStream(anRet);
                    if (anRet[0] == 200 && inStream != null) {
                        CResult rResult = new CResult(this);
                        nParseRc = rResult.Parse(inStream, bUseCompression);
                        anRet[1] = rResult.GetResult();
                        inStream = this.CloseInputStream(inStream);
                    }
                }
                catch (IOException ioe) {
                    if (DEBUG) {
                        ioe.printStackTrace();
                    }
                }
                finally {
                    this.CloseOutputStream();
                    this.CloseInputStream();
                }
            }
            this.Disconnect();
        }
        if (nParseRc == 3) {
            anRet = this.SendChangeEmail(sNewEmail, false);
        }
        return anRet;
    }

    public int[] SendChangeEmail(String sNewEmail) {
        return this.SendChangeEmail(sNewEmail, this.UseCompression());
    }

    private int[] PollForResult(long lTransferID, boolean bUseCompression) {
        boolean bTimedOut;
        int[] anRet = null;
        long lTimeout = System.currentTimeMillis() + 30000L;
        boolean bContinue = true;
        boolean bl = bTimedOut = System.currentTimeMillis() >= lTimeout;
        while (bContinue && !bTimedOut) {
            boolean bl2 = bTimedOut = System.currentTimeMillis() >= lTimeout;
            anRet = this.SendTransferStats(lTransferID, bUseCompression);
            if (anRet == null || anRet.length != 2 || anRet[0] != 200 || anRet[1] == -1 || anRet[1] == 6 || anRet[1] == 9) continue;
            bContinue = false;
        }
        if (anRet != null && anRet.length == 2 && anRet[1] == -1) {
            anRet[1] = 1;
        }
        if (bTimedOut) {
            anRet[1] = 20;
        }
        return anRet;
    }

    public int[] SendTransferStats(long lTransferID, boolean bUseCompression) {
        int[] anRet = new int[]{503, -1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateTransferStats(lTransferID);
            anRet = this.GetResult(rURL, bUseCompression);
        }
        return anRet;
    }

    protected Vector<IListDirListener> GetListDirListeners() {
        return this.m_aListDirListeners;
    }

    public void AddListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().add(rListener);
        }
    }

    public void RemoveListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().remove(rListener);
        }
    }

    public int GetListDirListenerCount() {
        int nCount = 0;
        if (this.GetListDirListeners() != null) {
            nCount = this.GetListDirListeners().size();
        }
        return nCount;
    }

    public IListDirListener GetListDirListener(int nIndex) {
        IListDirListener rListener = null;
        if (this.GetListDirListeners() != null && nIndex >= 0 && nIndex < this.GetListDirListenerCount()) {
            rListener = this.GetListDirListeners().get(nIndex);
        }
        return rListener;
    }

    public synchronized boolean GetResume() {
        return this.m_bResume;
    }

    public synchronized void SetResume(boolean bResume) {
        this.m_bResume = bResume;
    }

    private long FindResumeStartIndex(String sAbsToPath, boolean bDestIsRemote) {
        long lStart = 0L;
        if (bDestIsRemote) {
            CFile fChild;
            int[] anRetCodes = this.SendListPath(sAbsToPath, false);
            if (anRetCodes != null && anRetCodes.length == 2 && anRetCodes[0] == 200 && anRetCodes[1] == 0 && this.GetListDir() != null && (fChild = this.GetListDir().GetChildFile(0)) != null) {
                lStart = fChild.GetSize();
            }
        } else {
            File fDest = new File(sAbsToPath);
            if (fDest != null && fDest.exists()) {
                lStart = fDest.length();
            }
        }
        return lStart;
    }

    private void SetResumeStartIndex(long lStartIndex) {
        this.m_lResumeStartIndex = lStartIndex;
    }

    private long GetResumeStartIndex() {
        return this.m_lResumeStartIndex;
    }

    private void SetResumeEndIndex(long lEndIndex) {
        this.m_lResumeEndIndex = lEndIndex;
    }

    private long GetResumeEndIndex() {
        return this.m_lResumeEndIndex;
    }

    private void SetResumeRange(long lStartIndex, long lEndIndex) {
        this.SetResumeStartIndex(lStartIndex);
        this.SetResumeEndIndex(lEndIndex);
    }

    public URL GetDownloadMediaURI(String sAbsFromPath) {
        URL url = null;
        if (this.GetURLFactory() != null) {
            url = this.GetURLFactory().CreateDownloadMedia(sAbsFromPath);
        }
        return url;
    }

    public int[] SendGetDirectorySize(String sAbsPath) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateGetDirectorySize(sAbsPath);
            CDirSize rDirSize = new CDirSize(this);
            anRet = this.Get(rURL, this.UseCompression(), rDirSize);
            this.m_lDirectorySize = rDirSize.GetDirectorySize();
            rDirSize = null;
        }
        return anRet;
    }

    public int[] SendGetSpaceAvailable(String sAbsPath) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateGetSpaceAvailable(sAbsPath);
            CSpaceAvailable rSpaceAvail = new CSpaceAvailable(this);
            anRet = this.Get(rURL, this.UseCompression(), rSpaceAvail);
            this.m_lSpaceAvailable = rSpaceAvail.GetSpaceAvailable();
            rSpaceAvail = null;
        }
        return anRet;
    }

    public long GetDirSize() {
        return this.m_lDirectorySize;
    }

    public long GetSpaceAvailable() {
        return this.m_lSpaceAvailable;
    }

    public String GetDirChangeMsg() {
        return this.m_sDirChangeMsg;
    }

    public int GetNumOfThumbs() {
        return this.m_nNumOfThumbs;
    }

    public int GetNumOfDirs() {
        return this.m_nNumOfDirs;
    }

    protected int[] Get(URL rURL, boolean bUseCompression, CParsedObj rResponseParser) {
        int[] anRetCodes = new int[]{503, 1};
        if (rURL != null && rResponseParser != null) {
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            anRetCodes[0] = this.Get(rURL, asHeaderInfo);
            if (anRetCodes[0] == 200) {
                BufferedInputStream inStream = null;
                inStream = this.GetInputStream(anRetCodes);
                if (anRetCodes[0] == 200 && inStream != null) {
                    int nParsedResult = 1;
                    nParsedResult = rResponseParser.Parse(inStream, bUseCompression);
                    if (nParsedResult == 3 && bUseCompression) {
                        anRetCodes = this.Get(rURL, false, rResponseParser);
                    } else {
                        anRetCodes[1] = rResponseParser.GetResult();
                    }
                }
                this.Disconnect();
            }
        } else if (DEBUG) {
            CUtils.ASSERT(CSUConnection.class.getName(), CUtils.GetLineNumber(), "Programming error, invalid argument.", false);
        }
        return anRetCodes;
    }

    protected int[] GetResult(URL rURL, boolean bUseCompression) {
        CResult rResult = new CResult(this);
        int[] anRetCodes = this.Get(rURL, bUseCompression, rResult);
        rResult = null;
        return anRetCodes;
    }

    protected int[] GetListing(URL rURL, boolean bUseCompression) {
        CListing rListing = new CListing(this);
        for (IListDirListener rListener : this.GetListDirListeners()) {
            rListing.AddListDirListener(rListener);
        }
        int[] anRetCodes = this.Get(rURL, bUseCompression, rListing);
        for (IListDirListener rListener : this.GetListDirListeners()) {
            rListing.RemoveListDirListener(rListener);
        }
        this.m_sDirChangeMsg = rListing.GetDirChangeMsg();
        this.m_RemoteFile = rListing.GetParent();
        this.m_nNumOfThumbs = rListing.GetNumOfThumbs();
        this.m_nNumOfDirs = rListing.GetNumOfDirs();
        rListing = null;
        return anRetCodes;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_DYNAMIC_BUFFER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_UPLOAD_INDICES = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SPEED_LISTING = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPLOAD_WATCHDOG = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPLOAD_MSGS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPLOAD_FILE_RET_GOOD = false;
    }
}

