/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.net;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CSUConnection;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class CLogin {
    public static final boolean DEBUG_VIEW_RESPONSE;
    public static final boolean DEBUG_LOGIN_SSL;
    public static final String XML_TAG_RESULT = "Result";
    public static final String XML_TAG_ENC_SESSION_ID = "EncSessionID";
    public static final String XML_TAG_SESSION_ID = "SessionID";
    public static final String XML_TAG_SUPPORT_LINK = "SupportLink";
    public static final String XML_TAG_CAN_CHANGE_PASSWORD = "CanChangePassword";
    public static final String XML_TAG_IS_LOCAL_ADMIN = "IsLocalAdmin";
    public static final String XML_TAG_USER_EMAIL_ADDRESS = "UserEmailAddress";
    public static final String XML_TAG_USER_CAN_SET_EMAIL_ADDRESS = "UserCanSetEmailAddress";
    public static final String XML_TAG_REQUIRE_EMAIL_ADDRESS = "RequireEmailAddress";
    public static final String XML_TAG_WELCOME_MSG = "WelcomeMsg";
    public static final String URI_EQUALS = "=";
    public static final String URI_ITEM_DELIMITER = "%2C";
    public static final String URI_ARGUMENT_DELIMITER = "&";
    public static final String URI_USER = "user";
    public static final String URI_USER_EQUALS = "user=";
    public static final String URI_PASSWORD = "pword";
    public static final String URI_PASSWORD_EQUALS = "pword=";
    public static final String URI_LANGUAGE = "language";
    public static final String URI_LANGUAGE_EQUALS = "language=";
    private String m_sResult;
    private String m_sEncSessionID = "";
    private String m_sSessionID = "";
    private String m_sSupportLink = "0,";
    private String m_sCanChangePassword = "0";
    private String m_sIsLocalAdmin = "0";
    private String m_sUserEmailAddress = "";
    private String m_sUserCanSetEmailAddress = "0";
    private String m_sRequireEmailAddress = "0";
    private String m_sWelcomeMsg;
    private int m_nHTTPResponseCode = 503;

    private boolean IsTrue(String sVal) {
        boolean bIsTrue = false;
        if (sVal != null && !sVal.isEmpty() && !sVal.equals("0")) {
            bIsTrue = true;
        }
        return bIsTrue;
    }

    private String ParseXmlTag(String sXML, String sTag) {
        String sVal = null;
        if (sXML != null && !sXML.isEmpty() && sTag != null && !sTag.isEmpty()) {
            String sXmlTag = String.format("<%s>", sTag);
            int nStartIdx = sXML.indexOf(sXmlTag);
            nStartIdx += sXmlTag.length();
            sXmlTag = String.format("</%s>", sTag);
            int nEndIdx = sXML.indexOf(sXmlTag);
            if (nStartIdx >= 0 && nEndIdx < sXML.length() && nStartIdx < nEndIdx) {
                sVal = sXML.substring(nStartIdx, nEndIdx);
            }
        }
        return sVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Login(boolean bIsSecure, String sHost, long lPort, String sUser, String sPword, String sLang, String sLocale) {
        boolean bReceivedResponse = false;
        if (sPword == null) {
            sPword = "";
        }
        String sProtocol = "http://";
        if (bIsSecure) {
            sProtocol = "https://";
        }
        String sURL = String.format("%s%s:%s/%s?Command=Login", sProtocol, sHost, Long.toString(lPort), "Common/Java/Responses/Login.xml");
        HttpURLConnection HTTPSocket = null;
        OutputStream OutStream = null;
        InputStream InStream = null;
        try {
            URL LoginURL = new URL(sURL);
            String sWriteOut = URI_USER_EQUALS + CUtils.UrlEncode(sUser) + URI_ARGUMENT_DELIMITER;
            sWriteOut = sWriteOut + URI_PASSWORD_EQUALS + CUtils.UrlEncode(sPword) + URI_ARGUMENT_DELIMITER;
            sWriteOut = sWriteOut + URI_LANGUAGE_EQUALS + sLang + URI_ITEM_DELIMITER + sLocale + URI_ARGUMENT_DELIMITER;
            byte[] aWriteBytes = sWriteOut.getBytes();
            int nContentLen = aWriteBytes.length;
            HTTPSocket = (HttpURLConnection)LoginURL.openConnection();
            HTTPSocket.setDoOutput(true);
            HTTPSocket.setDoInput(true);
            HTTPSocket.setRequestMethod("POST");
            HTTPSocket.setFixedLengthStreamingMode(nContentLen);
            HTTPSocket.setRequestProperty("Content-Length", Integer.toString(nContentLen));
            OutStream = HTTPSocket.getOutputStream();
            OutStream.write(aWriteBytes, 0, nContentLen);
            OutStream.flush();
            OutStream.close();
            InStream = HTTPSocket.getInputStream();
            int nBufSize = 2048;
            byte[] aBuffer = new byte[nBufSize];
            long lBytesRead = 0L;
            while ((lBytesRead = (long)InStream.read(aBuffer, 0, aBuffer.length)) != -1L) {
                String sXML = new String(aBuffer);
                if (DEBUG_VIEW_RESPONSE) {
                    CMainFrame.Info(sXML);
                }
                String[] asXMLTags = new String[]{XML_TAG_RESULT, XML_TAG_ENC_SESSION_ID, XML_TAG_SESSION_ID, XML_TAG_SUPPORT_LINK, XML_TAG_CAN_CHANGE_PASSWORD, XML_TAG_IS_LOCAL_ADMIN, XML_TAG_USER_EMAIL_ADDRESS, XML_TAG_USER_CAN_SET_EMAIL_ADDRESS, XML_TAG_REQUIRE_EMAIL_ADDRESS, XML_TAG_WELCOME_MSG};
                for (int nIdx = 0; nIdx < asXMLTags.length; ++nIdx) {
                    String sKey = asXMLTags[nIdx];
                    String sValue = this.ParseXmlTag(sXML, sKey);
                    if (sValue == null) continue;
                    if (sKey.equals(XML_TAG_RESULT)) {
                        this.m_sResult = sValue;
                        continue;
                    }
                    if (sKey.equals(XML_TAG_ENC_SESSION_ID)) {
                        this.m_sEncSessionID = sValue;
                        continue;
                    }
                    if (sKey.equals(XML_TAG_SESSION_ID)) {
                        this.m_sSessionID = sValue;
                        continue;
                    }
                    if (sKey.equals(XML_TAG_SUPPORT_LINK)) {
                        this.m_sSupportLink = sValue;
                        continue;
                    }
                    if (sKey.equals(XML_TAG_CAN_CHANGE_PASSWORD)) {
                        this.m_sCanChangePassword = sValue;
                        continue;
                    }
                    if (sKey.equals(XML_TAG_IS_LOCAL_ADMIN)) {
                        this.m_sIsLocalAdmin = sValue;
                        continue;
                    }
                    if (sKey.equals(XML_TAG_USER_EMAIL_ADDRESS)) {
                        this.m_sUserEmailAddress = sValue;
                        continue;
                    }
                    if (sKey.equals(XML_TAG_USER_CAN_SET_EMAIL_ADDRESS)) {
                        this.m_sUserCanSetEmailAddress = sValue;
                        continue;
                    }
                    if (sKey.equals(XML_TAG_REQUIRE_EMAIL_ADDRESS)) {
                        this.m_sRequireEmailAddress = sValue;
                        continue;
                    }
                    if (!sKey.equals(XML_TAG_WELCOME_MSG)) continue;
                    this.m_sWelcomeMsg = sValue;
                }
            }
            InStream.close();
            this.m_nHTTPResponseCode = HTTPSocket.getResponseCode();
            bReceivedResponse = true;
            HTTPSocket.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            block36: {
                block35: {
                    try {
                        if (InStream != null) {
                            InStream.close();
                        }
                    }
                    catch (Exception e) {
                        if (!CMainFrame.DEBUG) break block35;
                        e.printStackTrace();
                    }
                }
                try {
                    if (OutStream != null) {
                        OutStream.close();
                    }
                }
                catch (Exception e) {
                    if (!CMainFrame.DEBUG) break block36;
                    e.printStackTrace();
                }
            }
            if (HTTPSocket != null) {
                HTTPSocket.disconnect();
            }
        }
        return bReceivedResponse;
    }

    public int[] ChangePassword(boolean bIsSecure, String sHost, long lPort, String sEncSessionID, String sOldPassword, String sNewPassword, int nCompressionType) {
        CClientInfo rInfo = new CClientInfo();
        rInfo.SetIsSecure(bIsSecure);
        rInfo.SetHost(sHost);
        rInfo.SetPort(lPort);
        rInfo.SetEncSessionID(sEncSessionID);
        CSUConnection rConn = new CSUConnection(rInfo, nCompressionType);
        return rConn.SendChangePassword(sOldPassword, sNewPassword);
    }

    public int[] ChangeEmail(boolean bIsSecure, String sHost, long lPort, String sEncSessionID, String sNewEmail, int nCompressionType) {
        CClientInfo rInfo = new CClientInfo();
        rInfo.SetIsSecure(bIsSecure);
        rInfo.SetHost(sHost);
        rInfo.SetPort(lPort);
        rInfo.SetEncSessionID(sEncSessionID);
        CSUConnection rConn = new CSUConnection(rInfo, nCompressionType);
        int[] anRetCodes = rConn.SendChangeEmail(sNewEmail);
        if (anRetCodes != null && anRetCodes.length == 2 && anRetCodes[0] == 200 && anRetCodes[1] == 0) {
            this.m_sUserEmailAddress = "0," + sNewEmail;
        }
        return anRetCodes;
    }

    public int[] Logout(boolean bIsSecure, String sHost, long lPort, String sEncSessionID, int nCompressionType) {
        CClientInfo rInfo = new CClientInfo();
        rInfo.SetIsSecure(bIsSecure);
        rInfo.SetHost(sHost);
        rInfo.SetPort(lPort);
        rInfo.SetEncSessionID(sEncSessionID);
        CSUConnection rConn = new CSUConnection(rInfo, nCompressionType);
        return rConn.SendLogout();
    }

    public String GetResultString() {
        return this.m_sResult;
    }

    public int GetResult() {
        int nResult = 1;
        if (this.GetResultString() != null && !this.GetResultString().isEmpty()) {
            nResult = Integer.parseInt(this.GetResultString());
        }
        return nResult;
    }

    public String GetEncSessionID() {
        return this.m_sEncSessionID;
    }

    public String GetSessionID() {
        return this.m_sSessionID;
    }

    public String GetSupportLinkString() {
        return this.m_sSupportLink;
    }

    public String GetSupportLink() {
        String[] asItems;
        String sSupportLink = "";
        if (this.GetSupportLinkString() != null && !this.GetSupportLinkString().isEmpty() && (asItems = this.GetSupportLinkString().split(",")) != null && asItems.length == 2) {
            sSupportLink = asItems[1];
        }
        return sSupportLink;
    }

    public String GetCanChangePasswordString() {
        return this.m_sCanChangePassword;
    }

    public boolean GetCanChangePassword() {
        return this.IsTrue(this.GetCanChangePasswordString());
    }

    public String GetUserEmailAddressString() {
        return this.m_sUserEmailAddress;
    }

    public String GetUserEmailAddress() {
        String[] asItems;
        String sEmailAddress = "";
        if (this.GetUserEmailAddressString() != null && !this.GetUserEmailAddressString().isEmpty() && (asItems = this.GetUserEmailAddressString().split(",")) != null && asItems.length == 2) {
            sEmailAddress = asItems[1];
        }
        return sEmailAddress;
    }

    public String GetUserCanSetEmailAddressString() {
        return this.m_sUserCanSetEmailAddress;
    }

    public boolean GetUserCanSetEmailAddress() {
        return this.IsTrue(this.GetUserCanSetEmailAddressString());
    }

    public String GetRequireEmailAddressString() {
        return this.m_sRequireEmailAddress;
    }

    public boolean GetRequireEmailAddress() {
        return this.IsTrue(this.GetRequireEmailAddressString());
    }

    public String GetIsLocalAdminString() {
        return this.m_sIsLocalAdmin;
    }

    public boolean IsLocalAdmin() {
        return this.IsTrue(this.GetIsLocalAdminString());
    }

    public int GetHTTPResponseCode() {
        return this.m_nHTTPResponseCode;
    }

    public String GetWelcomeMsg(boolean bURLDecode) {
        String sWelcomeMsg = this.m_sWelcomeMsg;
        if (bURLDecode) {
            sWelcomeMsg = CUtils.UrlDecode(sWelcomeMsg);
        }
        return sWelcomeMsg;
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_VIEW_RESPONSE = false;
        DEBUG_LOGIN_SSL = CMainFrame.DEBUG;
    }
}

