/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser.local;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.frames.CBaseDockBarFactory;
import com.rhinosoft.base.gui.frames.CBaseDockFrameFactory;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserPanel;
import com.rhinosoft.fvjv.gui.frames.browser.local.CLocalBarFactory;
import com.rhinosoft.fvjv.gui.frames.browser.local.CLocalFilePanel;
import com.rhinosoft.fvjv.gui.frames.browser.local.CLocalFrameFactory;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.local.CLocalThread;
import java.awt.AWTEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.filechooser.FileSystemView;

public class CLocalPanel
extends CBrowserPanel {
    public static final String THREAD_NAME_GENERAL = "LocalGeneral";
    public static final String THREAD_NAME_THUMBS = "LocalThumbs";
    public static final String THREAD_NAME_PREVIEW = "LocalPreview";
    public static final String THREAD_NAME_SEARCH = "LocalSearch";

    public static void main(String[] args) {
        LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        JFrame frame = new JFrame("Preview of initial layout designed by Visual Designer");
        frame.setDefaultCloseOperation(2);
        CLocalPanel panel = new CLocalPanel(frame, 0L);
        frame.getContentPane().add(panel);
        frame.toFront();
    }

    public CLocalPanel(RootPaneContainer rootPaneContainer, long lKeyID) {
        super(rootPaneContainer, lKeyID);
        this.InitVars();
    }

    @Override
    protected CBaseDockFrameFactory CreateDockFrameFactory() {
        return new CLocalFrameFactory(this);
    }

    @Override
    protected CBaseDockBarFactory CreateDockableBarFactory() {
        return new CLocalBarFactory(this);
    }

    @Override
    protected CBaseThread CreateThread(String sName) {
        CLocalThread tThread = null;
        if (CMainFrame.GET_APP() != null) {
            tThread = CMainFrame.GET_APP().CreateLocalThread(sName);
        }
        return tThread;
    }

    @Override
    protected CBaseThread CreateThreadGeneral() {
        return this.CreateThread(THREAD_NAME_GENERAL);
    }

    @Override
    protected CBaseThread CreateThreadThumbs() {
        return this.CreateThread(THREAD_NAME_THUMBS);
    }

    @Override
    protected CBaseThread CreateThreadPreview() {
        return this.CreateThread(THREAD_NAME_PREVIEW);
    }

    @Override
    protected CBaseThread CreateThreadSearch() {
        return this.CreateThread(THREAD_NAME_SEARCH);
    }

    @Override
    protected String GetKey() {
        String sRet = String.format("%s%s%d", "Local", "_", this.GetKeyID());
        return sRet;
    }

    @Override
    protected String GetKeyPrevLockFrame() {
        String sRet = String.format("%s%s%s%d", "Locked_", "Local", "_", this.GetKeyID());
        return sRet;
    }

    @Override
    protected String GetDefLastSessionDir() {
        return FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
    }

    private void InitVars() {
        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetLocalRoot() != null) {
            this.LoadWorkingDir(false);
        }
    }

    @Override
    protected boolean IsLocal() {
        return true;
    }

    @Override
    protected CFilePanel CreateFilePanel(CBaseThread rtGeneralThread, CBaseThread rtThumbThread, long lUniqueID) {
        return new CLocalFilePanel(rtGeneralThread, rtThumbThread, lUniqueID);
    }

    @Override
    protected String GetLastSessionDir(boolean bLoadDefaultDir) {
        String sLastSessionDir = super.GetLastSessionDir(bLoadDefaultDir);
        File fLastPath = new File(sLastSessionDir);
        if (!(fLastPath != null && fLastPath.exists() || FileSystemView.getFileSystemView() == null || FileSystemView.getFileSystemView().getDefaultDirectory() == null)) {
            sLastSessionDir = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        }
        return sLastSessionDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 3021: {
                    if (!(rEvent.GetEventObj() instanceof CThreadMsg)) return;
                    CThreadMsg rThreadMsg = (CThreadMsg)rEvent.GetEventObj();
                    switch (rThreadMsg.GetMsgID()) {
                        case 6: {
                            this.LoadWorkingDir(false);
                            if (this.GetBreadBar() != null) {
                                this.GetBreadBar().dispatchEvent(rEvent);
                            }
                            if (this.GetTree() == null) return;
                            this.GetTree().dispatchEvent(rEvent);
                            return;
                        }
                        default: {
                            super.processEvent(event);
                            return;
                        }
                    }
                }
                default: {
                    super.processEvent(event);
                }
            }
            return;
        }
        super.processEvent(event);
    }
}

