/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.frames.CFVJVDockPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.CNestedFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserPanel;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.AWTEvent;
import javax.swing.RootPaneContainer;

public abstract class CNestedBrowserFrame
extends CNestedFrame {
    public CNestedBrowserFrame(String sDockKey) {
        super(sDockKey);
        this.InitVars();
    }

    protected abstract CBrowserPanel CreatePanel(RootPaneContainer var1, long var2);

    @Override
    protected String GetAbsLayoutFilePath() {
        String sPath = null;
        if (CMainFrame.GET_APP() != null) {
            sPath = CMainFrame.GET_APP().GetDiskPathInitialBrowserTemplateLayout();
        }
        return sPath;
    }

    @Override
    protected CFVJVDockPanel CreatePanel(RootPaneContainer rootPaneContainer) {
        long lKeyID;
        CBrowserPanel rPanel = null;
        if (CMainFrame.GET_APP() != null && (lKeyID = CMainFrame.GET_APP().GetUniqueID(this.getKey())) > -1L) {
            rPanel = this.CreatePanel(CMainFrame.GET_APP(), lKeyID);
        }
        return rPanel;
    }

    private void InitVars() {
    }

    public CBrowserPanel GetBrowserPanel() {
        return (CBrowserPanel)this.GetDockPanel();
    }

    @Override
    protected void processEvent(AWTEvent event) {
        block10: {
            block9: {
                if (DEBUG_TRACK_EVENTS) {
                    System.out.println(String.format("CNestedBrowserFrame.processEvent(%d)", event.getID()));
                }
                if (!(event instanceof CRhinoEvent)) break block9;
                CRhinoEvent rEvent = (CRhinoEvent)event;
                switch (event.getID()) {
                    case 6008: {
                        Object[] arObjs = (Object[])rEvent.GetEventObj();
                        if (this.GetBrowserPanel().IsEventSource(arObjs[1]) && arObjs[0] instanceof CFile) {
                            CFile fWorkingDir = (CFile)arObjs[0];
                            this.InitTitles(fWorkingDir);
                        }
                        if (this.GetDockPanel() != null) {
                            this.GetDockPanel().dispatchEvent(event);
                            break;
                        }
                        break block10;
                    }
                    case 6006: 
                    case 6007: {
                        CFile fFile = (CFile)rEvent.GetEventObj();
                        if (fFile != null && this.GetBrowserPanel() != null && this.GetBrowserPanel().GetWorkingDir() == fFile) {
                            this.InitTitles(fFile);
                        }
                        if (this.GetDockPanel() != null) {
                            this.GetDockPanel().dispatchEvent(event);
                            break;
                        }
                        break block10;
                    }
                    default: {
                        super.processEvent(event);
                    }
                }
                break block10;
            }
            super.processEvent(event);
        }
    }

    private void InitTitles(CFile fWorkingDir) {
        if (fWorkingDir != null) {
            String sType = "";
            sType = fWorkingDir.IsLocal() ? CString.LoadString("IDS_DOCK_TITLE_PANE_LOCAL") : CString.LoadString("IDS_DOCK_TITLE_PANE_REMOTE");
            String sPath = String.format("%s (%s)", sType, fWorkingDir.GetPath());
            String sName = String.format("%s (%s)", sType, fWorkingDir.GetDisplayName());
            this.setTitle(sPath);
            this.setTabTitle(sName);
            this.setSideTitle(sName);
            String[] asItems = new String[]{this.getKey(), sName};
            CRhinoEvent rEvent = new CRhinoEvent(this, 9101, asItems);
            if (CMainFrame.GET_APP() != null) {
                CMainFrame.GET_APP().dispatchEvent(rEvent);
            }
        }
    }

    public CFile GetWorkingDir() {
        CFile fWorkingDir = null;
        if (this.GetBrowserPanel() != null) {
            fWorkingDir = this.GetBrowserPanel().GetWorkingDir();
        }
        return fWorkingDir;
    }

    public abstract boolean IsLocal();
}

