/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.rhinosoft.base.gui.frames.CBaseDockBarFactory;
import com.rhinosoft.base.gui.frames.CBaseDockFrameFactory;
import com.rhinosoft.fvjv.gui.frames.CFVJVDockPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CCustomBarFactory;
import com.rhinosoft.fvjv.gui.frames.browser.CCustomFrameFactory;
import com.rhinosoft.fvjv.gui.frames.browser.local.CLocalPanel;
import com.rhinosoft.fvjv.strings.CString;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;

public class CCustomPanel
extends CFVJVDockPanel {
    public static final String INITIAL_LAYOUT_KEY_DOCK_FRAME_TREE = "Tree";
    public static final String INITIAL_LAYOUT_KEY_DOCK_FRAME_PREVIEW = "Preview";
    public static final String INITIAL_LAYOUT_KEY_DOCK_BAR_NAVIGATION = "NavigationBar";
    public static final String INITIAL_LAYOUT_KEY_DOCK_BAR_SEARCHBAR = "SearchBar";
    private long m_lKeyID;
    private String m_sKeyTree;
    private String m_sKeyPreview;

    public static void main(String[] args) {
        LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        JFrame frame = new JFrame("Preview of initial layout designed by Visual Designer");
        frame.setDefaultCloseOperation(2);
        CLocalPanel panel = new CLocalPanel(frame, 0L);
        frame.getContentPane().add(panel);
        frame.toFront();
    }

    public CCustomPanel(RootPaneContainer rootPaneContainer, long lKeyID) {
        super(rootPaneContainer);
        this.InitVars(lKeyID);
    }

    @Override
    protected void InitStoredLayout() {
        String sTemp;
        StringBuilder sRetPath = new StringBuilder();
        if (CMainFrame.GET_APP() != null && (sTemp = CMainFrame.GET_APP().GetDiskPathFVJVUser()) != null && !sTemp.isEmpty()) {
            sRetPath.append(sTemp);
            sRetPath = CString.EnsureLastCharIsAFileSeparator(sRetPath);
            sRetPath.append("BrowserPane");
            sRetPath.append("_");
            sRetPath.append(this.GetKeyID());
            sRetPath.append(".layout");
        }
        this.SetStoredLayout(new File(sRetPath.toString()));
    }

    private void InitVars(long lKeyID) {
        this.m_lKeyID = lKeyID;
        if (lKeyID > -1L) {
            this.InitStoredLayout();
        }
    }

    protected long GetKeyID() {
        return this.m_lKeyID;
    }

    @Override
    protected CBaseDockFrameFactory CreateDockFrameFactory() {
        return new CCustomFrameFactory(this);
    }

    @Override
    protected CBaseDockBarFactory CreateDockableBarFactory() {
        return new CCustomBarFactory(this);
    }

    protected void SetKeyTree(String sKey) {
        this.m_sKeyTree = sKey;
    }

    protected void SetKeyPreview(String sKey) {
        this.m_sKeyPreview = sKey;
    }

    private String GetKeyPrefix(String sKey) {
        int nFound;
        if (sKey != null && (nFound = sKey.lastIndexOf("_")) >= 0 && nFound < sKey.length()) {
            sKey = sKey.substring(0, nFound);
        }
        return sKey;
    }

    public String GetKeyTree() {
        return this.GetKeyTree(false);
    }

    private String GetKeyTree(boolean bStripID) {
        String sKey = this.m_sKeyTree;
        if (bStripID) {
            sKey = this.GetKeyPrefix(sKey);
        }
        return sKey;
    }

    public String GetKeyPreview() {
        return this.GetKeyPreview(false);
    }

    private String GetKeyPreview(boolean bStripID) {
        String sKey = this.m_sKeyPreview;
        if (bStripID) {
            sKey = this.GetKeyPrefix(sKey);
        }
        return sKey;
    }

    public String GetKeyNavigation() {
        String sRet = INITIAL_LAYOUT_KEY_DOCK_BAR_NAVIGATION;
        sRet = String.format("%s%s%d", INITIAL_LAYOUT_KEY_DOCK_BAR_NAVIGATION, "_", this.GetKeyID());
        return sRet;
    }

    public String GetKeyToolbar() {
        String sRet = "Toolbar";
        sRet = String.format("%s%s%d", "Toolbar", "_", this.GetKeyID());
        return sRet;
    }

    public String GetKeySearchBar() {
        String sRet = INITIAL_LAYOUT_KEY_DOCK_BAR_SEARCHBAR;
        sRet = String.format("%s%s%d", INITIAL_LAYOUT_KEY_DOCK_BAR_SEARCHBAR, "_", this.GetKeyID());
        return sRet;
    }
}

