/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.swing.JideSplitButton;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.docking.CRhinoSplitBtn;
import com.rhinosoft.fvjv.gui.events.CFVJVAction;
import com.rhinosoft.fvjv.gui.events.CStopButton;
import com.rhinosoft.fvjv.gui.frames.CFVJVCommandBar;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CNestedBrowserFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.AWTEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class CBrowserToolbar
extends CFVJVCommandBar {
    private CRhinoSplitBtn m_cLockNavBtn;

    public CBrowserToolbar(String sKey) {
        super(sKey);
        this.InitVars();
    }

    private void InitVars() {
    }

    @Override
    protected AbstractButton CreateButton(int nActionID, boolean bIsVisible) {
        CFVJVAction rAction;
        AbstractButton cBtn = null;
        if (CMainFrame.GET_APP() != null && (rAction = CMainFrame.GET_APP().GetAction(nActionID)) != null) {
            if (nActionID == 2113) {
                JideSplitButton btnHistory;
                cBtn = btnHistory = new JideSplitButton(CMainFrame.GET_APP().GetAction(nActionID));
                btnHistory.setVisible(bIsVisible);
            } else if (nActionID == 9625) {
                boolean bIsLocal = false;
                if (this.GetStoredLayoutKey() != null && this.GetStoredLayoutKey().equals("ActionLayoutLocal")) {
                    bIsLocal = true;
                }
                this.m_cLockNavBtn = new CRhinoSplitBtn(bIsLocal, this.GetNestedBrowserFrame());
                cBtn = this.m_cLockNavBtn;
                this.m_cLockNavBtn.setVisible(bIsVisible);
                final CRhinoSplitBtn rLockNavBtn = this.m_cLockNavBtn;
                this.m_cLockNavBtn.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
                        if (rLockNavBtn != null) {
                            rLockNavBtn.UpdateTargetInfo();
                        }
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent event) {
                    }
                });
            } else if (nActionID == 2010) {
                CStopButton btn = new CStopButton(rAction);
                rAction.AddOwner(btn);
                cBtn = btn;
                btn.setVisible(bIsVisible);
            } else {
                cBtn = super.CreateButton(nActionID, bIsVisible);
            }
            this.UpdateBtnText(rAction, cBtn);
        }
        return cBtn;
    }

    private void UpdateBtnText(CFVJVAction rAction, AbstractButton rBtn) {
        if (rAction != null && rBtn != null) {
            String sText = rBtn.getText();
            switch (rAction.GetEventID()) {
                case 2114: {
                    sText = CString.LoadString("IDS_UP_DIR_BTN");
                    break;
                }
                case 2009: {
                    sText = CString.LoadString("IDS_DOWNLOAD_BTN");
                    break;
                }
                case 2008: {
                    sText = CString.LoadString("IDS_UPLOAD_BTN");
                    break;
                }
                case 2010: {
                    sText = CString.LoadString("IDS_STOP_BTN");
                    break;
                }
                case 2003: {
                    sText = CString.LoadString("IDS_NEW_FOLDER_BTN");
                    break;
                }
                case 2112: {
                    sText = "";
                    break;
                }
                case 2113: {
                    sText = "";
                    break;
                }
            }
            rBtn.setText(sText);
        }
    }

    @Override
    protected void InitButton(int nEventID, boolean bIsVisible) {
        if (nEventID == 2112 || nEventID == 2113) {
            this.AddButton(this.CreateButton(nEventID, bIsVisible));
            if (nEventID == 2112) {
                this.AddVisibleItem(this.CreateVisibleItem(2231, bIsVisible));
            }
        } else {
            super.InitButton(nEventID, bIsVisible);
        }
    }

    @Override
    protected JMenuItem GetVisibleMenuItem(int nVisibleActionID) {
        if (nVisibleActionID == 2206 || nVisibleActionID == 2207) {
            nVisibleActionID = 2231;
        }
        return super.GetVisibleMenuItem(nVisibleActionID);
    }

    public JideSplitButton GetForwardBtn() {
        AbstractButton rTemp;
        JideSplitButton rBtn = null;
        Vector<AbstractButton> arBtns = this.GetButton(2113, this.GetButtons(), false);
        if (arBtns != null && arBtns.size() == 1 && (rTemp = arBtns.get(0)) instanceof JideSplitButton) {
            rBtn = (JideSplitButton)rTemp;
        }
        return rBtn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processEvent(AWTEvent event) {
        CRhinoEvent rEvent = null;
        if (event instanceof CRhinoEvent) {
            rEvent = (CRhinoEvent)event;
        }
        if (rEvent != null) {
            switch (event.getID()) {
                case 9025: {
                    if (this.m_cLockNavBtn == null) return;
                    this.m_cLockNavBtn.SetDockFrameSource(this.GetNestedBrowserFrame());
                    return;
                }
                case 9113: {
                    if (!(event instanceof CRhinoEvent)) return;
                    CRhinoEvent rRhinoEvent = (CRhinoEvent)event;
                    this.SetBtnEnabled(2010, true);
                    return;
                }
                case 9114: {
                    if (!(event instanceof CRhinoEvent)) return;
                    CRhinoEvent rRhinoEvent = (CRhinoEvent)event;
                    this.SetBtnEnabled(2010, false);
                    return;
                }
                case 9020: {
                    Object[] anItems = (Object[])rEvent.GetEventObj();
                    if (anItems == null) return;
                    Integer nEventID = null;
                    Boolean bVal = null;
                    if (anItems.length >= 1) {
                        nEventID = (Integer)anItems[0];
                    }
                    if (anItems.length >= 2) {
                        bVal = (Boolean)anItems[1];
                    }
                    if (nEventID == 2113) {
                        AbstractButton rBtn;
                        Vector<AbstractButton> arBtns = this.GetButton(nEventID, this.GetButtons(), false);
                        if (arBtns == null || arBtns.size() != 1 || !((rBtn = arBtns.get(0)) instanceof JideSplitButton)) return;
                        JideSplitButton rSplitBtn = (JideSplitButton)rBtn;
                        rSplitBtn.setButtonEnabled(bVal);
                        return;
                    }
                    super.processEvent(event);
                    return;
                }
                case 9100: 
                case 9102: 
                case 9629: {
                    if (this.m_cLockNavBtn == null) return;
                    this.m_cLockNavBtn.dispatchEvent(rEvent);
                    return;
                }
                default: {
                    super.processEvent(event);
                    return;
                }
            }
        } else {
            super.processEvent(event);
        }
    }

    private void SetBtnEnabled(int nEventID, boolean bEnabled) {
        Vector<AbstractButton> arBtns = this.GetButton(nEventID, this.GetButtons(), false);
        if (arBtns != null) {
            for (AbstractButton rBtn : arBtns) {
                rBtn.setEnabled(bEnabled);
                Object[] anItems = new Object[]{nEventID, bEnabled};
                CRhinoEvent rEvent = new CRhinoEvent(this, 9020, anItems);
                if (CMainFrame.GET_APP() == null) continue;
                CMainFrame.GET_APP().dispatchEvent(rEvent);
            }
        }
    }

    protected DockableFrame GetDockFrame() {
        DockableFrame rRetDockFrame = null;
        DockableFrame rFrame = (DockableFrame)SwingUtilities.getAncestorOfClass(DockableFrame.class, this);
        if (rFrame != null) {
            rRetDockFrame = rFrame;
        }
        return rRetDockFrame;
    }

    protected CNestedBrowserFrame GetNestedBrowserFrame() {
        CNestedBrowserFrame rRetDockFrame = null;
        CNestedBrowserFrame rFrame = (CNestedBrowserFrame)SwingUtilities.getAncestorOfClass(CNestedBrowserFrame.class, this);
        if (rFrame != null) {
            rRetDockFrame = rFrame;
        }
        return rRetDockFrame;
    }
}

