/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser;

import com.jidesoft.docking.event.DockableFrameEvent;
import com.rhinosoft.base.gui.components.files.preview.CFilePreviewPane;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.components.files.preview.CPreviewPane;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserBaseNestedFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserPanel;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class CBrowserPreviewFrame
extends CBrowserBaseNestedFrame
implements ComponentListener,
ActionListener {
    private static boolean DEBUG_TIMER;
    public static final boolean DEBUG_TRACK_EVENTS;
    private CFilePreviewPane m_cPreviewPane;
    private JScrollPane m_cScrollPane;
    private Timer m_Timer;

    public CBrowserPreviewFrame(String sKey, CBrowserPanel rBrowserPanel) {
        super(sKey, rBrowserPanel);
        this.InitVars();
    }

    private void InitVars() {
        this.setFrameIcon(CMainFrame.GetJARImage("FilmStrip16.png"));
        this.m_cPreviewPane = this.CreatePreviewPane();
        if (this.GetPreviewPane() != null) {
            this.m_cScrollPane = new JScrollPane(this.GetPreviewPane());
            this.setContentPane(this.m_cScrollPane);
        }
        this.m_Timer = this.InitResizeTimer();
        this.addDockableFrameListener(this);
        this.addComponentListener(this);
        String sTitle = CString.LoadString("IDS_FRAME_SHOW_PREVIEW_PANE");
        this.setTitle(sTitle);
        this.setTabTitle(sTitle);
        this.setSideTitle(sTitle);
    }

    private Timer InitResizeTimer() {
        Timer rTimer = new Timer(750, this);
        if (rTimer != null) {
            rTimer.setRepeats(false);
        }
        return rTimer;
    }

    protected CFilePreviewPane CreatePreviewPane() {
        return new CPreviewPane();
    }

    public CFilePreviewPane GetPreviewPane() {
        return this.m_cPreviewPane;
    }

    @Override
    public void dockableFrameRemoved(DockableFrameEvent event) {
        super.dockableFrameRemoved(event);
        if (this.GetPreviewPane() != null) {
            this.GetPreviewPane().StopPlayer();
        }
    }

    @Override
    public void dockableFrameHidden(DockableFrameEvent event) {
        super.dockableFrameHidden(event);
        if (this.GetPreviewPane() != null) {
            this.GetPreviewPane().StopPlayer();
        }
    }

    @Override
    public void componentResized(ComponentEvent event) {
        this.StartResizeTimer();
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    public void StartResizeTimer() {
        if (this.m_Timer != null) {
            if (!this.m_Timer.isRunning()) {
                this.m_Timer.start();
            } else {
                this.m_Timer.restart();
            }
        }
    }

    public void StopResizeTimer() {
        if (this.m_Timer != null && this.m_Timer.isRunning()) {
            this.m_Timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (DEBUG_TIMER) {
            System.out.println("actionPerformed -->");
        }
        if (rEvent.getSource() == this.m_Timer) {
            this.StopResizeTimer();
            if (DEBUG_TIMER) {
                System.out.println("\tTimer hit!");
            }
            if (this.GetPreviewPane() != null) {
                this.GetPreviewPane().OnResize();
            }
        }
        if (DEBUG_TIMER) {
            System.out.println("actionPerformed <--");
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (DEBUG_TRACK_EVENTS) {
            System.out.printf("CNestedFrame.processEvent(%d)\r\n", event.getID());
        }
        switch (event.getID()) {
            case 9639: {
                this.setCursor((Cursor)((CRhinoEvent)event).GetEventObj());
                if (this.GetPreviewPane() == null) break;
                this.GetPreviewPane().dispatchEvent(event);
                break;
            }
            default: {
                if (event instanceof CRhinoEvent) {
                    if (this.GetPreviewPane() == null) break;
                    this.GetPreviewPane().dispatchEvent(event);
                    break;
                }
                super.processEvent(event);
            }
        }
    }

    @Override
    public void dockableFrameShown(DockableFrameEvent event) {
        super.dockableFrameShown(event);
        String sTitle = CString.LoadString("IDS_FRAME_SHOW_PREVIEW_PANE");
        this.setTitle(sTitle);
        this.setTabTitle(sTitle);
        this.setSideTitle(sTitle);
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TIMER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_EVENTS = false;
    }
}

