/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser;

import com.jidesoft.docking.DockableFrame;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserBaseNestedFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserPanel;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserPreviewFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserTreeFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CCustomFrameFactory;
import com.rhinosoft.fvjv.strings.CString;

public class CBrowserFrameFactory
extends CCustomFrameFactory {
    public static final boolean DEBUG_SHOW_KEY_IN_TITLE;

    public CBrowserFrameFactory(CBrowserPanel rOwner) {
        super(rOwner);
    }

    @Override
    protected CBrowserPanel GetOwner() {
        CBrowserPanel rRet = null;
        if (super.GetOwner() instanceof CBrowserPanel) {
            rRet = (CBrowserPanel)super.GetOwner();
        }
        return rRet;
    }

    @Override
    protected DockableFrame CreateDockFrame(String sKey) {
        CBrowserBaseNestedFrame frame = null;
        if (sKey != null && !sKey.isEmpty()) {
            String sKeyTree = this.GetKeyTree();
            String sKeyPreview = this.GetKeyPreview();
            if (sKeyTree != null && sKeyTree.startsWith(sKey)) {
                frame = new CBrowserTreeFrame(sKeyTree, this.GetOwner());
            } else if (sKeyPreview != null && sKeyPreview.startsWith(sKey)) {
                frame = new CBrowserPreviewFrame(sKeyPreview, this.GetOwner());
            }
        }
        return frame;
    }

    @Override
    protected void Layout(DockableFrame rDockFrame) {
        if (rDockFrame != null) {
            String sKey = rDockFrame.getKey();
            String sKeyTree = this.GetKeyTree();
            String sKeyPreview = this.GetKeyPreview();
            if (sKeyTree != null && sKeyTree.startsWith(sKey)) {
                if (!DEBUG_SHOW_KEY_IN_TITLE) {
                    String sTitle = CString.LoadString("IDS_FRAME_SHOW_TREE_PANE");
                    rDockFrame.setTabTitle(sTitle);
                    rDockFrame.setTitle(sTitle);
                    rDockFrame.setSideTitle(sTitle);
                }
                if (this.GetOwner() != null && rDockFrame instanceof CBrowserTreeFrame) {
                    CBrowserTreeFrame rTreeFrame = (CBrowserTreeFrame)rDockFrame;
                    if (rTreeFrame.GetTree() != null) {
                        rTreeFrame.GetTree().SetFrameKey(sKeyTree);
                    }
                    this.GetOwner().SetTree(rTreeFrame.GetTree());
                }
            } else if (sKeyPreview != null && sKeyPreview.startsWith(sKey)) {
                if (!DEBUG_SHOW_KEY_IN_TITLE) {
                    String sTitle = CString.LoadString("IDS_FRAME_SHOW_PREVIEW_PANE");
                    rDockFrame.setTabTitle(sTitle);
                    rDockFrame.setTitle(sTitle);
                    rDockFrame.setSideTitle(sTitle);
                }
                if (this.GetOwner() != null && rDockFrame instanceof CBrowserPreviewFrame) {
                    CBrowserPreviewFrame rPreviewPane = (CBrowserPreviewFrame)rDockFrame;
                    if (rPreviewPane.GetPreviewPane() != null) {
                        rPreviewPane.GetPreviewPane().SetFrameKey(sKeyTree);
                    }
                    this.GetOwner().SetPreviewPane(rPreviewPane.GetPreviewPane());
                }
            }
        }
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_SHOW_KEY_IN_TITLE = false;
    }
}

